/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config;

import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opennms.dataplatform.access.AuthenticateGrpc;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.plugins.cloud.config.CertUtil;
import org.opennms.plugins.cloud.config.ConfigStore;
import org.opennms.plugins.cloud.config.PasAccess;
import org.opennms.plugins.cloud.config.PrerequisiteChecker;
import org.opennms.plugins.cloud.config.TokenUtil;
import org.opennms.plugins.cloud.grpc.CloseUtil;
import org.opennms.plugins.cloud.grpc.GrpcConnection;
import org.opennms.plugins.cloud.grpc.GrpcConnectionConfig;
import org.opennms.plugins.cloud.srv.GrpcService;
import org.opennms.plugins.cloud.srv.RegistrationManager;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;
import org.opennms.tsaas.Tsaas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationManager.class);
    private ConfigStatus currentStatus = ConfigStatus.NOT_ATTEMPTED;
    private final ConfigStore config;
    private final RegistrationManager serviceManager;
    private final List<GrpcService> grpcServices;
    private final GrpcConnectionConfig pasConfigTls;
    private final GrpcConnectionConfig pasConfigMtls;
    private final RuntimeInfo runtimeInfo;
    private Instant tokenExpirationDate;
    private Instant certExpirationDate;

    public ConfigurationManager(ConfigStore config, GrpcConnectionConfig pasConfigTls, GrpcConnectionConfig pasConfigMtls, RegistrationManager serviceManager, RuntimeInfo runtimeInfo, List<GrpcService> grpcServices) {
        this.config = Objects.requireNonNull(config);
        this.pasConfigTls = Objects.requireNonNull(pasConfigTls);
        this.pasConfigMtls = Objects.requireNonNull(pasConfigMtls);
        this.serviceManager = Objects.requireNonNull(serviceManager);
        this.grpcServices = Objects.requireNonNull(grpcServices);
        this.runtimeInfo = Objects.requireNonNull(runtimeInfo);
        if (ConfigStatus.AUTHENTCATED.name().equals(this.config.getOrNull(ConfigStore.Key.configstatus)) || ConfigStatus.CONFIGURED.name().equals(this.config.getOrNull(ConfigStore.Key.configstatus))) {
            this.configure();
        }
    }

    void checkConnection() {
        Tsaas.CheckHealthResponse.ServingStatus status = this.grpcServices.stream().filter(TsaasStorage.class::isInstance).map(TsaasStorage.class::cast).findFirst().map(TsaasStorage::checkHealth).map(Tsaas.CheckHealthResponse::getStatus).orElseThrow();
        LOG.info("Status of TSAAS: {}", (Object)status);
    }

    public void initConfiguration(String key) {
        LOG.info("Starting initialization of cloud plugin.");
        PrerequisiteChecker.checkAndLogSystemId(this.runtimeInfo.getSystemId());
        PrerequisiteChecker.checkAndLogContainer(this.runtimeInfo);
        try (GrpcConnection<AuthenticateGrpc.AuthenticateBlockingStub> grpcWithTls = new GrpcConnection<AuthenticateGrpc.AuthenticateBlockingStub>(this.pasConfigTls, AuthenticateGrpc::newBlockingStub);){
            Objects.requireNonNull(key, "key must not be null");
            PasAccess pasWithTls = new PasAccess(grpcWithTls);
            Map<ConfigStore.Key, String> cloudCredentials = pasWithTls.getCredentialsFromAccessService(key, this.runtimeInfo.getSystemId());
            LOG.info("Cloud configuration received from PAS (Platform Access Service).");
            if (this.pasConfigTls.getClientTrustStore() != null && !this.pasConfigTls.getClientTrustStore().isBlank()) {
                cloudCredentials.put(ConfigStore.Key.truststore, this.pasConfigTls.getClientTrustStore());
            }
            cloudCredentials.put(ConfigStore.Key.configstatus, ConfigStatus.AUTHENTCATED.name());
            this.config.putProperties(cloudCredentials);
            LOG.info("Cloud configuration stored in OpenNMS.");
            this.currentStatus = ConfigStatus.AUTHENTCATED;
        }
        catch (Exception e) {
            this.currentStatus = ConfigStatus.FAILED;
            LOG.error("Initialization failed. Used config:\n{}", (Object)this.pasConfigTls, (Object)e);
            throw e;
        }
    }

    public void deactivateKeyConfiguration() {
        this.currentStatus = ConfigStatus.DEACTIVATED;
        this.config.putProperty(ConfigStore.Key.configstatus, ConfigStatus.DEACTIVATED.name());
        this.destroyGrpcServices();
    }

    public void renewCerts() throws CertificateException {
        try (CloseUtil closeUtil = new CloseUtil();){
            LOG.info("Starting renewing of certificates.");
            GrpcConnectionConfig cloudGatewayConfig = this.readCloudGatewayConfig();
            this.certExpirationDate = CertUtil.getExpiryDate(cloudGatewayConfig.getPublicKey());
            GrpcConnection<AuthenticateGrpc.AuthenticateBlockingStub> pasWithMtlsConfig = this.createPasGrpc(cloudGatewayConfig);
            closeUtil.add(pasWithMtlsConfig);
            PasAccess pasWithMtls = new PasAccess(pasWithMtlsConfig);
            Map<ConfigStore.Key, String> cloudCredentials = pasWithMtls.renewCertificate(this.runtimeInfo.getSystemId());
            LOG.info("New certificates received from PAS (Platform Access Service).");
            cloudCredentials.put(ConfigStore.Key.configstatus, ConfigStatus.AUTHENTCATED.name());
            this.config.putProperties(cloudCredentials);
            LOG.info("Cloud configuration stored in OpenNMS.");
        }
        catch (Exception e) {
            this.currentStatus = ConfigStatus.FAILED;
            LOG.error("fetching new certs failed.", (Throwable)e);
            throw e;
        }
    }

    public synchronized ConfigStatus configure() {
        String systemId = this.runtimeInfo.getSystemId();
        try (CloseUtil closeUtil = new CloseUtil();){
            GrpcConnectionConfig cloudGatewayConfig = this.readCloudGatewayConfig();
            this.certExpirationDate = CertUtil.getExpiryDate(cloudGatewayConfig.getPublicKey());
            GrpcConnection<AuthenticateGrpc.AuthenticateBlockingStub> pasWithMtlsConfig = this.createPasGrpc(cloudGatewayConfig);
            closeUtil.add(pasWithMtlsConfig);
            PasAccess pasWithMtls = new PasAccess(pasWithMtlsConfig);
            Set<RegistrationManager.Service> activeServices = pasWithMtls.getActiveServices(systemId);
            LOG.info("Active services received: {}.", activeServices);
            String token = pasWithMtls.getToken(activeServices, systemId);
            this.tokenExpirationDate = TokenUtil.getExpiryDate(token);
            cloudGatewayConfig = cloudGatewayConfig.toBuilder().tokenKey("token").tokenValue(token).security(GrpcConnectionConfig.Security.MTLS).build();
            LOG.info("Received token.");
            this.initGrpcServices(cloudGatewayConfig);
            LOG.info("All services configured with grpc config.");
            this.checkConnection();
            this.registerServices(activeServices);
            LOG.info("Active services registered with OpenNMS.");
            this.currentStatus = ConfigStatus.CONFIGURED;
        }
        catch (Exception e) {
            this.currentStatus = ConfigStatus.FAILED;
            LOG.error("configure failed.", (Throwable)e);
        }
        return this.currentStatus;
    }

    private GrpcConnection<AuthenticateGrpc.AuthenticateBlockingStub> createPasGrpc(GrpcConnectionConfig cloudGatewayConfig) {
        GrpcConnectionConfig mtlsConfig = this.pasConfigMtls.toBuilder().privateKey(cloudGatewayConfig.getPrivateKey()).publicKey(cloudGatewayConfig.getPublicKey()).build();
        return new GrpcConnection<AuthenticateGrpc.AuthenticateBlockingStub>(mtlsConfig, AuthenticateGrpc::newBlockingStub);
    }

    private void registerServices(Set<RegistrationManager.Service> activeServices) {
        HashSet<RegistrationManager.Service> inactiveServices = new HashSet<RegistrationManager.Service>(Arrays.asList(RegistrationManager.Service.values()));
        inactiveServices.removeAll(activeServices);
        for (RegistrationManager.Service service : inactiveServices) {
            this.serviceManager.deregister(service);
        }
        for (RegistrationManager.Service service : activeServices) {
            this.serviceManager.register(service);
        }
    }

    GrpcConnectionConfig readCloudGatewayConfig() {
        return GrpcConnectionConfig.builder().host(this.config.getOrNull(ConfigStore.Key.grpchost)).port(this.config.get(ConfigStore.Key.grpcport).map(Integer::parseInt).orElse(0)).privateKey(this.config.getOrNull(ConfigStore.Key.privatekey)).publicKey(this.config.getOrNull(ConfigStore.Key.publickey)).tokenKey(this.config.getOrNull(ConfigStore.Key.tokenkey)).tokenValue(this.config.getOrNull(ConfigStore.Key.tokenvalue)).clientTrustStore(this.config.getOrNull(ConfigStore.Key.truststore)).build();
    }

    public void initGrpcServices(GrpcConnectionConfig config) {
        for (GrpcService service : this.grpcServices) {
            try {
                service.initGrpc(config);
            }
            catch (Exception e) {
                LOG.error("could not initGrpc", (Throwable)e);
            }
        }
    }

    private void destroyGrpcServices() {
        for (GrpcService service : this.grpcServices) {
            service.destroy();
        }
    }

    public ConfigStatus getStatus() {
        return this.currentStatus;
    }

    public Instant getTokenExpiration() {
        return this.tokenExpirationDate == null ? Instant.now() : this.tokenExpirationDate;
    }

    public Instant getCertExpiration() {
        return this.certExpirationDate == null ? Instant.now() : this.certExpirationDate;
    }

    public static enum ConfigStatus {
        NOT_ATTEMPTED,
        AUTHENTCATED,
        CONFIGURED,
        FAILED,
        DEACTIVATED;

    }
}

