/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.config.shell;

import java.util.Objects;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.integration.api.v1.runtime.Container;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.plugins.cloud.config.ConfigurationManager;

@Command(scope="opennms-cloud", name="init", description="Core: Contacts platform access service (PAS) and retrieves configuration\nSentinel: Contacts Core and retrieves configuration")
@Service
public class InitCloud
implements Action {
    @Reference
    ConfigurationManager manager;
    @Reference
    RuntimeInfo runtimeInfo;
    @Argument
    String apiKey;

    public Object execute() {
        ConfigurationManager.ConfigStatus status;
        if (Container.OPENNMS.equals((Object)this.runtimeInfo.getContainer())) {
            status = this.initForCore();
        } else if (Container.SENTINEL.equals((Object)this.runtimeInfo.getContainer())) {
            status = this.manager.configure();
        } else {
            System.err.printf("It looks like we are running in a non supported environment, supported=OPENNMS, SENTINEL but it is %s", this.runtimeInfo.getContainer());
            return null;
        }
        if (ConfigurationManager.ConfigStatus.CONFIGURED == status) {
            System.out.printf("Initialization of cloud plugin in %s was successful.%n", this.runtimeInfo.getContainer());
        } else {
            System.out.printf("Initialization of cloud plugin in %s failed: %s. Check log (log:display) for details.%n", new Object[]{this.runtimeInfo.getContainer(), status});
        }
        return null;
    }

    private ConfigurationManager.ConfigStatus initForCore() {
        if (this.apiKey == null || this.apiKey.isBlank()) {
            System.out.println("please enter api key");
        }
        Objects.requireNonNull(this.apiKey);
        this.manager.initConfiguration(this.apiKey);
        return this.manager.configure();
    }
}

