/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.plugins.cloud.srv;

import java.util.Dictionary;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opennms.integration.api.v1.timeseries.TimeSeriesStorage;
import org.opennms.plugins.cloud.srv.RegistrationManager;
import org.opennms.plugins.cloud.srv.tsaas.TsaasStorage;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class RegistrationManagerTest {
    private BundleContext context;
    private TsaasStorage tsaas;
    private RegistrationManager manager;
    ServiceRegistration<TimeSeriesStorage> registration;

    @Before
    public void setUp() {
        this.context = (BundleContext)Mockito.mock(BundleContext.class);
        this.registration = (ServiceRegistration)Mockito.mock(ServiceRegistration.class);
        this.tsaas = (TsaasStorage)Mockito.mock(TsaasStorage.class);
        Mockito.when((Object)this.context.registerService((Class)ArgumentMatchers.eq(TimeSeriesStorage.class), (Object)((TimeSeriesStorage)ArgumentMatchers.eq((Object)this.tsaas)), (Dictionary)ArgumentMatchers.any())).thenReturn(this.registration);
        this.manager = new RegistrationManager(this.context, this.tsaas);
    }

    @Test
    public void shouldRegisterOnlyWhenNotRegistered() {
        this.manager.register(RegistrationManager.Service.TSAAS);
        ((BundleContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.times((int)1))).registerService((Class)ArgumentMatchers.eq(TimeSeriesStorage.class), (Object)((TimeSeriesStorage)ArgumentMatchers.eq((Object)this.tsaas)), (Dictionary)ArgumentMatchers.any());
        Mockito.reset((Object[])new BundleContext[]{this.context});
        this.manager.register(RegistrationManager.Service.TSAAS);
        ((BundleContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).registerService((Class)ArgumentMatchers.eq(TimeSeriesStorage.class), (Object)((TimeSeriesStorage)ArgumentMatchers.eq((Object)this.tsaas)), (Dictionary)ArgumentMatchers.any());
    }

    @Test
    public void shouldDeregisterOnlyWhenRegistered() {
        this.manager.register(RegistrationManager.Service.TSAAS);
        this.manager.deregister(RegistrationManager.Service.TSAAS);
        ((ServiceRegistration)Mockito.verify(this.registration, (VerificationMode)Mockito.times((int)1))).unregister();
        Mockito.reset((Object[])new ServiceRegistration[]{this.registration});
        this.manager.deregister(RegistrationManager.Service.TSAAS);
        ((ServiceRegistration)Mockito.verify(this.registration, (VerificationMode)Mockito.never())).unregister();
    }

    @Test
    public void destroyShouldDeregisterAllServices() {
        this.manager.register(RegistrationManager.Service.TSAAS);
        this.manager.destroy();
        ((ServiceRegistration)Mockito.verify(this.registration, (VerificationMode)Mockito.times((int)1))).unregister();
    }
}

