/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.impl;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

class JsonNodeClaim
implements Claim {
    private final ObjectReader objectReader;
    private final JsonNode data;

    private JsonNodeClaim(JsonNode node, ObjectReader objectReader) {
        this.data = node;
        this.objectReader = objectReader;
    }

    @Override
    public Boolean asBoolean() {
        return this.isMissing() || this.isNull() || !this.data.isBoolean() ? null : Boolean.valueOf(this.data.asBoolean());
    }

    @Override
    public Integer asInt() {
        return this.isMissing() || this.isNull() || !this.data.isNumber() ? null : Integer.valueOf(this.data.asInt());
    }

    @Override
    public Long asLong() {
        return this.isMissing() || this.isNull() || !this.data.isNumber() ? null : Long.valueOf(this.data.asLong());
    }

    @Override
    public Double asDouble() {
        return this.isMissing() || this.isNull() || !this.data.isNumber() ? null : Double.valueOf(this.data.asDouble());
    }

    @Override
    public String asString() {
        return this.isMissing() || this.isNull() || !this.data.isTextual() ? null : this.data.asText();
    }

    @Override
    public Date asDate() {
        if (this.isMissing() || this.isNull() || !this.data.canConvertToLong()) {
            return null;
        }
        long seconds = this.data.asLong();
        return new Date(seconds * 1000L);
    }

    @Override
    public Instant asInstant() {
        if (this.isMissing() || this.isNull() || !this.data.canConvertToLong()) {
            return null;
        }
        long seconds = this.data.asLong();
        return Instant.ofEpochSecond(seconds);
    }

    @Override
    public <T> T[] asArray(Class<T> clazz) throws JWTDecodeException {
        if (this.isMissing() || this.isNull() || !this.data.isArray()) {
            return null;
        }
        Object[] arr = (Object[])Array.newInstance(clazz, this.data.size());
        for (int i = 0; i < this.data.size(); ++i) {
            try {
                arr[i] = this.objectReader.treeToValue((TreeNode)this.data.get(i), clazz);
                continue;
            }
            catch (JsonProcessingException e) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to " + clazz.getSimpleName(), e);
            }
        }
        return arr;
    }

    @Override
    public <T> List<T> asList(Class<T> clazz) throws JWTDecodeException {
        if (this.isMissing() || this.isNull() || !this.data.isArray()) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < this.data.size(); ++i) {
            try {
                list.add(this.objectReader.treeToValue((TreeNode)this.data.get(i), clazz));
                continue;
            }
            catch (JsonProcessingException e) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to " + clazz.getSimpleName(), e);
            }
        }
        return list;
    }

    @Override
    public Map<String, Object> asMap() throws JWTDecodeException {
        if (this.isMissing() || this.isNull() || !this.data.isObject()) {
            return null;
        }
        try {
            TypeReference<Map<String, Object>> mapType = new TypeReference<Map<String, Object>>(){};
            JsonParser thisParser = this.objectReader.treeAsTokens(this.data);
            return (Map)thisParser.readValueAs(mapType);
        }
        catch (IOException e) {
            throw new JWTDecodeException("Couldn't map the Claim value to Map", e);
        }
    }

    @Override
    public <T> T as(Class<T> clazz) throws JWTDecodeException {
        try {
            if (this.isMissing() || this.isNull()) {
                return null;
            }
            return this.objectReader.treeAsTokens(this.data).readValueAs(clazz);
        }
        catch (IOException e) {
            throw new JWTDecodeException("Couldn't map the Claim value to " + clazz.getSimpleName(), e);
        }
    }

    @Override
    public boolean isNull() {
        return !this.isMissing() && this.data.isNull();
    }

    @Override
    public boolean isMissing() {
        return this.data == null || this.data.isMissingNode();
    }

    public String toString() {
        if (this.isMissing()) {
            return "Missing claim";
        }
        if (this.isNull()) {
            return "Null claim";
        }
        return this.data.toString();
    }

    static Claim extractClaim(String claimName, Map<String, JsonNode> tree, ObjectReader objectReader) {
        JsonNode node = tree.get(claimName);
        return JsonNodeClaim.claimFromNode(node, objectReader);
    }

    static Claim claimFromNode(JsonNode node, ObjectReader objectReader) {
        return new JsonNodeClaim(node, objectReader);
    }
}

