/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.handler;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.HandlerBase;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;

public class JsonHandler
extends HandlerBase {
    private static final String NAME = "JSON";
    private static final String RELEASE = "1.0";
    private static final int[] DATE = new int[]{2019, 10, 18};
    private static final String NOTE = "";
    private static final String RIGHTS = "Version 1.0 release by Open Preservation Foundation. Released under the GNU Lesser General Public License.";
    private JsonObjectBuilder jhoveBuilder;
    private double _sampleRate;

    public JsonHandler() {
        super(NAME, RELEASE, DATE, NOTE, RIGHTS);
        this._vendor = Agent.bnfInstance();
    }

    public JsonHandler(String name, String release, int[] date, String note, String rights) {
        super(name, release, date, note, rights);
        this._vendor = Agent.bnfInstance();
    }

    @Override
    public void show() {
        --this._level;
    }

    @Override
    public void show(App app) {
        String s;
        JsonObjectBuilder appBuilder = Json.createObjectBuilder();
        JsonObjectBuilder apiBuilder = Json.createObjectBuilder();
        apiBuilder.add("version", app.getRelease());
        apiBuilder.add("date", date.format(this._je.getDate()));
        appBuilder.add("api", apiBuilder);
        String configFile = this._je.getConfigFile();
        if (configFile != null) {
            appBuilder.add("configuration", configFile);
        }
        if ((s = this._je.getSaxClass()) != null) {
            appBuilder.add("saxParser", s);
        }
        if ((s = this._je.getJhoveHome()) != null) {
            appBuilder.add("jhoveHome", s);
        }
        if ((s = this._je.getEncoding()) != null) {
            appBuilder.add("encoding", s);
        }
        if ((s = this._je.getTempDirectory()) != null) {
            appBuilder.add("tempDirectory", s);
        }
        appBuilder.add("bufferSize", this._je.getBufferSize());
        JsonArrayBuilder modulesBuilder = Json.createArrayBuilder();
        for (String modKey : this._je.getModuleMap().keySet()) {
            Module module = this._je.getModule(modKey);
            modulesBuilder.add(Json.createObjectBuilder().add("module", module.getName()).add("release", module.getRelease()));
        }
        appBuilder.add("modules", modulesBuilder);
        JsonArrayBuilder oHandlersBuilder = Json.createArrayBuilder();
        for (String handlerKey : this._je.getHandlerMap().keySet()) {
            OutputHandler handler = this._je.getHandler(handlerKey);
            oHandlersBuilder.add(Json.createObjectBuilder().add("outputHandler", handler.getName()).add("release", handler.getRelease()));
        }
        appBuilder.add("outputHandlers", oHandlersBuilder);
        appBuilder.add("usage", app.getUsage());
        appBuilder.add("rights", app.getRights());
        this.jhoveBuilder.add("app", appBuilder);
    }

    @Override
    public void show(OutputHandler handler) {
        String s;
        Agent vendor;
        JsonObjectBuilder outputHandlerBuilder = Json.createObjectBuilder();
        outputHandlerBuilder.add("name", handler.getName());
        outputHandlerBuilder.add("release", handler.getRelease());
        outputHandlerBuilder.add("date", date.format(handler.getDate()));
        List<Document> list = handler.getSpecification();
        int n = list.size();
        if (n > 0) {
            JsonArrayBuilder specBuilder = Json.createArrayBuilder();
            for (int i = 0; i < n; ++i) {
                specBuilder.add(this.showDocument(list.get(i)));
            }
            outputHandlerBuilder.add("specifications", specBuilder);
        }
        if ((vendor = handler.getVendor()) != null) {
            outputHandlerBuilder.add("vendor", this.showAgent(vendor, "Vendor"));
        }
        if ((s = handler.getNote()) != null) {
            outputHandlerBuilder.add("note", s);
        }
        if ((s = handler.getRights()) != null) {
            outputHandlerBuilder.add("rights", s);
        }
        this.jhoveBuilder.add("handler", outputHandlerBuilder);
    }

    @Override
    public void show(Module module) {
        List<String> ftr;
        List<Document> list2;
        List<Signature> list1;
        String s;
        JsonObjectBuilder modBuilder = Json.createObjectBuilder();
        modBuilder.add("name", module.getName());
        modBuilder.add("release", module.getRelease());
        modBuilder.add("date", HandlerBase.date.format(module.getDate()));
        String[] ss = module.getFormat();
        if (ss.length > 0) {
            modBuilder.add("formats", this.showArray(ss));
        }
        if ((s = module.getCoverage()) != null) {
            modBuilder.add("coverage", s);
        }
        if ((ss = module.getMimeType()).length > 0) {
            modBuilder.add("mimeTypes", this.showArray(ss));
        }
        if ((list1 = module.getSignature()) != null && !list1.isEmpty()) {
            JsonArrayBuilder sigBuilder = Json.createArrayBuilder();
            for (Signature signature : list1) {
                sigBuilder.add(this.showSignature(signature));
            }
            modBuilder.add("signatures", sigBuilder);
        }
        if ((list2 = module.getSpecification()) != null && !list2.isEmpty()) {
            JsonArrayBuilder docBuilder = Json.createArrayBuilder();
            for (Document document : list2) {
                docBuilder.add(this.showDocument(document));
            }
            modBuilder.add("specifications", docBuilder);
        }
        if ((ftr = module.getFeatures()) != null && !ftr.isEmpty()) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (String f : ftr) {
                jsonArrayBuilder.add(f);
            }
            modBuilder.add("features", jsonArrayBuilder);
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        s = module.getWellFormedNote();
        if (s != null) {
            jsonObjectBuilder.add("wellFormed", s);
        }
        if ((s = module.getValidityNote()) != null) {
            jsonObjectBuilder.add("validity", s);
        }
        if ((s = module.getRepInfoNote()) != null) {
            jsonObjectBuilder.add("repInfo", s);
        }
        modBuilder.add("methodology", jsonObjectBuilder);
        Agent agent = module.getVendor();
        if (agent != null) {
            modBuilder.add("vendor", this.showAgent(agent, "Vendor"));
        }
        if ((s = module.getNote()) != null) {
            modBuilder.add("note", s);
        }
        if ((s = module.getRights()) != null) {
            modBuilder.add("rights", s);
        }
        this.jhoveBuilder.add("module", modBuilder);
    }

    @Override
    public void show(RepInfo info) {
        List<Checksum> list;
        Map<String, Property> map;
        List<String> list3;
        List<Message> list2;
        String wfStr;
        String s;
        long size;
        Date date;
        JsonObjectBuilder infoBuilder = Json.createObjectBuilder();
        Module module = info.getModule();
        this._logger.info("Reporting RepInfo");
        if (this._je.getSignatureFlag()) {
            this._logger.info("Checking signatures only");
        }
        infoBuilder.add("uri", info.getUri());
        if (module != null) {
            infoBuilder.add("reportingModule", Json.createObjectBuilder().add("name", module.getName()).add("release", module.getRelease()).add("date", JsonHandler.date.format(module.getDate())));
        }
        if ((date = info.getCreated()) != null) {
            infoBuilder.add("created", this.toDateTime(date));
        }
        if ((date = info.getLastModified()) != null) {
            infoBuilder.add("lastModified", this.toDateTime(date));
        }
        if ((size = info.getSize()) > -1L) {
            infoBuilder.add("size", size);
        }
        if ((s = info.getFormat()) != null) {
            infoBuilder.add("format", s);
        }
        if ((s = info.getVersion()) != null) {
            infoBuilder.add("version", s);
        }
        if (!this._je.getSignatureFlag()) {
            switch (info.getWellFormed()) {
                case 1: {
                    wfStr = "Well-Formed";
                    break;
                }
                case 0: {
                    wfStr = "Not well-formed";
                    break;
                }
                default: {
                    wfStr = "Unknown";
                }
            }
            if (info.getWellFormed() == 1) {
                switch (info.getValid()) {
                    case 1: {
                        wfStr = wfStr + " and valid";
                        break;
                    }
                    case 0: {
                        wfStr = wfStr + ", but not valid";
                        break;
                    }
                }
            }
            this._logger.info("Validity/WF status: " + wfStr);
            infoBuilder.add("status", wfStr);
        } else {
            switch (info.getWellFormed()) {
                case 1: {
                    wfStr = "Well-Formed";
                    break;
                }
                default: {
                    wfStr = "Not well-formed";
                }
            }
            infoBuilder.add("status", wfStr);
        }
        List<String> list1 = info.getSigMatch();
        if (list1 != null && !list1.isEmpty()) {
            JsonArrayBuilder sigBuilder = Json.createArrayBuilder();
            for (String string : list1) {
                sigBuilder.add(string);
            }
            infoBuilder.add("sigMatch", sigBuilder);
        }
        if ((list2 = info.getMessage()) != null && !list2.isEmpty()) {
            JsonArrayBuilder msgBuilder = Json.createArrayBuilder();
            for (Message message : list2) {
                msgBuilder.add(this.showMessage(message));
            }
            infoBuilder.add("messages", msgBuilder);
        }
        if ((s = info.getMimeType()) != null) {
            infoBuilder.add("mimeType", s);
        }
        if ((list3 = info.getProfile()) != null && !list3.isEmpty()) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (String string : list3) {
                jsonArrayBuilder.add(string);
            }
            infoBuilder.add("profiles", jsonArrayBuilder);
        }
        if ((map = info.getProperty()) != null && !map.isEmpty()) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (String key : map.keySet()) {
                Property property = info.getProperty(key);
                jsonArrayBuilder.add(this.showProperty(property));
            }
            infoBuilder.add("properties", jsonArrayBuilder);
        }
        if ((list = info.getChecksum()) != null && !list.isEmpty()) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (Checksum ck : list) {
                jsonArrayBuilder.add(this.showChecksum(ck));
            }
            infoBuilder.add("properties", jsonArrayBuilder);
        }
        if ((s = info.getNote()) != null) {
            infoBuilder.add("note", s);
        }
        this.jhoveBuilder.add("repInfo", infoBuilder);
    }

    protected JsonObjectBuilder showAgent(Agent agent, String label) {
        JsonObjectBuilder agentBuilder = Json.createObjectBuilder();
        agentBuilder.add("kind", label);
        agentBuilder.add("name", agent.getName());
        agentBuilder.add("type", agent.getType().toString());
        String s = agent.getAddress();
        if (s != null) {
            agentBuilder.add("address", s);
        }
        if ((s = agent.getTelephone()) != null) {
            agentBuilder.add("telephone", s);
        }
        if ((s = agent.getFax()) != null) {
            agentBuilder.add("fax", s);
        }
        if ((s = agent.getEmail()) != null) {
            agentBuilder.add("email", s);
        }
        if ((s = agent.getWeb()) != null) {
            agentBuilder.add("web", s);
        }
        return agentBuilder;
    }

    protected JsonObjectBuilder showChecksum(Checksum checksum) {
        return Json.createObjectBuilder().add("checksum", checksum.getValue()).add("type", checksum.getType().toString());
    }

    protected JsonObjectBuilder showDocument(Document document) {
        List<Identifier> list;
        String s;
        List<Agent> list2;
        JsonObjectBuilder docBuilder = Json.createObjectBuilder();
        docBuilder.add("title", document.getTitle());
        docBuilder.add("type", document.getType().toString());
        List<Agent> list1 = document.getAuthor();
        if (list1 != null && !list1.isEmpty()) {
            JsonArrayBuilder autBuilder = Json.createArrayBuilder();
            for (Agent agent : list1) {
                autBuilder.add(this.showAgent(agent, "Author"));
            }
            docBuilder.add("authors", autBuilder);
        }
        if ((list2 = document.getPublisher()) != null && !list2.isEmpty()) {
            JsonArrayBuilder pubBuilder = Json.createArrayBuilder();
            for (Agent ag : list2) {
                pubBuilder.add(this.showAgent(ag, "Publisher"));
            }
            docBuilder.add("publishers", pubBuilder);
        }
        if ((s = document.getEdition()) != null) {
            docBuilder.add("edition", s);
        }
        if ((s = document.getDate()) != null) {
            docBuilder.add("date", s);
        }
        if ((s = document.getEnumeration()) != null) {
            docBuilder.add("enumeration", s);
        }
        if ((s = document.getPages()) != null) {
            docBuilder.add("pages", s);
        }
        if ((list = document.getIdentifier()) != null && !list.isEmpty()) {
            JsonArrayBuilder idBuilder = Json.createArrayBuilder();
            for (Identifier id : list) {
                idBuilder.add(this.showIdentifier(id));
            }
            docBuilder.add("identifiers", idBuilder);
        }
        if ((s = document.getNote()) != null) {
            docBuilder.add("note", s);
        }
        return docBuilder;
    }

    @Override
    public void showFooter() {
        JsonObjectBuilder mainBuilder = Json.createObjectBuilder();
        mainBuilder.add("jhove", this.jhoveBuilder);
        JsonObject jsonObject = mainBuilder.build();
        JsonWriter jsonWriter = Json.createWriter(this._writer);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
    }

    @Override
    public void showHeader() {
        this.jhoveBuilder = Json.createObjectBuilder();
        this.jhoveBuilder.add("name", this._app.getName());
        this.jhoveBuilder.add("release", this._app.getRelease());
        this.jhoveBuilder.add("date", HandlerBase.date.format(this._app.getDate()));
        this.jhoveBuilder.add("executionTime", this.toDateTime(new Date()));
    }

    protected JsonObjectBuilder showIdentifier(Identifier identifier) {
        JsonObjectBuilder idBuilder = Json.createObjectBuilder();
        idBuilder.add("value", identifier.getValue());
        idBuilder.add("type", identifier.getType().toString());
        String note = identifier.getNote();
        if (note != null) {
            idBuilder.add("note", note);
        }
        return idBuilder;
    }

    protected JsonObjectBuilder showMessage(Message message) {
        String id;
        long offset;
        JsonObjectBuilder msgBuilder = Json.createObjectBuilder();
        msgBuilder.add("message", message.getMessage());
        String submsg = message.getSubMessage();
        if (submsg != null) {
            msgBuilder.add("subMessage", submsg);
        }
        if ((offset = message.getOffset()) > -1L) {
            msgBuilder.add("offset", offset);
        }
        if (!message.getPrefix().isEmpty()) {
            msgBuilder.add("severity", message.getPrefix().toLowerCase());
        }
        if ((id = message.getJhoveMessage().getId()) != null && !id.isEmpty() && !"NO-ID".equals(id)) {
            msgBuilder.add("id", message.getId());
        }
        return msgBuilder;
    }

    protected JsonObjectBuilder showSignature(Signature signature) {
        String use;
        String note;
        JsonObjectBuilder sigBuilder = Json.createObjectBuilder();
        String sigValue = signature.isStringValue() ? signature.getValueString() : signature.getValueHexString();
        sigBuilder.add("type", signature.getType().toString());
        sigBuilder.add("value", sigValue);
        if (SignatureType.MAGIC.equals((Object)signature.getType()) && ((InternalSignature)signature).hasFixedOffset()) {
            sigBuilder.add("offset", "0x" + Integer.toHexString(((InternalSignature)signature).getOffset()));
        }
        if ((note = signature.getNote()) != null) {
            sigBuilder.add("note", note);
        }
        if ((use = signature.getUse().toString()) != null) {
            sigBuilder.add("use", use);
        }
        return sigBuilder;
    }

    protected String valueToString(Object obj) {
        if (obj instanceof Date) {
            return this.toDateTime((Date)obj);
        }
        return obj.toString();
    }

    protected JsonObjectBuilder showProperty(Property property) {
        JsonObjectBuilder propBuilder = Json.createObjectBuilder();
        PropertyArity arity = property.getArity();
        switch (arity) {
            case SCALAR: {
                return this.showScalarProperty(property);
            }
            case ARRAY: {
                return this.showArrayProperty(property);
            }
            case LIST: {
                return this.showListProperty(property);
            }
            case MAP: {
                return this.showMapProperty(property);
            }
            case SET: {
                return this.showSetProperty(property);
            }
        }
        return propBuilder;
    }

    protected JsonObjectBuilder showScalarProperty(Property property) {
        JsonObjectBuilder propBuilder = Json.createObjectBuilder();
        PropertyType propType = property.getType();
        switch (propType) {
            case BOOLEAN: {
                Boolean b = (Boolean)property.getValue();
                propBuilder.add(property.getName(), b);
                break;
            }
            case BYTE: 
            case CHARACTER: 
            case OBJECT: {
                propBuilder.add(property.getName(), property.getValue().toString());
                break;
            }
            case DATE: {
                Date dt = (Date)property.getValue();
                propBuilder.add(property.getName(), this.toDateTime(dt));
                break;
            }
            case DOUBLE: {
                Double d = (Double)property.getValue();
                propBuilder.add(property.getName(), d);
                break;
            }
            case FLOAT: {
                Float f = (Float)property.getValue();
                propBuilder.add(property.getName(), f.floatValue());
                break;
            }
            case INTEGER: {
                Integer i = (Integer)property.getValue();
                propBuilder.add(property.getName(), i);
                break;
            }
            case LONG: {
                Long l = (Long)property.getValue();
                propBuilder.add(property.getName(), l);
                break;
            }
            case AESAUDIOMETADATA: {
                propBuilder.add(property.getName(), this.showAESAudioMetadata((AESAudioMetadata)property.getValue()));
                break;
            }
            case NISOIMAGEMETADATA: {
                propBuilder.add(property.getName(), this.showNisoImageMetadata((NisoImageMetadata)property.getValue()));
                break;
            }
            case TEXTMDMETADATA: {
                propBuilder.add(property.getName(), this.showTextMDMetadata((TextMDMetadata)property.getValue()));
                break;
            }
            case SHORT: {
                Short s = (Short)property.getValue();
                propBuilder.add(property.getName(), s.shortValue());
                break;
            }
            case STRING: {
                propBuilder.add(property.getName(), (String)property.getValue());
                break;
            }
            case RATIONAL: {
                propBuilder.add(property.getName(), this.showRational((Rational)property.getValue()));
                break;
            }
            case PROPERTY: {
                Property property2 = (Property)property.getValue();
                propBuilder.add(property.getName(), this.showProperty(property2));
                break;
            }
            default: {
                propBuilder.add(property.getName(), property.getValue().toString());
            }
        }
        return propBuilder;
    }

    protected JsonObjectBuilder showListProperty(Property property) {
        JsonObjectBuilder propBuilder = Json.createObjectBuilder();
        List propList = (List)property.getValue();
        JsonArrayBuilder lPropBuilder = Json.createArrayBuilder();
        PropertyType type = property.getType();
        ListIterator iter = propList.listIterator();
        while (iter.hasNext()) {
            Object val = iter.next();
            switch (type) {
                case BOOLEAN: {
                    lPropBuilder.add((Boolean)val);
                    break;
                }
                case BYTE: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case CHARACTER: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case DATE: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case DOUBLE: {
                    lPropBuilder.add((Double)val);
                    break;
                }
                case FLOAT: {
                    lPropBuilder.add(((Float)val).floatValue());
                    break;
                }
                case INTEGER: {
                    lPropBuilder.add((Integer)val);
                    break;
                }
                case LONG: {
                    lPropBuilder.add((Long)val);
                    break;
                }
                case OBJECT: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case SHORT: {
                    lPropBuilder.add(((Short)val).shortValue());
                    break;
                }
                case STRING: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case RATIONAL: {
                    lPropBuilder.add(this.showRational((Rational)val));
                    break;
                }
                case PROPERTY: {
                    lPropBuilder.add(this.showProperty((Property)val));
                    break;
                }
                case NISOIMAGEMETADATA: {
                    lPropBuilder.add(this.showNisoImageMetadata((NisoImageMetadata)property.getValue()));
                    break;
                }
                case AESAUDIOMETADATA: {
                    lPropBuilder.add(this.showAESAudioMetadata((AESAudioMetadata)property.getValue()));
                    break;
                }
                case TEXTMDMETADATA: {
                    lPropBuilder.add(this.showTextMDMetadata((TextMDMetadata)property.getValue()));
                    break;
                }
            }
        }
        propBuilder.add(property.getName(), lPropBuilder);
        return propBuilder;
    }

    protected JsonObjectBuilder showSetProperty(Property property) {
        JsonObjectBuilder propBuilder = Json.createObjectBuilder();
        Set propSet = (Set)property.getValue();
        JsonArrayBuilder lPropBuilder = Json.createArrayBuilder();
        PropertyType type = property.getType();
        for (Object val : propSet) {
            switch (type) {
                case BOOLEAN: {
                    lPropBuilder.add((Boolean)val);
                    break;
                }
                case BYTE: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case CHARACTER: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case DATE: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case DOUBLE: {
                    lPropBuilder.add((Double)val);
                    break;
                }
                case FLOAT: {
                    lPropBuilder.add(((Float)val).floatValue());
                    break;
                }
                case INTEGER: {
                    lPropBuilder.add((Integer)val);
                    break;
                }
                case LONG: {
                    lPropBuilder.add((Long)val);
                    break;
                }
                case OBJECT: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case SHORT: {
                    lPropBuilder.add(((Short)val).shortValue());
                    break;
                }
                case STRING: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case RATIONAL: {
                    lPropBuilder.add(this.showRational((Rational)val));
                    break;
                }
                case PROPERTY: {
                    lPropBuilder.add(this.showProperty((Property)val));
                    break;
                }
                case NISOIMAGEMETADATA: {
                    lPropBuilder.add(this.showNisoImageMetadata((NisoImageMetadata)property.getValue()));
                    break;
                }
                case AESAUDIOMETADATA: {
                    lPropBuilder.add(this.showAESAudioMetadata((AESAudioMetadata)property.getValue()));
                    break;
                }
                case TEXTMDMETADATA: {
                    lPropBuilder.add(this.showTextMDMetadata((TextMDMetadata)property.getValue()));
                    break;
                }
            }
        }
        propBuilder.add(property.getName(), lPropBuilder);
        return propBuilder;
    }

    protected JsonObjectBuilder showMapProperty(Property property) {
        JsonObjectBuilder propBuilder = Json.createObjectBuilder();
        JsonObjectBuilder lPropBuilder = Json.createObjectBuilder();
        Map propMap = (Map)property.getValue();
        PropertyType type = property.getType();
        for (Object key : propMap.keySet()) {
            String keystr = key.toString();
            Object val = propMap.get(key);
            switch (type) {
                case BOOLEAN: {
                    lPropBuilder.add(keystr, (Boolean)val);
                    break;
                }
                case BYTE: {
                    lPropBuilder.add(keystr, this.valueToString(val));
                    break;
                }
                case CHARACTER: {
                    lPropBuilder.add(keystr, this.valueToString(val));
                    break;
                }
                case DATE: {
                    lPropBuilder.add(keystr, this.valueToString(val));
                    break;
                }
                case DOUBLE: {
                    lPropBuilder.add(keystr, (Double)val);
                    break;
                }
                case FLOAT: {
                    lPropBuilder.add(keystr, ((Float)val).floatValue());
                    break;
                }
                case INTEGER: {
                    lPropBuilder.add(keystr, (Integer)val);
                    break;
                }
                case LONG: {
                    lPropBuilder.add(keystr, (Long)val);
                    break;
                }
                case OBJECT: {
                    lPropBuilder.add(keystr, this.valueToString(val));
                    break;
                }
                case SHORT: {
                    lPropBuilder.add(keystr, ((Short)val).shortValue());
                    break;
                }
                case STRING: {
                    lPropBuilder.add(keystr, this.valueToString(val));
                    break;
                }
                case RATIONAL: {
                    lPropBuilder.add(keystr, this.showRational((Rational)val));
                    break;
                }
                case PROPERTY: {
                    lPropBuilder.add(keystr, this.showProperty((Property)val));
                    break;
                }
                case NISOIMAGEMETADATA: {
                    lPropBuilder.add(keystr, this.showNisoImageMetadata((NisoImageMetadata)property.getValue()));
                    break;
                }
                case AESAUDIOMETADATA: {
                    lPropBuilder.add(keystr, this.showAESAudioMetadata((AESAudioMetadata)property.getValue()));
                    break;
                }
                case TEXTMDMETADATA: {
                    lPropBuilder.add(keystr, this.showTextMDMetadata((TextMDMetadata)property.getValue()));
                    break;
                }
            }
        }
        propBuilder.add(property.getName(), lPropBuilder);
        return propBuilder;
    }

    protected int propertyLength(Property property) {
        int n = 0;
        try {
            block1 : switch (property.getArity()) {
                case SET: {
                    Set propSet = (Set)property.getValue();
                    n = propSet.size();
                    break;
                }
                case LIST: {
                    List propList = (List)property.getValue();
                    n = propList.size();
                    break;
                }
                case MAP: {
                    Map propMap = (Map)property.getValue();
                    n = propMap.size();
                    break;
                }
                case ARRAY: {
                    switch (property.getType()) {
                        case BOOLEAN: {
                            boolean[] boolArray = (boolean[])property.getValue();
                            n = boolArray.length;
                            break block1;
                        }
                        case BYTE: {
                            byte[] byteArray = (byte[])property.getValue();
                            n = byteArray.length;
                            break block1;
                        }
                        case CHARACTER: {
                            char[] charArray = (char[])property.getValue();
                            n = charArray.length;
                            break block1;
                        }
                        case DATE: {
                            Date[] dateArray = (Date[])property.getValue();
                            n = dateArray.length;
                            break block1;
                        }
                        case DOUBLE: {
                            double[] doubleArray = (double[])property.getValue();
                            n = doubleArray.length;
                            break block1;
                        }
                        case FLOAT: {
                            float[] floatArray = (float[])property.getValue();
                            n = floatArray.length;
                            break block1;
                        }
                        case INTEGER: {
                            int[] intArray = (int[])property.getValue();
                            n = intArray.length;
                            break block1;
                        }
                        case LONG: {
                            long[] longArray = (long[])property.getValue();
                            n = longArray.length;
                            break block1;
                        }
                        case OBJECT: {
                            Object[] objArray = (Object[])property.getValue();
                            n = objArray.length;
                            break block1;
                        }
                        case SHORT: {
                            short[] shortArray = (short[])property.getValue();
                            n = shortArray.length;
                            break block1;
                        }
                        case STRING: {
                            String[] stringArray = (String[])property.getValue();
                            n = stringArray.length;
                            break block1;
                        }
                        case RATIONAL: {
                            Rational[] rationalArray = (Rational[])property.getValue();
                            n = rationalArray.length;
                            break block1;
                        }
                        case PROPERTY: {
                            Property[] propArray = (Property[])property.getValue();
                            n = propArray.length;
                            break block1;
                        }
                        case NISOIMAGEMETADATA: {
                            NisoImageMetadata[] nisoArray = (NisoImageMetadata[])property.getValue();
                            n = nisoArray.length;
                            break block1;
                        }
                        case AESAUDIOMETADATA: {
                            AESAudioMetadata[] aesArray = (AESAudioMetadata[])property.getValue();
                            n = aesArray.length;
                            break block1;
                        }
                        case TEXTMDMETADATA: {
                            TextMDMetadata[] textMDArray = (TextMDMetadata[])property.getValue();
                            n = textMDArray.length;
                            break block1;
                        }
                    }
                    Object[] array2 = (Object[])property.getValue();
                    n = array2.length;
                    break;
                }
                default: {
                    n = property.getValue().toString().length() == 0 ? 0 : 1;
                }
            }
        }
        catch (Exception e) {
            return 0;
        }
        return n;
    }

    protected JsonObjectBuilder showArrayProperty(Property property) {
        boolean[] boolArray = null;
        byte[] byteArray = null;
        char[] charArray = null;
        Date[] dateArray = null;
        double[] doubleArray = null;
        float[] floatArray = null;
        int[] intArray = null;
        long[] longArray = null;
        Object[] objArray = null;
        Property[] propArray = null;
        short[] shortArray = null;
        String[] stringArray = null;
        Rational[] rationalArray = null;
        NisoImageMetadata[] nisoArray = null;
        AESAudioMetadata[] aesArray = null;
        TextMDMetadata[] textMDArray = null;
        int n = 0;
        PropertyType propType = property.getType();
        switch (propType) {
            case BOOLEAN: {
                boolArray = (boolean[])property.getValue();
                n = boolArray.length;
                break;
            }
            case BYTE: {
                byteArray = (byte[])property.getValue();
                n = byteArray.length;
                break;
            }
            case CHARACTER: {
                charArray = (char[])property.getValue();
                n = charArray.length;
                break;
            }
            case DATE: {
                dateArray = (Date[])property.getValue();
                n = dateArray.length;
                break;
            }
            case DOUBLE: {
                doubleArray = (double[])property.getValue();
                n = doubleArray.length;
                break;
            }
            case FLOAT: {
                floatArray = (float[])property.getValue();
                n = floatArray.length;
                break;
            }
            case INTEGER: {
                intArray = (int[])property.getValue();
                n = intArray.length;
                break;
            }
            case LONG: {
                longArray = (long[])property.getValue();
                n = longArray.length;
                break;
            }
            case OBJECT: {
                objArray = (Object[])property.getValue();
                n = objArray.length;
                break;
            }
            case SHORT: {
                shortArray = (short[])property.getValue();
                n = shortArray.length;
                break;
            }
            case STRING: {
                stringArray = (String[])property.getValue();
                n = stringArray.length;
                break;
            }
            case RATIONAL: {
                rationalArray = (Rational[])property.getValue();
                n = rationalArray.length;
                break;
            }
            case PROPERTY: {
                propArray = (Property[])property.getValue();
                n = propArray.length;
                break;
            }
            case NISOIMAGEMETADATA: {
                nisoArray = (NisoImageMetadata[])property.getValue();
                n = nisoArray.length;
                break;
            }
            case AESAUDIOMETADATA: {
                aesArray = (AESAudioMetadata[])property.getValue();
                n = aesArray.length;
                break;
            }
            case TEXTMDMETADATA: {
                textMDArray = (TextMDMetadata[])property.getValue();
                n = textMDArray.length;
                break;
            }
        }
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        block36: for (int i = 0; i < n; ++i) {
            switch (propType) {
                case BOOLEAN: {
                    arrayBuilder.add(boolArray[i]);
                    continue block36;
                }
                case BYTE: {
                    arrayBuilder.add(String.valueOf(byteArray[i]));
                    continue block36;
                }
                case CHARACTER: {
                    arrayBuilder.add(String.valueOf(charArray[i]));
                    continue block36;
                }
                case DATE: {
                    arrayBuilder.add(dateArray[i].toString());
                    continue block36;
                }
                case DOUBLE: {
                    arrayBuilder.add(doubleArray[i]);
                    continue block36;
                }
                case FLOAT: {
                    arrayBuilder.add(floatArray[i]);
                    continue block36;
                }
                case INTEGER: {
                    arrayBuilder.add(intArray[i]);
                    continue block36;
                }
                case LONG: {
                    arrayBuilder.add(longArray[i]);
                    continue block36;
                }
                case OBJECT: {
                    arrayBuilder.add(this.valueToString(objArray[i]));
                    continue block36;
                }
                case SHORT: {
                    arrayBuilder.add(shortArray[i]);
                    continue block36;
                }
                case STRING: {
                    arrayBuilder.add(stringArray[i]);
                    continue block36;
                }
                case RATIONAL: {
                    arrayBuilder.add(rationalArray[i].toString());
                    continue block36;
                }
                case PROPERTY: {
                    arrayBuilder.add(this.showProperty(propArray[i]));
                    continue block36;
                }
                case NISOIMAGEMETADATA: {
                    arrayBuilder.add(this.showNisoImageMetadata(nisoArray[i]));
                    continue block36;
                }
                case AESAUDIOMETADATA: {
                    arrayBuilder.add(this.showAESAudioMetadata(aesArray[i]));
                    continue block36;
                }
                case TEXTMDMETADATA: {
                    arrayBuilder.add(this.showTextMDMetadata(textMDArray[i]));
                    continue block36;
                }
                default: {
                    arrayBuilder.add("<error>");
                }
            }
        }
        return Json.createObjectBuilder().add(property.getName(), arrayBuilder);
    }

    protected JsonObjectBuilder showTextMDMetadata(TextMDMetadata textMD) {
        JsonObjectBuilder textmdBuilder = Json.createObjectBuilder();
        String s = textMD.getCharset();
        if (s != null) {
            textmdBuilder.add("textmd:charset", s);
        }
        if ((s = textMD.getByte_orderString()) != null) {
            textmdBuilder.add("textmd:byte_order", s);
        }
        if ((s = textMD.getByte_size()) != null) {
            textmdBuilder.add("textmd:byte_size", s);
        }
        if ((s = textMD.getCharacter_size()) != null) {
            textmdBuilder.add("textmd:character_size", s);
        }
        if ((s = textMD.getLinebreakString()) != null) {
            textmdBuilder.add("textmd:linebreak", s);
        }
        if ((s = textMD.getLanguage()) != null) {
            textmdBuilder.add("textmd:language", s);
        }
        if ((s = textMD.getMarkup_basis()) != null) {
            textmdBuilder.add("textmd:markup_basis", s);
        }
        if ((s = textMD.getMarkup_basis_version()) != null) {
            textmdBuilder.add("textmd:markup_basis_version", s);
        }
        if ((s = textMD.getMarkup_language()) != null) {
            textmdBuilder.add("textmd:markup_language", s);
        }
        if ((s = textMD.getMarkup_language_version()) != null) {
            textmdBuilder.add("textmd:markup_language_version", s);
        }
        return textmdBuilder;
    }

    protected JsonObjectBuilder showNisoImageMetadata(NisoImageMetadata niso) {
        if ("0.2".equals(this._je.getMixVersion())) {
            return null;
        }
        if (RELEASE.equals(this._je.getMixVersion())) {
            return this.showNisoImageMetadata(niso, true);
        }
        return this.showNisoImageMetadata(niso, false);
    }

    protected JsonObjectBuilder showNisoImageMetadata(NisoImageMetadata niso, boolean bMix10) {
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        JsonObjectBuilder ob = this.showNisoBasicDigitalObjectInformation(niso, bMix10);
        if (ob != null) {
            mixBuilder.add("mix:BasicDigitalObjectInformation", ob);
        }
        if ((ob = this.showNisoBasicImageInformation(niso, bMix10)) != null) {
            mixBuilder.add("mix:BasicImageInformation", ob);
        }
        if ((ob = this.showNisoImageCaptureMetadata(niso, bMix10)) != null) {
            mixBuilder.add("mix:ImageCaptureMetadata", ob);
        }
        if ((ob = this.showNisoImageAssessmentMetadata(niso, bMix10)) != null) {
            mixBuilder.add("mix:ImageAssessmentMetadata", ob);
        }
        if ((ob = this.showChangeHistory(niso, bMix10)) != null) {
            mixBuilder.add("mix:ChangeHistory", ob);
        }
        return mixBuilder;
    }

    protected JsonObjectBuilder showNisoBasicDigitalObjectInformation(NisoImageMetadata niso, boolean bMix10) {
        String compStr;
        long ln;
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        String s = niso.getImageIdentifier();
        if (s != null) {
            mixBuilder.add("mix:ObjectIdentifier", Json.createObjectBuilder().add("mix:objectIdentifierType", "JHOVE").add("mix:objectIdentifierValue", s));
        }
        if ((ln = niso.getFileSize()) != -1L) {
            mixBuilder.add("mix:fileSize", ln);
        }
        if ((s = niso.getMimeType()) != null) {
            mixBuilder.add("mix:formatName", s);
        }
        if ((s = niso.getByteOrder()) != null) {
            if (s.startsWith("big")) {
                s = bMix10 ? "big_endian" : "big endian";
            } else if (s.startsWith("little")) {
                s = bMix10 ? "little_endian" : "little endian";
            }
            mixBuilder.add("mix:byteOrder", s);
        }
        int comp = niso.getCompressionScheme();
        int level = niso.getCompressionLevel();
        switch (comp) {
            case 1: {
                compStr = "Uncompressed";
                break;
            }
            case 2: {
                compStr = "CCITT 1D";
                break;
            }
            case 3: {
                compStr = "Group 3 Fax";
                break;
            }
            case 4: {
                compStr = "Group 4 Fax";
                break;
            }
            case 5: {
                compStr = "LZW";
                break;
            }
            case 6: {
                compStr = "JPEG";
                break;
            }
            case 32773: {
                compStr = "PackBits";
                break;
            }
            case 34713: {
                compStr = "JPEG2000 Lossy";
                break;
            }
            case 34714: {
                compStr = "JPEG2000 Lossless";
                break;
            }
            default: {
                compStr = "Unknown";
            }
        }
        if (comp != -1) {
            if (comp == 34713 || comp == 34714) {
                mixBuilder.add("mix:compressionScheme", this.compressionSchemeToString(comp));
                if (level != -1) {
                    mixBuilder.add("mix:compressionRatio", level);
                }
            } else if (bMix10) {
                mixBuilder.add("mix:compressionScheme", Integer.toString(comp));
            } else {
                mixBuilder.add("mix:compressionScheme", compStr);
            }
        }
        int n = niso.getChecksumMethod();
        s = niso.getChecksumValue();
        if (n != -1 || s != null) {
            if (n != -1) {
                mixBuilder.add("mix:messageDigestAlgorithm", n);
            }
            if (s != null) {
                mixBuilder.add("mix:messageDigest", s);
            }
        }
        return mixBuilder;
    }

    protected JsonObjectBuilder showNisoBasicImageInformation(NisoImageMetadata niso, boolean bMix10) {
        int n;
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        boolean hasBuilder = false;
        long ln = niso.getImageWidth();
        if (ln != -1L) {
            mixBuilder.add("mix:imageWidth", ln);
            hasBuilder = true;
        }
        if ((ln = niso.getImageLength()) != -1L) {
            mixBuilder.add("mix:imageHeight", ln);
            hasBuilder = true;
        }
        if ((n = niso.getColorSpace()) != -1) {
            if (bMix10) {
                mixBuilder.add("mix:colorSpace", n);
            } else {
                mixBuilder.add("mix:colorSpace", this.photometricInterpretationToString(n));
            }
            hasBuilder = true;
        }
        String s = niso.getProfileName();
        String s2 = niso.getProfileURL();
        if (s != null || s2 != null) {
            JsonObjectBuilder iccBuilder = Json.createObjectBuilder();
            if (s != null) {
                iccBuilder.add("mix:iccProfileName", s);
            }
            if (s2 != null) {
                iccBuilder.add("mix:iccProfileURL", s2);
            }
            mixBuilder.add("mix:IccProfile", iccBuilder);
            hasBuilder = true;
        }
        int[] iarray = niso.getYCbCrSubSampling();
        n = niso.getYCbCrPositioning();
        Rational[] rarray = niso.getYCbCrCoefficients();
        if (iarray != null || n != -1 || rarray != null) {
            JsonObjectBuilder yccBuilder = Json.createObjectBuilder();
            if (iarray != null && iarray.length >= 2) {
                yccBuilder.add("mix:YCbCrSubSampling", Json.createObjectBuilder().add("mix:yCbCrSubsampleHoriz", iarray[0]).add("mix:yCbCrSubsampleVert", iarray[1]));
            }
            if (n != -1) {
                yccBuilder.add("mix:yCbCrPositioning", n);
            }
            if (rarray != null) {
                if (bMix10) {
                    yccBuilder.add("mix:yCbCrCoefficients", this.showArray(rarray));
                } else {
                    yccBuilder.add("mix:yCbCrCoefficients", Json.createObjectBuilder().add("mix:lumaRed", this.showRational(rarray[0])).add("mix:lumaGreen", this.showRational(rarray[1])).add("mix:lumaBlue", this.showRational(rarray[2])));
                }
            }
            mixBuilder.add("mix:YCbCr", yccBuilder);
            hasBuilder = true;
        }
        if ((rarray = niso.getReferenceBlackWhite()) != null) {
            if (bMix10) {
                mixBuilder.add("mix:referenceBlackWhite", this.showArray(rarray));
            } else {
                JsonArrayBuilder aBuilder = Json.createArrayBuilder();
                for (int i = 0; i < rarray.length - 1; i += 2) {
                    String pi;
                    JsonObjectBuilder cBuilder = Json.createObjectBuilder();
                    if (niso.getColorSpace() == 6) {
                        switch (i) {
                            case 0: {
                                pi = "Y";
                                break;
                            }
                            case 2: {
                                pi = "Cb";
                                break;
                            }
                            default: {
                                pi = "Cr";
                                break;
                            }
                        }
                    } else {
                        switch (i) {
                            case 0: {
                                pi = "R";
                                break;
                            }
                            case 2: {
                                pi = "G";
                                break;
                            }
                            default: {
                                pi = "B";
                            }
                        }
                    }
                    cBuilder.add("mix:componentPhotometricInterpretation", pi);
                    cBuilder.add("mix:footroom", this.showRational(rarray[i]));
                    cBuilder.add("mix:headroom", this.showRational(rarray[i + 1]));
                    aBuilder.add(cBuilder);
                }
                mixBuilder.add("mix:ReferenceBlackWhite", aBuilder);
            }
            hasBuilder = true;
        }
        int lay = niso.getJp2Layers();
        int lev = niso.getJp2ResolutionLevels();
        String sizTiles = niso.getJp2Tiles();
        if (sizTiles != null || lay != -1 || lev != -1) {
            JsonObjectBuilder jp2Builder = Json.createObjectBuilder();
            if (sizTiles != null) {
                if (bMix10) {
                    jp2Builder.add("mix:tiles", sizTiles);
                } else {
                    String[] sizes = sizTiles.split("x");
                    jp2Builder.add("mix:tiles", this.showArray(sizes));
                }
            }
            if (lay != -1) {
                jp2Builder.add("mix:qualityLayers", lay);
            }
            if (lev != -1) {
                jp2Builder.add("mix:resolutionLevels", lev);
            }
            mixBuilder.add("mix:JPEG2000", jp2Builder);
            hasBuilder = true;
        }
        if (hasBuilder) {
            return mixBuilder;
        }
        return null;
    }

    protected JsonObjectBuilder showNisoImageCaptureMetadata(NisoImageMetadata niso, boolean bMix10) {
        double[] darray;
        Rational r;
        String mfg;
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        boolean hasBuilder = false;
        String s = niso.getSourceType();
        if (s != null) {
            mixBuilder.add("mix:sourceType", s);
            hasBuilder = true;
        }
        if ((s = niso.getSourceID()) != null) {
            mixBuilder.add("mix:sourceIDValue", s);
            hasBuilder = true;
        }
        double d = niso.getSourceXDimension();
        int n = niso.getSourceXDimensionUnit();
        if (d != -1.0 || n != -1) {
            if (d != -1.0) {
                mixBuilder.add("mix:sourceXDimensionValue", d);
            }
            if (n != -1) {
                mixBuilder.add("mix:sourceXDimensionUnit", n);
            }
            d = niso.getSourceYDimension();
            n = niso.getSourceYDimensionUnit();
            if (d != -1.0 || n != -1) {
                if (d != -1.0) {
                    mixBuilder.add("mix:sourceYDimensionValue", d);
                }
                if (n != -1) {
                    mixBuilder.add("mix:sourceYDimensionUnit", n);
                }
            }
            hasBuilder = true;
        }
        if ((s = niso.getDateTimeCreated()) != null) {
            mixBuilder.add("mix:dateTimeCreated", s);
            hasBuilder = true;
        }
        if ((s = niso.getImageProducer()) != null) {
            mixBuilder.add("mix:imageProducer", s);
            hasBuilder = true;
        }
        if ((s = niso.getDeviceSource()) != null) {
            mixBuilder.add("mix:captureDevice", s);
            hasBuilder = true;
        }
        if ((mfg = niso.getScannerManufacturer()) != null) {
            mixBuilder.add("mix:scannerManufacturer", mfg);
            hasBuilder = true;
        }
        String model = niso.getScannerModelName();
        String modelNum = niso.getScannerModelNumber();
        String serNum = niso.getScannerModelSerialNo();
        if (model != null || modelNum != null || serNum != null) {
            hasBuilder = true;
            JsonObjectBuilder smBuilder = Json.createObjectBuilder();
            if (model != null) {
                smBuilder.add("mix:scannerModelName", model);
            }
            if (modelNum != null) {
                smBuilder.add("mix:scannerModelNumber", modelNum);
            }
            if (serNum != null) {
                smBuilder.add("mix:scannerModelSerialNo", serNum);
            }
            mixBuilder.add("mix:ScannerModel", smBuilder);
        }
        double xres = niso.getXPhysScanResolution();
        double yres = niso.getYPhysScanResolution();
        if (xres != -1.0 && yres != -1.0) {
            double res;
            double d2 = res = xres > yres ? xres : yres;
            if (bMix10) {
                mixBuilder.add("mix:maximumOpticalResolution", res);
            } else {
                mixBuilder.add("mix:MaximumOpticalResolution", Json.createObjectBuilder().add("mix:xOpticalResolution", xres).add("mix:yOpticalResolution", yres).add("mix:resolutionUnit", ".in"));
            }
            hasBuilder = true;
        }
        if ((s = niso.getScanningSoftware()) != null) {
            hasBuilder = true;
            mixBuilder.add("mix:scanningSoftwareName", s);
            s = niso.getScanningSoftwareVersionNo();
            if (s != null) {
                mixBuilder.add("mix:scanningSoftwareVersionNo", s);
            }
        }
        if ((s = niso.getDigitalCameraManufacturer()) != null) {
            mixBuilder.add("mix:digitalCameraManufacturer", s);
            hasBuilder = true;
        }
        String dcmodel = niso.getDigitalCameraModelName();
        String dcmodelNum = niso.getDigitalCameraModelNumber();
        String dcserNum = niso.getDigitalCameraModelSerialNo();
        if (dcmodel != null || dcmodelNum != null || dcserNum != null) {
            hasBuilder = true;
            JsonObjectBuilder smBuilder = Json.createObjectBuilder();
            if (dcmodel != null) {
                smBuilder.add("mix:digitalCameraModelName", dcmodel);
            }
            if (dcmodelNum != null) {
                smBuilder.add("mix:digitalCameraModelNumber", dcmodelNum);
            }
            if (dcserNum != null) {
                smBuilder.add("mix:mix:digitalCameraModelSerialNo", dcserNum);
            }
            mixBuilder.add("mix:DigitalCameraModel", smBuilder);
        }
        JsonObjectBuilder ccsBuilder = Json.createObjectBuilder();
        boolean useCcSetBuf = false;
        d = niso.getFNumber();
        if (d != -1.0) {
            ccsBuilder.add("mix:fNumber", d);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureTime()) != -1.0) {
            ccsBuilder.add("mix:exposureTime", d);
            useCcSetBuf = true;
        }
        if ((n = niso.getExposureProgram()) != -1) {
            if (bMix10) {
                ccsBuilder.add("mix:exposureProgram", n);
            } else {
                if (n > 8 || n < 0) {
                    n = 0;
                }
                ccsBuilder.add("mix:exposureProgram", NisoImageMetadata.EXPOSURE_PROGRAM[n]);
            }
            useCcSetBuf = true;
        }
        if ((s = niso.getExifVersion()) != null) {
            ccsBuilder.add("mix:exifVersion", s);
            useCcSetBuf = true;
        }
        if ((r = niso.getBrightness()) != null) {
            ccsBuilder.add("mix:brightnessValue", this.showRational(r));
            useCcSetBuf = true;
        }
        if ((r = niso.getExposureBias()) != null) {
            ccsBuilder.add("mix:exposureBiasValue", this.showRational(r));
            useCcSetBuf = true;
        }
        if ((r = niso.getMaxApertureValue()) != null) {
            ccsBuilder.add("mix:maxApertureValue", this.showRational(r));
            useCcSetBuf = true;
        }
        if ((darray = niso.getSubjectDistance()) != null) {
            ccsBuilder.add("mix:subjectDistance", this.showArray(darray));
            useCcSetBuf = true;
        }
        if ((n = niso.getMeteringMode()) != -1) {
            if (bMix10) {
                ccsBuilder.add("mix:meteringMode", n);
            } else {
                s = this.meteringModeToString(n);
                if (s.startsWith("Center weighted")) {
                    s = "Center weighted Average";
                }
                ccsBuilder.add("mix:MeteringMode", s);
            }
            useCcSetBuf = true;
        }
        if ((n = niso.getFlash()) != -1) {
            int firstBit = n & 1;
            ccsBuilder.add("mix:flash", NisoImageMetadata.FLASH_20[firstBit]);
            useCcSetBuf = true;
        }
        if ((d = niso.getFocalLength()) != -1.0) {
            ccsBuilder.add("mix:focalLength", d);
            useCcSetBuf = true;
        }
        if ((r = niso.getFlashEnergy()) != null) {
            ccsBuilder.add("mix:flashEnergy", this.showRational(r));
            useCcSetBuf = true;
        }
        if ((n = niso.getBackLight()) != -1) {
            ccsBuilder.add("mix:backLight", n);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureIndex()) != -1.0) {
            ccsBuilder.add("mix:exposureIndex", d);
            useCcSetBuf = true;
        }
        if ((n = niso.getAutoFocus()) != -1) {
            ccsBuilder.add("mix:autoFocus", n);
            useCcSetBuf = true;
        }
        d = niso.getXPrintAspectRatio();
        double d2 = niso.getYPrintAspectRatio();
        if (d != -1.0) {
            ccsBuilder.add("mix:xPrintAspectRatio", d);
            useCcSetBuf = true;
        }
        if (d2 != -1.0) {
            ccsBuilder.add("mix:yPrintAspectRatio", d);
            useCcSetBuf = true;
        }
        if (useCcSetBuf) {
            mixBuilder.add("mix:CameraCaptureSettings", ccsBuilder);
            hasBuilder = true;
        }
        if ((n = niso.getOrientation()) != -1) {
            if (bMix10) {
                mixBuilder.add("mix:orientation", n);
            } else {
                String[] orient = new String[]{"unknown", "normal*", "normal, image flipped", "normal, rotated 180\u00b0", "normal, image flipped, rotated 180\u00b0", "normal, image flipped, rotated cw 90\u00b0", "normal, rotated ccw 90\u00b0", "normal, image flipped, rotated ccw 90\u00b0", "normal, rotated cw 90\u00b0"};
                if (n > 8 || n < 0) {
                    n = 0;
                }
                mixBuilder.add("mix:orientation", orient[n]);
            }
            hasBuilder = true;
        }
        if ((s = niso.getMethodology()) != null) {
            mixBuilder.add("mix:methodology", s);
            hasBuilder = true;
        }
        if (hasBuilder) {
            return mixBuilder;
        }
        return null;
    }

    protected JsonObjectBuilder showNisoImageAssessmentMetadata(NisoImageMetadata niso, boolean bMix10) {
        String s;
        Rational r;
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        boolean hasBuilder = false;
        JsonObjectBuilder smBuilder = Json.createObjectBuilder();
        boolean useMetricsBuf = false;
        int n = niso.getSamplingFrequencyPlane();
        if (n != -1) {
            smBuilder.add("mix:samplingFrequencyPlane", n);
            useMetricsBuf = true;
        }
        if ((n = niso.getSamplingFrequencyUnit()) != -1) {
            if (bMix10) {
                smBuilder.add("mix:samplingFrequencyUnit", n);
            } else {
                String[] sfu = new String[]{null, "no absolute unit of measurement", "in.", "cm"};
                if (n < 1 || n > 3) {
                    n = 1;
                }
                smBuilder.add("mix:samplingFrequencyUnit", sfu[n]);
            }
            useMetricsBuf = true;
        }
        if ((r = niso.getXSamplingFrequency()) != null) {
            smBuilder.add("mix:xSamplingFrequency", this.showRational(r));
            useMetricsBuf = true;
        }
        if ((r = niso.getYSamplingFrequency()) != null) {
            smBuilder.add("mix:ySamplingFrequency", this.showRational(r));
            useMetricsBuf = true;
        }
        if (useMetricsBuf) {
            mixBuilder.add("mix:SpatialMetrics", smBuilder);
            hasBuilder = true;
        }
        JsonObjectBuilder imeBuilder = Json.createObjectBuilder();
        boolean useColorEncBuf = false;
        int[] iarray = niso.getBitsPerSample();
        if (iarray != null) {
            imeBuilder.add("mix:bitsPerSample", this.showArray(iarray));
            imeBuilder.add("mix:bitsPerSampleUnit", "integer");
            useColorEncBuf = true;
        }
        if ((n = niso.getSamplesPerPixel()) != -1) {
            imeBuilder.add("mix:samplesPerPixel", n);
            useColorEncBuf = true;
        }
        if ((iarray = niso.getExtraSamples()) != null && (n = iarray[0]) >= 0 && n <= 3) {
            if (bMix10) {
                imeBuilder.add("mix:extraSamples", this.showArray(iarray));
            } else {
                String[] sarray = new String[iarray.length];
                for (int ii = 0; ii < iarray.length; ++ii) {
                    sarray[ii] = NisoImageMetadata.EXTRA_SAMPLE_20[iarray[ii]];
                    imeBuilder.add("mix:extraSamples", this.showArray(sarray));
                }
            }
            useColorEncBuf = true;
        }
        if ((s = niso.getColormapReference()) != null) {
            imeBuilder.add("mix:colormapReference", s);
            useColorEncBuf = true;
        }
        if ((iarray = niso.getGrayResponseCurve()) != null) {
            imeBuilder.add("mix:grayResponseCurve", this.showArray(iarray));
            useColorEncBuf = true;
        }
        if ((n = niso.getGrayResponseUnit()) != -1) {
            if (bMix10) {
                imeBuilder.add("mix:grayResponseUnit", n);
            } else if (n > 0 && n <= 5) {
                imeBuilder.add("mix:grayResponseUnit", NisoImageMetadata.GRAY_RESPONSE_UNIT_20[n - 1]);
            }
            useColorEncBuf = true;
        }
        r = niso.getWhitePointXValue();
        Rational r2 = niso.getWhitePointYValue();
        if (r != null && r2 != null) {
            imeBuilder.add("mix:WhitePoint", Json.createObjectBuilder().add("mix:whitePointXValue", this.showRational(r)).add("mix:whitePointYValue", this.showRational(r2)));
            useColorEncBuf = true;
        }
        JsonObjectBuilder pcBuilder = Json.createObjectBuilder();
        boolean useChromaBuf = false;
        r = niso.getPrimaryChromaticitiesRedX();
        if (r != null) {
            pcBuilder.add("mix:primaryChromaticitiesRedX", this.showRational(r));
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesRedY()) != null) {
            pcBuilder.add("mix:primaryChromaticitiesRedY", this.showRational(r));
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesGreenX()) != null) {
            pcBuilder.add("mix:primaryChromaticitiesGreenX", this.showRational(r));
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesGreenY()) != null) {
            pcBuilder.add("mix:primaryChromaticitiesGreenY", this.showRational(r));
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesBlueX()) != null) {
            pcBuilder.add("mix:primaryChromaticitiesBlueX", this.showRational(r));
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesBlueY()) != null) {
            pcBuilder.add("mix:primaryChromaticitiesBlueY", this.showRational(r));
            useChromaBuf = true;
        }
        if (useChromaBuf) {
            imeBuilder.add("mix:PrimaryChromaticities", pcBuilder);
            useColorEncBuf = true;
        }
        if (useColorEncBuf) {
            mixBuilder.add("mix:ImageColorEncoding", imeBuilder);
            hasBuilder = true;
        }
        JsonObjectBuilder tdBuilder = Json.createObjectBuilder();
        boolean useTargetBuf = false;
        n = niso.getTargetType();
        if (n != -1) {
            tdBuilder.add("mix:targetType", n);
            useTargetBuf = true;
        }
        if ((s = niso.getTargetIDManufacturer()) != null) {
            tdBuilder.add("mix:targetManufacturer", s);
            useTargetBuf = true;
        }
        if ((s = niso.getTargetIDName()) != null) {
            tdBuilder.add("mix:targetName", s);
            useTargetBuf = true;
        }
        if ((s = niso.getTargetIDNo()) != null) {
            tdBuilder.add("mix:targetNo", s);
            useTargetBuf = true;
        }
        if ((s = niso.getTargetIDMedia()) != null) {
            tdBuilder.add("mix:targetMedia", s);
            useTargetBuf = true;
        }
        if ((s = niso.getImageData()) != null) {
            tdBuilder.add("mix:externalTarget", s);
            useTargetBuf = true;
        }
        if ((s = niso.getPerformanceData()) != null) {
            tdBuilder.add("mix:performanceData", s);
            useTargetBuf = true;
        }
        if (useTargetBuf) {
            mixBuilder.add("mix:TargetData", tdBuilder);
            hasBuilder = true;
        }
        if (hasBuilder) {
            return mixBuilder;
        }
        return null;
    }

    protected JsonObjectBuilder showChangeHistory(NisoImageMetadata niso, boolean bMix10) {
        String[] sarray;
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        boolean hasBuilder = false;
        String s = niso.getSourceData();
        if (s != null) {
            mixBuilder.add("mix:sourceData", s);
            hasBuilder = true;
        }
        if ((s = niso.getProcessingAgency()) != null) {
            mixBuilder.add("mix:processingAgency", s);
            hasBuilder = true;
        }
        JsonObjectBuilder psBuilder = Json.createObjectBuilder();
        boolean useSftwBuf = false;
        s = niso.getProcessingSoftwareName();
        if (s != null) {
            psBuilder.add("mix:processingSoftwareName", s);
            useSftwBuf = true;
        }
        if ((s = niso.getProcessingSoftwareVersion()) != null) {
            psBuilder.add("mix:processingSoftwareVersion", s);
            useSftwBuf = true;
        }
        if ((s = niso.getOS()) != null) {
            psBuilder.add("mix:processingOperatingSystemName", s);
            useSftwBuf = true;
        }
        if ((s = niso.getOSVersion()) != null) {
            psBuilder.add("mix:processingOperatingSystemVersion", s);
            useSftwBuf = true;
        }
        if (useSftwBuf) {
            mixBuilder.add("mix:ProcessingSoftware", psBuilder);
            hasBuilder = true;
        }
        if ((sarray = niso.getProcessingActions()) != null) {
            mixBuilder.add("mix:processingActions", this.showArray(sarray));
            hasBuilder = true;
        }
        if (hasBuilder) {
            return mixBuilder;
        }
        return null;
    }

    private String meteringModeToString(int n) {
        String s = NisoImageMetadata.METERING_MODE[1];
        if (n >= 1 && n <= 6) {
            s = NisoImageMetadata.METERING_MODE[n];
        }
        return s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1);
    }

    private String photometricInterpretationToString(int n) {
        switch (n) {
            case 0: {
                return "WhiteIsZero";
            }
            case 1: {
                return "BlackIsZero";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "PaletteColor";
            }
            case 4: {
                return "TransparencyMask";
            }
            case 5: {
                return "CMYK";
            }
            case 6: {
                return "YCbCr";
            }
            case 8: {
                return "CIELab";
            }
            case 9: {
                return "ICCLab";
            }
            case 10: {
                return "ITULab";
            }
            case 32803: {
                return "CFA";
            }
            case 34892: {
                return "LinearRaw";
            }
        }
        return "Unknown";
    }

    private String compressionSchemeToString(int n) {
        for (int i = 0; i < NisoImageMetadata.COMPRESSION_SCHEME_INDEX.length; ++i) {
            if (n != NisoImageMetadata.COMPRESSION_SCHEME_INDEX[i]) continue;
            return NisoImageMetadata.COMPRESSION_SCHEME[i];
        }
        return Integer.toString(n);
    }

    protected JsonObjectBuilder showAESAudioMetadata(AESAudioMetadata aes) {
        List<AESAudioMetadata.FormatRegion> flist;
        List<AESAudioMetadata.Face> facelist;
        String[] use;
        long lin;
        int in;
        JsonObjectBuilder aesBuilder = Json.createObjectBuilder();
        this._sampleRate = aes.getSampleRate();
        String s = aes.getAnalogDigitalFlag();
        if (s != null) {
            aesBuilder.add("aes:analogDigitalFlag", s);
        }
        if ((s = aes.getSchemaVersion()) != null) {
            aesBuilder.add("aes:schemaVersion", s);
        }
        if ((s = aes.getFormat()) != null) {
            aesBuilder.add("aes:format", s);
        }
        if ((s = aes.getSpecificationVersion()) != null) {
            aesBuilder.add("aes:specificationVersion", s);
        }
        if ((s = aes.getAppSpecificData()) != null) {
            aesBuilder.add("aes:appSpecificData", s);
        }
        if ((s = aes.getAudioDataEncoding()) != null) {
            aesBuilder.add("aes:audioDataEncoding", s);
        }
        if ((in = aes.getByteOrder()) != -1) {
            aesBuilder.add("aes:byteOrder", in == 0 ? "BIG_ENDIAN" : "LITTLE_ENDIAN");
        }
        if ((lin = aes.getFirstSampleOffset()) != -1L) {
            aesBuilder.add("aes:firstSampleOffset", lin);
        }
        if ((use = aes.getUse()) != null) {
            aesBuilder.add("aes:use", Json.createObjectBuilder().add("aes:useType", use[0]).add("aes:otherType", use[1]));
        }
        if ((s = aes.getPrimaryIdentifier()) != null) {
            String t = aes.getPrimaryIdentifierType();
            aesBuilder.add("aes:primaryIdentifier", s);
            if (t != null) {
                aesBuilder.add("aes:primaryIdentifierType", t);
            }
        }
        if ((facelist = aes.getFaceList()) != null && !facelist.isEmpty()) {
            int nchan;
            AESAudioMetadata.Face f = facelist.get(0);
            JsonObjectBuilder faceBuilder = Json.createObjectBuilder();
            AESAudioMetadata.TimeDesc startTime = f.getStartTime();
            if (startTime != null) {
                faceBuilder.add("aes:timeline", this.writeAESTimeRange(startTime, f.getDuration()));
            }
            if ((nchan = aes.getNumChannels()) != -1) {
                faceBuilder.add("aes:numChannels", nchan);
            }
            String[] locs = aes.getMapLocations();
            JsonArrayBuilder streamsBuilder = Json.createArrayBuilder();
            for (int ch = 0; ch < nchan; ++ch) {
                streamsBuilder.add(Json.createObjectBuilder().add("aes:channelNum", ch).add("aes:mapLocation", locs[ch]));
            }
            faceBuilder.add("aes:streams", streamsBuilder);
            aesBuilder.add("aes:face", faceBuilder);
        }
        if ((flist = aes.getFormatList()) != null && !flist.isEmpty()) {
            AESAudioMetadata.FormatRegion rgn = flist.get(0);
            int bitDepth = rgn.getBitDepth();
            double sampleRate = rgn.getSampleRate();
            int wordSize = rgn.getWordSize();
            String[] bitRed = rgn.getBitrateReduction();
            JsonArrayBuilder formatListBuilder = Json.createArrayBuilder();
            JsonObjectBuilder formatRegionBuilder = Json.createObjectBuilder();
            if (bitDepth != -1 || sampleRate != -1.0 || wordSize != -1) {
                if (bitDepth != -1) {
                    formatRegionBuilder.add("aes:bitDepth", bitDepth);
                }
                if (sampleRate != -1.0) {
                    formatRegionBuilder.add("aes:sampleRate", sampleRate);
                }
                if (wordSize != -1) {
                    formatRegionBuilder.add("aes:wordSize", wordSize);
                }
                if (bitRed != null) {
                    formatRegionBuilder.add("aes:bitrateReduction", Json.createObjectBuilder().add("aes:codecName", bitRed[0]).add("aes:codecNameVersion", bitRed[1]).add("aes:codecCreatorApplication", bitRed[2]).add("aes:codecCreatorApplicationVersion", bitRed[3]).add("aes:codecQuality", bitRed[4]).add("aes:dataRate", bitRed[5]).add("aes:dataRateMode", bitRed[6]));
                }
                formatListBuilder.add(formatRegionBuilder);
                aesBuilder.add("aes:formatList", formatListBuilder);
            }
        }
        return aesBuilder;
    }

    private JsonObjectBuilder writeAESTimeRange(AESAudioMetadata.TimeDesc start, AESAudioMetadata.TimeDesc duration) {
        double sr = start.getSampleRate();
        if (sr == 1.0) {
            sr = this._sampleRate;
        }
        JsonObjectBuilder timerangeBuilder = Json.createObjectBuilder();
        timerangeBuilder.add("tcf:startTime", Json.createObjectBuilder().add("tcf:frameCount", 30).add("tcf:timeBase", 1000).add("tcf:videoField", "FIELD_1").add("tcf:countingMode", "NTSC_NON_DROP_FRAME").add("tcf:hours", start.getHours()).add("tcf:minutes", start.getMinutes()).add("tcf:seconds", start.getSeconds()).add("tcf:frames", start.getFrames()).add("tcf:samples", Json.createObjectBuilder().add("tcf:sampleRate", "S" + Integer.toString((int)sr)).add("tcf:numberOfSamples", start.getSamples())).add("tcf:filmFraming", Json.createObjectBuilder().add("tcf:framing", "NOT_APPLICABLE").add("tcf:framingType", "tcf:ntscFilmFramingType")));
        if (duration != null) {
            sr = duration.getSampleRate();
            if (sr == 1.0) {
                sr = this._sampleRate;
            }
            timerangeBuilder.add("tcf:duration", Json.createObjectBuilder().add("tcf:frameCount", 30).add("tcf:timeBase", 1000).add("tcf:videoField", "FIELD_1").add("tcf:countingMode", "NTSC_NON_DROP_FRAME").add("tcf:hours", duration.getHours()).add("tcf:minutes", duration.getMinutes()).add("tcf:seconds", duration.getSeconds()).add("tcf:frames", duration.getFrames()).add("tcf:samples", Json.createObjectBuilder().add("tcf:sampleRate", "S" + Integer.toString((int)sr)).add("tcf:numberOfSamples", duration.getSamples())).add("tcf:filmFraming", Json.createObjectBuilder().add("tcf:framing", "NOT_APPLICABLE").add("tcf:framingType", "tcf:ntscFilmFramingType")));
        }
        return timerangeBuilder;
    }

    protected JsonArrayBuilder showArray(int[] iarray) {
        JsonArrayBuilder aBuilder = Json.createArrayBuilder();
        for (int i : iarray) {
            aBuilder.add(i);
        }
        return aBuilder;
    }

    protected JsonArrayBuilder showArray(double[] darray) {
        JsonArrayBuilder dBuilder = Json.createArrayBuilder();
        for (double d : darray) {
            dBuilder.add(d);
        }
        return dBuilder;
    }

    protected JsonArrayBuilder showArray(String[] sarray) {
        JsonArrayBuilder sBuilder = Json.createArrayBuilder();
        for (String s : sarray) {
            if (s == null) {
                sBuilder.addNull();
                continue;
            }
            sBuilder.add(s);
        }
        return sBuilder;
    }

    protected JsonArrayBuilder showArray(Rational[] rarray) {
        JsonArrayBuilder rBuilder = Json.createArrayBuilder();
        for (Rational r : rarray) {
            if (r == null) {
                rBuilder.addNull();
                continue;
            }
            rBuilder.add(this.showRational(r));
        }
        return rBuilder;
    }

    protected JsonArrayBuilder showRational(Rational r) {
        JsonArrayBuilder rationalBuilder = Json.createArrayBuilder();
        long numer = r.getNumerator();
        long denom = r.getDenominator();
        rationalBuilder.add(numer);
        rationalBuilder.add(denom);
        return rationalBuilder;
    }
}

