/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.ListIterator;

public class ObjectIdentifier {
    private List<Module> _moduleList;

    public ObjectIdentifier(List<Module> moduleList) {
        this._moduleList = moduleList;
    }

    public void identify(File file, RepInfo info, String parm, boolean verbose, boolean shortCheck) {
        ListIterator<Module> modIter = this._moduleList.listIterator();
        while (modIter.hasNext()) {
            RepInfo info1;
            block55: {
                info1 = (RepInfo)info.clone();
                Module mod = modIter.next();
                try {
                    Throwable throwable;
                    if (!mod.hasFeature("edu.harvard.hul.ois.jhove.canValidate")) continue;
                    if (mod.isRandomAccess()) {
                        throwable = null;
                        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                            mod.param(parm);
                            if (verbose) {
                                mod.setVerbosity(1);
                            }
                            if (shortCheck) {
                                mod.checkSignatures(file, raf, info1);
                            } else {
                                mod.parse(raf, info1);
                            }
                            break block55;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    mod.param(parm);
                    if (shortCheck) {
                        throwable = null;
                        try (FileInputStream stream = new FileInputStream(file);){
                            mod.checkSignatures(file, stream, info1);
                            break block55;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    int parseIndex = 0;
                    try (FileInputStream stream = new FileInputStream(file);){
                        parseIndex = mod.parse(stream, info1, 0);
                    }
                    while (parseIndex != 0) {
                        stream = new FileInputStream(file);
                        var11_14 = null;
                        try {
                            parseIndex = mod.parse(stream, info1, parseIndex);
                        }
                        catch (Throwable throwable4) {
                            var11_14 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (stream == null) continue;
                            if (var11_14 != null) {
                                try {
                                    ((InputStream)stream).close();
                                }
                                catch (Throwable throwable5) {
                                    var11_14.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            ((InputStream)stream).close();
                        }
                    }
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (info1.getWellFormed() != 1) continue;
            info.copy(info1);
            break;
        }
    }
}

