/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Callback;
import edu.harvard.hul.ois.jhove.ConfigHandler;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.MacStuff;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.viewer.AppInfoWindow;
import edu.harvard.hul.ois.jhove.viewer.ConfigWindow;
import edu.harvard.hul.ois.jhove.viewer.ModuleInfoWindow;
import edu.harvard.hul.ois.jhove.viewer.PrefsWindow;
import edu.harvard.hul.ois.jhove.viewer.ProgressWindow;
import edu.harvard.hul.ois.jhove.viewer.ViewHandler;
import java.awt.Color;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JhoveWindow
extends JFrame
implements Callback,
DropTargetListener {
    private App _app;
    private JhoveBase _base;
    private AppInfoWindow _appInfoWin;
    private ModuleInfoWindow _moduleInfoWin;
    private JMenu _moduleSubmenu;
    private JMenuItem _openFileItem;
    private JMenuItem _openURLItem;
    private JMenuItem _closeAllItem;
    private ButtonGroup _moduleGroup;
    private String syncStr = "";
    private boolean _rawOutput;
    private boolean _doChecksum;
    private ProgressWindow _progWind;
    private PrefsWindow _prefsWindow;
    private File _lastDir;
    private String _selectedModule;
    private ActionListener _moduleMenuListener;
    private JPanel logo;
    private ViewHandler _viewHandler;
    private static final int appInfoWinXPos = 50;
    private static final int appInfoWinYPos = 45;
    private static final int moduleInfoWinXPos = 100;
    private static final int moduleInfoWinYPos = 90;
    protected Logger _logger;
    private final InvisibleFilenameFilter invisibleFilter = new InvisibleFilenameFilter();

    public JhoveWindow(App app, JhoveBase base) {
        super("Jhove");
        this._logger = Logger.getLogger("edu.harvard.hul.ois.jhove.viewer");
        this._app = app;
        this._base = base;
        this._moduleMenuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JhoveWindow.this._selectedModule = e.getActionCommand();
            }
        };
        this._lastDir = null;
        this._moduleGroup = new ButtonGroup();
        this.addMenus();
        Container rootPane = this.getContentPane();
        this.setDefaultCloseOperation(3);
        Comparator<Module> modListComparator = new Comparator<Module>(){

            @Override
            public int compare(Module o1, Module o2) {
                Module m1 = o1;
                Module m2 = o2;
                String name1 = m1.getName();
                String name2 = m2.getName();
                return String.CASE_INSENSITIVE_ORDER.compare(name1, name2);
            }
        };
        Vector<String> moduleItems = new Vector<String>(10);
        List<Module> moduleList = base.getModuleList();
        ArrayList<Module> menuModuleList = new ArrayList<Module>(moduleList.size());
        menuModuleList.addAll(moduleList);
        Collections.sort(menuModuleList, modListComparator);
        Iterator iter = menuModuleList.iterator();
        moduleItems.add("(None selected)");
        JRadioButtonMenuItem modItem = null;
        String itemName = null;
        while (iter.hasNext()) {
            Module mod = (Module)iter.next();
            itemName = mod.getName();
            modItem = new JRadioButtonMenuItem(itemName);
            modItem.setActionCommand(itemName);
            modItem.addActionListener(this._moduleMenuListener);
            this._moduleSubmenu.add(modItem);
            this._moduleGroup.add(modItem);
        }
        this.logo = new JPanel();
        URL logoURL = JhoveWindow.class.getResource("jhovelogo.png");
        if (logoURL != null) {
            ImageIcon icn = new ImageIcon(logoURL);
            icn.setDescription("Jhove logo");
            this.setNormalBackground();
            JLabel logoLabel = new JLabel(icn);
            this.logo.add(logoLabel);
        }
        DropTarget dt = new DropTarget(this.logo, this);
        rootPane.add(this.logo);
        this.pack();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JhoveWindow.this._base.abort();
            }
        };
        this._progWind = new ProgressWindow(listener);
        this._viewHandler = new ViewHandler(this, this._app, this._base);
    }

    private final void addMenus() {
        final JhoveWindow jthis = this;
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        this._openFileItem = new JMenuItem("Open file...");
        fileMenu.add(this._openFileItem);
        this._openFileItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._openFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JhoveWindow.this.pickAndAnalyzeFile();
            }
        });
        this._openURLItem = new JMenuItem("Open URL...");
        fileMenu.add(this._openURLItem);
        this._openURLItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JhoveWindow.this.pickAndAnalyzeURL();
            }
        });
        this._closeAllItem = new JMenuItem("Close all document windows");
        fileMenu.add(this._closeAllItem);
        if (!MacStuff.isMacintosh()) {
            JMenuItem quitItem = new JMenuItem("Exit");
            fileMenu.add(quitItem);
            quitItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            quitItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        JMenu editMenu = new JMenu("Edit");
        menuBar.add(editMenu);
        this._moduleSubmenu = new JMenu("Select module");
        editMenu.add(this._moduleSubmenu);
        JRadioButtonMenuItem noModuleItem = new JRadioButtonMenuItem("(Any)");
        noModuleItem.setActionCommand("");
        noModuleItem.setSelected(true);
        noModuleItem.addActionListener(this._moduleMenuListener);
        this._moduleSubmenu.add(noModuleItem);
        this._moduleGroup.add(noModuleItem);
        this._selectedModule = "";
        JMenuItem editConfigItem = new JMenuItem("Edit configuration...");
        editMenu.add(editConfigItem);
        editConfigItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JhoveWindow.this.openConfigWindow();
            }
        });
        JMenuItem prefItem = new JMenuItem("Preferences...");
        editMenu.add(prefItem);
        prefItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JhoveWindow.this._prefsWindow == null) {
                    JhoveWindow.this._prefsWindow = new PrefsWindow(jthis);
                    JhoveWindow.this._prefsWindow.setLocation(180, 160);
                    JhoveWindow.this._prefsWindow.pack();
                }
                JhoveWindow.this._prefsWindow.saveAndShow();
            }
        });
        JMenu helpMenu = new JMenu("Help");
        menuBar.add(helpMenu);
        JMenuItem aboutModuleItem = new JMenuItem("About module...");
        helpMenu.add(aboutModuleItem);
        aboutModuleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JhoveWindow.this.showModuleInfo();
            }
        });
        JMenuItem aboutAppItem = new JMenuItem("About Jhove...");
        helpMenu.add(aboutAppItem);
        aboutAppItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JhoveWindow.this.showAppInfo();
            }
        });
        this.setJMenuBar(menuBar);
    }

    private void setNormalBackground() {
        this.logo.setBackground(new Color(255, 255, 255));
    }

    private void setDragBackground() {
        this.logo.setBackground(new Color(180, 240, 140));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pickAndAnalyzeFile() {
        this._openFileItem.setEnabled(false);
        this._openURLItem.setEnabled(false);
        File file = null;
        String string = this.syncStr;
        synchronized (string) {
            JFileChooser chooser = new JFileChooser();
            JhoveWindow.makeChooserOpaque(chooser);
            if (this._lastDir != null) {
                chooser.setCurrentDirectory(this._lastDir);
            }
            chooser.setDialogTitle("Pick a file to analyze");
            int ok = chooser.showOpenDialog(this);
            if (ok != 0) {
                this._openFileItem.setEnabled(true);
                this._openURLItem.setEnabled(true);
                return;
            }
            file = chooser.getSelectedFile();
            this._lastDir = chooser.getCurrentDirectory();
            ParseThread thr = new ParseThread(this);
            thr.setFile(file);
            thr.setModule(this.getSelectedModule());
            thr.start();
            this._base.setCurrentThread(thr);
        }
    }

    public static void makeChooserOpaque(JFileChooser chooser) {
        chooser.putClientProperty("JFileChooser.appBundleIsTraversable", "never");
        chooser.putClientProperty("JFileChooser.packageIsTraversable", "never");
    }

    public void pickAndAnalyzeFile1(File file, Module module) {
        String name = file.getName();
        this._base.resetAbort();
        this._progWind.setDocName(name, false);
        this._progWind.setProgressState(2, false);
        this._progWind.setByteCount(-1L, true);
        this._progWind.setVisible(true);
        try {
            ArrayList<File> files = new ArrayList<File>(1);
            files.add(file);
            this.openAndParse(files, module);
        }
        catch (ThreadDeath d) {
            this._openFileItem.setEnabled(true);
            this._openURLItem.setEnabled(true);
            throw d;
        }
        this._openFileItem.setEnabled(true);
        this._openURLItem.setEnabled(true);
    }

    public void pickAndAnalyzeFileList1(List<File> files, Module module) {
        if (files.isEmpty()) {
            return;
        }
        File file = files.get(0);
        String name = file.getName();
        this._base.resetAbort();
        this._progWind.setDocName(name, false);
        this._progWind.setProgressState(2, false);
        this._progWind.setByteCount(-1L, true);
        this._progWind.setVisible(true);
        try {
            this.openAndParse(files, module);
        }
        catch (ThreadDeath d) {
            this._openFileItem.setEnabled(true);
            this._openURLItem.setEnabled(true);
            throw d;
        }
        this._openFileItem.setEnabled(true);
        this._openURLItem.setEnabled(true);
    }

    public void analyzeDirectory(File file, Module module) {
        String[] subfiles = file.list(this.invisibleFilter);
        if (subfiles != null) {
            for (int i = 0; i < subfiles.length; ++i) {
                File subfile = new File(file, subfiles[i]);
                if (subfile == null) continue;
                if (subfile.isDirectory()) {
                    this.analyzeDirectory(subfile, module);
                    continue;
                }
                this.pickAndAnalyzeFile1(subfile, module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pickAndAnalyzeURL() {
        this._openFileItem.setEnabled(false);
        this._openURLItem.setEnabled(false);
        String uri = null;
        String string = this.syncStr;
        synchronized (string) {
            String urlStr = (String)JOptionPane.showInputDialog(this, "Choose a URL to analyze", "Select URL", -1, null, null, "http://");
            if (urlStr == null) {
                this._openFileItem.setEnabled(true);
                this._openURLItem.setEnabled(true);
                return;
            }
            uri = urlStr.trim();
        }
        ParseThread thr = new ParseThread(this);
        thr.setURI(uri);
        thr.setModule(this.getSelectedModule());
        thr.start();
    }

    public void pickAndAnalyzeURL1(String uri, Module module) {
        this._progWind.setDocName(uri.toString(), false);
        this._progWind.setProgressState(1, false);
        this._progWind.setContentLength(0L, false);
        this._progWind.setByteCount(0L, true);
        this._progWind.setVisible(true);
        try {
            this._base.dispatch(this._app, module, null, this._viewHandler, null, new String[]{uri});
        }
        catch (Exception e) {
            this.reportError("Error processing URL", e.getMessage());
        }
        this._progWind.setVisible(false);
        this._openFileItem.setEnabled(true);
        this._openURLItem.setEnabled(true);
    }

    @Override
    public int callback(int selector, Object parm) {
        switch (selector) {
            case 1: {
                long bytecnt = (Long)parm;
                this._progWind.setByteCount(bytecnt, true);
                break;
            }
            case 2: {
                String name = (String)parm;
                if (name.length() > 48) {
                    name = "..." + name.substring(name.length() - 48, name.length());
                }
                this._progWind.setDocName(name, true);
                break;
            }
        }
        return 0;
    }

    public void setRawOutput(boolean rawOutput) {
        this._rawOutput = rawOutput;
    }

    public void setDoChecksum(boolean checksum) {
        this._doChecksum = checksum;
    }

    private void openAndParse(List<File> files, Module module) {
        String[] paths = new String[files.size()];
        Iterator<File> iter = files.iterator();
        int i = 0;
        while (iter.hasNext()) {
            File fil = iter.next();
            paths[i] = fil.getAbsolutePath();
            if (!fil.exists()) {
                this._progWind.setVisible(false);
                return;
            }
            if (!fil.canRead()) {
                this._progWind.setVisible(false);
                this.reportError("File not readable", fil.getName());
                return;
            }
            ++i;
        }
        this._base.setShowRawFlag(this._rawOutput);
        this._base.setChecksumFlag(this._doChecksum);
        try {
            this._base.dispatch(this._app, module, null, this._viewHandler, null, paths);
        }
        catch (Exception e) {
            this._logger.warning(e.toString());
        }
        this._progWind.setVisible(false);
    }

    private void openConfigWindow() {
        String configFile = this._base.getConfigFile();
        ConfigHandler configHandler = new ConfigHandler();
        XMLReader parser = null;
        String saxClass = this._base.getSaxClass();
        try {
            if (saxClass != null) {
                parser = XMLReaderFactory.createXMLReader(saxClass);
            } else {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                parser = factory.newSAXParser().getXMLReader();
            }
            File config = new File(configFile);
            String canonicalPath = config.getCanonicalPath();
            String fileURL = "file://";
            if (canonicalPath.charAt(0) != '/') {
                fileURL = fileURL + '/';
            }
            fileURL = fileURL + canonicalPath;
            parser.setContentHandler(configHandler);
            parser.setEntityResolver(configHandler);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.parse(fileURL);
        }
        catch (IOException e) {
            this.reportError("Config Error", "Cannot read configuration file");
            return;
        }
        catch (SAXException e) {
            this.reportError("Config Error", "SAX parser not found: " + saxClass);
            return;
        }
        catch (ParserConfigurationException e) {
            this.reportError("Config Error", "ParserConfigurationException");
        }
        ConfigWindow confWin = new ConfigWindow(this, new File(configFile), configHandler);
        confWin.setLocation(120, 40);
        confWin.setVisible(true);
    }

    private void showModuleInfo() {
        Module module = this.getSelectedModule();
        if (this._moduleInfoWin == null) {
            this._moduleInfoWin = new ModuleInfoWindow(this._app, this._base, module);
            this._moduleInfoWin.setLocation(100, 90);
        } else {
            this._moduleInfoWin.showModule(module);
        }
        this._moduleInfoWin.setVisible(true);
    }

    private void showAppInfo() {
        if (this._appInfoWin == null) {
            this._appInfoWin = new AppInfoWindow(this._app, this._base);
            this._appInfoWin.setLocation(50, 45);
        }
        this._appInfoWin.setVisible(true);
    }

    private Module getSelectedModule() {
        if ("".equals(this._selectedModule)) {
            return null;
        }
        return this._base.getModuleMap().get(this._selectedModule.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportError(String title, String msg) {
        String string = this.syncStr;
        synchronized (string) {
            JOptionPane.showMessageDialog(this, msg, title, 0);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (this.dataFlavorOK(flavors)) {
            this.setDragBackground();
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.setNormalBackground();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (this.dataFlavorOK(flavors)) {
            dtde.acceptDrop(dtde.getDropAction());
            Transferable thingy = dtde.getTransferable();
            try {
                List fileList = (List)thingy.getTransferData(DataFlavor.javaFileListFlavor);
                ParseThread thr = new ParseThread(this);
                thr.setFileList(fileList);
                thr.setModule(this.getSelectedModule());
                thr.start();
                this._base.setCurrentThread(thr);
                dtde.dropComplete(true);
            }
            catch (Exception e) {
                dtde.dropComplete(false);
                return;
            }
        } else {
            dtde.rejectDrop();
        }
        this.setNormalBackground();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    protected JMenuItem getCloseAllItem() {
        return this._closeAllItem;
    }

    private boolean dataFlavorOK(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].isFlavorJavaFileListType()) continue;
            return true;
        }
        return false;
    }

    protected class InvisibleFilenameFilter
    implements FilenameFilter {
        protected InvisibleFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return !name.startsWith(".");
        }
    }

    class ParseThread
    extends Thread {
        private JhoveWindow _win;
        private String _uri;
        private File _file;
        private List<File> _fileList;
        private Module _module;

        protected ParseThread(JhoveWindow win) {
            this._win = win;
        }

        @Override
        public void run() {
            JhoveWindow.this._base.resetAbort();
            try {
                if (this._uri != null) {
                    this._win.pickAndAnalyzeURL1(this._uri, this._module);
                } else if (this._file != null) {
                    if (this._file.isDirectory()) {
                        JhoveWindow.this.analyzeDirectory(this._file, this._module);
                    } else {
                        this._win.pickAndAnalyzeFile1(this._file, this._module);
                    }
                } else if (this._fileList != null) {
                    this._win.pickAndAnalyzeFileList1(this._fileList, this._module);
                }
                JhoveWindow.this._base.setCurrentThread(null);
            }
            catch (ThreadDeath d) {
                JhoveWindow.this._progWind.setVisible(false);
                throw d;
            }
        }

        protected void setURI(String uri) {
            this._uri = uri;
        }

        protected void setFile(File file) {
            this._file = file;
        }

        protected void setFileList(List<File> fileList) {
            this._fileList = fileList;
        }

        protected void setModule(Module module) {
            this._module = module;
        }
    }
}

