/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.viewer.JhoveWindow;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrefsWindow
extends JDialog {
    private JhoveWindow jhoveWin;
    private JCheckBox rawCheckBox;
    private JCheckBox checksumCheckBox;
    private boolean saveRawOutput;
    private boolean saveChecksum;

    public PrefsWindow(JhoveWindow owner) {
        super(owner, "Jhove Preferences", true);
        this.addWindowListener(new PrefsWindowListener(this));
        this.jhoveWin = owner;
        JPanel mainPanel = new JPanel(new GridLayout(4, 1));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.rawCheckBox = new JCheckBox("Raw data", false);
        mainPanel.add(this.rawCheckBox);
        this.checksumCheckBox = new JCheckBox("Calculate checksums", false);
        mainPanel.add(this.checksumCheckBox);
        JPanel bottomPanel = new JPanel(new GridLayout(1, 3));
        this.getContentPane().add((Component)bottomPanel, "South");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefsWindow.this.setPrefsFromDialog();
                PrefsWindow.this.hide();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefsWindow.this.hide();
                PrefsWindow.this.restore();
            }
        });
        bottomPanel.add(new JLabel(""));
        bottomPanel.add(cancelButton);
        bottomPanel.add(okButton);
    }

    public void saveAndShow() {
        this.saveRawOutput = this.rawCheckBox.isSelected();
        this.saveChecksum = this.checksumCheckBox.isSelected();
        this.show();
    }

    private void restore() {
        this.rawCheckBox.setSelected(this.saveRawOutput);
        this.checksumCheckBox.setSelected(this.saveChecksum);
    }

    private void setPrefsFromDialog() {
        this.jhoveWin.setRawOutput(this.rawCheckBox.isSelected());
        this.jhoveWin.setDoChecksum(this.checksumCheckBox.isSelected());
    }

    private class PrefsWindowListener
    extends WindowAdapter {
        private PrefsWindow prefsWin;

        public PrefsWindowListener(PrefsWindow w) {
            this.prefsWin = w;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.prefsWin.restore();
        }
    }
}

