/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.ModuleInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigHandler
extends DefaultHandler {
    private String _class;
    protected StringBuffer _content;
    private static final String configSchemaName = "jhoveConfig.xsd";
    private List<String[]> _handler;
    protected List<List<String>> _handlerParams;
    private String _init;
    private List<String> _param;
    private String _tempDir = null;
    private String _mixVsn = null;
    private String _encoding = null;
    private String language = "";
    private String _logLevel = null;
    private int _bufferSize = -1;
    private String _jhoveHome;
    private int _sigBytes = 1024;
    protected boolean _isHandler = false;
    protected boolean _isLanguage = false;
    protected boolean _isModule = false;
    private boolean _isTempDir = false;
    private boolean _isMixVsn;
    private boolean _isEncoding = false;
    private boolean _isBufferSize = false;
    private boolean _isJhoveHome = false;
    private boolean _isLogLevel = false;
    private boolean _isSigBytes;
    protected List<ModuleInfo> _module = new ArrayList<ModuleInfo>();
    protected List<List<String>> _modParams;

    public ConfigHandler() {
        this._handler = new ArrayList<String[]>();
        this._modParams = new ArrayList<List<String>>();
        this._handlerParams = new ArrayList<List<String>>();
    }

    public List<ModuleInfo> getModule() {
        return this._module;
    }

    public List<List<String>> getModuleParams() {
        return this._modParams;
    }

    public List<List<String>> getHandlerParams() {
        return this._handlerParams;
    }

    public List<String[]> getHandler() {
        return this._handler;
    }

    public String getTempDir() {
        return this._tempDir;
    }

    public String getMixVsn() {
        return this._mixVsn;
    }

    public int getSigBytes() {
        return this._sigBytes;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public String getJhoveHome() {
        return this._jhoveHome;
    }

    public String getLogLevel() {
        return this._logLevel;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) {
        this._content = new StringBuffer();
        if ("module".equals(rawName)) {
            this._isModule = true;
            this._init = null;
            this._param = new ArrayList<String>(1);
            this._class = null;
        } else if ("outputHandler".equals(rawName)) {
            this._isHandler = true;
            this._init = null;
            this._param = new ArrayList<String>(1);
            this._class = null;
        } else if ("languageCode".equals(rawName)) {
            this._isLanguage = true;
            this._init = null;
            this._param = new ArrayList<String>(1);
            this._class = null;
        } else if ("tempDirectory".equals(rawName)) {
            this._isTempDir = true;
        } else if ("mixVersion".equals(rawName)) {
            this._isMixVsn = true;
        } else if ("defaultEncoding".equals(rawName)) {
            this._isEncoding = true;
        } else if ("bufferSize".equals(rawName)) {
            this._isBufferSize = true;
        } else if ("jhoveHome".equals(rawName)) {
            this._isJhoveHome = true;
        } else if ("logLevel".equals(rawName)) {
            this._isLogLevel = true;
        } else if ("sigBytes".equals(rawName)) {
            this._isSigBytes = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this._content.append(ch, start, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) {
        if (this._isModule) {
            if ("class".equals(rawName)) {
                this._class = this._content.toString();
            } else if ("init".equals(rawName)) {
                this._init = this._content.toString();
            } else if ("param".equals(rawName)) {
                this._param.add(this._content.toString());
            } else if ("module".equals(rawName)) {
                ModuleInfo modInfo = new ModuleInfo(this._class, this._init);
                this._module.add(modInfo);
                this._modParams.add(this._param);
                this._isModule = false;
            }
        } else if (this._isHandler) {
            if ("class".equals(rawName)) {
                this._class = this._content.toString();
            } else if ("init".equals(rawName)) {
                this._init = this._content.toString();
            } else if ("param".equals(rawName)) {
                this._param.add(this._content.toString());
            } else if ("outputHandler".equals(rawName)) {
                String[] tuple = new String[]{this._class, this._init};
                this._handler.add(tuple);
                this._handlerParams.add(this._param);
                this._isHandler = false;
            }
        } else if (this._isLanguage) {
            this.language = this._content.toString().trim();
            this._isLanguage = false;
        } else if (this._isTempDir) {
            this._tempDir = this._content.toString().trim();
            this._isTempDir = false;
        } else if (this._isMixVsn) {
            this._mixVsn = this._content.toString().trim();
            this._isMixVsn = false;
        } else if (this._isSigBytes) {
            try {
                this._sigBytes = Integer.parseInt(this._content.toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this._isSigBytes = false;
        } else if (this._isEncoding) {
            this._encoding = this._content.toString().trim();
            this._isEncoding = false;
        } else if (this._isJhoveHome) {
            this._jhoveHome = this._content.toString().trim();
            this._isJhoveHome = false;
        } else if (this._isLogLevel) {
            this._logLevel = this._content.toString().trim();
            this._isLogLevel = false;
        } else if (this._isBufferSize) {
            try {
                this._bufferSize = Integer.parseInt(this._content.toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this._isBufferSize = false;
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId.endsWith(configSchemaName)) {
            try {
                URL resURL = this.getClass().getResource(configSchemaName);
                InputStream strm = resURL.openStream();
                return new InputSource(strm);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.resolveEntity(publicId, systemId);
    }
}

