/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.viewer.JhoveWindow;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class InfoWindow
extends JFrame {
    protected App _app;
    private JhoveBase _base;
    private JMenuItem _saveItem;
    private JMenuItem _closeItem;
    private JComboBox<String> _handlerBox;
    private JComboBox<String> _encodingBox;
    private static String _lastEncoding;
    private static String _lastHandler;
    protected static final String eol;
    private static final String[] encodings;
    protected SimpleDateFormat _dateFmt;
    private static final String FILE_NOT_SAVED = "File not saved";

    public InfoWindow(String title, App app, JhoveBase base) throws HeadlessException {
        super(title);
        if (title.length() > 32) {
            this.setTitle(title.substring(0, 29) + "...");
        }
        this._app = app;
        this._base = base;
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        this._saveItem = new JMenuItem("Save as...");
        this._saveItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fileMenu.add(this._saveItem);
        this._closeItem = new JMenuItem("Close");
        fileMenu.add(this._closeItem);
        this._closeItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this._closeItem.addActionListener(e -> this.closeFromMenu());
        this.setDefaultCloseOperation(1);
        this.setJMenuBar(menuBar);
        this._dateFmt = new SimpleDateFormat("yyyy-MM-dd");
    }

    protected void setSaveActionListener(ActionListener listener) {
        this._saveItem.addActionListener(listener);
    }

    protected PrintWriter doSaveDialog() {
        JFileChooser saver = new JFileChooser();
        JhoveWindow.makeChooserOpaque(saver);
        File lastDir = this._base.getSaveDirectory();
        if (lastDir != null) {
            saver.setCurrentDirectory(lastDir);
        }
        JPanel accessory = new JPanel();
        accessory.setPreferredSize(new Dimension(180, 120));
        Vector<String> handlerItems = new Vector<String>(10);
        for (OutputHandler han : this._base.getHandlerList()) {
            handlerItems.add(han.getName());
        }
        this._handlerBox = new JComboBox(handlerItems);
        this._handlerBox.setSize(120, 20);
        accessory.add(new JLabel("Choose output handler"));
        if (_lastHandler != null) {
            this._handlerBox.setSelectedItem(_lastHandler);
        }
        accessory.add(this._handlerBox);
        Vector<String> encItems = new Vector<String>(encodings.length + 1);
        String defaultEncoding = this._base.getEncoding();
        ArrayList<String> otherEncodings = new ArrayList<String>(encodings.length);
        for (String encoding : encodings) {
            if (encoding.equalsIgnoreCase(defaultEncoding)) {
                encItems.add(encoding);
                continue;
            }
            otherEncodings.add(encoding);
        }
        encItems.addAll(otherEncodings);
        this._encodingBox = new JComboBox(encItems);
        if (_lastEncoding != null) {
            this._encodingBox.setSelectedItem(_lastEncoding);
        }
        this._encodingBox.setSize(120, 20);
        this._encodingBox.setEditable(true);
        accessory.add(new JLabel("Select encoding"));
        accessory.add(this._encodingBox);
        saver.setAccessory(accessory);
        saver.setDialogTitle("Save information to file");
        int retval = saver.showSaveDialog(this);
        if (retval == 0) {
            FileOutputStream os = null;
            File file = null;
            try {
                this._base.setSaveDirectory(saver.getCurrentDirectory());
                file = saver.getSelectedFile();
                if (file.exists()) {
                    int opt = JOptionPane.showConfirmDialog(this, "That file already exists. Replace?", "Replace", 2);
                    if (opt != 0) {
                        return null;
                    }
                    if (!file.delete()) {
                        JOptionPane.showMessageDialog(this, "Could not delete file", "File not deleted", 0);
                        return null;
                    }
                }
                file.createNewFile();
                String encoding = (String)this._encodingBox.getSelectedItem();
                os = new FileOutputStream(file);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, encoding);
                return new PrintWriter(writer);
            }
            catch (UnsupportedEncodingException uee) {
                JOptionPane.showMessageDialog(this, "Unknown encoding ", FILE_NOT_SAVED, 0);
                try {
                    if (os != null) {
                        os.close();
                    }
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ioe.getMessage(), FILE_NOT_SAVED, 0);
                try {
                    if (os != null) {
                        os.close();
                    }
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    protected OutputHandler selectHandler() {
        _lastHandler = (String)this._handlerBox.getSelectedItem();
        OutputHandler handler = this._base.getHandlerMap().get(_lastHandler.toLowerCase());
        _lastEncoding = (String)this._encodingBox.getSelectedItem();
        handler.setEncoding(_lastEncoding);
        handler.setApp(this._app);
        handler.setBase(this._base);
        return handler;
    }

    protected void closeFromMenu() {
        this.setVisible(false);
    }

    static {
        eol = System.getProperty("line.separator");
        encodings = new String[]{"UTF-8", "ISO-8859-1", "Cp1252", "MacRoman"};
    }
}

