/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.viewer.InfoWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AppInfoWindow
extends InfoWindow {
    private JTextArea texta;

    public AppInfoWindow(App app, JhoveBase jbase) {
        super("JHOVE Information", app, jbase);
        this.setSaveActionListener(e -> this.saveInfo());
        this.texta = new JTextArea();
        this.texta.setColumns(72);
        JScrollPane scrollpane = new JScrollPane(this.texta);
        this.texta.setFont(new Font("sansserif", 0, 10));
        this.texta.setLineWrap(true);
        this.texta.setWrapStyleWord(true);
        scrollpane.setMinimumSize(new Dimension(240, 240));
        scrollpane.setMaximumSize(new Dimension(500, 250));
        scrollpane.setPreferredSize(new Dimension(500, 250));
        this.getContentPane().add((Component)scrollpane, "Center");
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(8, 8));
        this.getContentPane().add((Component)panel, "South");
        this.showApp(app, jbase);
        this.pack();
        this.texta.setEditable(false);
        this.texta.select(0, 0);
        Rectangle r = new Rectangle(0, 0, 1, 1);
        this.texta.scrollRectToVisible(r);
    }

    private void showApp(App app, JhoveBase jbase) {
        String saxClass;
        String configFile;
        Date dt;
        String rel;
        String appName = app.getName();
        if (appName != null) {
            this.texta.append("Name: " + appName + eol);
        }
        if ((rel = app.getRelease()) != null) {
            this.texta.append("Release: " + rel);
        }
        if ((dt = app.getDate()) != null) {
            this.texta.append("   " + this._dateFmt.format(dt) + eol);
        }
        if ((configFile = jbase.getConfigFile()) != null) {
            this.texta.append("Configuration: " + configFile + eol);
        }
        if ((saxClass = jbase.getSaxClass()) != null) {
            this.texta.append("SAX parser: " + saxClass + eol);
        }
        for (String moduleName : jbase.getModuleMap().keySet()) {
            Map<String, Module> moduleMap = jbase.getModuleMap();
            Module module = moduleMap.get(moduleName);
            this.texta.append(" Module: " + module.getName() + " " + module.getRelease() + eol);
        }
        String rights = app.getRights();
        if (rights != null) {
            this.texta.append(" Rights: " + rights + eol);
        }
    }

    private void saveInfo() {
        PrintWriter wtr = this.doSaveDialog();
        if (wtr == null) {
            return;
        }
        OutputHandler handler = this.selectHandler();
        try {
            handler.setWriter(wtr);
            handler.show(this._app);
            wtr.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error writing file", 0);
        }
    }
}

