/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.ExitCode;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.JhoveException;
import edu.harvard.hul.ois.jhove.viewer.JhoveWindow;
import java.awt.Toolkit;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class JhoveView {
    private static final Logger LOGGER = Logger.getLogger(JhoveView.class.getCanonicalName());
    private static final String NAME = "JhoveView";
    private static final String ICON_PATH = "org/openpreservation/jhove/icon.png";

    private JhoveView() {
    }

    public static void main(String[] args) {
        String version = System.getProperty("java.vm.version");
        if (version.compareTo("1.8.0") < 0) {
            LOGGER.log(Level.SEVERE, "Java 1.8 or higher is required");
            JhoveView.errorAlert("Java 1.8 or higher is required");
            System.exit(ExitCode.INCOMPATIBLE_VM.getReturnCode());
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        App app = App.newAppWithName(NAME);
        try {
            String configFile = JhoveBase.getConfigFileFromProperties();
            String saxClass = JhoveBase.getSaxClassFromProperties();
            boolean quoted = false;
            for (int i = 0; i < args.length; ++i) {
                if (quoted) {
                    int len = args[i].length();
                    if (args[i].charAt(len - 1) != '\"') continue;
                    quoted = false;
                    continue;
                }
                if ("-c".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    configFile = args[++i];
                    continue;
                }
                if ("-x".equals(args[i])) {
                    if (i >= args.length - 1) continue;
                    saxClass = args[++i];
                    continue;
                }
                if (args[i].charAt(0) != '\"') continue;
                quoted = true;
            }
            JhoveBase je = new JhoveBase();
            try {
                je.init(configFile, saxClass);
            }
            catch (JhoveException e) {
                JhoveView.errorAlert(e.getMessage());
            }
            JhoveWindow jwin = new JhoveWindow(app, je);
            URL url = ClassLoader.getSystemResource(ICON_PATH);
            Toolkit kit = Toolkit.getDefaultToolkit();
            jwin.setIconImage(kit.createImage(url));
            jwin.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            LOGGER.log(Level.SEVERE, e.getMessage());
            System.exit(ExitCode.ERROR.getReturnCode());
        }
    }

    private static void errorAlert(String msg) {
        JFrame hiddenFrame = new JFrame();
        String message = msg.length() > 80 ? msg.substring(0, 79) + "..." : msg;
        LOGGER.log(Level.WARNING, msg);
        JOptionPane.showMessageDialog(hiddenFrame, message, "Jhove Error", 0);
    }
}

