/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.viewer.InfoWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ModuleInfoWindow
extends InfoWindow {
    private JTextArea texta;
    private int _level;
    private Module _module;
    private static final String DATE = "Date: ";
    private static final String NOTE = "Note: ";
    private static final String TYPE = "Type: ";

    public ModuleInfoWindow(App app, JhoveBase base, Module module) {
        super("Module Information", app, base);
        this._module = module;
        this.setSaveActionListener(e -> this.saveInfo());
        this.texta = new JTextArea();
        this.texta.setColumns(72);
        JScrollPane scrollpane = new JScrollPane(this.texta);
        this.texta.setFont(new Font("sansserif", 0, 10));
        this.texta.setLineWrap(true);
        this.texta.setWrapStyleWord(true);
        scrollpane.setMinimumSize(new Dimension(240, 240));
        scrollpane.setMaximumSize(new Dimension(600, 500));
        scrollpane.setPreferredSize(new Dimension(600, 500));
        this.getContentPane().add((Component)scrollpane, "Center");
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(8, 8));
        this.getContentPane().add((Component)panel, "South");
        this.showModule(module);
        this.pack();
    }

    public void showModule(Module module) {
        this._module = module;
        if (module == null) {
            this.texta.setText("(No module selected)");
        } else {
            Agent vendor;
            String s;
            this._level = 0;
            this.texta.setText("");
            String margin = this.getIndent(++this._level);
            this.texta.append(margin + "Module: " + module.getName() + eol);
            this.texta.append(margin + "Release: " + module.getRelease() + eol);
            this.texta.append(margin + DATE + this._dateFmt.format(module.getDate()) + eol);
            String[] ss = module.getFormat();
            if (ss.length > 0) {
                this.texta.append(margin + "Format: " + ss[0]);
                for (int i = 1; i < ss.length; ++i) {
                    this.texta.append(", " + ss[i]);
                }
                this.texta.append(eol);
            }
            if ((s = module.getCoverage()) != null) {
                this.texta.append(margin + "Coverage: " + s + eol);
            }
            if ((ss = module.getMimeType()).length > 0) {
                this.texta.append(margin + "MIMEtype: " + ss[0]);
                for (int i = 1; i < ss.length; ++i) {
                    this.texta.append(", " + ss[i]);
                }
                this.texta.append(eol);
            }
            for (Signature sig : module.getSignature()) {
                this.showSignature(sig);
            }
            for (Document spec : module.getSpecification()) {
                this.showDocument(spec, "Specification");
            }
            this.texta.append(margin + " Features:\n");
            for (String feature : module.getFeatures()) {
                this.texta.append(margin + "  " + feature + "\n");
            }
            this.texta.append(margin + "Methodology:\n");
            s = module.getWellFormedNote();
            if (s != null) {
                this.texta.append(margin + "Well-formed: " + s + eol);
            }
            if ((s = module.getValidityNote()) != null) {
                this.texta.append(margin + "Validity: " + s + eol);
            }
            if ((s = module.getRepInfoNote()) != null) {
                this.texta.append(margin + "RepresentationInformation: " + s + eol);
            }
            if ((vendor = module.getVendor()) != null) {
                this.showAgent(vendor, "Vendor");
            }
            if ((s = module.getNote()) != null) {
                this.texta.append(margin + NOTE + s + eol);
            }
            if ((s = module.getRights()) != null) {
                this.texta.append(margin + "Rights: " + s + eol);
            }
        }
        this.texta.setEditable(false);
        this.texta.select(0, 0);
        Rectangle r = new Rectangle(0, 0, 1, 1);
        this.texta.scrollRectToVisible(r);
    }

    private void showSignature(Signature signature) {
        String use;
        String note;
        String margin = this.getIndent(++this._level);
        String sigValue = signature.isStringValue() ? signature.getValueString() : signature.getValueHexString();
        this.texta.append(margin + signature.getType().toString() + ": " + sigValue + eol);
        if (signature.getType().equals((Object)SignatureType.MAGIC) && ((InternalSignature)signature).hasFixedOffset()) {
            this.texta.append(margin + "Offset: " + ((InternalSignature)signature).getOffset() + eol);
        }
        if ((note = signature.getNote()) != null) {
            this.texta.append(margin + NOTE + note + eol);
        }
        if ((use = signature.getUse().toString()) != null) {
            this.texta.append(margin + "Use: " + use + eol);
        }
        --this._level;
    }

    private void showDocument(Document document, String label) {
        String margin = this.getIndent(++this._level);
        this.texta.append(margin + label + ": " + document.getTitle() + eol);
        this.texta.append(margin + TYPE + (Object)((Object)document.getType()) + eol);
        for (Agent agent : document.getAuthor()) {
            this.showAgent(agent, "Author");
        }
        for (Agent publisher : document.getPublisher()) {
            this.showAgent(publisher, "Publisher");
        }
        String s = document.getEdition();
        if (s != null) {
            this.texta.append(margin + "Edition: " + s + eol);
        }
        if ((s = document.getDate()) != null) {
            this.texta.append(margin + DATE + s + eol);
        }
        if ((s = document.getEnumeration()) != null) {
            this.texta.append(margin + "Enumeration: " + s + eol);
        }
        if ((s = document.getPages()) != null) {
            this.texta.append(margin + "Pages: " + s + eol);
        }
        for (Identifier id : document.getIdentifier()) {
            this.showIdentifier(id);
        }
        s = document.getNote();
        if (s != null) {
            this.texta.append(margin + NOTE + s + eol);
        }
        --this._level;
    }

    private void showAgent(Agent agent, String label) {
        String margin = this.getIndent(++this._level);
        this.texta.append(margin + label + ": " + agent.getName() + eol);
        this.texta.append(margin + TYPE + agent.getType().toString() + eol);
        String s = agent.getAddress();
        if (s != null) {
            this.texta.append(margin + "Address: " + s + eol);
        }
        if ((s = agent.getTelephone()) != null) {
            this.texta.append(margin + "Telephone: " + s + eol);
        }
        if ((s = agent.getFax()) != null) {
            this.texta.append(margin + "Fax: " + s + eol);
        }
        if ((s = agent.getEmail()) != null) {
            this.texta.append(margin + "Email: " + s + eol);
        }
        if ((s = agent.getWeb()) != null) {
            this.texta.append(margin + "Web: " + s + eol);
        }
        --this._level;
    }

    private void showIdentifier(Identifier identifier) {
        String margin = this.getIndent(++this._level);
        this.texta.append(margin + "Identifier: " + identifier.getValue() + eol);
        this.texta.append(margin + TYPE + identifier.getType().toString() + eol);
        String note = identifier.getNote();
        if (note != null) {
            this.texta.append(margin + NOTE + note + eol);
        }
        --this._level;
    }

    private String getIndent(int lev) {
        switch (lev) {
            case 1: {
                return " ";
            }
            case 2: {
                return "  ";
            }
            case 3: {
                return "   ";
            }
            case 4: {
                return "    ";
            }
        }
        return "";
    }

    private void saveInfo() {
        if (this._module == null) {
            JOptionPane.showMessageDialog(this, "No module selected", "Can't save", 1);
            return;
        }
        PrintWriter wtr = this.doSaveDialog();
        if (wtr == null) {
            return;
        }
        OutputHandler handler = this.selectHandler();
        try {
            handler.setWriter(wtr);
            handler.show(this._module);
            wtr.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error writing file", 0);
        }
    }
}

