/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.viewer.InfoWindow;
import edu.harvard.hul.ois.jhove.viewer.JhoveWindow;
import edu.harvard.hul.ois.jhove.viewer.RepTreeRoot;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;

public class ViewWindow
extends InfoWindow {
    private List<RepInfo> _info;
    private JMenuItem _closeAllItem;
    private ActionListener _closeAllListener;
    private DefaultMutableTreeNode _rootNode;
    private JTree tree;

    public ViewWindow(App app, JhoveBase base, JhoveWindow jhwin) {
        super("JHOVE Results", app, base);
        DefaultMutableTreeNode root;
        this.setSaveActionListener(e -> this.saveInfo());
        this._info = new LinkedList<RepInfo>();
        this._rootNode = root = new DefaultMutableTreeNode("Documents");
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.tree = new JTree();
        this.tree.setModel(treeModel);
        this.tree.setShowsRootHandles(true);
        TreeCellRenderer rend = this.tree.getCellRenderer();
        if (rend instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer trend = (DefaultTreeCellRenderer)rend;
            trend.setOpenIcon(null);
            trend.setClosedIcon(null);
            trend.setLeafIcon(null);
        }
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel panel = new JPanel();
        panel.setMinimumSize(new Dimension(8, 8));
        this.getContentPane().add((Component)panel, "South");
        this.setDefaultCloseOperation(2);
        this.setSize(400, 600);
        if (jhwin != null) {
            this._closeAllItem = jhwin.getCloseAllItem();
            this._closeAllListener = e -> this.closeFromMenu();
            this._closeAllItem.addActionListener(this._closeAllListener);
        }
    }

    public void addRepInfo(RepInfo info, JhoveBase base) {
        this._info.add(info);
        RepTreeRoot node = new RepTreeRoot(info, base);
        this._rootNode.add(node);
    }

    public void expandRows() {
        this.tree.expandRow(0);
        if (this.tree.getRowCount() == 2) {
            this.tree.expandRow(1);
        }
    }

    private void saveInfo() {
        PrintWriter wtr = this.doSaveDialog();
        if (wtr == null) {
            return;
        }
        try {
            OutputHandler handler = this.selectHandler();
            handler.reset();
            handler.setWriter(wtr);
            handler.showHeader();
            for (RepInfo info : this._info) {
                handler.show(info);
            }
            handler.showFooter();
            wtr.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error writing file", 0);
        }
    }

    @Override
    protected void closeFromMenu() {
        super.closeFromMenu();
        if (this._closeAllItem != null) {
            this._closeAllItem.removeActionListener(this._closeAllListener);
        }
        this.dispose();
    }
}

