/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.AgentType;

public final class Agent {
    private static final Agent HARVARD = new Builder("Harvard University Library", AgentType.EDUCATIONAL).address("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138").telephone("+1 (617) 495-3724").email("jhove-support@hulmail.harvard.edu").build();
    private static final Agent OPF = new Builder("Open Preservation Foundation", AgentType.NONPROFIT).web("http://openpreservation.org").email("jhove@openpreservation.org").build();
    private static final Agent BNF = new Builder("Biblioth\u00e8que nationale de France", AgentType.EDUCATIONAL).web("http://www.bnf.fr").build();
    private final String _name;
    private final AgentType _type;
    private final String _address;
    private final String _telephone;
    private final String _fax;
    private final String _email;
    private final String _web;
    private final String _note;

    private Agent(String name, AgentType type, String address, String telephone, String fax, String email, String web, String note) {
        this._name = name;
        this._type = type;
        this._address = address;
        this._telephone = telephone;
        this._fax = fax;
        this._email = email;
        this._web = web;
        this._note = note;
    }

    public String getAddress() {
        return this._address;
    }

    public String getEmail() {
        return this._email;
    }

    public String getFax() {
        return this._fax;
    }

    public String getName() {
        return this._name;
    }

    public String getNote() {
        return this._note;
    }

    public String getTelephone() {
        return this._telephone;
    }

    public AgentType getType() {
        return this._type;
    }

    public String getWeb() {
        return this._web;
    }

    public static final Agent harvardInstance() {
        return HARVARD;
    }

    public static final Agent opfInstance() {
        return OPF;
    }

    public static final Agent bnfInstance() {
        return BNF;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._address == null ? 0 : this._address.hashCode());
        result = 31 * result + (this._email == null ? 0 : this._email.hashCode());
        result = 31 * result + (this._fax == null ? 0 : this._fax.hashCode());
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._note == null ? 0 : this._note.hashCode());
        result = 31 * result + (this._telephone == null ? 0 : this._telephone.hashCode());
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        result = 31 * result + (this._web == null ? 0 : this._web.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Agent other = (Agent)obj;
        if (this._address == null ? other._address != null : !this._address.equals(other._address)) {
            return false;
        }
        if (this._email == null ? other._email != null : !this._email.equals(other._email)) {
            return false;
        }
        if (this._fax == null ? other._fax != null : !this._fax.equals(other._fax)) {
            return false;
        }
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        if (this._note == null ? other._note != null : !this._note.equals(other._note)) {
            return false;
        }
        if (this._telephone == null ? other._telephone != null : !this._telephone.equals(other._telephone)) {
            return false;
        }
        if (this._type == null ? other._type != null : !this._type.equals((Object)other._type)) {
            return false;
        }
        return !(this._web == null ? other._web != null : !this._web.equals(other._web));
    }

    public static final Agent newW3CInstance() {
        Builder builder = new Builder("Word Wide Web Consortium", AgentType.NONPROFIT).address("Massachusetts Institute of Technology, Computer Science and Artificial Intelligence Laboratory, 32 Vassar Street, Room 32-G515, Cambridge, MA 02139").telephone("(617) 253-2613").fax("(617) 258-5999").web("http://www.w3.org/");
        return builder.build();
    }

    public static final Agent newIsoInstance() {
        Builder builder = new Builder("ISO", AgentType.STANDARD).address("1, rue de Varembe, Casa postale 56, CH-1211, Geneva 20, Switzerland").telephone("+41 22 749 01 11").fax("+41 22 733 34 30").email("iso@iso.ch").web("http://www.iso.org/");
        return builder.build();
    }

    public static final Agent newAdobeInstance() {
        Builder builder = new Builder("Adobe Systems, Inc.", AgentType.COMMERCIAL).address("345 Park Avenue, San Jose, California 95110-2704").telephone("+1 (408) 536-6000").fax("+1 (408) 537-6000").web("http://www.adobe.com/");
        return builder.build();
    }

    /* synthetic */ Agent(String string, AgentType agentType, String string2, String string3, String string4, String string5, String string6, String string7, Agent agent) {
        this(string, agentType, string2, string3, string4, string5, string6, string7);
    }

    public static class Builder {
        private String name;
        private AgentType type = AgentType.EDUCATIONAL;
        private String address;
        private String telephone;
        private String fax;
        private String email;
        private String web;
        private String note;

        public Builder(String name, AgentType type) {
            this.name = name;
            this.type = type;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder fax(String fax) {
            this.fax = fax;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Builder telephone(String telephone) {
            this.telephone = telephone;
            return this;
        }

        public Builder web(String web) {
            this.web = web;
            return this;
        }

        public Agent build() {
            return new Agent(this.name, this.type, this.address, this.telephone, this.fax, this.email, this.web, this.note, null);
        }
    }
}

