/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.ModuleInfo;
import edu.harvard.hul.ois.jhove.viewer.ConfigWindow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JOptionPane;

public class ConfigWriter {
    private PrintWriter _confOut;
    private File _tempFile;
    private File _confFile;
    ConfigWindow _parent;
    private static final String CLASS_TAG_START = "   <class>";
    private static final String CLASS_TAG_CLOSE = "</class>";

    public ConfigWriter(File file, ConfigWindow parent) throws IOException {
        this._confFile = file;
        this._parent = parent;
        String path = file.getParent();
        file.getParentFile().mkdirs();
        this._tempFile = File.createTempFile("jho", ".conf", new File(path));
        FileOutputStream ostrm = new FileOutputStream(this._tempFile);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)ostrm, "UTF-8");
        this._confOut = new PrintWriter(osw);
    }

    public void writeFile(List<ModuleInfo> modules, List<String[]> handlers, File homeDir, File tempDir, String encoding, int bufferSize) {
        this.writeHead();
        this._confOut.println(" <jhoveHome>" + ConfigWriter.encodeContent(homeDir.getPath()) + "</jhoveHome>");
        if (encoding != null && encoding.length() > 0) {
            this._confOut.println(" <defaultEncoding>" + ConfigWriter.encodeContent(encoding) + "</defaultEncoding>");
        }
        if (tempDir != null) {
            this._confOut.println(" <tempDirectory>" + ConfigWriter.encodeContent(tempDir.getPath()) + "</tempDirectory>");
        }
        if (bufferSize > 0) {
            this._confOut.println(" <bufferSize>" + bufferSize + "</bufferSize>");
        }
        ListIterator<ModuleInfo> iter = modules.listIterator();
        while (iter.hasNext()) {
            ModuleInfo minfo = iter.next();
            if ("".equals(minfo.clas)) continue;
            this._confOut.println(" <module>");
            this._confOut.println(CLASS_TAG_START + ConfigWriter.encodeContent(minfo.clas) + CLASS_TAG_CLOSE);
            if (minfo.init != null && minfo.init.length() > 0) {
                this._confOut.println("   <init>" + ConfigWriter.encodeContent(minfo.init) + "</init>");
            }
            if (minfo.params != null) {
                for (int i = 0; i < minfo.params.length; ++i) {
                    this._confOut.println("   <param>" + ConfigWriter.encodeContent(minfo.params[i]) + "</param>");
                }
            }
            this._confOut.println(" </module>");
        }
        ListIterator<String[]> hiter = handlers.listIterator();
        while (hiter.hasNext()) {
            String handler = hiter.next()[0];
            if (handler.length() <= 0) continue;
            this._confOut.println(" <outputHandler>");
            this._confOut.println(CLASS_TAG_START + ConfigWriter.encodeContent(handler) + CLASS_TAG_CLOSE);
            this._confOut.println(" </outputHandler>");
        }
        this.writeTail();
        this._confOut.close();
        if (this._confFile.exists() && !this._confFile.delete()) {
            if (this._parent != null) {
                JOptionPane.showMessageDialog(this._parent, "Can't replace old config file", "Error", 0);
            }
            this._tempFile.delete();
        } else {
            this._tempFile.renameTo(this._confFile);
        }
    }

    private void writeHead() {
        this._confOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this._confOut.println("<jhoveConfig version=\"1.0\"");
        this._confOut.println("             xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        this._confOut.println("             xmlns=\"http://hul.harvard.edu/ois/xml/ns/jhove/jhoveConfig\"");
        this._confOut.println("xsi:schemaLocation=\"http://hul.harvard.edu/ois/xml/ns/jhove/jhoveConfig");
        this._confOut.println("             http://hul.harvard.edu/ois/xml/xsd/jhove/jhoveConfig.xsd\">");
    }

    private void writeTail() {
        this._confOut.println("</jhoveConfig>");
    }

    private static String encodeContent(String content) {
        if (content == null) {
            content = "";
        }
        StringBuffer buffer = new StringBuffer(content);
        int n = 0;
        while ((n = buffer.indexOf("&", n)) > -1) {
            buffer.insert(n + 1, "amp;");
            n += 5;
        }
        n = 0;
        while ((n = buffer.indexOf("<", n)) > -1) {
            buffer.replace(n, n + 1, "&lt;");
            n += 4;
        }
        n = 0;
        while ((n = buffer.indexOf(">", n)) > -1) {
            buffer.replace(n, n + 1, "&gt;");
            n += 4;
        }
        return buffer.toString();
    }
}

