/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMPHandler
extends DefaultHandler {
    private static final String xmpBasicSchema = "http://ns.adobe.com/xap/1.0/";
    private boolean pdfaCompliant = true;

    public boolean isPdfaCompliant() {
        return this.pdfaCompliant;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if ("xpacket".equals(target)) {
            boolean bigEndian = false;
            boolean noEndian = true;
            int idx = data.indexOf("begin=");
            idx = data.indexOf(34, idx + 1);
            if (data.length() >= idx + 2) {
                char char1 = data.charAt(idx + 1);
                char char2 = data.charAt(idx + 2);
                if (char1 == '\u00ff' && char2 == '\u00fe') {
                    noEndian = false;
                    bigEndian = false;
                } else if (char1 == '\u00fe' && char2 == '\u00ff') {
                    noEndian = false;
                    bigEndian = true;
                }
            }
            if ((idx = data.indexOf("bytes=")) > 0) {
                this.pdfaCompliant = false;
            }
            if ((idx = data.indexOf("encoding=")) > 0) {
                this.pdfaCompliant = false;
                idx = data.indexOf(34, idx + 1);
                int encEnd = data.indexOf(34, idx + 1);
                String encoding = data.substring(idx + 1, encEnd);
                String exText = "ENC=";
                exText = noEndian ? String.valueOf(exText) + " ," : (bigEndian ? String.valueOf(exText) + "B," : String.valueOf(exText) + "L,");
                exText = String.valueOf(exText) + encoding;
                throw new SAXException(exText);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) {
        if (xmpBasicSchema.equals(namespaceURI) && !"Bag".equals(rawName) && !"Seq".equals(rawName)) {
            "Alt".equals(rawName);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) {
    }
}

