/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.handler;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.HandlerBase;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import edu.harvard.hul.ois.jhove.Utils;
import edu.harvard.hul.ois.jhove.handler.Handlers;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class XmlHandler
extends HandlerBase {
    private static final ThreadLocal<NumberFormat> formatters = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat _format = NumberFormat.getInstance(Locale.ROOT);
            _format.setGroupingUsed(false);
            _format.setMinimumFractionDigits(0);
            return _format;
        }
    };
    private static final String NAME = "XML";
    private static final String RELEASE = "1.14";
    private static final int[] DATE = new int[]{2025, 3, 12};
    private static final String NOTE = "This output handler is defined by the XML Schema https://schema.openpreservation.org/ois/xml/xsd/jhove/jhove.xsd";
    private static final String RIGHTS = "Derived from software Copyright 2004-2011 by the President and Fellows of Harvard College. Version 1.8 release by Open Preservation Foundation. Released under the GNU Lesser General Public License.";
    private static final String EOL = System.getProperty("line.separator");
    private static final String SCHEMA_VERSION = "1.10";
    private double _sampleRate;
    private String reportingModule = "";

    public XmlHandler() {
        super(NAME, RELEASE, DATE, NOTE, RIGHTS);
        this._vendor = Agent.harvardInstance();
    }

    public XmlHandler(String name, String release, int[] date, String note, String rights) {
        super(name, release, date, note, rights);
        this._vendor = Agent.harvardInstance();
    }

    @Override
    public void show() {
        --this._level;
    }

    @Override
    public void show(App app) {
        String[][] attr2;
        String s;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("app"));
        String[][] attrs = new String[][]{{"date", date.format(this._je.getDate())}};
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("api", attrs, app.getRelease()));
        String configFile = this._je.getConfigFile();
        if (configFile != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("configuration", configFile));
        }
        if ((s = this._je.getSaxClass()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("saxParser", s));
        }
        if ((s = this._je.getJhoveHome()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("jhoveHome", s));
        }
        if ((s = this._je.getEncoding()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("encoding", s));
        }
        if ((s = this._je.getTempDirectory()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("tempDirectory", s));
        }
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("bufferSize", Integer.toString(this._je.getBufferSize())));
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("modules"));
        Iterator<String> iter = this._je.getModuleMap().keySet().iterator();
        while (iter.hasNext()) {
            Module module = this._je.getModule(iter.next());
            attr2 = new String[][]{{"release", module.getRelease()}};
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("module", attr2, module.getName()));
        }
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("modules"));
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("outputHandlers"));
        iter = this._je.getHandlerMap().keySet().iterator();
        while (iter.hasNext()) {
            OutputHandler handler = this._je.getHandler(iter.next());
            attr2 = new String[][]{{"release", handler.getRelease()}};
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("outputHandler", attr2, handler.getName()));
        }
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("outputHandlers"));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("usage", app.getUsage()));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("rights", app.getRights()));
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("app"));
        --this._level;
    }

    @Override
    public void show(OutputHandler handler) {
        String s;
        Agent vendor;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = String.valueOf(margin) + " ";
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("handler"));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("name", handler.getName()));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("release", handler.getRelease()));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("date", date.format(handler.getDate())));
        List<Document> list = handler.getSpecification();
        int n = list.size();
        if (n > 0) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("specifications"));
            ++this._level;
            int i = 0;
            while (i < n) {
                this.showDocument(list.get(i));
                ++i;
            }
            --this._level;
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("specifications"));
        }
        if ((vendor = handler.getVendor()) != null) {
            this.showAgent(vendor, "Vendor");
        }
        if ((s = handler.getNote()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("note", s));
        }
        if ((s = handler.getRights()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("rights", s));
        }
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("handler"));
        --this._level;
    }

    @Override
    public void show(Module module) {
        List<String> featList;
        List<Document> docList;
        List<Signature> sigList;
        String s;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("module"));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("name", module.getName()));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("release", module.getRelease()));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("date", HandlerBase.date.format(module.getDate())));
        String[] ss = module.getFormat();
        if (ss.length > 0) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("formats"));
            int i = 0;
            while (i < ss.length) {
                this._writer.println(String.valueOf(margn3) + XmlHandler.element("format", ss[i]));
                ++i;
            }
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("formats"));
        }
        if ((s = module.getCoverage()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("coverage", s));
        }
        if ((ss = module.getMimeType()).length > 0) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("mimeTypes"));
            int i = 0;
            while (i < ss.length) {
                this._writer.println(String.valueOf(margn3) + XmlHandler.element("mimeType", ss[i]));
                ++i;
            }
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("mimeTypes"));
        }
        if (!(sigList = module.getSignature()).isEmpty()) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("signatures"));
            ++this._level;
            for (Signature sig : sigList) {
                this.showSignature(sig);
            }
            --this._level;
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("signatures"));
        }
        if (!(docList = module.getSpecification()).isEmpty()) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("specifications"));
            ++this._level;
            for (Document doc : docList) {
                this.showDocument(doc);
            }
            --this._level;
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("specifications"));
        }
        if ((featList = module.getFeatures()) != null && !featList.isEmpty()) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("features"));
            for (String feat : featList) {
                this._writer.println(String.valueOf(margn3) + XmlHandler.element("feature", feat));
            }
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("features"));
        }
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("methodology"));
        s = module.getWellFormedNote();
        if (s != null) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("wellFormed", s));
        }
        if ((s = module.getValidityNote()) != null) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("validity", s));
        }
        if ((s = module.getRepInfoNote()) != null) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("repInfo", s));
        }
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("methodology"));
        Agent vendor = module.getVendor();
        if (vendor != null) {
            this.showAgent(vendor, "Vendor");
        }
        if ((s = module.getNote()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("note", s));
        }
        if ((s = module.getRights()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("rights", s));
        }
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("module"));
        --this._level;
    }

    @Override
    public void show(RepInfo info) {
        List<Checksum> checksums;
        Map<String, Property> map;
        List<String> profiles;
        List<Message> messages;
        String wfStr;
        String s;
        long size;
        Date date;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        Module module = info.getModule();
        this._logger.info("Reporting RepInfo");
        if (this._je.getSignatureFlag()) {
            this._logger.info("Checking signatures only");
        }
        String[][] attrs = new String[][]{{"uri", XmlHandler.cleanURIString(info.getUri())}};
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("repInfo", attrs));
        if (module != null) {
            String[][] attr2 = new String[][]{{"release", module.getRelease()}, {"date", XmlHandler.date.format(module.getDate())}};
            this.reportingModule = module.getName();
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("reportingModule", attr2, this.reportingModule));
        }
        if ((date = info.getCreated()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("created", this.toDateTime(date)));
        }
        if ((date = info.getLastModified()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("lastModified", this.toDateTime(date)));
        }
        if ((size = info.getSize()) > -1L) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("size", Long.toString(size)));
        }
        if ((s = info.getFormat()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("format", s));
        }
        if ((s = info.getVersion()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("version", s));
        }
        if (!this._je.getSignatureFlag()) {
            switch (info.getWellFormed()) {
                case 1: {
                    wfStr = "Well-Formed";
                    break;
                }
                case 0: {
                    wfStr = "Not well-formed";
                    break;
                }
                default: {
                    wfStr = "Unknown";
                }
            }
            if (info.getWellFormed() == 1) {
                switch (info.getValid()) {
                    case 1: {
                        wfStr = String.valueOf(wfStr) + " and valid";
                        break;
                    }
                    case 0: {
                        wfStr = String.valueOf(wfStr) + ", but not valid";
                    }
                }
            }
            this._logger.info("Validity/WF status: " + wfStr);
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("status", wfStr));
        } else {
            switch (info.getWellFormed()) {
                case 1: {
                    wfStr = "Well-Formed";
                    break;
                }
                default: {
                    wfStr = "Not well-formed";
                }
            }
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("status", wfStr));
        }
        List<String> sigMatches = info.getSigMatch();
        if (!sigMatches.isEmpty()) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("sigMatch"));
            ++this._level;
            for (String sigMatch : sigMatches) {
                this._writer.println(String.valueOf(margn2) + XmlHandler.element("module", sigMatch));
            }
            --this._level;
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("sigMatch"));
        }
        if (!(messages = info.getMessage()).isEmpty()) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("messages"));
            ++this._level;
            for (Message message : messages) {
                this.showMessage(message);
            }
            --this._level;
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("messages"));
        }
        if ((s = info.getMimeType()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("mimeType", s));
        }
        if (!(profiles = info.getProfile()).isEmpty()) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("profiles"));
            for (String profile : profiles) {
                this._writer.println(String.valueOf(margn3) + XmlHandler.element("profile", profile));
            }
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("profiles"));
        }
        if ((map = info.getProperty()) != null && !map.isEmpty()) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("properties"));
            for (Map.Entry<String, Property> entry : map.entrySet()) {
                this.showProperty(entry.getValue());
            }
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("properties"));
        }
        if (!(checksums = info.getChecksum()).isEmpty()) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("checksums"));
            ++this._level;
            for (Checksum checksum : checksums) {
                this.showChecksum(checksum);
            }
            --this._level;
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("checksums"));
        }
        if ((s = info.getNote()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("note", s));
        }
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("repInfo"));
        --this._level;
    }

    protected void showAgent(Agent agent, String label) {
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = String.valueOf(margin) + " ";
        String[][] attrs = new String[][]{{"type", label}};
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("agent", attrs));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("name", agent.getName()));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("type", agent.getType().toString()));
        String s = agent.getAddress();
        if (s != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("address", s));
        }
        if ((s = agent.getTelephone()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("telephone", s));
        }
        if ((s = agent.getFax()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("fax", s));
        }
        if ((s = agent.getEmail()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("email", s));
        }
        if ((s = agent.getWeb()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("web", s));
        }
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("agent"));
        --this._level;
    }

    protected void showChecksum(Checksum checksum) {
        String margin = XmlHandler.getIndent(++this._level);
        String[][] attrs = new String[][]{{"type", checksum.getType().toString()}};
        this._writer.println(String.valueOf(margin) + XmlHandler.element("checksum", attrs, checksum.getValue()));
        --this._level;
    }

    protected void showDocument(Document document) {
        List<Identifier> list3;
        String s;
        List<Agent> list2;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = String.valueOf(margin) + " ";
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("specification"));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("title", document.getTitle()));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("type", document.getType().toString()));
        List<Agent> list1 = document.getAuthor();
        int n = list1.size();
        if (n > 0) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("authors"));
            ++this._level;
            int i = 0;
            while (i < n) {
                this.showAgent(list1.get(i), "Author");
                ++i;
            }
            --this._level;
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("authors"));
        }
        if ((n = (list2 = document.getPublisher()).size()) > 0) {
            ++this._level;
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("publishers"));
            int i = 0;
            while (i < n) {
                this.showAgent(list2.get(i), "Publisher");
                ++i;
            }
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("publishers"));
            --this._level;
        }
        if ((s = document.getEdition()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("edition", s));
        }
        if ((s = document.getDate()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("date", s));
        }
        if ((s = document.getEnumeration()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("enumeration", s));
        }
        if ((s = document.getPages()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("pages", s));
        }
        if ((n = (list3 = document.getIdentifier()).size()) > 0) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("identifiers"));
            ++this._level;
            int i = 0;
            while (i < n) {
                this.showIdentifier(list3.get(i));
                ++i;
            }
            --this._level;
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("identifiers"));
        }
        if ((s = document.getNote()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("note", s));
        }
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("specification"));
        --this._level;
    }

    @Override
    public void showFooter() {
        String margin = XmlHandler.getIndent(this._level--);
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("jhove"));
        this._writer.flush();
    }

    @Override
    public void showHeader() {
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = String.valueOf(margin) + " ";
        if (this._encoding != null) {
            this._writer.println(String.valueOf(margin) + XmlHandler.xmlDecl(this._encoding));
        } else {
            this._writer.println(String.valueOf(margin) + XmlHandler.xmlDecl());
        }
        String[][] attrs = new String[][]{{"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xmlns", "http://schema.openpreservation.org/ois/xml/ns/jhove"}, {"xsi:schemaLocation", "http://schema.openpreservation.org/ois/xml/ns/jhove https://schema.openpreservation.org/ois/xml/xsd/jhove/1.10/jhove.xsd"}, {"name", this._app.getName()}, {"release", this._app.getRelease()}, {"date", HandlerBase.date.format(this._app.getDate())}};
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("jhove", attrs));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("date", this.toDateTime(new Date())));
    }

    protected void showIdentifier(Identifier identifier) {
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = String.valueOf(margin) + " ";
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("identifier"));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("value", identifier.getValue()));
        this._writer.println(String.valueOf(margn2) + XmlHandler.element("type", identifier.getType().toString()));
        String note = identifier.getNote();
        if (note != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("note", note));
        }
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("identifier"));
        --this._level;
    }

    protected void showMessage(Message message) {
        String id;
        long offset;
        String margin = XmlHandler.getIndent(++this._level);
        String[][] attrs = new String[5][];
        boolean hasAttr = false;
        String[] stringArray = new String[2];
        stringArray[0] = "subMessage";
        attrs[0] = stringArray;
        String[] stringArray2 = new String[2];
        stringArray2[0] = "offset";
        attrs[1] = stringArray2;
        String[] stringArray3 = new String[2];
        stringArray3[0] = "severity";
        attrs[2] = stringArray3;
        String[] stringArray4 = new String[2];
        stringArray4[0] = "id";
        attrs[3] = stringArray4;
        String[] stringArray5 = new String[2];
        stringArray5[0] = "infoLink";
        attrs[4] = stringArray5;
        String submsg = message.getSubMessage();
        if (submsg != null) {
            attrs[0][1] = submsg;
            hasAttr = true;
        }
        if ((offset = message.getOffset()) > -1L) {
            attrs[1][1] = Long.toString(offset);
            hasAttr = true;
        }
        if (!message.getPrefix().isEmpty()) {
            attrs[2][1] = message.getPrefix().toLowerCase();
            hasAttr = true;
        }
        if ((id = message.getJhoveMessage().getId()) != null && !id.isEmpty() && !id.equals("NO-ID")) {
            attrs[3][1] = message.getId();
            attrs[4][1] = Handlers.makeInfoLink(this.reportingModule, id);
            hasAttr = true;
        }
        if (hasAttr) {
            this._writer.println(String.valueOf(margin) + XmlHandler.element("message", attrs, message.getMessage()));
        } else {
            this._writer.println(String.valueOf(margin) + XmlHandler.element("message", message.getMessage()));
        }
        --this._level;
    }

    protected void showSignature(Signature signature) {
        String use;
        String note;
        String margin = XmlHandler.getIndent(++this._level);
        String margin1 = String.valueOf(margin) + " ";
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("signature"));
        String sigValue = signature.isStringValue() ? signature.getValueString() : signature.getValueHexString();
        this._writer.println(String.valueOf(margin1) + XmlHandler.element("type", signature.getType().toString()));
        this._writer.println(String.valueOf(margin1) + XmlHandler.element("value", sigValue));
        if (signature.getType().equals((Object)SignatureType.MAGIC) && ((InternalSignature)signature).hasFixedOffset()) {
            this._writer.println(String.valueOf(margin1) + XmlHandler.element("offset", "0x" + Integer.toHexString(((InternalSignature)signature).getOffset())));
        }
        if ((note = signature.getNote()) != null) {
            this._writer.println(String.valueOf(margin1) + XmlHandler.element("note", note));
        }
        if ((use = signature.getUse().toString()) != null) {
            this._writer.println(String.valueOf(margin1) + XmlHandler.element("use", use));
        }
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("signature"));
        --this._level;
    }

    protected String valueToString(Object obj) {
        if (obj instanceof Date) {
            return this.toDateTime((Date)obj);
        }
        return obj.toString();
    }

    protected void showProperty(Property property) {
        PropertyArity arity = property.getArity();
        PropertyType type = property.getType();
        if (Utils.isPropertyEmpty(property, arity)) {
            return;
        }
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        boolean valueIsProperty = PropertyType.PROPERTY.equals((Object)type);
        boolean valueIsNiso = PropertyType.NISOIMAGEMETADATA.equals((Object)type);
        boolean valueIsAes = PropertyType.AESAUDIOMETADATA.equals((Object)type);
        boolean valueIsTextMD = PropertyType.TEXTMDMETADATA.equals((Object)type);
        String[][] propAttrs = new String[][]{{"arity", arity.toString()}, {"type", type.toString()}};
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("property"));
        this._writer.println(String.valueOf(margn3) + XmlHandler.element("name", property.getName()));
        this._writer.println(String.valueOf(margn3) + XmlHandler.elementStart("values", propAttrs));
        if (arity.equals((Object)PropertyArity.SCALAR)) {
            if (valueIsProperty) {
                this.showProperty((Property)property.getValue());
            } else if (valueIsNiso) {
                this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("value"));
                this.showNisoImageMetadata((NisoImageMetadata)property.getValue());
                this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("value"));
            } else if (valueIsAes) {
                this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("value"));
                this.showAESAudioMetadata((AESAudioMetadata)property.getValue());
                this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("value"));
            } else if (valueIsTextMD) {
                this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("value"));
                this.showTextMDMetadata((TextMDMetadata)property.getValue());
                this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("value"));
            } else {
                this._writer.println(String.valueOf(margn4) + XmlHandler.element("value", property.getValue().toString()));
            }
        } else if (arity.equals((Object)PropertyArity.LIST)) {
            List propList = (List)property.getValue();
            ListIterator iter = propList.listIterator();
            while (iter.hasNext()) {
                Object val = iter.next();
                if (valueIsProperty) {
                    this.showProperty((Property)val);
                    continue;
                }
                if (valueIsNiso) {
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("value"));
                    this.showNisoImageMetadata((NisoImageMetadata)property.getValue());
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("value"));
                    continue;
                }
                if (valueIsAes) {
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("value"));
                    this.showAESAudioMetadata((AESAudioMetadata)property.getValue());
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("value"));
                    continue;
                }
                if (valueIsTextMD) {
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("value"));
                    this.showTextMDMetadata((TextMDMetadata)property.getValue());
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("value"));
                    continue;
                }
                this._writer.println(String.valueOf(margn4) + XmlHandler.element("value", this.valueToString(val)));
            }
        } else if (arity.equals((Object)PropertyArity.MAP)) {
            Map propMap = (Map)property.getValue();
            for (Object key : propMap.keySet()) {
                String keystr = key.toString();
                Object val = propMap.get(key);
                String[][] attrs = new String[1][];
                String[] keyAttr = new String[]{"key", keystr};
                attrs[0] = keyAttr;
                if (valueIsProperty) {
                    Property pval = (Property)val;
                    if (pval.getName().equals(keystr)) {
                        this._writer.print(String.valueOf(margn4) + XmlHandler.elementStart("value"));
                    } else {
                        this._writer.print(String.valueOf(margn4) + XmlHandler.elementStart("value", attrs));
                    }
                    this.showProperty(pval);
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("value"));
                    continue;
                }
                if (valueIsNiso) {
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("value"));
                    this.showNisoImageMetadata((NisoImageMetadata)val);
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("value"));
                    continue;
                }
                if (valueIsAes) {
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("value"));
                    this.showAESAudioMetadata((AESAudioMetadata)val);
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("value"));
                    continue;
                }
                if (valueIsTextMD) {
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("value"));
                    this.showTextMDMetadata((TextMDMetadata)val);
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("value"));
                    continue;
                }
                this._writer.println(String.valueOf(margn4) + XmlHandler.element("value", attrs, this.valueToString(val)));
            }
        } else if (arity.equals((Object)PropertyArity.SET)) {
            Set propSet = (Set)property.getValue();
            for (Object val : propSet) {
                if (valueIsProperty) {
                    this.showProperty((Property)val);
                    continue;
                }
                this._writer.println(String.valueOf(margn4) + XmlHandler.element("value", this.valueToString(val)));
            }
        } else if (arity.equals((Object)PropertyArity.ARRAY)) {
            this.showArrayProperty(property, margn4);
        }
        this._writer.println(String.valueOf(margn3) + XmlHandler.elementEnd("values"));
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("property"));
        --this._level;
    }

    /*
     * Unable to fully structure code
     */
    protected void showArrayProperty(Property property, String margin) {
        boolArray = null;
        byteArray = null;
        charArray = null;
        dateArray = null;
        doubleArray = null;
        floatArray = null;
        intArray = null;
        longArray = null;
        objArray = null;
        propArray = null;
        shortArray = null;
        stringArray = null;
        rationalArray = null;
        nisoArray = null;
        aesArray = null;
        textMDArray = null;
        n = 0;
        propType = property.getType();
        if (PropertyType.BOOLEAN.equals((Object)propType)) {
            boolArray = (boolean[])property.getValue();
            n = boolArray.length;
        } else if (PropertyType.BYTE.equals((Object)propType)) {
            byteArray = (byte[])property.getValue();
            n = byteArray.length;
        } else if (PropertyType.CHARACTER.equals((Object)propType)) {
            charArray = (char[])property.getValue();
            n = charArray.length;
        } else if (PropertyType.DATE.equals((Object)propType)) {
            dateArray = (Date[])property.getValue();
            n = dateArray.length;
        } else if (PropertyType.DOUBLE.equals((Object)propType)) {
            doubleArray = (double[])property.getValue();
            n = doubleArray.length;
        } else if (PropertyType.FLOAT.equals((Object)propType)) {
            floatArray = (float[])property.getValue();
            n = floatArray.length;
        } else if (PropertyType.INTEGER.equals((Object)propType)) {
            intArray = (int[])property.getValue();
            n = intArray.length;
        } else if (PropertyType.LONG.equals((Object)propType)) {
            longArray = (long[])property.getValue();
            n = longArray.length;
        } else if (PropertyType.OBJECT.equals((Object)propType)) {
            objArray = (Object[])property.getValue();
            n = objArray.length;
        } else if (PropertyType.SHORT.equals((Object)propType)) {
            shortArray = (short[])property.getValue();
            n = shortArray.length;
        } else if (PropertyType.STRING.equals((Object)propType)) {
            stringArray = (String[])property.getValue();
            n = stringArray.length;
        } else if (PropertyType.RATIONAL.equals((Object)propType)) {
            rationalArray = (Rational[])property.getValue();
            n = rationalArray.length;
        } else if (PropertyType.PROPERTY.equals((Object)propType)) {
            propArray = (Property[])property.getValue();
            n = propArray.length;
        } else if (PropertyType.NISOIMAGEMETADATA.equals((Object)propType)) {
            nisoArray = (NisoImageMetadata[])property.getValue();
            n = nisoArray.length;
        } else if (PropertyType.AESAUDIOMETADATA.equals((Object)propType)) {
            aesArray = (AESAudioMetadata[])property.getValue();
            n = aesArray.length;
        } else if (PropertyType.TEXTMDMETADATA.equals((Object)propType)) {
            textMDArray = (TextMDMetadata[])property.getValue();
            n = textMDArray.length;
        }
        i = 0;
        while (i < n) {
            block51: {
                block50: {
                    block49: {
                        block48: {
                            block47: {
                                block46: {
                                    block45: {
                                        block44: {
                                            block43: {
                                                block42: {
                                                    block41: {
                                                        block40: {
                                                            if (!PropertyType.BOOLEAN.equals((Object)propType)) break block40;
                                                            elem = String.valueOf(boolArray[i]);
                                                            ** GOTO lbl145
                                                        }
                                                        if (!PropertyType.BYTE.equals((Object)propType)) break block41;
                                                        elem = String.valueOf(byteArray[i]);
                                                        ** GOTO lbl145
                                                    }
                                                    if (!PropertyType.CHARACTER.equals((Object)propType)) break block42;
                                                    elem = String.valueOf(charArray[i]);
                                                    ** GOTO lbl145
                                                }
                                                if (!PropertyType.DATE.equals((Object)propType)) break block43;
                                                elem = dateArray[i].toString();
                                                ** GOTO lbl145
                                            }
                                            if (!PropertyType.DOUBLE.equals((Object)propType)) break block44;
                                            elem = String.valueOf(doubleArray[i]);
                                            ** GOTO lbl145
                                        }
                                        if (!PropertyType.FLOAT.equals((Object)propType)) break block45;
                                        elem = String.valueOf(floatArray[i]);
                                        ** GOTO lbl145
                                    }
                                    if (!PropertyType.INTEGER.equals((Object)propType)) break block46;
                                    elem = String.valueOf(intArray[i]);
                                    ** GOTO lbl145
                                }
                                if (!PropertyType.LONG.equals((Object)propType)) break block47;
                                elem = String.valueOf(longArray[i]);
                                ** GOTO lbl145
                            }
                            if (!PropertyType.OBJECT.equals((Object)propType)) break block48;
                            elem = this.valueToString(objArray[i]);
                            ** GOTO lbl145
                        }
                        if (!PropertyType.SHORT.equals((Object)propType)) break block49;
                        elem = String.valueOf(shortArray[i]);
                        ** GOTO lbl145
                    }
                    if (!PropertyType.STRING.equals((Object)propType)) break block50;
                    elem = stringArray[i];
                    ** GOTO lbl145
                }
                if (!PropertyType.RATIONAL.equals((Object)propType)) break block51;
                elem = rationalArray[i].toString();
                ** GOTO lbl145
            }
            if (PropertyType.PROPERTY.equals((Object)propType)) {
                this.showProperty(propArray[i]);
            } else if (PropertyType.NISOIMAGEMETADATA.equals((Object)propType)) {
                this.showNisoImageMetadata(nisoArray[i]);
            } else if (PropertyType.AESAUDIOMETADATA.equals((Object)propType)) {
                this.showAESAudioMetadata(aesArray[i]);
            } else if (PropertyType.TEXTMDMETADATA.equals((Object)propType)) {
                this.showTextMDMetadata(textMDArray[i]);
            } else {
                elem = "<error>";
lbl145:
                // 13 sources

                this._writer.println(String.valueOf(margin) + XmlHandler.element("value", elem));
            }
            ++i;
        }
    }

    protected void showTextMDMetadata(TextMDMetadata textMD) {
        String[][] attrs1;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String[][] attrs = new String[][]{{"xmlns:textmd", "info:lc/xmlns/textMD-v3"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "info:lc/xmlns/textMD-v3 http://www.loc.gov/standards/textMD/textMD-v3.01a.xsd"}};
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("textmd:textMD", attrs));
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("textmd:character_info"));
        this._writer.println(String.valueOf(margn3) + XmlHandler.element("textmd:charset", textMD.getCharset()));
        this._writer.println(String.valueOf(margn3) + XmlHandler.element("textmd:byte_order", textMD.getByte_orderString()));
        this._writer.println(String.valueOf(margn3) + XmlHandler.element("textmd:byte_size", textMD.getByte_size()));
        if ("variable".equals(textMD.getCharacter_size())) {
            attrs1 = new String[][]{{"encoding", textMD.getCharset()}};
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("textmd:character_size", attrs1, "variable"));
        } else if (textMD.getCharacter_size() != null && textMD.getCharacter_size().length() != 0) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("textmd:character_size", textMD.getCharacter_size()));
        }
        this._writer.println(String.valueOf(margn3) + XmlHandler.element("textmd:linebreak", textMD.getLinebreakString()));
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("textmd:character_info"));
        if (textMD.getLanguage() != null && textMD.getLanguage().length() != 0) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("textmd:language", textMD.getLanguage()));
        }
        if (textMD.getMarkup_basis() != null && textMD.getMarkup_basis().length() != 0) {
            if (textMD.getMarkup_basis_version() != null) {
                attrs1 = new String[][]{{"version", textMD.getMarkup_basis_version()}};
                this._writer.println(String.valueOf(margn2) + XmlHandler.element("textmd:markup_basis", attrs1, textMD.getMarkup_basis()));
            } else {
                this._writer.println(String.valueOf(margn2) + XmlHandler.element("textmd:markup_basis", textMD.getMarkup_basis()));
            }
        }
        if (textMD.getMarkup_language() != null && textMD.getMarkup_language().length() != 0) {
            if (textMD.getMarkup_language_version() != null) {
                attrs1 = new String[][]{{"version", textMD.getMarkup_language_version()}};
                this._writer.println(String.valueOf(margn2) + XmlHandler.element("textmd:markup_language", attrs1, textMD.getMarkup_language()));
            } else {
                this._writer.println(String.valueOf(margn2) + XmlHandler.element("textmd:markup_language", textMD.getMarkup_language()));
            }
        }
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("textmd:textMD"));
        --this._level;
    }

    protected void showNisoImageMetadata(NisoImageMetadata niso) {
        if ("0.2".equals(this._je.getMixVersion())) {
            this.showNisoImageMetadata02(niso);
        } else if ("1.0".equals(this._je.getMixVersion())) {
            this.showNisoImageMetadata10(niso);
        } else {
            this.showNisoImageMetadata20(niso);
        }
    }

    protected void showNisoImageMetadata02(NisoImageMetadata niso) {
        String margin = XmlHandler.getIndent(++this._level);
        String[][] attrs = new String[][]{{"xmlns:mix", "http://www.loc.gov/mix/"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "http://www.loc.gov/mix/ http://www.loc.gov/mix/mix02.xsd"}};
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("mix:mix", attrs));
        this.showNisoBasicImageParameters02(niso, margin);
        this.showNisoImageCreation02(niso, margin);
        this.showNisoImagingPerformanceAssessment02(niso, margin);
        this.showNisoChangeHistory02(niso, margin);
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("mix:mix"));
        --this._level;
    }

    protected void showNisoBasicImageParameters02(NisoImageMetadata niso, String margin) {
        long ln;
        long[] larray;
        Rational[] rarray;
        int[] iarray;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        String margn6 = String.valueOf(margn5) + " ";
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("mix:BasicImageParameters"));
        StringBuffer fBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:Format") + EOL);
        boolean useFBuf = false;
        String s = niso.getMimeType();
        if (s != null) {
            fBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:MIMEType", s) + EOL);
            useFBuf = true;
        }
        if ((s = niso.getByteOrder()) != null) {
            fBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:ByteOrder", s) + EOL);
            useFBuf = true;
        }
        int comp = niso.getCompressionScheme();
        int level = niso.getCompressionLevel();
        if (comp != -1 || level != -1) {
            fBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:Compression") + EOL);
            if (comp != -1) {
                fBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:CompressionScheme", Integer.toString(comp)) + EOL);
            }
            if (level != -1) {
                fBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:CompressionLevel", Integer.toString(level)) + EOL);
            }
            fBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:Compression") + EOL);
            useFBuf = true;
        }
        StringBuffer piBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:PhotometricInterpretation") + EOL);
        boolean usePIBuf = false;
        int n = niso.getColorSpace();
        if (n != -1) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:ColorSpace", Integer.toString(n)) + EOL);
            usePIBuf = true;
        }
        String s2 = niso.getProfileURL();
        s = niso.getProfileName();
        if (s != null || s2 != null) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:ICCProfile") + EOL);
            if (s != null) {
                piBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:ProfileName", s) + EOL);
            }
            if (s2 != null) {
                piBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:ProfileURL", s2) + EOL);
            }
            piBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:ICCProfile") + EOL);
            usePIBuf = true;
        }
        if ((iarray = niso.getYCbCrSubSampling()) != null) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:YCbCrSubSampling", XmlHandler.integerArray(iarray)) + EOL);
            usePIBuf = true;
        }
        if ((n = niso.getYCbCrPositioning()) != -1) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:YCbCrPositioning", Integer.toString(n)) + EOL);
            usePIBuf = true;
        }
        if ((rarray = niso.getYCbCrCoefficients()) != null) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:YCbCrCoefficients", XmlHandler.rationalArray(rarray)) + EOL);
            usePIBuf = true;
        }
        if ((rarray = niso.getReferenceBlackWhite()) != null) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:ReferenceBlackWhite", XmlHandler.rationalArray(rarray)) + EOL);
            usePIBuf = true;
        }
        piBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:PhotometricInterpretation") + EOL);
        if (usePIBuf) {
            fBuf.append(piBuf);
            useFBuf = true;
        }
        StringBuffer segBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:Segments") + EOL);
        boolean useSegBuf = false;
        n = niso.getSegmentType();
        if (n != -1) {
            segBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:SegmentType", Integer.toString(n)) + EOL);
            useSegBuf = true;
        }
        if ((larray = niso.getStripOffsets()) != null) {
            segBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:StripOffsets", XmlHandler.longArray(larray)) + EOL);
            useSegBuf = true;
        }
        if ((ln = niso.getRowsPerStrip()) != -1L) {
            segBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:RowsPerStrip", Long.toString(ln)) + EOL);
            useSegBuf = true;
        }
        if ((larray = niso.getStripByteCounts()) != null) {
            segBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:StripByteCounts", XmlHandler.longArray(larray)) + EOL);
            useSegBuf = true;
        }
        if ((ln = niso.getTileWidth()) != -1L) {
            segBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:TileWidth", Long.toString(ln)) + EOL);
            useSegBuf = true;
        }
        if ((ln = niso.getTileLength()) != -1L) {
            segBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:TileLength", Long.toString(ln)) + EOL);
            useSegBuf = true;
        }
        if ((larray = niso.getTileOffsets()) != null) {
            segBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:TileOffsets", XmlHandler.longArray(larray)) + EOL);
            useSegBuf = true;
        }
        if ((larray = niso.getTileByteCounts()) != null) {
            segBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:TileByteCounts", XmlHandler.longArray(larray)) + EOL);
            useSegBuf = true;
        }
        segBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:Segments") + EOL);
        if (useSegBuf) {
            fBuf.append(segBuf);
            useFBuf = true;
        }
        if ((n = niso.getPlanarConfiguration()) != -1) {
            fBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:PlanarConfiguration", Integer.toString(n)) + EOL);
        }
        fBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:Format") + EOL);
        if (useFBuf) {
            this._writer.print(fBuf.toString());
        }
        StringBuffer fileBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:File") + EOL);
        boolean useFileBuf = false;
        s = niso.getImageIdentifier();
        if (s != null) {
            fileBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:ImageIdentifier", s) + EOL);
            useFileBuf = true;
        }
        if ((ln = niso.getFileSize()) != -1L) {
            fileBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:FileSize", Long.toString(ln)) + EOL);
            useFileBuf = true;
        }
        n = niso.getChecksumMethod();
        s = niso.getChecksumValue();
        if (n != -1 || s != null) {
            fileBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:Checksum") + EOL);
            if (n != -1) {
                fileBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:ChecksumMethod", Integer.toString(n)) + EOL);
            }
            if (s != null) {
                fileBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:ChecksumValue", s) + EOL);
            }
            fileBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:Checksum") + EOL);
            useFileBuf = true;
        }
        if ((n = niso.getOrientation()) != -1) {
            if (n > 9 || n < 1) {
                n = 9;
            }
            fileBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:Orientation", Integer.toString(n)) + EOL);
            useFileBuf = true;
        }
        if ((n = niso.getDisplayOrientation()) != -1) {
            fileBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:DisplayOrientation", Integer.toString(n)) + EOL);
            useFileBuf = true;
        }
        ln = niso.getXTargetedDisplayAR();
        long ln2 = niso.getYTargetedDisplayAR();
        if (ln != -1L || ln2 != -1L) {
            fileBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:TargetedDisplayAR") + EOL);
            if (ln != -1L) {
                fileBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:XTargetedDisplayAR", Long.toString(ln)) + EOL);
            }
            if (ln2 != -1L) {
                fileBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:YTargetedDisplayAR", Long.toString(ln2)) + EOL);
            }
            fileBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:TargetedDisplayAR") + EOL);
            useFileBuf = true;
        }
        fileBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:File") + EOL);
        if (useFileBuf) {
            this._writer.print(fileBuf.toString());
        }
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("mix:BasicImageParameters"));
    }

    protected void showNisoImageCreation02(NisoImageMetadata niso, String margin) {
        int n;
        double[] darray;
        Rational r;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        String margn6 = String.valueOf(margn5) + " ";
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("mix:ImageCreation"));
        String s = niso.getSourceType();
        if (s != null) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("mix:SourceType", s));
        }
        if ((s = niso.getSourceID()) != null) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("mix:SourceID", s));
        }
        if ((s = niso.getImageProducer()) != null) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("mix:ImageProducer", s));
        }
        StringBuffer hostBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:Host") + EOL);
        boolean useHostBuf = false;
        s = niso.getHostComputer();
        if (s != null) {
            hostBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:HostComputer", s) + EOL);
            useHostBuf = true;
        }
        if ((s = niso.getOS()) != null) {
            hostBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:OperatingSystem", s) + EOL);
            useHostBuf = true;
        }
        if ((s = niso.getOSVersion()) != null) {
            hostBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:OSVersion", s) + EOL);
            useHostBuf = true;
        }
        hostBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:Host") + EOL);
        if (useHostBuf) {
            this._writer.print(hostBuf);
        }
        if ((s = niso.getDeviceSource()) != null) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("mix:DeviceSource", s));
        }
        StringBuffer sscBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:ScanningSystemCapture") + EOL);
        boolean useSSCBuf = false;
        StringBuffer sshBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:ScanningSystemHardware") + EOL);
        boolean useSSHBuf = false;
        s = niso.getScannerManufacturer();
        if (s != null) {
            sshBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:ScannerManufacturer", s) + EOL);
            useSSHBuf = true;
        }
        s = niso.getScannerModelName();
        String s1 = niso.getScannerModelNumber();
        String s2 = niso.getScannerModelSerialNo();
        if (s != null || s1 != null || s2 != null) {
            sshBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:ScannerModel") + EOL);
            if (s != null) {
                sshBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:ScannerModelName", s) + EOL);
                useSSHBuf = true;
            }
            if (s1 != null) {
                sshBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:ScannerModelNumber", s1) + EOL);
                useSSHBuf = true;
            }
            if (s2 != null) {
                sshBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:ScannerModelSerialNo ", s2) + EOL);
                useSSHBuf = true;
            }
            sshBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:ScannerModel") + EOL);
        }
        sshBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:ScanningSystemHardware") + EOL);
        if (useSSHBuf) {
            sscBuf.append(sshBuf);
            useSSCBuf = true;
        }
        StringBuffer sssBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:ScanningSystemSoftware") + EOL);
        boolean useSSSBuf = false;
        s = niso.getScanningSoftware();
        if (s != null) {
            sssBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:ScanningSoftware", s) + EOL);
            useSSSBuf = true;
        }
        if ((s = niso.getScanningSoftwareVersionNo()) != null) {
            sssBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:ScanningSoftwareVersionNo", s) + EOL);
            useSSSBuf = true;
        }
        sssBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:ScanningSystemSoftware") + EOL);
        if (useSSSBuf) {
            sscBuf.append(sssBuf);
            useSSCBuf = true;
        }
        StringBuffer scsBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:ScannerCaptureSettings") + EOL);
        boolean useSCSBuf = false;
        double d = niso.getPixelSize();
        if (d != -1.0) {
            scsBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:PixelSize", formatters.get().format(d)) + EOL);
            useSCSBuf = true;
        }
        d = niso.getXPhysScanResolution();
        double d1 = niso.getYPhysScanResolution();
        if (d != -1.0 || d1 != -1.0) {
            scsBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:PhysScanResolution") + EOL);
            if (d != -1.0) {
                scsBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:XphysScanResolution", formatters.get().format(d)) + EOL);
            }
            if (d1 != -1.0) {
                scsBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:YphysScanResolution", formatters.get().format(d1)) + EOL);
            }
            scsBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:PhysScanResolution") + EOL);
            useSCSBuf = true;
        }
        scsBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:ScannerCaptureSettings") + EOL);
        if (useSCSBuf) {
            sscBuf.append(scsBuf);
            useSSCBuf = true;
        }
        sscBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:ScanningSystemCapture") + EOL);
        if (useSSCBuf) {
            this._writer.print(sscBuf.toString());
        }
        StringBuffer dccBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:DigitalCameraCapture") + EOL);
        boolean useDCCBuf = false;
        s = niso.getDigitalCameraManufacturer();
        if (s != null) {
            dccBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:DigitalCameraManufacturer", s) + EOL);
            useDCCBuf = true;
        }
        if ((s = niso.getDigitalCameraModelName()) != null) {
            dccBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:DigitalCameraModel", s) + EOL);
            useDCCBuf = true;
        }
        dccBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:DigitalCameraCapture") + EOL);
        if (useDCCBuf) {
            this._writer.print(dccBuf.toString());
        }
        StringBuffer ccsBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:CameraCaptureSettings") + EOL);
        boolean useCCSBuf = false;
        d = niso.getFNumber();
        if (d != -1.0) {
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:FNumber", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((d = niso.getExposureTime()) != -1.0) {
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:ExposureTime", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((r = niso.getBrightness()) != null) {
            d = r.toDouble();
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:Brightness", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((r = niso.getExposureBias()) != null) {
            d = r.toDouble();
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:ExposureBias", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((darray = niso.getSubjectDistance()) != null) {
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:SubjectDistance", XmlHandler.doubleArray(darray)) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getMeteringMode()) != -1) {
            s = this.meteringModeToString(n);
            if (s.startsWith("Center weighted")) {
                s = "Center weighted Average";
            }
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:MeteringMode", s) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getSceneIlluminant()) != -1) {
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:SceneIlluminant", Integer.toString(n)) + EOL);
            useCCSBuf = true;
        }
        if ((d = niso.getColorTemp()) != -1.0) {
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:ColorTemp", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((d = niso.getFocalLength()) != -1.0) {
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:FocalLength", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getFlash()) != -1) {
            int firstBit = n & 1;
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:Flash", NisoImageMetadata.FLASH[firstBit]) + EOL);
            useCCSBuf = true;
        }
        if ((r = niso.getFlashEnergy()) != null) {
            d = r.toDouble();
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:FlashEnergy", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getFlashReturn()) != -1) {
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:FlashReturn", Integer.toString(n)) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getBackLight()) != -1) {
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:BackLight", Integer.toString(n)) + EOL);
            useCCSBuf = true;
        }
        if ((d = niso.getExposureIndex()) != -1.0) {
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:ExposureIndex", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getAutoFocus()) != -1) {
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:AutoFocus", Integer.toString(n)) + EOL);
            useCCSBuf = true;
        }
        d = niso.getXPrintAspectRatio();
        d1 = niso.getYPrintAspectRatio();
        if (d != -1.0 || d1 != -1.0) {
            ccsBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:PrintAspectRatio") + EOL);
            if (d != -1.0) {
                ccsBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:XPrintAspectRatio", formatters.get().format(d)) + EOL);
            }
            if (d1 != -1.0) {
                ccsBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:YPrintAspectRatio", formatters.get().format(d1)) + EOL);
                ccsBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:PrintAspectRatio") + EOL);
                useCCSBuf = true;
            }
        }
        ccsBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:CameraCaptureSettings") + EOL);
        if (useCCSBuf) {
            this._writer.print(ccsBuf.toString());
        }
        if ((n = niso.getSensor()) != -1) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("mix:Sensor", Integer.toString(n)));
        }
        if ((s = niso.getDateTimeCreated()) != null) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("mix:DateTimeCreated", s));
        }
        if ((s = niso.getMethodology()) != null) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.element("mix:Methodology", s));
        }
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("mix:ImageCreation"));
    }

    protected void showNisoImagingPerformanceAssessment02(NisoImageMetadata niso, String margin) {
        long ln;
        Rational r;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        String margn6 = String.valueOf(margn5) + " ";
        String margn7 = String.valueOf(margn6) + " ";
        StringBuffer ipaBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:ImagingPerformanceAssessment") + EOL);
        boolean useIPABuf = false;
        StringBuffer smBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:SpatialMetrics") + EOL);
        boolean useSMBuf = false;
        int n = niso.getSamplingFrequencyPlane();
        if (n != -1) {
            smBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:SamplingFrequencyPlane", Integer.toString(n)) + EOL);
            useSMBuf = true;
        }
        if ((n = niso.getSamplingFrequencyUnit()) != -1) {
            smBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:SamplingFrequencyUnit", Integer.toString(n)) + EOL);
            useSMBuf = true;
        }
        if ((r = niso.getXSamplingFrequency()) != null) {
            smBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:XSamplingFrequency", Long.toString(r.toLong())) + EOL);
            useSMBuf = true;
        }
        if ((r = niso.getYSamplingFrequency()) != null) {
            smBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:YSamplingFrequency", Long.toString(r.toLong())) + EOL);
            useSMBuf = true;
        }
        if ((ln = niso.getImageWidth()) != -1L) {
            smBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:ImageWidth", Long.toString(ln)) + EOL);
            useSMBuf = true;
        }
        if ((ln = niso.getImageLength()) != -1L) {
            smBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:ImageLength", Long.toString(ln)) + EOL);
            useSMBuf = true;
        }
        double d = niso.getSourceXDimension();
        n = niso.getSourceXDimensionUnit();
        if (d != -1.0 || n != -1) {
            smBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:Source_X") + EOL);
            if (d != -1.0) {
                smBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:Source_Xdimension", formatters.get().format(d)) + EOL);
            }
            if (n != -1) {
                smBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:Source_XdimensionUnit", Integer.toString(n)) + EOL);
            }
            smBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:Source_X") + EOL);
            useSMBuf = true;
        }
        d = niso.getSourceYDimension();
        n = niso.getSourceYDimensionUnit();
        if (d != -1.0 || n != -1) {
            smBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:Source_Y") + EOL);
            if (d != -1.0) {
                smBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:Source_Ydimension", formatters.get().format(d)) + EOL);
            }
            if (n != -1) {
                smBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:Source_YdimensionUnit", Integer.toString(n)) + EOL);
            }
            smBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:Source_Y") + EOL);
            useSMBuf = true;
        }
        smBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:SpatialMetrics") + EOL);
        if (useSMBuf) {
            ipaBuf.append(smBuf);
            useIPABuf = true;
        }
        StringBuffer eBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:Energetics") + EOL);
        boolean useEBuf = false;
        int[] iarray = niso.getBitsPerSample();
        if (iarray != null) {
            eBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:BitsPerSample", XmlHandler.integerArray(iarray, ',')) + EOL);
            useEBuf = true;
        }
        if ((n = niso.getSamplesPerPixel()) != -1) {
            eBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:SamplesPerPixel", Integer.toString(n)) + EOL);
            useEBuf = true;
        }
        if ((iarray = niso.getExtraSamples()) != null && (n = iarray[0]) >= 0 && n <= 3) {
            eBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:ExtraSamples", Integer.toString(n)) + EOL);
            useEBuf = true;
        }
        StringBuffer cmBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:Colormap") + EOL);
        boolean useCMBuf = false;
        String s = niso.getColormapReference();
        if (s != null) {
            cmBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:Reference", s) + EOL);
            useCMBuf = true;
        }
        if ((iarray = niso.getColormapRedValue()) != null) {
            cmBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:Wrap"));
            int[] bcarray = niso.getColormapBitCodeValue();
            int[] garray = niso.getColormapGreenValue();
            int[] barray = niso.getColormapBlueValue();
            try {
                int i = 0;
                while (i < iarray.length) {
                    cmBuf.append(String.valueOf(margn6) + XmlHandler.elementStart("mix:Color") + EOL);
                    n = bcarray[i];
                    if (n != -1) {
                        cmBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:BitCodeValue", Integer.toString(n)) + EOL);
                    }
                    if ((n = iarray[i]) != -1) {
                        cmBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:RedValue", Integer.toString(n)) + EOL);
                    }
                    if ((n = garray[i]) != -1) {
                        cmBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:GreenValue", Integer.toString(n)) + EOL);
                    }
                    if ((n = barray[i]) != -1) {
                        cmBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:BlueValue", Integer.toString(n)) + EOL);
                    }
                    cmBuf.append(String.valueOf(margn6) + XmlHandler.elementEnd("mix:Color") + EOL);
                    ++i;
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            cmBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:Wrap") + EOL);
            useCMBuf = true;
        }
        cmBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:Colormap"));
        if (useCMBuf) {
            eBuf.append(cmBuf);
            useEBuf = true;
        }
        iarray = niso.getGrayResponseCurve();
        n = niso.getGrayResponseUnit();
        if (iarray != null || n != -1) {
            eBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:GrayResponse") + EOL);
            if (iarray != null) {
                eBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:GrayResponseCurve", XmlHandler.integerArray(iarray)) + EOL);
            }
            if (n != -1) {
                eBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:GrayResponseUnit", Integer.toString(n)) + EOL);
            }
            eBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:GrayResponse") + EOL);
            useEBuf = true;
        }
        r = niso.getWhitePointXValue();
        Rational r1 = niso.getWhitePointYValue();
        if (r != null || r1 != null) {
            eBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:WhitePoint") + EOL);
            if (r != null) {
                eBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:WhitePoint_Xvalue", r.toString()) + EOL);
            }
            if (r1 != null) {
                eBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:WhitePoint_Yvalue", r1.toString()) + EOL);
            }
            eBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:WhitePoint") + EOL);
            useEBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesRedX()) != null) {
            eBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:PrimaryChromaticities") + EOL);
            eBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:PrimaryChromaticities_RedX", r.toString()) + EOL);
            r = niso.getPrimaryChromaticitiesRedY();
            if (r != null) {
                eBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:PrimaryChromaticities_RedY", r.toString()) + EOL);
            }
            if ((r = niso.getPrimaryChromaticitiesGreenX()) != null) {
                eBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:PrimaryChromaticities_GreenX", r.toString()) + EOL);
            }
            if ((r = niso.getPrimaryChromaticitiesGreenY()) != null) {
                eBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:PrimaryChromaticities_GreenY", r.toString()) + EOL);
            }
            if ((r = niso.getPrimaryChromaticitiesBlueX()) != null) {
                eBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:PrimaryChromaticities_BlueX", r.toString()) + EOL);
            }
            if ((r = niso.getPrimaryChromaticitiesBlueY()) != null) {
                eBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:PrimaryChromaticities_BlueY", r.toString()) + EOL);
            }
            eBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:PrimaryChromaticities") + EOL);
            useEBuf = true;
        }
        eBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:Energetics") + EOL);
        if (useEBuf) {
            ipaBuf.append(eBuf);
            useIPABuf = true;
        }
        StringBuffer tdBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:TargetData") + EOL);
        boolean useTDBuf = false;
        n = niso.getTargetType();
        if (n != -1) {
            tdBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:TargetType", Integer.toString(n)) + EOL);
            useTDBuf = true;
        }
        StringBuffer tiBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:TargetID") + EOL);
        boolean useTIBuf = false;
        s = niso.getTargetIDManufacturer();
        if (s != null) {
            tiBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:TargetIDManufacturer", s) + EOL);
            useTIBuf = true;
        }
        if ((s = niso.getTargetIDName()) != null) {
            tiBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:TargetIDName", s) + EOL);
            useTIBuf = true;
        }
        if ((s = niso.getTargetIDNo()) != null) {
            tiBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:TargetIDNo", s) + EOL);
            useTIBuf = true;
        }
        if ((s = niso.getTargetIDMedia()) != null) {
            tiBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:TargetIDMedia", s) + EOL);
            useTIBuf = true;
        }
        tiBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:TargetID") + EOL);
        if (useTIBuf) {
            tdBuf.append(tiBuf);
            useTDBuf = true;
        }
        if ((s = niso.getImageData()) != null) {
            tdBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:ImageData", s) + EOL);
            useTDBuf = true;
        }
        if ((s = niso.getPerformanceData()) != null) {
            tdBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:PerformanceData", s) + EOL);
            useTDBuf = true;
        }
        if ((s = niso.getProfiles()) != null) {
            tdBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:Profiles", s) + EOL);
            useTDBuf = true;
        }
        tdBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:TargetData") + EOL);
        if (useTDBuf) {
            ipaBuf.append(tdBuf);
            useIPABuf = true;
        }
        ipaBuf.append(String.valueOf(margn2) + XmlHandler.elementEnd("mix:ImagingPerformanceAssessment") + EOL);
        if (useIPABuf) {
            this._writer.print(ipaBuf.toString());
        }
    }

    protected void showNisoChangeHistory02(NisoImageMetadata niso, String margin) {
        String[] sarray;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        StringBuffer chBuf = new StringBuffer(String.valueOf(margn2) + XmlHandler.elementStart("mix:ChangeHistory") + EOL);
        boolean useCHBuf = false;
        StringBuffer ipBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:ImageProcessing") + EOL);
        boolean useIPBuf = false;
        String s = niso.getDateTimeProcessed();
        if (s != null) {
            ipBuf.append(String.valueOf(margn4) + XmlHandler.element("DateTimeProcessed", s) + EOL);
            useIPBuf = true;
        }
        if ((s = niso.getSourceData()) != null) {
            ipBuf.append(String.valueOf(margn4) + XmlHandler.element("SourceData", s) + EOL);
            useIPBuf = true;
        }
        if ((s = niso.getProcessingAgency()) != null) {
            ipBuf.append(String.valueOf(margn4) + XmlHandler.element("ProcessingAgency", s) + EOL);
            useIPBuf = true;
        }
        StringBuffer psBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("ProcessingSoftware") + EOL);
        boolean usePSBuf = false;
        s = niso.getProcessingSoftwareName();
        if (s != null) {
            psBuf.append(String.valueOf(margn5) + XmlHandler.element("ProcessingSoftwareName", s) + EOL);
            usePSBuf = true;
        }
        if ((s = niso.getProcessingSoftwareVersion()) != null) {
            psBuf.append(String.valueOf(margn5) + XmlHandler.element("ProcessingSoftwareVersion", s) + EOL);
            usePSBuf = true;
        }
        psBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("ProcessingSoftware") + EOL);
        if (usePSBuf) {
            ipBuf.append(psBuf);
            useIPBuf = true;
        }
        if ((sarray = niso.getProcessingActions()) != null) {
            int i = 0;
            while (i < sarray.length) {
                ipBuf.append(String.valueOf(margn4) + XmlHandler.element("ProcessingActions", sarray[i]) + EOL);
                ++i;
            }
            useIPBuf = true;
        }
        ipBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:ImageProcessing") + EOL);
        if (useIPBuf) {
            chBuf.append(ipBuf);
            useCHBuf = true;
        }
        chBuf.append(String.valueOf(margn2) + XmlHandler.elementEnd("mix:ChangeHistory") + EOL);
        if (useCHBuf) {
            this._writer.print(chBuf.toString());
        }
    }

    protected void showNisoImageMetadata10(NisoImageMetadata niso) {
        String margin = XmlHandler.getIndent(++this._level);
        String[][] attrs = new String[][]{{"xmlns:mix", "http://www.loc.gov/mix/v10"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "http://www.loc.gov/mix/v10 http://www.loc.gov/standards/mix/mix10/mix10.xsd"}};
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("mix:mix", attrs));
        this.showNisoBasicDigitalObjectInformation10(niso, margin);
        this.showNisoBasicImageInformation10(niso, margin);
        this.showNisoImageCaptureMetadata10(niso, margin);
        this.showNisoImageAssessmentMetadata10(niso, margin);
        this.showChangeHistory10(niso, margin);
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("mix:mix"));
        --this._level;
    }

    protected void showNisoBasicDigitalObjectInformation10(NisoImageMetadata niso, String margin) {
        long ln;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("mix:BasicDigitalObjectInformation"));
        StringBuffer objIDBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:ObjectIdentifier") + EOL);
        boolean useObjIDBuf = false;
        objIDBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:objectIdentifierType", "JHOVE") + EOL);
        String s = niso.getImageIdentifier();
        if (s != null) {
            objIDBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:objectIdentifierValue", s) + EOL);
            useObjIDBuf = true;
        }
        objIDBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:ObjectIdentifier") + EOL);
        if (useObjIDBuf) {
            this._writer.print(objIDBuf.toString());
        }
        if ((ln = niso.getFileSize()) != -1L) {
            this._writer.print(String.valueOf(margn4) + XmlHandler.element("mix:fileSize", Long.toString(ln)) + EOL);
        }
        if ((s = niso.getByteOrder()) != null) {
            if (s.startsWith("big")) {
                s = "big_endian";
            } else if (s.startsWith("little")) {
                s = "little_endian";
            }
            this._writer.print(String.valueOf(margn4) + XmlHandler.element("mix:byteOrder", s) + EOL);
        }
        int comp = niso.getCompressionScheme();
        int level = niso.getCompressionLevel();
        if (comp != -1 || level != -1) {
            this._writer.print(String.valueOf(margn4) + XmlHandler.elementStart("mix:Compression") + EOL);
            if (comp != -1) {
                if (comp == 34713 || comp == 34714) {
                    this._writer.print(String.valueOf(margn5) + XmlHandler.element("mix:compressionScheme", this.compressionSchemeToString(comp)) + EOL);
                    if (level != -1) {
                        this._writer.print(String.valueOf(margn5) + XmlHandler.element("mix:compressionRatio", Integer.toString(level)) + EOL);
                    }
                } else {
                    this._writer.print(String.valueOf(margn5) + XmlHandler.element("mix:compressionScheme", Integer.toString(comp)) + EOL);
                }
            }
            this._writer.print(String.valueOf(margn4) + XmlHandler.elementEnd("mix:Compression") + EOL);
        }
        int n = niso.getChecksumMethod();
        s = niso.getChecksumValue();
        if (n != -1 || s != null) {
            this._writer.print(String.valueOf(margn4) + XmlHandler.elementStart("mix:Fixity") + EOL);
            if (n != -1) {
                this._writer.print(String.valueOf(margn5) + XmlHandler.element("mix:messageDigestAlgorithm", Integer.toString(n)) + EOL);
            }
            if (s != null) {
                this._writer.print(String.valueOf(margn5) + XmlHandler.element("mix:messageDigest", s) + EOL);
            }
            this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("mix:Fixity"));
        }
        this._writer.println(String.valueOf(margn3) + XmlHandler.elementEnd("mix:BasicDigitalObjectInformation"));
    }

    protected void showNisoBasicImageInformation10(NisoImageMetadata niso, String margin) {
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        String margn6 = String.valueOf(margn5) + " ";
        String margn7 = String.valueOf(margn6) + " ";
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("mix:BasicImageInformation"));
        StringBuffer basCharBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:BasicImageCharacteristics") + EOL);
        boolean useBasCharBuf = false;
        long ln = niso.getImageWidth();
        if (ln != -1L) {
            basCharBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:imageWidth", Long.toString(ln)) + EOL);
            useBasCharBuf = true;
        }
        if ((ln = niso.getImageLength()) != -1L) {
            basCharBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:imageHeight", Long.toString(ln)) + EOL);
            useBasCharBuf = true;
        }
        StringBuffer piBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:PhotometricInterpretation") + EOL);
        boolean usePIBuf = false;
        int n = niso.getColorSpace();
        if (n != -1) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:colorSpace", Integer.toString(n)) + EOL);
            usePIBuf = true;
        }
        String s = niso.getProfileName();
        String s2 = niso.getProfileURL();
        if (s != null || s2 != null) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:ColorProfile") + EOL);
            piBuf.append(String.valueOf(margn6) + XmlHandler.elementStart("mix:IccProfile") + EOL);
            if (s != null) {
                piBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:iccProfileName", s) + EOL);
            }
            if (s2 != null) {
                piBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:iccProfileURL", s2) + EOL);
            }
            piBuf.append(String.valueOf(margn6) + XmlHandler.elementEnd("mix:IccProfile") + EOL);
            piBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:ColorProfile") + EOL);
            usePIBuf = true;
        }
        int[] iarray = niso.getYCbCrSubSampling();
        n = niso.getYCbCrPositioning();
        Rational[] rarray = niso.getYCbCrCoefficients();
        if (iarray != null || n != -1 || rarray != null) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:YCbCr") + EOL);
            usePIBuf = true;
            if (iarray != null && iarray.length >= 2) {
                piBuf.append(String.valueOf(margn6) + XmlHandler.elementStart("mix:YCbCrSubSampling") + EOL);
                piBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:yCbCrSubsampleHoriz", Integer.toString(iarray[0])) + EOL);
                piBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:yCbCrSubsampleVert", Integer.toString(iarray[1])) + EOL);
                piBuf.append(String.valueOf(margn6) + XmlHandler.elementEnd("mix:YCbCrSubSampling") + EOL);
            }
            if (n != -1) {
                piBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:yCbCrPositioning", Integer.toString(n)) + EOL);
            }
            if (rarray != null) {
                piBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:yCbCrCoefficients", XmlHandler.rationalArray10(rarray)) + EOL);
            }
            piBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:YCbCr") + EOL);
        }
        if ((rarray = niso.getReferenceBlackWhite()) != null) {
            piBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:referenceBlackWhite", XmlHandler.rationalArray10(rarray)) + EOL);
            usePIBuf = true;
        }
        piBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:PhotometricInterpretation") + EOL);
        if (usePIBuf) {
            basCharBuf.append(piBuf);
            useBasCharBuf = true;
        }
        basCharBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:BasicImageCharacteristics"));
        if (useBasCharBuf) {
            this._writer.println(basCharBuf);
        }
        StringBuffer speCharBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:SpecialFormatCharacteristics") + EOL);
        boolean useSpeCharBuf = false;
        int lay = niso.getJp2Layers();
        int lev = niso.getJp2ResolutionLevels();
        String sizTiles = niso.getJp2Tiles();
        if (sizTiles != null || lay != -1 || lev != -1) {
            useSpeCharBuf = true;
            speCharBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:JPEG2000") + EOL);
            speCharBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:EncodingOptions") + EOL);
            if (sizTiles != null) {
                speCharBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:tiles", sizTiles) + EOL);
            }
            if (lay != -1) {
                speCharBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:qualityLayers", Integer.toString(lay)) + EOL);
            }
            if (sizTiles != null) {
                speCharBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:resolutionLevels", Integer.toString(lev)) + EOL);
            }
            speCharBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:EncodingOptions") + EOL);
            speCharBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:JPEG2000") + EOL);
        }
        speCharBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:SpecialFormatCharacteristics"));
        if (useSpeCharBuf) {
            this._writer.println(speCharBuf);
        }
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("mix:BasicImageInformation"));
    }

    protected void showNisoImageCaptureMetadata10(NisoImageMetadata niso, String margin) {
        double[] darray;
        Rational r;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        String margn6 = String.valueOf(margn5) + " ";
        String margn7 = String.valueOf(margn6) + " ";
        StringBuffer captureBuffer = new StringBuffer();
        boolean useCaptureBuffer = false;
        String s = niso.getSourceType();
        if (s != null) {
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.element("mix:sourceType", s));
            useCaptureBuffer = true;
        }
        if ((s = niso.getSourceID()) != null) {
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.elementStart("mix:SourceID"));
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.element("mix:sourceIDValue", s));
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:sourceID"));
            useCaptureBuffer = true;
        }
        double d = niso.getSourceXDimension();
        int n = niso.getSourceXDimensionUnit();
        if (d != -1.0 || n != -1) {
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.elementStart("mix:SourceSize"));
            captureBuffer.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:SourceXDimension") + EOL);
            if (d != -1.0) {
                captureBuffer.append(String.valueOf(margn5) + XmlHandler.element("mix:sourceXDimensionValue", formatters.get().format(d)) + EOL);
            }
            if (n != -1) {
                captureBuffer.append(String.valueOf(margn5) + XmlHandler.element("mix:sourceXDimensionUnit", Integer.toString(n)) + EOL);
            }
            captureBuffer.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:SourceXDimension") + EOL);
            d = niso.getSourceYDimension();
            n = niso.getSourceYDimensionUnit();
            if (d != -1.0 || n != -1) {
                captureBuffer.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:SourceYDimension") + EOL);
                if (d != -1.0) {
                    captureBuffer.append(String.valueOf(margn5) + XmlHandler.element("mix:sourceYDimensionValue", formatters.get().format(d)) + EOL);
                }
                if (n != -1) {
                    captureBuffer.append(String.valueOf(margn5) + XmlHandler.element("mix:sourceYDimensionUnit", Integer.toString(n)) + EOL);
                }
                captureBuffer.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:SourceYDimension") + EOL);
            }
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:SourceSize") + EOL);
            useCaptureBuffer = true;
        }
        StringBuffer genCapBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:GeneralCaptureInformation") + EOL);
        boolean useGenCapBuf = false;
        s = niso.getDateTimeCreated();
        if (s != null) {
            genCapBuf.append(String.valueOf(margn3) + XmlHandler.element("mix:dateTimeCreated", s) + EOL);
            useGenCapBuf = true;
        }
        if ((s = niso.getImageProducer()) != null) {
            genCapBuf.append(String.valueOf(margn3) + XmlHandler.element("mix:imageProducer", s) + EOL);
            useGenCapBuf = true;
        }
        if ((s = niso.getDeviceSource()) != null) {
            genCapBuf.append(String.valueOf(margn3) + XmlHandler.element("mix:captureDevice", s) + EOL);
        }
        genCapBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:GeneralCaptureInformation") + EOL);
        if (useGenCapBuf) {
            captureBuffer.append(genCapBuf);
            useCaptureBuffer = true;
        }
        StringBuffer scanCapBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:ScannerCapture") + EOL);
        boolean useScanCapBuf = false;
        String mfg = niso.getScannerManufacturer();
        if (mfg != null) {
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:scannerManufacturer", mfg) + EOL);
            useScanCapBuf = true;
        }
        String model = niso.getScannerModelName();
        String modelNum = niso.getScannerModelNumber();
        String serNum = niso.getScannerModelSerialNo();
        if (model != null || modelNum != null || serNum != null) {
            useScanCapBuf = true;
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:ScannerModel") + EOL);
            if (model != null) {
                scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:scannerModelName", model) + EOL);
            }
            if (modelNum != null) {
                scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:scannerModelNumber", modelNum) + EOL);
            }
            if (serNum != null) {
                scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:scannerModelSerialNo", serNum) + EOL);
            }
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:ScannerModel") + EOL);
        }
        double xres = niso.getXPhysScanResolution();
        double yres = niso.getYPhysScanResolution();
        if (xres != -1.0 && yres != -1.0) {
            double res = xres > yres ? xres : yres;
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:maximumOpticalResolution", formatters.get().format(res)) + EOL);
        }
        if ((s = niso.getScanningSoftware()) != null) {
            useScanCapBuf = true;
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:ScanningSystemSoftware") + EOL);
            scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:scanningSoftwareName", s) + EOL);
            s = niso.getScanningSoftwareVersionNo();
            if (s != null) {
                scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:scanningSoftwareVersionNo", s) + EOL);
            }
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:ScanningSystemSoftware") + EOL);
        }
        scanCapBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:ScannerCapture") + EOL);
        if (useScanCapBuf) {
            captureBuffer.append(scanCapBuf);
            useCaptureBuffer = true;
        }
        StringBuffer digCamBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:DigitalCameraCapture") + EOL);
        boolean useDigCamBuf = false;
        s = niso.getDigitalCameraManufacturer();
        if (s != null) {
            digCamBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:digitalCameraManufacturer", s) + EOL);
            useDigCamBuf = true;
        }
        String dcmodel = niso.getDigitalCameraModelName();
        String dcmodelNum = niso.getDigitalCameraModelNumber();
        String dcserNum = niso.getDigitalCameraModelSerialNo();
        if (dcmodel != null || dcmodelNum != null || dcserNum != null) {
            useDigCamBuf = true;
            digCamBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:DigitalCameraModel") + EOL);
            if (dcmodel != null) {
                digCamBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:digitalCameraModelName", dcmodel) + EOL);
            }
            if (dcmodelNum != null) {
                digCamBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:digitalCameraModelNumber", dcmodelNum) + EOL);
            }
            if (dcserNum != null) {
                digCamBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:mix:digitalCameraModelSerialNo", dcserNum) + EOL);
            }
            digCamBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:DigitalCameraModel") + EOL);
        }
        StringBuffer ccSetBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:CameraCaptureSettings") + EOL);
        boolean useCcSetBuf = false;
        ccSetBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:ImageData") + EOL);
        d = niso.getFNumber();
        if (d != -1.0) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:fNumber", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureTime()) != -1.0) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:exposureTime", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getExposureProgram()) != -1) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:exposureProgram", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ("0220".equals(s = niso.getExifVersion())) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:exifVersion", s) + EOL);
            useCcSetBuf = true;
        }
        if ((r = niso.getBrightness()) != null) {
            this.rationalToString(ccSetBuf, "mix:brightnessValue", margn6, r);
            useCcSetBuf = true;
        }
        if ((r = niso.getExposureBias()) != null) {
            this.rationalToString(ccSetBuf, "mix:exposureBiasValue", margn6, r);
            useCcSetBuf = true;
        }
        if ((r = niso.getMaxApertureValue()) != null) {
            this.rationalToString(ccSetBuf, "mix:maxApertureValue", margn6, r);
            useCcSetBuf = true;
        }
        if ((darray = niso.getSubjectDistance()) != null) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:subjectDistance", formatters.get().format(darray[0])) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getMeteringMode()) != -1) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:meteringMode", this.meteringModeToString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getFlash()) != -1) {
            int firstBit = n & 1;
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:flash", NisoImageMetadata.FLASH_20[firstBit]) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getFocalLength()) != -1.0) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:focalLength", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((r = niso.getFlashEnergy()) != null) {
            this.rationalToString(ccSetBuf, "mix:flashEnergy", margn6, r);
            useCcSetBuf = true;
        }
        if ((n = niso.getBackLight()) != -1) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:backLight", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureIndex()) != -1.0) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:exposureIndex", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getAutoFocus()) != -1) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:autoFocus", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        d = niso.getXPrintAspectRatio();
        double d2 = niso.getYPrintAspectRatio();
        if (d != -1.0 || d2 != -1.0) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.elementStart("mix:PrintAspectRatio") + EOL);
            if (d != -1.0) {
                ccSetBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:xPrintAspectRatio", formatters.get().format(d)) + EOL);
            }
            if (d2 != -1.0) {
                ccSetBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:yPrintAspectRatio", formatters.get().format(d)) + EOL);
            }
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.elementEnd("mix:PrintAspectRatio") + EOL);
        }
        ccSetBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:ImageData") + EOL);
        ccSetBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:CameraCaptureSettings") + EOL);
        if (useCcSetBuf) {
            digCamBuf.append(ccSetBuf);
            useDigCamBuf = true;
        }
        digCamBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:DigitalCameraCapture") + EOL);
        if (useDigCamBuf) {
            captureBuffer.append(digCamBuf);
            useCaptureBuffer = true;
        }
        if ((n = niso.getOrientation()) != -1) {
            if (n > 9 || n < 1) {
                n = 9;
            }
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.element("mix:orientation", Integer.toString(n)) + EOL);
            useCaptureBuffer = true;
        }
        if ((s = niso.getMethodology()) != null) {
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.element("mix:methodology", s) + EOL);
        }
        if (useCaptureBuffer) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("mix:ImageCaptureMetadata"));
            this._writer.print(captureBuffer.toString());
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("mix:ImageCaptureMetadata"));
        }
    }

    protected void showNisoImageAssessmentMetadata10(NisoImageMetadata niso, String margin) {
        String s;
        Rational r;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("mix:ImageAssessmentMetadata"));
        StringBuffer metricsBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:SpatialMetrics") + EOL);
        boolean useMetricsBuf = false;
        int n = niso.getSamplingFrequencyPlane();
        if (n != -1) {
            metricsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:samplingFrequencyPlane", Integer.toString(n)) + EOL);
            useMetricsBuf = true;
        }
        if ((n = niso.getSamplingFrequencyUnit()) != -1) {
            metricsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:samplingFrequencyUnit", Integer.toString(n)) + EOL);
            useMetricsBuf = true;
        }
        if ((r = niso.getXSamplingFrequency()) != null) {
            this.rationalToString(metricsBuf, "mix:xSamplingFrequency", margn4, r);
        }
        if ((r = niso.getYSamplingFrequency()) != null) {
            this.rationalToString(metricsBuf, "mix:ySamplingFrequency", margn4, r);
        }
        metricsBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:SpatialMetrics"));
        if (useMetricsBuf) {
            this._writer.println(metricsBuf);
        }
        StringBuffer colorEncBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:ImageColorEncoding") + EOL);
        boolean useColorEncBuf = false;
        int[] iarray = niso.getBitsPerSample();
        if (iarray != null) {
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:bitsPerSample") + EOL);
            colorEncBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:bitsPerSampleValue", XmlHandler.integerArray(iarray, ',')) + EOL);
            colorEncBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:bitsPerSampleUnit", "integer") + EOL);
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:bitsPerSample") + EOL);
            useColorEncBuf = true;
        }
        if ((n = niso.getSamplesPerPixel()) != -1) {
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:samplesPerPixel", Integer.toString(n)) + EOL);
            useColorEncBuf = true;
        }
        if ((iarray = niso.getExtraSamples()) != null && (n = iarray[0]) >= 0 && n <= 3) {
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:extraSamples", Integer.toString(n)) + EOL);
            useColorEncBuf = true;
        }
        if ((s = niso.getColormapReference()) != null) {
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:Colormap") + EOL);
            colorEncBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:colormapReference", s) + EOL);
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:Colormap") + EOL);
            useColorEncBuf = true;
        }
        if ((iarray = niso.getGrayResponseCurve()) != null) {
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:grayResponseCurve", "N") + EOL);
            useColorEncBuf = true;
        }
        if ((n = niso.getGrayResponseUnit()) != -1) {
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:grayResponseUnit", Integer.toString(n)) + EOL);
            useColorEncBuf = true;
        }
        r = niso.getWhitePointXValue();
        Rational r2 = niso.getWhitePointYValue();
        if (r != null || r2 != null) {
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:WhitePoint") + EOL);
            if (r != null) {
                colorEncBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:whitePointXValue", r.toString()) + EOL);
            }
            if (r2 != null) {
                colorEncBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:whitePointYValue", r2.toString()) + EOL);
            }
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:WhitePoint") + EOL);
            useColorEncBuf = true;
        }
        StringBuffer chromaBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:PrimaryChromaticities") + EOL);
        boolean useChromaBuf = false;
        r = niso.getPrimaryChromaticitiesRedX();
        if (r != null) {
            chromaBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:primaryChromaticitiesRedX", r.toString()) + EOL);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesRedY()) != null) {
            chromaBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:primaryChromaticitiesRedY", r.toString()) + EOL);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesGreenX()) != null) {
            chromaBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:primaryChromaticitiesGreenX", r.toString()) + EOL);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesGreenY()) != null) {
            chromaBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:primaryChromaticitiesGreenY", r.toString()) + EOL);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesBlueX()) != null) {
            chromaBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:primaryChromaticitiesBlueX", r.toString()) + EOL);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesBlueY()) != null) {
            chromaBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:primaryChromaticitiesBlueY", r.toString()) + EOL);
            useChromaBuf = true;
        }
        chromaBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:PrimaryChromaticities") + EOL);
        if (useChromaBuf) {
            colorEncBuf.append(chromaBuf);
            useColorEncBuf = true;
        }
        colorEncBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:ImageColorEncoding") + EOL);
        if (useColorEncBuf) {
            this._writer.print(colorEncBuf);
        }
        StringBuffer targetBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:TargetData") + EOL);
        boolean useTargetBuf = false;
        n = niso.getTargetType();
        if (n != -1) {
            targetBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:targetType", Integer.toString(n)) + EOL);
            useTargetBuf = true;
        }
        StringBuffer targetIDBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:TargetID") + EOL);
        boolean useTargetIDBuf = false;
        s = niso.getTargetIDManufacturer();
        if (s != null) {
            targetIDBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:targetManufacturer", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDName()) != null) {
            targetIDBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:targetName", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDNo()) != null) {
            targetIDBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:targetNo", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDMedia()) != null) {
            targetIDBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:targetMedia", s) + EOL);
            useTargetIDBuf = true;
        }
        targetIDBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:TargetID") + EOL);
        if (useTargetIDBuf) {
            targetBuf.append(targetIDBuf);
            useTargetBuf = true;
        }
        if ((s = niso.getImageData()) != null) {
            targetBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:externalTarget", s) + EOL);
            useTargetBuf = true;
        }
        if ((s = niso.getPerformanceData()) != null) {
            targetBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:performanceData", s) + EOL);
            useTargetBuf = true;
        }
        targetBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:TargetData") + EOL);
        if (useTargetBuf) {
            this._writer.print(targetBuf);
        }
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("mix:ImageAssessmentMetadata"));
    }

    protected void showChangeHistory10(NisoImageMetadata niso, String margin) {
        String[] sarray;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        StringBuffer chBuf = new StringBuffer(String.valueOf(margn2) + XmlHandler.elementStart("mix:ChangeHistory") + EOL);
        boolean useChBuf = false;
        chBuf.append(String.valueOf(margn3) + XmlHandler.elementStart("mix:ImageProcessing") + EOL);
        String s = niso.getSourceData();
        if (s != null) {
            chBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:sourceData", s) + EOL);
            useChBuf = true;
        }
        if ((s = niso.getProcessingAgency()) != null) {
            chBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:processingAgency", s) + EOL);
            useChBuf = true;
        }
        StringBuffer sftwBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:ProcessingSoftware") + EOL);
        boolean useSftwBuf = false;
        s = niso.getProcessingSoftwareName();
        if (s != null) {
            sftwBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:processingSoftwareName", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getProcessingSoftwareVersion()) != null) {
            sftwBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:processingSoftwareVersion", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getOS()) != null) {
            sftwBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:processingOperatingSystemName", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getOSVersion()) != null) {
            sftwBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:processingOperatingSystemVersion", s) + EOL);
            useSftwBuf = true;
        }
        sftwBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:ProcessingSoftware") + EOL);
        if (useSftwBuf) {
            chBuf.append(sftwBuf);
            useChBuf = true;
        }
        if ((sarray = niso.getProcessingActions()) != null) {
            int i = 0;
            while (i < sarray.length) {
                chBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:processingActions", sarray[i]) + EOL);
                ++i;
            }
            useChBuf = true;
        }
        chBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:ImageProcessing") + EOL);
        chBuf.append(String.valueOf(margn2) + XmlHandler.elementEnd("mix:ChangeHistory") + EOL);
        if (useChBuf) {
            this._writer.println(chBuf);
        }
    }

    protected void showNisoImageMetadata20(NisoImageMetadata niso) {
        String margin = XmlHandler.getIndent(++this._level);
        String[][] attrs = new String[][]{{"xmlns:mix", "http://www.loc.gov/mix/v20"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "http://www.loc.gov/mix/v20 http://www.loc.gov/standards/mix/mix20/mix20.xsd"}};
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("mix:mix", attrs));
        this.showNisoBasicDigitalObjectInformation20(niso, margin);
        this.showNisoBasicImageInformation20(niso, margin);
        this.showNisoImageCaptureMetadata20(niso, margin);
        this.showNisoImageAssessmentMetadata20(niso, margin);
        this.showChangeHistory20(niso, margin);
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("mix:mix"));
        --this._level;
    }

    protected void showNisoBasicDigitalObjectInformation20(NisoImageMetadata niso, String margin) {
        String compStr;
        String mime;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        String margn6 = String.valueOf(margn5) + " ";
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("mix:BasicDigitalObjectInformation"));
        StringBuffer objIDBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:ObjectIdentifier") + EOL);
        objIDBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:objectIdentifierType", "JHOVE") + EOL);
        String s = niso.getImageIdentifier();
        if (s != null) {
            objIDBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:objectIdentifierValue", s) + EOL);
        }
        objIDBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:ObjectIdentifier") + EOL);
        this._writer.print(objIDBuf.toString());
        long ln = niso.getFileSize();
        if (ln != -1L) {
            this._writer.print(String.valueOf(margn3) + XmlHandler.element("mix:fileSize", Long.toString(ln)) + EOL);
        }
        if ((mime = niso.getMimeType()) != null) {
            this._writer.println(String.valueOf(margn3) + XmlHandler.elementStart("mix:FormatDesignation"));
            this._writer.print(String.valueOf(margn4) + XmlHandler.element("mix:formatName", mime) + EOL);
            this._writer.println(String.valueOf(margn3) + XmlHandler.elementEnd("mix:FormatDesignation"));
        }
        if ((s = niso.getByteOrder()) != null) {
            if (s.startsWith("big")) {
                s = "big endian";
            } else if (s.startsWith("little")) {
                s = "little endian";
            }
            this._writer.print(String.valueOf(margn3) + XmlHandler.element("mix:byteOrder", s) + EOL);
        }
        int comp = niso.getCompressionScheme();
        int level = niso.getCompressionLevel();
        switch (comp) {
            case 1: {
                compStr = "Uncompressed";
                break;
            }
            case 2: {
                compStr = "CCITT 1D";
                break;
            }
            case 3: {
                compStr = "Group 3 Fax";
                break;
            }
            case 4: {
                compStr = "Group 4 Fax";
                break;
            }
            case 5: {
                compStr = "LZW";
                break;
            }
            case 6: {
                compStr = "JPEG";
                break;
            }
            case 32773: {
                compStr = "PackBits";
                break;
            }
            case 34713: {
                compStr = "JPEG2000 Lossy";
                break;
            }
            case 34714: {
                compStr = "JPEG2000 Lossless";
                break;
            }
            default: {
                compStr = "Unknown";
            }
        }
        if (comp != -1 || level != -1) {
            this._writer.print(String.valueOf(margn3) + XmlHandler.elementStart("mix:Compression") + EOL);
            if (comp != -1) {
                this._writer.print(String.valueOf(margn4) + XmlHandler.element("mix:compressionScheme", compStr) + EOL);
            }
            if (level != -1 && (comp == 34713 || comp == 34714)) {
                this._writer.print(String.valueOf(margn5) + XmlHandler.elementStart("mix:compressionRatio") + EOL);
                this._writer.print(String.valueOf(margn6) + XmlHandler.element("mix:numerator", Integer.toString(level)) + EOL);
                this._writer.print(String.valueOf(margn5) + XmlHandler.elementEnd("mix:compressionRatio") + EOL);
            }
            this._writer.print(String.valueOf(margn3) + XmlHandler.elementEnd("mix:Compression") + EOL);
        }
        int n = niso.getChecksumMethod();
        s = niso.getChecksumValue();
        if (n != -1 || s != null) {
            this._writer.print(String.valueOf(margn4) + XmlHandler.elementStart("mix:Fixity") + EOL);
            if (n != -1) {
                this._writer.print(String.valueOf(margn5) + XmlHandler.element("mix:messageDigestAlgorithm", Integer.toString(n)) + EOL);
            }
            if (s != null) {
                this._writer.print(String.valueOf(margn5) + XmlHandler.element("mix:messageDigest", s) + EOL);
            }
            this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("mix:Fixity"));
        }
        this._writer.print(String.valueOf(margn2) + XmlHandler.elementEnd("mix:BasicDigitalObjectInformation") + EOL);
    }

    protected void showNisoBasicImageInformation20(NisoImageMetadata niso, String margin) {
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        String margn6 = String.valueOf(margn5) + " ";
        String margn7 = String.valueOf(margn6) + " ";
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("mix:BasicImageInformation"));
        StringBuffer basCharBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:BasicImageCharacteristics") + EOL);
        boolean useBasCharBuf = false;
        long ln = niso.getImageWidth();
        if (ln != -1L) {
            basCharBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:imageWidth", Long.toString(ln)) + EOL);
            useBasCharBuf = true;
        }
        if ((ln = niso.getImageLength()) != -1L) {
            basCharBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:imageHeight", Long.toString(ln)) + EOL);
            useBasCharBuf = true;
        }
        StringBuffer piBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:PhotometricInterpretation") + EOL);
        boolean usePIBuf = false;
        int n = niso.getColorSpace();
        if (n != -1) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:colorSpace", this.photometricInterpretationToString(n)) + EOL);
            usePIBuf = true;
        }
        String s = niso.getProfileName();
        String s2 = niso.getProfileURL();
        if (s != null || s2 != null) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:ColorProfile") + EOL);
            piBuf.append(String.valueOf(margn6) + XmlHandler.elementStart("mix:IccProfile") + EOL);
            if (s != null) {
                piBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:iccProfileName", s) + EOL);
            }
            if (s2 != null) {
                piBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:iccProfileURI", s2) + EOL);
            }
            piBuf.append(String.valueOf(margn6) + XmlHandler.elementEnd("mix:IccProfile") + EOL);
            piBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:ColorProfile") + EOL);
            usePIBuf = true;
        }
        int[] iarray = niso.getYCbCrSubSampling();
        n = niso.getYCbCrPositioning();
        Rational[] rarray = niso.getYCbCrCoefficients();
        if (iarray != null || n != -1 || rarray != null) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:YCbCr") + EOL);
            usePIBuf = true;
            if (iarray != null && iarray.length >= 2) {
                piBuf.append(String.valueOf(margn6) + XmlHandler.elementStart("mix:YCbCrSubSampling") + EOL);
                piBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:yCbCrSubsampleHoriz", Integer.toString(iarray[0])) + EOL);
                piBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:yCbCrSubsampleVert", Integer.toString(iarray[1])) + EOL);
                piBuf.append(String.valueOf(margn6) + XmlHandler.elementEnd("mix:YCbCrSubSampling") + EOL);
            }
            if (n != -1) {
                piBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:yCbCrPositioning", Integer.toString(n)) + EOL);
            }
            if (rarray != null && rarray.length >= 3) {
                piBuf.append(String.valueOf(margn6) + XmlHandler.elementStart("mix:YCbCrCoefficients") + EOL);
                this.rationalToString(piBuf, "mix:lumaRed", margn7, rarray[0]);
                this.rationalToString(piBuf, "mix:lumaGreen", margn7, rarray[1]);
                this.rationalToString(piBuf, "mix:lumaBlue", margn7, rarray[2]);
                piBuf.append(String.valueOf(margn6) + XmlHandler.elementEnd("mix:YCbCrCoefficients") + EOL);
            }
            piBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:YCbCr") + EOL);
        }
        if ((rarray = niso.getReferenceBlackWhite()) != null) {
            piBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:ReferenceBlackWhite") + EOL);
            int i = 0;
            while (i < rarray.length - 1) {
                String pi;
                piBuf.append(String.valueOf(margn6) + XmlHandler.elementStart("mix:Component") + EOL);
                piBuf.append(String.valueOf(margn7) + XmlHandler.elementStart("mix:componentPhotometricInterpretation"));
                if (niso.getColorSpace() == 6) {
                    switch (i) {
                        case 0: {
                            pi = "Y";
                            break;
                        }
                        case 2: {
                            pi = "Cb";
                            break;
                        }
                        default: {
                            pi = "Cr";
                            break;
                        }
                    }
                } else {
                    switch (i) {
                        case 0: {
                            pi = "R";
                            break;
                        }
                        case 2: {
                            pi = "G";
                            break;
                        }
                        default: {
                            pi = "B";
                        }
                    }
                }
                piBuf.append(String.valueOf(pi) + XmlHandler.elementEnd("mix:componentPhotometricInterpretation") + EOL);
                this.rationalToString(piBuf, "mix:footroom", margn7, rarray[i]);
                this.rationalToString(piBuf, "mix:headroom", margn7, rarray[i + 1]);
                piBuf.append(String.valueOf(margn7) + XmlHandler.elementEnd("mix:Component") + EOL);
                i += 2;
            }
            piBuf.append(String.valueOf(margn6) + XmlHandler.elementEnd("mix:ReferenceBlackWhite") + EOL);
            usePIBuf = true;
        }
        piBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:PhotometricInterpretation") + EOL);
        if (usePIBuf) {
            basCharBuf.append(piBuf);
            useBasCharBuf = true;
        }
        basCharBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:BasicImageCharacteristics"));
        if (useBasCharBuf) {
            this._writer.println(basCharBuf);
        }
        StringBuffer speCharBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:SpecialFormatCharacteristics") + EOL);
        boolean useSpeCharBuf = false;
        int lay = niso.getJp2Layers();
        int lev = niso.getJp2ResolutionLevels();
        String sizTiles = niso.getJp2Tiles();
        if (sizTiles != null || lay != -1 || lev != -1) {
            useSpeCharBuf = true;
            speCharBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:JPEG2000") + EOL);
            speCharBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:EncodingOptions") + EOL);
            if (sizTiles != null) {
                String[] sizes = sizTiles.split("x");
                speCharBuf.append(String.valueOf(margn6) + XmlHandler.elementStart("mix:Tiles") + EOL);
                speCharBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:tileWidth", sizes[0]) + EOL);
                speCharBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:tileHeight", sizes[1]) + EOL);
                speCharBuf.append(String.valueOf(margn6) + XmlHandler.elementEnd("mix:Tiles") + EOL);
            }
            if (lay != -1) {
                speCharBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:qualityLayers", Integer.toString(lay)) + EOL);
            }
            if (sizTiles != null) {
                speCharBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:resolutionLevels", Integer.toString(lev)) + EOL);
            }
            speCharBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:EncodingOptions") + EOL);
            speCharBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:JPEG2000") + EOL);
        }
        speCharBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:SpecialFormatCharacteristics"));
        if (useSpeCharBuf) {
            this._writer.println(speCharBuf);
        }
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("mix:BasicImageInformation"));
    }

    protected void showNisoImageCaptureMetadata20(NisoImageMetadata niso, String margin) {
        double[] darray;
        Rational r;
        int n;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        String margn6 = String.valueOf(margn5) + " ";
        String margn7 = String.valueOf(margn6) + " ";
        String margn8 = String.valueOf(margn7) + " ";
        StringBuffer captureBuffer = new StringBuffer();
        boolean useCaptureBuffer = false;
        String s = niso.getSourceType();
        String si = niso.getSourceID();
        double d = niso.getSourceXDimension();
        if (s != null || si != null || d != -1.0) {
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.element("mix:SourceInformation", s));
            useCaptureBuffer = true;
            if (s != null) {
                captureBuffer.append(String.valueOf(margn4) + XmlHandler.element("mix:sourceType", s));
            }
            if (si != null) {
                captureBuffer.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:SourceID"));
                captureBuffer.append(String.valueOf(margn4) + XmlHandler.element("mix:sourceIDValue", si));
                captureBuffer.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:sourceID"));
            }
            n = niso.getSourceXDimensionUnit();
            if (d != -1.0 || n != -1) {
                captureBuffer.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:SourceSize"));
                captureBuffer.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:SourceXDimension") + EOL);
                if (d != -1.0) {
                    captureBuffer.append(String.valueOf(margn6) + XmlHandler.element("mix:sourceXDimensionValue", formatters.get().format(d)) + EOL);
                }
                if (n != -1) {
                    captureBuffer.append(String.valueOf(margn6) + XmlHandler.element("mix:sourceXDimensionUnit", Integer.toString(n)) + EOL);
                }
                captureBuffer.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:SourceXDimension") + EOL);
                d = niso.getSourceYDimension();
                n = niso.getSourceYDimensionUnit();
                if (d != -1.0 || n != -1) {
                    captureBuffer.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:SourceYDimension") + EOL);
                    if (d != -1.0) {
                        captureBuffer.append(String.valueOf(margn6) + XmlHandler.element("mix:sourceYDimensionValue", formatters.get().format(d)) + EOL);
                    }
                    if (n != -1) {
                        captureBuffer.append(String.valueOf(margn6) + XmlHandler.element("mix:sourceYDimensionUnit", Integer.toString(n)) + EOL);
                    }
                    captureBuffer.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:SourceYDimension") + EOL);
                }
                captureBuffer.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:SourceSize") + EOL);
            }
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:SourceInformation") + EOL);
        }
        StringBuffer genCapBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:GeneralCaptureInformation") + EOL);
        boolean useGenCapBuf = false;
        s = niso.getDateTimeCreated();
        if (s != null) {
            genCapBuf.append(String.valueOf(margn3) + XmlHandler.element("mix:dateTimeCreated", s) + EOL);
            useGenCapBuf = true;
        }
        if ((s = niso.getImageProducer()) != null) {
            genCapBuf.append(String.valueOf(margn3) + XmlHandler.element("mix:imageProducer", s) + EOL);
            useGenCapBuf = true;
        }
        if ((s = niso.getDeviceSource()) != null) {
            genCapBuf.append(String.valueOf(margn3) + XmlHandler.element("mix:captureDevice", s) + EOL);
        }
        genCapBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:GeneralCaptureInformation") + EOL);
        if (useGenCapBuf) {
            captureBuffer.append(genCapBuf);
            useCaptureBuffer = true;
        }
        StringBuffer scanCapBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:ScannerCapture") + EOL);
        boolean useScanCapBuf = false;
        String mfg = niso.getScannerManufacturer();
        if (mfg != null) {
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:scannerManufacturer", mfg) + EOL);
            useScanCapBuf = true;
        }
        String model = niso.getScannerModelName();
        String modelNum = niso.getScannerModelNumber();
        String serNum = niso.getScannerModelSerialNo();
        if (model != null || modelNum != null || serNum != null) {
            useScanCapBuf = true;
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:ScannerModel") + EOL);
            if (model != null) {
                scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:scannerModelName", model) + EOL);
            }
            if (modelNum != null) {
                scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:scannerModelNumber", modelNum) + EOL);
            }
            if (serNum != null) {
                scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:scannerModelSerialNo", serNum) + EOL);
            }
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:ScannerModel") + EOL);
        }
        double xres = niso.getXPhysScanResolution();
        double yres = niso.getYPhysScanResolution();
        if (xres != -1.0 && yres != -1.0) {
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:MaximumOpticalResolution") + EOL);
            scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:xOpticalResolution", formatters.get().format(xres)) + EOL);
            scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:yOpticalResolution", formatters.get().format(yres)) + EOL);
            scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:resolutionUnit", "in.") + EOL);
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:MaximumOpticalResolution"));
        }
        if ((s = niso.getScanningSoftware()) != null) {
            useScanCapBuf = true;
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:ScanningSystemSoftware") + EOL);
            scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:scanningSoftwareName", s) + EOL);
            s = niso.getScanningSoftwareVersionNo();
            if (s != null) {
                scanCapBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:scanningSoftwareVersionNo", s) + EOL);
            }
            scanCapBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:ScanningSystemSoftware") + EOL);
        }
        scanCapBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:ScannerCapture") + EOL);
        if (useScanCapBuf) {
            captureBuffer.append(scanCapBuf);
            useCaptureBuffer = true;
        }
        StringBuffer digCamBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:DigitalCameraCapture") + EOL);
        boolean useDigCamBuf = false;
        s = niso.getDigitalCameraManufacturer();
        if (s != null) {
            digCamBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:digitalCameraManufacturer", s) + EOL);
            useDigCamBuf = true;
        }
        String dcmodel = niso.getDigitalCameraModelName();
        String dcmodelNum = niso.getDigitalCameraModelNumber();
        String dcserNum = niso.getDigitalCameraModelSerialNo();
        if (dcmodel != null || dcmodelNum != null || dcserNum != null) {
            useDigCamBuf = true;
            digCamBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:DigitalCameraModel") + EOL);
            if (dcmodel != null) {
                digCamBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:digitalCameraModelName", dcmodel) + EOL);
            }
            if (dcmodelNum != null) {
                digCamBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:digitalCameraModelNumber", dcmodelNum) + EOL);
            }
            if (dcserNum != null) {
                digCamBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:mix:digitalCameraModelSerialNo", dcserNum) + EOL);
            }
            digCamBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:DigitalCameraModel") + EOL);
        }
        StringBuffer ccSetBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:CameraCaptureSettings") + EOL);
        boolean useCcSetBuf = false;
        ccSetBuf.append(String.valueOf(margn5) + XmlHandler.elementStart("mix:ImageData") + EOL);
        d = niso.getFNumber();
        if (d != -1.0) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:fNumber", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureTime()) != -1.0) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:exposureTime", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getExposureProgram()) != -1) {
            if (n > 8 || n < 0) {
                n = 0;
            }
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:exposureProgram", NisoImageMetadata.EXPOSURE_PROGRAM[n]) + EOL);
            useCcSetBuf = true;
        }
        if (niso.getExifVersion() != null) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:exifVersion", niso.getExifVersion()) + EOL);
            useCcSetBuf = true;
        }
        if ((r = niso.getBrightness()) != null) {
            this.rationalToString(ccSetBuf, "mix:brightnessValue", margn6, r);
            useCcSetBuf = true;
        }
        if ((r = niso.getExposureBias()) != null) {
            this.rationalToString(ccSetBuf, "mix:exposureBiasValue", margn6, r);
            useCcSetBuf = true;
        }
        if ((r = niso.getMaxApertureValue()) != null) {
            this.rationalToString(ccSetBuf, "mix:maxApertureValue", margn6, r);
            useCcSetBuf = true;
        }
        if ((darray = niso.getSubjectDistance()) != null) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.elementStart("mix:SubjectDistance") + EOL);
            useCcSetBuf = true;
            if (darray[0] == darray[1]) {
                ccSetBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:distance", formatters.get().format(darray[0])) + EOL);
            } else {
                ccSetBuf.append(String.valueOf(margn7) + XmlHandler.elementStart("mix:MinMaxDistance") + EOL);
                ccSetBuf.append(String.valueOf(margn8) + XmlHandler.element("mix:minDistance", formatters.get().format(darray[0])) + EOL);
                ccSetBuf.append(String.valueOf(margn8) + XmlHandler.element("mix:maxDistance", formatters.get().format(darray[1])) + EOL);
                ccSetBuf.append(String.valueOf(margn7) + XmlHandler.elementEnd("mix:MinMaxDistance") + EOL);
            }
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.elementEnd("mix:SubjectDistance") + EOL);
        }
        if ((n = niso.getMeteringMode()) != -1) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:meteringMode", this.meteringModeToString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getFlash()) != -1) {
            int firstBit = n & 1;
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:flash", NisoImageMetadata.FLASH_20[firstBit]) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getFocalLength()) != -1.0) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:focalLength", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((r = niso.getFlashEnergy()) != null) {
            this.rationalToString(ccSetBuf, "mix:flashEnergy", margn6, r);
            useCcSetBuf = true;
        }
        if ((n = niso.getBackLight()) != -1) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:backLight", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureIndex()) != -1.0) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:exposureIndex", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getAutoFocus()) != -1) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.element("mix:autoFocus", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        d = niso.getXPrintAspectRatio();
        double d2 = niso.getYPrintAspectRatio();
        if (d != -1.0 || d2 != -1.0) {
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.elementStart("mix:PrintAspectRatio") + EOL);
            if (d != -1.0) {
                ccSetBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:xPrintAspectRatio", formatters.get().format(d)) + EOL);
            }
            if (d2 != -1.0) {
                ccSetBuf.append(String.valueOf(margn7) + XmlHandler.element("mix:yPrintAspectRatio", formatters.get().format(d2)) + EOL);
            }
            ccSetBuf.append(String.valueOf(margn6) + XmlHandler.elementEnd("mix:PrintAspectRatio") + EOL);
        }
        ccSetBuf.append(String.valueOf(margn5) + XmlHandler.elementEnd("mix:ImageData") + EOL);
        ccSetBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:CameraCaptureSettings") + EOL);
        if (useCcSetBuf) {
            digCamBuf.append(ccSetBuf);
            useDigCamBuf = true;
        }
        digCamBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:DigitalCameraCapture") + EOL);
        if (useDigCamBuf) {
            captureBuffer.append(digCamBuf);
            useCaptureBuffer = true;
        }
        if ((n = niso.getOrientation()) != -1) {
            String[] orient = new String[]{"", "normal*", "normal, image flipped", "normal, rotated 180\u00b0", "normal, image flipped, rotated 180\u00b0", "normal, image flipped, rotated cw 90\u00b0", "normal, rotated ccw 90\u00b0", "normal, image flipped, rotated ccw 90\u00b0", "normal, rotated cw 90\u00b0", "unknown"};
            if (n > 9 || n < 1) {
                n = 9;
            }
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.element("mix:orientation", orient[n]) + EOL);
            useCaptureBuffer = true;
        }
        if ((s = niso.getMethodology()) != null) {
            captureBuffer.append(String.valueOf(margn3) + XmlHandler.element("mix:methodology", s) + EOL);
        }
        if (useCaptureBuffer) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("mix:ImageCaptureMetadata"));
            this._writer.print(captureBuffer.toString());
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("mix:ImageCaptureMetadata"));
        }
    }

    protected void showNisoImageAssessmentMetadata20(NisoImageMetadata niso, String margin) {
        String s;
        int ii;
        Rational r;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("mix:ImageAssessmentMetadata"));
        StringBuffer metricsBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:SpatialMetrics") + EOL);
        boolean useMetricsBuf = false;
        int n = niso.getSamplingFrequencyPlane();
        if (n != -1) {
            metricsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:samplingFrequencyPlane", Integer.toString(n)) + EOL);
            useMetricsBuf = true;
        }
        if ((n = niso.getSamplingFrequencyUnit()) != -1) {
            String[] stringArray = new String[4];
            stringArray[1] = "no absolute unit of measurement";
            stringArray[2] = "in.";
            stringArray[3] = "cm";
            String[] sfu = stringArray;
            if (n < 1 || n > 3) {
                n = 1;
            }
            metricsBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:samplingFrequencyUnit", sfu[n]) + EOL);
            useMetricsBuf = true;
        }
        if ((r = niso.getXSamplingFrequency()) != null) {
            this.rationalToString(metricsBuf, "mix:xSamplingFrequency", margn4, r);
        }
        if ((r = niso.getYSamplingFrequency()) != null) {
            this.rationalToString(metricsBuf, "mix:ySamplingFrequency", margn4, r);
        }
        metricsBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:SpatialMetrics"));
        if (useMetricsBuf) {
            this._writer.println(metricsBuf);
        }
        StringBuffer colorEncBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:ImageColorEncoding") + EOL);
        boolean useColorEncBuf = false;
        int[] iarray = niso.getBitsPerSample();
        if (iarray != null) {
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:BitsPerSample") + EOL);
            ii = 0;
            while (ii < iarray.length) {
                colorEncBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:bitsPerSampleValue", Integer.toString(iarray[ii])) + EOL);
                ++ii;
            }
            colorEncBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:bitsPerSampleUnit", "integer") + EOL);
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:BitsPerSample") + EOL);
            useColorEncBuf = true;
        }
        if ((n = niso.getSamplesPerPixel()) != -1) {
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:samplesPerPixel", Integer.toString(n)) + EOL);
            useColorEncBuf = true;
        }
        if ((iarray = niso.getExtraSamples()) != null) {
            ii = 0;
            while (ii < iarray.length) {
                n = iarray[ii];
                if (n >= 0 && n <= 3) {
                    colorEncBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:extraSamples", NisoImageMetadata.EXTRA_SAMPLE_20[n]) + EOL);
                    useColorEncBuf = true;
                }
                ++ii;
            }
        }
        if ((s = niso.getColormapReference()) != null) {
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:Colormap") + EOL);
            colorEncBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:colormapReference", s) + EOL);
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:Colormap") + EOL);
            useColorEncBuf = true;
        }
        iarray = niso.getGrayResponseCurve();
        n = niso.getGrayResponseUnit();
        if (iarray != null || n != -1) {
            StringBuffer grayRespBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:GrayResponse") + EOL);
            if (iarray != null) {
                int ii2 = 0;
                while (ii2 < iarray.length) {
                    grayRespBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:grayResponseCurve", Integer.toString(iarray[ii2])) + EOL);
                    ++ii2;
                }
            }
            if (n != -1 && n > 0 && n <= 5) {
                grayRespBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:grayResponseUnit", NisoImageMetadata.GRAY_RESPONSE_UNIT_20[n - 1]) + EOL);
            }
            grayRespBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:GrayResponse") + EOL);
            colorEncBuf.append(grayRespBuf);
            useColorEncBuf = true;
        }
        r = niso.getWhitePointXValue();
        Rational r2 = niso.getWhitePointYValue();
        if (r != null || r2 != null) {
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementStart("mix:WhitePoint") + EOL);
            if (r != null) {
                this.rationalToString(colorEncBuf, "mix:whitePointXValue", margn5, r);
            }
            if (r2 != null) {
                this.rationalToString(colorEncBuf, "mix:whitePointYValue", margn5, r2);
            }
            colorEncBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:WhitePoint") + EOL);
            useColorEncBuf = true;
        }
        StringBuffer chromaBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:PrimaryChromaticities") + EOL);
        boolean useChromaBuf = false;
        r = niso.getPrimaryChromaticitiesRedX();
        if (r != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesRedX", margn5, r);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesRedY()) != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesRedY", margn5, r);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesGreenX()) != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesGreenX", margn5, r);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesGreenY()) != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesGreenY", margn5, r);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesBlueX()) != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesBlueX", margn5, r);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesBlueY()) != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesBlueY", margn5, r);
            useChromaBuf = true;
        }
        chromaBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:PrimaryChromaticities") + EOL);
        if (useChromaBuf) {
            colorEncBuf.append(chromaBuf);
            useColorEncBuf = true;
        }
        colorEncBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:ImageColorEncoding") + EOL);
        if (useColorEncBuf) {
            this._writer.print(colorEncBuf);
        }
        StringBuffer targetBuf = new StringBuffer(String.valueOf(margn3) + XmlHandler.elementStart("mix:TargetData") + EOL);
        boolean useTargetBuf = false;
        n = niso.getTargetType();
        if (n != -1) {
            targetBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:targetType", Integer.toString(n)) + EOL);
            useTargetBuf = true;
        }
        StringBuffer targetIDBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:TargetID") + EOL);
        boolean useTargetIDBuf = false;
        s = niso.getTargetIDManufacturer();
        if (s != null) {
            targetIDBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:targetManufacturer", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDName()) != null) {
            targetIDBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:targetName", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDNo()) != null) {
            targetIDBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:targetNo", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDMedia()) != null) {
            targetIDBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:targetMedia", s) + EOL);
            useTargetIDBuf = true;
        }
        targetIDBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:TargetID") + EOL);
        if (useTargetIDBuf) {
            targetBuf.append(targetIDBuf);
            useTargetBuf = true;
        }
        if ((s = niso.getImageData()) != null) {
            targetBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:externalTarget", s) + EOL);
            useTargetBuf = true;
        }
        if ((s = niso.getPerformanceData()) != null) {
            targetBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:performanceData", s) + EOL);
            useTargetBuf = true;
        }
        targetBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:TargetData") + EOL);
        if (useTargetBuf) {
            this._writer.print(targetBuf);
        }
        this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("mix:ImageAssessmentMetadata"));
    }

    protected void showChangeHistory20(NisoImageMetadata niso, String margin) {
        String[] sarray;
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        StringBuffer chBuf = new StringBuffer(String.valueOf(margn2) + XmlHandler.elementStart("mix:ChangeHistory") + EOL);
        boolean useChBuf = false;
        chBuf.append(String.valueOf(margn3) + XmlHandler.elementStart("mix:ImageProcessing") + EOL);
        String s = niso.getSourceData();
        if (s != null) {
            chBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:sourceData", s) + EOL);
            useChBuf = true;
        }
        if ((s = niso.getProcessingAgency()) != null) {
            chBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:processingAgency", s) + EOL);
            useChBuf = true;
        }
        StringBuffer sftwBuf = new StringBuffer(String.valueOf(margn4) + XmlHandler.elementStart("mix:ProcessingSoftware") + EOL);
        boolean useSftwBuf = false;
        s = niso.getProcessingSoftwareName();
        if (s != null) {
            sftwBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:processingSoftwareName", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getProcessingSoftwareVersion()) != null) {
            sftwBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:processingSoftwareVersion", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getOS()) != null) {
            sftwBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:processingOperatingSystemName", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getOSVersion()) != null) {
            sftwBuf.append(String.valueOf(margn5) + XmlHandler.element("mix:processingOperatingSystemVersion", s) + EOL);
            useSftwBuf = true;
        }
        sftwBuf.append(String.valueOf(margn4) + XmlHandler.elementEnd("mix:ProcessingSoftware") + EOL);
        if (useSftwBuf) {
            chBuf.append(sftwBuf);
            useChBuf = true;
        }
        if ((sarray = niso.getProcessingActions()) != null) {
            int i = 0;
            while (i < sarray.length) {
                chBuf.append(String.valueOf(margn4) + XmlHandler.element("mix:processingActions", sarray[i]) + EOL);
                ++i;
            }
            useChBuf = true;
        }
        chBuf.append(String.valueOf(margn3) + XmlHandler.elementEnd("mix:ImageProcessing") + EOL);
        chBuf.append(String.valueOf(margn2) + XmlHandler.elementEnd("mix:ChangeHistory") + EOL);
        if (useChBuf) {
            this._writer.println(chBuf);
        }
    }

    private String meteringModeToString(int n) {
        String s = NisoImageMetadata.METERING_MODE[1];
        if (n >= 1 && n <= 6) {
            s = NisoImageMetadata.METERING_MODE[n];
        }
        return String.valueOf(s.substring(0, 1).toUpperCase(Locale.ROOT)) + s.substring(1);
    }

    private String photometricInterpretationToString(int n) {
        String s = "Unknown";
        switch (n) {
            case 0: {
                s = "WhiteIsZero";
                break;
            }
            case 1: {
                s = "BlackIsZero";
                break;
            }
            case 2: {
                s = "RGB";
                break;
            }
            case 3: {
                s = "PaletteColor";
                break;
            }
            case 4: {
                s = "TransparencyMask";
                break;
            }
            case 5: {
                s = "CMYK";
                break;
            }
            case 6: {
                s = "YCbCr";
                break;
            }
            case 8: {
                s = "CIELab";
                break;
            }
            case 9: {
                s = "ICCLab";
                break;
            }
            case 10: {
                s = "ITULab";
                break;
            }
            case 32803: {
                s = "CFA";
                break;
            }
            case 34892: {
                s = "LinearRaw";
                break;
            }
            case 65535: {
                s = "YCCK";
                break;
            }
        }
        return s;
    }

    private String compressionSchemeToString(int n) {
        int i = 0;
        while (i < NisoImageMetadata.COMPRESSION_SCHEME_INDEX.length) {
            if (n == NisoImageMetadata.COMPRESSION_SCHEME_INDEX[i]) {
                return NisoImageMetadata.COMPRESSION_SCHEME[i];
            }
            ++i;
        }
        return Integer.toString(n);
    }

    protected void showAESAudioMetadata(AESAudioMetadata aes) {
        List<AESAudioMetadata.FormatRegion> flist;
        List<AESAudioMetadata.Face> facelist;
        String[] use;
        long lin;
        int in;
        this._level += 3;
        String margin = XmlHandler.getIndent(this._level);
        String margn2 = String.valueOf(margin) + " ";
        String margn3 = String.valueOf(margn2) + " ";
        String margn4 = String.valueOf(margn3) + " ";
        String margn5 = String.valueOf(margn4) + " ";
        String formatRegionID = "J1";
        String faceRegionID = "J2";
        String faceID = "J3";
        String audioObjectID = "J4";
        String streamIDBase = "J9";
        this._sampleRate = aes.getSampleRate();
        String[][] attrs = new String[][]{{"xmlns:aes", "http://www.aes.org/audioObject"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"ID", "J4"}, {"analogDigitalFlag", aes.getAnalogDigitalFlag()}, {"disposition", "Validated by JHOVE"}, {"schemaVersion", aes.getSchemaVersion()}};
        this._writer.println(String.valueOf(margin) + XmlHandler.elementStart("aes:audioObject", attrs));
        String s = aes.getFormat();
        if (s != null) {
            String v = aes.getSpecificationVersion();
            String[][] fmattrs = new String[1][2];
            fmattrs[0][0] = "specificationVersion";
            fmattrs[0][1] = v != null ? v : "";
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("aes:format", fmattrs, s));
        }
        if ((s = aes.getAppSpecificData()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("aes:appSpecificData", s));
        }
        if ((s = aes.getAudioDataEncoding()) != null) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("aes:audioDataEncoding", s));
        }
        if ((in = aes.getByteOrder()) != -1) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("aes:byteOrder", in == 0 ? "BIG_ENDIAN" : "LITTLE_ENDIAN"));
        }
        if ((lin = aes.getFirstSampleOffset()) != -1L) {
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("aes:firstSampleOffset", Long.toString(lin)));
        }
        if ((use = aes.getUse()) != null) {
            String[][] uattrs = new String[][]{{"useType", use[0]}, {"otherType", use[1]}};
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("aes:use", uattrs));
        }
        if ((s = aes.getPrimaryIdentifier()) != null) {
            String t = aes.getPrimaryIdentifierType();
            String[][] idattrs = new String[1][2];
            idattrs[0][0] = "identifierType";
            idattrs[0][1] = t != null ? t : "";
            this._writer.println(String.valueOf(margn2) + XmlHandler.element("aes:primaryIdentifier", idattrs, s));
        }
        if (!(facelist = aes.getFaceList()).isEmpty()) {
            String[][] faceRegionAttrs = new String[][]{{"ID", "J2"}, {"formatRef", "J1"}, {"faceRef", "J3"}, {"label", "BuiltByJHOVE"}};
            String[][] stringArray = new String[4][];
            String[] stringArray2 = new String[2];
            stringArray2[0] = "direction";
            stringArray[0] = stringArray2;
            stringArray[1] = new String[]{"ID", "J3"};
            stringArray[2] = new String[]{"audioObjectRef", "J4"};
            stringArray[3] = new String[]{"label", "Face"};
            String[][] faceAttrs = stringArray;
            AESAudioMetadata.Face f = facelist.get(0);
            faceAttrs[0][1] = f.getDirection();
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("aes:face", faceAttrs));
            AESAudioMetadata.TimeDesc startTime = f.getStartTime();
            if (startTime != null) {
                this._writer.println(String.valueOf(margn3) + XmlHandler.elementStart("aes:timeline"));
                this.writeAESTimeRange(margn3, startTime, f.getDuration());
                this._writer.println(String.valueOf(margn3) + XmlHandler.elementEnd("aes:timeline"));
            }
            AESAudioMetadata.FaceRegion facergn = f.getFaceRegion(0);
            this._writer.println(String.valueOf(margn3) + XmlHandler.elementStart("aes:region", faceRegionAttrs));
            this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("aes:timeRange"));
            this.writeAESTimeRange(margn4, facergn.getStartTime(), facergn.getDuration());
            this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("aes:timeRange"));
            int nchan = aes.getNumChannels();
            if (nchan != -1) {
                this._writer.println(String.valueOf(margn4) + XmlHandler.element("aes:numChannels", Integer.toString(nchan)));
            }
            int ch = 0;
            while (ch < nchan) {
                String[][] streamAttrs = new String[][]{{"ID", "J9" + Integer.toString(ch)}, {"label", "JHOVE"}, {"faceRegionRef", "J2"}};
                this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("aes:stream", streamAttrs));
                String[][] chanAttrs = new String[][]{{"channelNum", Integer.toString(ch)}};
                this._writer.println(String.valueOf(margn5) + XmlHandler.element("aes:channelAssignment", chanAttrs));
                this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("aes:stream"));
                ++ch;
            }
            this._writer.println(String.valueOf(margn3) + XmlHandler.elementEnd("aes:region"));
            this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("aes:face"));
        }
        if (!(flist = aes.getFormatList()).isEmpty()) {
            AESAudioMetadata.FormatRegion rgn = flist.get(0);
            int bitDepth = rgn.getBitDepth();
            double sampleRate = rgn.getSampleRate();
            int wordSize = rgn.getWordSize();
            String[] bitRed = rgn.getBitrateReduction();
            if (bitDepth != -1 || sampleRate != -1.0 || wordSize != -1) {
                this._writer.println(String.valueOf(margn2) + XmlHandler.elementStart("aes:formatList"));
                String[][] frAttr = new String[][]{{"ID", "J1"}, {"xsi:type", "aes:formatRegionType"}, {"ownerRef", "J2"}, {"label", "JHOVE"}};
                this._writer.println(String.valueOf(margn3) + XmlHandler.elementStart("aes:formatRegion", frAttr));
                if (bitDepth != -1) {
                    this._writer.println(String.valueOf(margn4) + XmlHandler.element("aes:bitDepth", Integer.toString(bitDepth)));
                }
                if (sampleRate != -1.0) {
                    this._writer.println(String.valueOf(margn4) + XmlHandler.element("aes:sampleRate", formatters.get().format(sampleRate)));
                }
                if (wordSize != -1) {
                    this._writer.println(String.valueOf(margn4) + XmlHandler.element("aes:wordSize", Integer.toString(wordSize)));
                }
                if (bitRed != null) {
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementStart("aes:bitrateReduction"));
                    this._writer.println(String.valueOf(margn5) + XmlHandler.element("aes:codecName", bitRed[0]));
                    this._writer.println(String.valueOf(margn5) + XmlHandler.element("aes:codecNameVersion", bitRed[1]));
                    this._writer.println(String.valueOf(margn5) + XmlHandler.element("aes:codecCreatorApplication", bitRed[2]));
                    this._writer.println(String.valueOf(margn5) + XmlHandler.element("aes:codecCreatorApplicationVersion", bitRed[3]));
                    this._writer.println(String.valueOf(margn5) + XmlHandler.element("aes:codecQuality", bitRed[4]));
                    this._writer.println(String.valueOf(margn5) + XmlHandler.element("aes:dataRate", bitRed[5]));
                    this._writer.println(String.valueOf(margn5) + XmlHandler.element("aes:dataRateMode", bitRed[6]));
                    this._writer.println(String.valueOf(margn4) + XmlHandler.elementEnd("aes:bitrateReduction"));
                }
                this._writer.println(String.valueOf(margn3) + XmlHandler.elementEnd("aes:formatRegion"));
                this._writer.println(String.valueOf(margn2) + XmlHandler.elementEnd("aes:formatList"));
            }
        }
        this._writer.println(String.valueOf(margin) + XmlHandler.elementEnd("aes:audioObject"));
        this._level -= 3;
    }

    private void writeAESTimeRange(String baseIndent, AESAudioMetadata.TimeDesc start, AESAudioMetadata.TimeDesc duration) {
        String margn1 = String.valueOf(baseIndent) + " ";
        this.writeAESTimeRangePart(margn1, "aes:startTime", start);
        if (duration != null) {
            this.writeAESTimeRangePart(margn1, "aes:duration", duration);
        }
    }

    private void writeAESTimeRangePart(String indent, String elementName, AESAudioMetadata.TimeDesc timeDesc) {
        double sampleRate = timeDesc.getSampleRate();
        if (sampleRate == 1.0) {
            sampleRate = this._sampleRate;
        }
        String[][] attributes = new String[][]{{"editRate", formatters.get().format(sampleRate)}, {"factorNumerator", "1"}, {"factorDenominator", "1"}};
        this._writer.println(String.valueOf(indent) + XmlHandler.element(elementName, attributes, String.valueOf(timeDesc.getSamples())));
    }

    private static final String cleanURIString(String path) {
        File input = new File(path);
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        String fileScheme = "file";
        try {
            if (isWindows && !path.isEmpty() && path.startsWith(Character.toString(File.separatorChar))) {
                if (path.startsWith("\\")) {
                    return new URI("file", XmlHandler.normaliseToSlash(path), null).toString();
                }
                return new URI("file", "", XmlHandler.normaliseToSlash(path), null).toString();
            }
            if (input.isAbsolute()) {
                return new URI("file", "", XmlHandler.normaliseToSlash(XmlHandler.ensureHeadSlash(input.getAbsolutePath())), null).toString();
            }
            return new URI(null, XmlHandler.normaliseToSlash(path), null).toString();
        }
        catch (URISyntaxException e) {
            return path;
        }
    }

    private static final String ensureHeadSlash(String name) {
        return !name.isEmpty() && name.startsWith(Character.toString(File.separatorChar)) ? String.valueOf(Character.toString(File.separatorChar)) + name : name;
    }

    private static final String normaliseToSlash(String name) {
        return File.separatorChar == '/' ? name : name.replace(File.separatorChar, '/');
    }

    public void rationalToString(StringBuffer buf, String tag, String margin, Rational r) {
        String margn2 = String.valueOf(margin) + " ";
        long numer = r.getNumerator();
        long denom = r.getDenominator();
        buf.append(String.valueOf(margin) + XmlHandler.elementStart(tag) + EOL);
        buf.append(String.valueOf(margn2) + XmlHandler.element("mix:numerator", Long.toString(numer)) + EOL);
        if (denom != 1L) {
            buf.append(String.valueOf(margn2) + XmlHandler.element("mix:denominator", Long.toString(denom)) + EOL);
        }
        buf.append(String.valueOf(margin) + XmlHandler.elementEnd(tag) + EOL);
    }
}

