/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.messages;

import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessageFactImpl;
import edu.harvard.hul.ois.jhove.messages.JhoveMessageFactory;
import edu.harvard.hul.ois.jhove.messages.JhoveMessageImpl;
import java.util.Locale;
import java.util.ResourceBundle;

public enum JhoveMessages {
    INSTANCE;

    public static final String NO_ID = "NO-ID";
    public static final String EMPTY_MESSAGE = "";
    public static final JhoveMessage DEFAULT_MESSAGE;

    static {
        DEFAULT_MESSAGE = JhoveMessages.getMessageInstance(NO_ID, EMPTY_MESSAGE);
    }

    public static JhoveMessage getMessageInstance(String message) throws IllegalArgumentException {
        return JhoveMessages.getMessageInstance(NO_ID, message);
    }

    public static JhoveMessage getMessageInstance(String id, String message) throws IllegalArgumentException {
        return JhoveMessages.getMessageInstance(id, message, EMPTY_MESSAGE);
    }

    public static JhoveMessage getMessageInstance(JhoveMessage message, String subMessage) {
        return JhoveMessages.getMessageInstance(message.getId(), message.getMessage(), subMessage);
    }

    public static JhoveMessage getMessageInstance(String id, String message, String subMessage) throws IllegalArgumentException {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("id cannot be null or an empty string.");
        }
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null.");
        }
        return JhoveMessageImpl.getInstance(id, message, subMessage);
    }

    public static JhoveMessageFactory getInstance(String bundleName) throws IllegalArgumentException {
        String moduleLanguage = System.getProperty("module.language");
        Locale local = moduleLanguage == null || moduleLanguage.trim().length() == 0 ? Locale.getDefault() : Locale.forLanguageTag(moduleLanguage);
        return JhoveMessages.getInstance(bundleName, local);
    }

    public static JhoveMessageFactory getInstance(String bundleName, Locale locale) throws IllegalArgumentException {
        if (bundleName == null || bundleName.isEmpty()) {
            throw new IllegalArgumentException("bundleName cannot be null or empty");
        }
        if (locale == null) {
            throw new IllegalArgumentException("locale cannot be null.");
        }
        ResourceBundle messageBundle = ResourceBundle.getBundle(bundleName, locale);
        return JhoveMessageFactImpl.getInstance(messageBundle);
    }
}

