/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import edu.harvard.hul.ois.jhove.handler.Handlers;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;

public class RepTreeRoot
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -4409152022584715925L;
    private RepInfo _info;
    private JhoveBase _base;
    private boolean _rawOutput;
    private DateFormat _dateFmt;
    private double _sampleRate;
    private String reportingModule = "";
    private static final String TEXT_MD_METADTA = "TextMDMetadata";
    private static final String FORMAT = "Format: ";
    private static final String VERSION = "Version: ";
    private static final String BYTE_ORDER = "ByteOrder: ";

    public RepTreeRoot(RepInfo info, JhoveBase base) {
        super(info.getUri());
        this._info = info;
        this._base = base;
        this._rawOutput = this._base.getShowRawFlag();
        this._dateFmt = DateFormat.getDateInstance();
        this.snarfRepInfo();
    }

    private DefaultMutableTreeNode propToNode(Property pProp) {
        PropertyArity arity = pProp.getArity();
        PropertyType typ = pProp.getType();
        Object pValue = pProp.getValue();
        if (arity == PropertyArity.SCALAR) {
            if (null == typ) {
                return new DefaultMutableTreeNode(pProp.getName() + ": " + pValue.toString());
            }
            switch (typ) {
                case NISOIMAGEMETADATA: {
                    NisoImageMetadata nData = (NisoImageMetadata)pValue;
                    return this.nisoToNode(nData);
                }
                case AESAUDIOMETADATA: {
                    AESAudioMetadata aData = (AESAudioMetadata)pValue;
                    return this.aesToNode(aData);
                }
                case TEXTMDMETADATA: {
                    TextMDMetadata tData = (TextMDMetadata)pValue;
                    return this.textMDToNode(tData);
                }
                case PROPERTY: {
                    if (TEXT_MD_METADTA.equals(pProp.getName())) {
                        TextMDMetadata tData = (TextMDMetadata)pValue;
                        return this.textMDToNode(tData);
                    }
                    DefaultMutableTreeNode val = new DefaultMutableTreeNode(pProp.getName());
                    val.add(this.propToNode((Property)pValue));
                    return val;
                }
            }
            DefaultMutableTreeNode val = new DefaultMutableTreeNode(pProp.getName() + ": " + pValue.toString());
            return val;
        }
        DefaultMutableTreeNode val = new DefaultMutableTreeNode(pProp.getName());
        if (null != arity) {
            switch (arity) {
                case ARRAY: {
                    this.addArrayMembers(val, pProp);
                    break;
                }
                case LIST: {
                    this.addListMembers(val, pProp);
                    break;
                }
                case MAP: {
                    this.addMapMembers(val, pProp);
                    break;
                }
                case SET: {
                    this.addSetMembers(val, pProp);
                    break;
                }
            }
        }
        return val;
    }

    public int getIndexOfChild(Object parent, Object child) {
        Property pProp = (Property)parent;
        PropertyArity arity = pProp.getArity();
        Iterator<Object> iter = null;
        if (arity == PropertyArity.SET || arity == PropertyArity.LIST || arity == PropertyArity.MAP) {
            if (null == arity) {
                List list = (List)pProp.getValue();
                iter = list.iterator();
            } else {
                switch (arity) {
                    case SET: {
                        Set set = (Set)pProp.getValue();
                        iter = set.iterator();
                        break;
                    }
                    case MAP: {
                        Map map = (Map)pProp.getValue();
                        iter = map.values().iterator();
                        break;
                    }
                    default: {
                        List list = (List)pProp.getValue();
                        iter = list.iterator();
                    }
                }
            }
            int i = 0;
            while (true) {
                if (!iter.hasNext()) {
                    return 0;
                }
                if (iter.next() == child) {
                    return i;
                }
                ++i;
            }
        }
        PropertyType propType = pProp.getType();
        Date[] dateArray = null;
        Property[] propArray = null;
        Rational[] rationalArray = null;
        Object[] objArray = null;
        int n = 0;
        if (null == propType) {
            return 0;
        }
        switch (propType) {
            case DATE: {
                dateArray = (Date[])pProp.getValue();
                n = dateArray.length;
                break;
            }
            case OBJECT: {
                objArray = (Object[])pProp.getValue();
                n = objArray.length;
                break;
            }
            case RATIONAL: {
                rationalArray = (Rational[])pProp.getValue();
                n = rationalArray.length;
                break;
            }
            case PROPERTY: {
                propArray = (Property[])pProp.getValue();
                n = propArray.length;
                break;
            }
            default: {
                return 0;
            }
        }
        for (int i = 0; i < n; ++i) {
            Object elem = null;
            switch (propType) {
                case DATE: {
                    elem = dateArray[i];
                    break;
                }
                case OBJECT: {
                    elem = objArray[i];
                    break;
                }
                case RATIONAL: {
                    elem = rationalArray[i];
                    break;
                }
                case PROPERTY: {
                    elem = propArray[i];
                    break;
                }
            }
            if (elem != child) continue;
            return i;
        }
        return 0;
    }

    private void snarfRepInfo() {
        List<Checksum> cksumList;
        Map<String, Property> map;
        List<String> profileList;
        List<Message> messageList;
        String wfStr;
        String s;
        long sz;
        Module module = this._info.getModule();
        if (module != null) {
            DefaultMutableTreeNode moduleNode = new DefaultMutableTreeNode("Module");
            this.reportingModule = module.getName();
            moduleNode.add(new DefaultMutableTreeNode(this.reportingModule, false));
            moduleNode.add(new DefaultMutableTreeNode("Release: " + module.getRelease(), false));
            moduleNode.add(new DefaultMutableTreeNode("Date: " + this._dateFmt.format(module.getDate()), false));
            this.add(moduleNode);
        }
        DefaultMutableTreeNode infoNode = new DefaultMutableTreeNode("RepInfo");
        infoNode.add(new DefaultMutableTreeNode("URI: " + this._info.getUri(), false));
        Date dt = this._info.getCreated();
        if (dt != null) {
            infoNode.add(new DefaultMutableTreeNode("Created: " + dt.toString(), false));
        }
        if ((dt = this._info.getLastModified()) != null) {
            infoNode.add(new DefaultMutableTreeNode("LastModified: " + dt.toString(), false));
        }
        if ((sz = this._info.getSize()) != -1L) {
            infoNode.add(new DefaultMutableTreeNode("Size: " + Long.toString(sz), false));
        }
        if ((s = this._info.getFormat()) != null) {
            infoNode.add(new DefaultMutableTreeNode(FORMAT + s, false));
        }
        if ((s = this._info.getVersion()) != null) {
            infoNode.add(new DefaultMutableTreeNode(VERSION + s, false));
        }
        switch (this._info.getWellFormed()) {
            case 1: {
                wfStr = "Well-Formed";
                break;
            }
            case 0: {
                wfStr = "Not well-formed";
                break;
            }
            default: {
                wfStr = "Unknown";
            }
        }
        if (this._info.getWellFormed() == 1) {
            switch (this._info.getValid()) {
                case 1: {
                    wfStr = wfStr + " and valid";
                    break;
                }
                case 0: {
                    wfStr = wfStr + ", but not valid";
                }
            }
        }
        infoNode.add(new DefaultMutableTreeNode("Status: " + wfStr, false));
        List<String> sigList = this._info.getSigMatch();
        if (sigList != null && !sigList.isEmpty()) {
            DefaultMutableTreeNode sigNode = new DefaultMutableTreeNode("SignatureMatches");
            infoNode.add(sigNode);
            for (int i = 0; i < sigList.size(); ++i) {
                DefaultMutableTreeNode sNode = new DefaultMutableTreeNode(sigList.get(i));
                sigNode.add(sNode);
            }
        }
        if ((messageList = this._info.getMessage()) != null && !messageList.isEmpty()) {
            DefaultMutableTreeNode msgNode = new DefaultMutableTreeNode("Messages");
            infoNode.add(msgNode);
            for (int i = 0; i < messageList.size(); ++i) {
                String subMessage;
                Message msg = messageList.get(i);
                String prefix = msg instanceof InfoMessage ? "InfoMessage: " : (msg instanceof ErrorMessage ? "ErrorMessage: " : "Message: ");
                DefaultMutableTreeNode mNode = new DefaultMutableTreeNode(prefix + msg.getMessage());
                if (msg.getId() != null && !msg.getId().isEmpty()) {
                    mNode.add(new DefaultMutableTreeNode("ID: " + msg.getId()));
                    mNode.add(new DefaultMutableTreeNode("InfoLink: " + Handlers.makeInfoLink(this.reportingModule, msg.getId())));
                }
                if ((subMessage = msg.getSubMessage()) != null) {
                    mNode.add(new DefaultMutableTreeNode("SubMessage: " + subMessage));
                }
                long offset = -1L;
                if (msg instanceof ErrorMessage) {
                    offset = ((ErrorMessage)msg).getOffset();
                }
                if (offset >= 0L) {
                    mNode.add(new DefaultMutableTreeNode("Offset: " + Long.toString(offset)));
                }
                msgNode.add(mNode);
            }
        }
        if ((s = this._info.getMimeType()) != null) {
            infoNode.add(new DefaultMutableTreeNode("MimeType: " + s, false));
        }
        if ((profileList = this._info.getProfile()) != null && !profileList.isEmpty()) {
            DefaultMutableTreeNode profNode = new DefaultMutableTreeNode("Profiles");
            infoNode.add(profNode);
            for (int i = 0; i < profileList.size(); ++i) {
                profNode.add(new DefaultMutableTreeNode(profileList.get(i), false));
            }
        }
        if ((map = this._info.getProperty()) != null) {
            for (String key : map.keySet()) {
                Property property = this._info.getProperty(key);
                infoNode.add(this.propToNode(property));
            }
        }
        if ((cksumList = this._info.getChecksum()) != null && !cksumList.isEmpty()) {
            DefaultMutableTreeNode ckNode = new DefaultMutableTreeNode("Checksums");
            infoNode.add(ckNode);
            for (Checksum cksum : cksumList) {
                DefaultMutableTreeNode csNode = new DefaultMutableTreeNode("Checksum");
                ckNode.add(csNode);
                csNode.add(new DefaultMutableTreeNode("Type:" + cksum.getType().toString(), false));
                csNode.add(new DefaultMutableTreeNode("Checksum: " + cksum.getValue(), false));
            }
        }
        if ((s = this._info.getNote()) != null) {
            infoNode.add(new DefaultMutableTreeNode("Note: " + s, false));
        }
        this.add(infoNode);
    }

    private void addArrayMembers(DefaultMutableTreeNode node, Property p) {
        Object pVal = p.getValue();
        PropertyType typ = p.getType();
        if (null != typ) {
            switch (typ) {
                case INTEGER: {
                    if (pVal instanceof int[]) {
                        Integer[] vals = (Integer[])Arrays.stream((int[])pVal).boxed().toArray(Integer[]::new);
                        this.addToNode(node, vals);
                        break;
                    }
                    this.addToNode(node, (Integer[])pVal);
                    break;
                }
                case LONG: {
                    if (pVal instanceof long[]) {
                        Long[] vals = (Long[])Arrays.stream((long[])pVal).boxed().toArray(Long[]::new);
                        this.addToNode(node, vals);
                        break;
                    }
                    this.addToNode(node, (Long[])pVal);
                    break;
                }
                case BOOLEAN: {
                    this.addToNode(node, (Boolean[])pVal);
                    break;
                }
                case CHARACTER: {
                    this.addToNode(node, (Character[])pVal);
                    break;
                }
                case DOUBLE: {
                    if (pVal instanceof double[]) {
                        Double[] vals = (Double[])Arrays.stream((double[])pVal).boxed().toArray(Double[]::new);
                        this.addToNode(node, vals);
                        break;
                    }
                    this.addToNode(node, (Double[])pVal);
                    break;
                }
                case FLOAT: {
                    this.addToNode(node, (Float[])pVal);
                    break;
                }
                case SHORT: {
                    this.addToNode(node, (Short[])pVal);
                    break;
                }
                case BYTE: {
                    this.addToNode(node, (Byte[])pVal);
                    break;
                }
                case STRING: {
                    this.addToNode(node, (String[])pVal);
                    break;
                }
                case RATIONAL: {
                    this.addToNode(node, (Rational[])pVal);
                    break;
                }
                case PROPERTY: {
                    this.addToNode(node, (Property[])pVal);
                    break;
                }
                case NISOIMAGEMETADATA: {
                    this.addToNode(node, (NisoImageMetadata[])pVal);
                    break;
                }
                case OBJECT: {
                    this.addToNode(node, (Object[])pVal);
                    break;
                }
            }
        }
    }

    private void addListMembers(DefaultMutableTreeNode node, Property p) {
        List l = (List)p.getValue();
        PropertyType ptyp = p.getType();
        boolean canHaveChildren = Boolean.FALSE;
        l.forEach(item -> node.add(this.getDefaultMutableTreeNode(ptyp, item, canHaveChildren)));
    }

    private void addSetMembers(DefaultMutableTreeNode node, Property p) {
        Set s = (Set)p.getValue();
        PropertyType ptyp = p.getType();
        boolean canHaveChildren = Boolean.FALSE;
        for (Object item : s) {
            node.add(this.getDefaultMutableTreeNode(ptyp, item, canHaveChildren));
        }
    }

    private void addMapMembers(DefaultMutableTreeNode node, Property p) {
        Map m = (Map)p.getValue();
        PropertyType ptyp = p.getType();
        Boolean canHaveChildren = Boolean.TRUE;
        for (String key : m.keySet()) {
            Object item = m.get(key);
            DefaultMutableTreeNode itemNode = this.getDefaultMutableTreeNode(ptyp, item, canHaveChildren);
            node.add(itemNode);
            itemNode.setAllowsChildren(true);
            itemNode.add(new DefaultMutableTreeNode("Key: " + key, false));
        }
    }

    private DefaultMutableTreeNode aesToNode(AESAudioMetadata aes) {
        List<AESAudioMetadata.FormatRegion> flist;
        List<AESAudioMetadata.Face> facelist;
        String[] use;
        long lin;
        int in;
        this._sampleRate = aes.getSampleRate();
        DefaultMutableTreeNode val = new DefaultMutableTreeNode("AESAudioMetadata", true);
        String s = aes.getAnalogDigitalFlag();
        if (s != null) {
            val.add(new DefaultMutableTreeNode("AnalogDigitalFlag: " + s, false));
        }
        if ((s = aes.getSchemaVersion()) != null) {
            val.add(new DefaultMutableTreeNode("SchemaVersion: " + s, false));
        }
        if ((s = aes.getFormat()) != null) {
            DefaultMutableTreeNode fmt = new DefaultMutableTreeNode(FORMAT + s, true);
            val.add(fmt);
            String v = aes.getSpecificationVersion();
            if (v != null) {
                fmt.add(new DefaultMutableTreeNode("SpecificationVersion: " + v, false));
            }
        }
        if ((s = aes.getAppSpecificData()) != null) {
            val.add(new DefaultMutableTreeNode("AppSpecificData: " + s, false));
        }
        if ((s = aes.getAudioDataEncoding()) != null) {
            val.add(new DefaultMutableTreeNode("AudioDataEncoding: " + s, false));
        }
        if ((in = aes.getByteOrder()) != -1) {
            val.add(new DefaultMutableTreeNode(BYTE_ORDER + (in == 0 ? "BIG_ENDIAN" : "LITTLE_ENDIAN")));
        }
        if ((lin = aes.getFirstSampleOffset()) != -1L) {
            val.add(new DefaultMutableTreeNode("FirstSampleOffset: " + Long.toString(lin)));
        }
        if ((use = aes.getUse()) != null) {
            DefaultMutableTreeNode u = new DefaultMutableTreeNode("Use", true);
            val.add(u);
            u.add(new DefaultMutableTreeNode("UseType: " + use[0], false));
            u.add(new DefaultMutableTreeNode("OtherType: " + use[1], false));
        }
        if ((s = aes.getPrimaryIdentifier()) != null) {
            String t = aes.getPrimaryIdentifierType();
            DefaultMutableTreeNode pi = new DefaultMutableTreeNode("PrimaryIdentifier: " + s, true);
            val.add(pi);
            if (t != null) {
                pi.add(new DefaultMutableTreeNode("IdentifierType: " + t));
            }
        }
        if (!(facelist = aes.getFaceList()).isEmpty()) {
            AESAudioMetadata.Face f = facelist.get(0);
            DefaultMutableTreeNode face = new DefaultMutableTreeNode("Face", true);
            DefaultMutableTreeNode timeline = new DefaultMutableTreeNode("TimeLine", true);
            AESAudioMetadata.TimeDesc startTime = f.getStartTime();
            if (startTime != null) {
                this.addAESTimeRange(timeline, startTime, f.getDuration());
            }
            face.add(timeline);
            AESAudioMetadata.FaceRegion facergn = f.getFaceRegion(0);
            DefaultMutableTreeNode region = new DefaultMutableTreeNode("Region", true);
            timeline = new DefaultMutableTreeNode("TimeRange", true);
            this.addAESTimeRange(timeline, facergn.getStartTime(), facergn.getDuration());
            region.add(timeline);
            int nchan = aes.getNumChannels();
            if (nchan != -1) {
                region.add(new DefaultMutableTreeNode("NumChannels: " + Integer.toString(nchan), false));
                for (int ch = 0; ch < nchan; ++ch) {
                    DefaultMutableTreeNode stream = new DefaultMutableTreeNode("Stream", true);
                    region.add(stream);
                    stream.add(new DefaultMutableTreeNode("ChannelNum: " + Integer.toString(ch), false));
                }
            }
            face.add(region);
            val.add(face);
        }
        if (!(flist = aes.getFormatList()).isEmpty()) {
            AESAudioMetadata.FormatRegion rgn = flist.get(0);
            int bitDepth = rgn.getBitDepth();
            double sampleRate = rgn.getSampleRate();
            int wordSize = rgn.getWordSize();
            String[] bitRed = rgn.getBitrateReduction();
            if (bitDepth != -1 || sampleRate != -1.0 || wordSize != -1) {
                DefaultMutableTreeNode formatList = new DefaultMutableTreeNode("FormatList", true);
                DefaultMutableTreeNode formatRegion = new DefaultMutableTreeNode("FormatRegion", true);
                if (bitDepth != -1) {
                    formatRegion.add(new DefaultMutableTreeNode("BitDepth: " + Integer.toString(bitDepth), false));
                }
                if (sampleRate != -1.0) {
                    formatRegion.add(new DefaultMutableTreeNode("SampleRate: " + Double.toString(sampleRate), false));
                }
                if (wordSize != -1) {
                    formatRegion.add(new DefaultMutableTreeNode("WordSize: " + Integer.toString(bitDepth), false));
                }
                if (bitRed != null) {
                    DefaultMutableTreeNode br = new DefaultMutableTreeNode("BitrateReduction", true);
                    br.add(new DefaultMutableTreeNode("codecName: " + bitRed[0], false));
                    br.add(new DefaultMutableTreeNode("codecNameVersion: " + bitRed[1], false));
                    br.add(new DefaultMutableTreeNode("codecCreatorApplication: " + bitRed[2], false));
                    br.add(new DefaultMutableTreeNode("codecCreatorApplicationVersion: " + bitRed[3], false));
                    br.add(new DefaultMutableTreeNode("codecQuality: " + bitRed[4], false));
                    br.add(new DefaultMutableTreeNode("dataRate: " + bitRed[5], false));
                    br.add(new DefaultMutableTreeNode("dataRateMode: " + bitRed[6], false));
                    formatRegion.add(br);
                }
                formatList.add(formatRegion);
                val.add(formatList);
            }
        }
        return val;
    }

    private void addAESTimeRange(DefaultMutableTreeNode parent, AESAudioMetadata.TimeDesc start, AESAudioMetadata.TimeDesc duration) {
        this.writeAESTimeRangePart(parent, "StartTime", start);
        if (duration != null) {
            this.writeAESTimeRangePart(parent, "Duration", duration);
        }
    }

    private void writeAESTimeRangePart(DefaultMutableTreeNode parent, String name, AESAudioMetadata.TimeDesc timeDesc) {
        double sampleRate = timeDesc.getSampleRate();
        if (sampleRate == 1.0) {
            sampleRate = this._sampleRate;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(name, true);
        node.add(new DefaultMutableTreeNode("Value: " + String.valueOf(timeDesc.getSamples()), false));
        node.add(new DefaultMutableTreeNode("EditRate: " + sampleRate, false));
        node.add(new DefaultMutableTreeNode("FactorNumerator: 1", false));
        node.add(new DefaultMutableTreeNode("FactorDenominator: 1", false));
        parent.add(node);
    }

    private DefaultMutableTreeNode textMDToNode(TextMDMetadata textMD) {
        DefaultMutableTreeNode val = new DefaultMutableTreeNode(TEXT_MD_METADTA, true);
        DefaultMutableTreeNode u = new DefaultMutableTreeNode("Character_info", true);
        val.add(u);
        String s = textMD.getCharset();
        if (s != null) {
            u.add(new DefaultMutableTreeNode("Charset: " + s, false));
        }
        if ((s = textMD.getByte_orderString()) != null) {
            u.add(new DefaultMutableTreeNode("Byte_order: " + s, false));
        }
        if ((s = textMD.getByte_size()) != null) {
            u.add(new DefaultMutableTreeNode("Byte_size: " + s, false));
        }
        if ((s = textMD.getCharacter_size()) != null) {
            u.add(new DefaultMutableTreeNode("Character_size: " + s, false));
        }
        if ((s = textMD.getLinebreakString()) != null) {
            u.add(new DefaultMutableTreeNode("Linebreak: " + s, false));
        }
        if ((s = textMD.getLanguage()) != null) {
            val.add(new DefaultMutableTreeNode("Language: " + s, false));
        }
        if ((s = textMD.getMarkup_basis()) != null) {
            DefaultMutableTreeNode basis = new DefaultMutableTreeNode("Markup_basis: " + s, true);
            val.add(basis);
            s = textMD.getMarkup_basis_version();
            if (s != null) {
                basis.add(new DefaultMutableTreeNode(VERSION + s, false));
            }
        }
        if ((s = textMD.getMarkup_language()) != null) {
            DefaultMutableTreeNode language = new DefaultMutableTreeNode("Markup_language: " + s, true);
            val.add(language);
            s = textMD.getMarkup_language_version();
            if (s != null) {
                language.add(new DefaultMutableTreeNode(VERSION + s, false));
            }
        }
        return val;
    }

    private DefaultMutableTreeNode nisoToNode(NisoImageMetadata niso) {
        String[] sarray;
        int i;
        Rational rat;
        double[] darray;
        Rational r;
        double d;
        int i2;
        DefaultMutableTreeNode nod;
        long ln;
        long[] larray;
        int i3;
        Rational[] rarray;
        int[] iarray;
        int n;
        DefaultMutableTreeNode val = new DefaultMutableTreeNode("NisoImageMetadata", true);
        String s = niso.getMimeType();
        if (s != null) {
            val.add(new DefaultMutableTreeNode("FormatName: " + s, false));
        }
        if ((s = niso.getByteOrder()) != null) {
            val.add(new DefaultMutableTreeNode(BYTE_ORDER + s, false));
        }
        if ((n = niso.getCompressionScheme()) != -1) {
            val.add(new DefaultMutableTreeNode("CompressionScheme: " + this.integerRepresentation(n, NisoImageMetadata.COMPRESSION_SCHEME, NisoImageMetadata.COMPRESSION_SCHEME_INDEX), false));
        }
        if ((n = niso.getCompressionLevel()) != -1) {
            val.add(new DefaultMutableTreeNode("CompressionLevel: " + Integer.toString(n), false));
        }
        if ((n = niso.getColorSpace()) != -1) {
            val.add(new DefaultMutableTreeNode("ColorSpace: " + this.integerRepresentation(n, NisoImageMetadata.COLORSPACE, NisoImageMetadata.COLORSPACE_INDEX), false));
        }
        if ((s = niso.getProfileName()) != null) {
            val.add(new DefaultMutableTreeNode("ProfileName: " + s, false));
        }
        if ((s = niso.getProfileURL()) != null) {
            val.add(new DefaultMutableTreeNode("ProfileURL: " + s, false));
        }
        if ((iarray = niso.getYCbCrSubSampling()) != null) {
            DefaultMutableTreeNode nod2 = new DefaultMutableTreeNode("YCbCrSubSampling");
            val.add(nod2);
            for (int i4 = 0; i4 < iarray.length; ++i4) {
                nod2.add(new DefaultMutableTreeNode(Integer.toString(iarray[i4]), false));
            }
        }
        if ((n = niso.getYCbCrPositioning()) != -1) {
            val.add(new DefaultMutableTreeNode("YCbCrPositioning: " + this.integerRepresentation(n, NisoImageMetadata.YCBCR_POSITIONING), false));
        }
        if ((rarray = niso.getYCbCrCoefficients()) != null) {
            DefaultMutableTreeNode nod3 = new DefaultMutableTreeNode("YCbCrCoefficients", true);
            val.add(nod3);
            for (i3 = 0; i3 < rarray.length; ++i3) {
                nod3.add(new DefaultMutableTreeNode(rarray[i3].toString(), false));
            }
        }
        if ((rarray = niso.getReferenceBlackWhite()) != null) {
            DefaultMutableTreeNode nod4 = new DefaultMutableTreeNode("ReferenceBlackWhite", true);
            val.add(nod4);
            for (i3 = 0; i3 < rarray.length; ++i3) {
                nod4.add(new DefaultMutableTreeNode(rarray[i3].toString(), false));
            }
        }
        if ((n = niso.getSegmentType()) != -1) {
            val.add(new DefaultMutableTreeNode("YSegmentType: " + this.integerRepresentation(n, NisoImageMetadata.SEGMENT_TYPE), false));
        }
        if ((larray = niso.getStripOffsets()) != null) {
            DefaultMutableTreeNode nod5 = new DefaultMutableTreeNode("StripOffsets", true);
            val.add(nod5);
            for (int i5 = 0; i5 < larray.length; ++i5) {
                nod5.add(new DefaultMutableTreeNode(Long.toString(larray[i5]), false));
            }
        }
        if ((ln = niso.getRowsPerStrip()) != -1L) {
            val.add(new DefaultMutableTreeNode("RowsPerStrip: " + Long.toString(ln), false));
        }
        if ((larray = niso.getStripByteCounts()) != null) {
            nod = new DefaultMutableTreeNode("StripByteCounts", true);
            val.add(nod);
            for (i2 = 0; i2 < larray.length; ++i2) {
                nod.add(new DefaultMutableTreeNode(Long.toString(larray[i2]), false));
            }
        }
        if ((ln = niso.getTileWidth()) != -1L) {
            val.add(new DefaultMutableTreeNode("TileWidth: " + Long.toString(ln)));
        }
        if ((ln = niso.getTileLength()) != -1L) {
            val.add(new DefaultMutableTreeNode("TileLength: " + Long.toString(ln)));
        }
        if ((larray = niso.getTileOffsets()) != null) {
            nod = new DefaultMutableTreeNode("TileOffsets", true);
            val.add(nod);
            for (i2 = 0; i2 < larray.length; ++i2) {
                nod.add(new DefaultMutableTreeNode(Long.toString(larray[i2]), false));
            }
        }
        if ((larray = niso.getTileByteCounts()) != null) {
            nod = new DefaultMutableTreeNode("TileByteCounts", true);
            val.add(nod);
            for (i2 = 0; i2 < larray.length; ++i2) {
                nod.add(new DefaultMutableTreeNode(Long.toString(larray[i2]), false));
            }
        }
        if ((n = niso.getPlanarConfiguration()) != -1) {
            val.add(new DefaultMutableTreeNode("PlanarConfiguration: " + this.integerRepresentation(n, NisoImageMetadata.PLANAR_CONFIGURATION), false));
        }
        if ((s = niso.getImageIdentifier()) != null) {
            val.add(new DefaultMutableTreeNode("ImageIdentifier: " + s, false));
        }
        if ((s = niso.getImageIdentifierLocation()) != null) {
            val.add(new DefaultMutableTreeNode("ImageIdentifierLocation: " + s, false));
        }
        if ((ln = niso.getFileSize()) != -1L) {
            val.add(new DefaultMutableTreeNode("FileSize: " + Long.toString(ln), false));
        }
        if ((n = niso.getChecksumMethod()) != -1) {
            val.add(new DefaultMutableTreeNode("ChecksumMethod: " + this.integerRepresentation(n, NisoImageMetadata.CHECKSUM_METHOD), false));
        }
        if ((s = niso.getChecksumValue()) != null) {
            val.add(new DefaultMutableTreeNode("ChecksumValue: " + s, false));
        }
        if ((n = niso.getOrientation()) != -1) {
            val.add(new DefaultMutableTreeNode("Orientation: " + this.integerRepresentation(n, NisoImageMetadata.ORIENTATION), false));
        }
        if ((n = niso.getDisplayOrientation()) != -1) {
            val.add(new DefaultMutableTreeNode("DisplayOrientation: " + this.integerRepresentation(n, NisoImageMetadata.DISPLAY_ORIENTATION), false));
        }
        if ((ln = niso.getXTargetedDisplayAR()) != -1L) {
            val.add(new DefaultMutableTreeNode("XTargetedDisplayAR: " + Long.toString(ln), false));
        }
        if ((ln = niso.getYTargetedDisplayAR()) != -1L) {
            val.add(new DefaultMutableTreeNode("YTargetedDisplayAR: " + Long.toString(ln), false));
        }
        if ((s = niso.getPreferredPresentation()) != null) {
            val.add(new DefaultMutableTreeNode("PreferredPresentation: " + s, false));
        }
        if ((s = niso.getSourceType()) != null) {
            val.add(new DefaultMutableTreeNode("SourceType: " + s, false));
        }
        if ((s = niso.getImageProducer()) != null) {
            val.add(new DefaultMutableTreeNode("ImageProducer: " + s, false));
        }
        if ((s = niso.getHostComputer()) != null) {
            val.add(new DefaultMutableTreeNode("HostComputer: " + s, false));
        }
        if ((s = niso.getOS()) != null) {
            val.add(new DefaultMutableTreeNode("OperatingSystem: " + s, false));
        }
        if ((s = niso.getOSVersion()) != null) {
            val.add(new DefaultMutableTreeNode("OSVersion: " + s, false));
        }
        if ((s = niso.getDeviceSource()) != null) {
            val.add(new DefaultMutableTreeNode("DeviceSource: " + s, false));
        }
        if ((s = niso.getScannerManufacturer()) != null) {
            val.add(new DefaultMutableTreeNode("ScannerManufacturer: " + s, false));
        }
        if ((s = niso.getScannerModelName()) != null) {
            val.add(new DefaultMutableTreeNode("ScannerModelName: " + s, false));
        }
        if ((s = niso.getScannerModelNumber()) != null) {
            val.add(new DefaultMutableTreeNode("ScannerModelNumber: " + s, false));
        }
        if ((s = niso.getScannerModelSerialNo()) != null) {
            val.add(new DefaultMutableTreeNode("ScannerModelSerialNo: " + s, false));
        }
        if ((s = niso.getScanningSoftware()) != null) {
            val.add(new DefaultMutableTreeNode("ScanningSoftware: " + s, false));
        }
        if ((s = niso.getScanningSoftwareVersionNo()) != null) {
            val.add(new DefaultMutableTreeNode("ScanningSoftwareVersionNo: " + s, false));
        }
        if ((d = niso.getPixelSize()) != -1.0) {
            val.add(new DefaultMutableTreeNode("PixelSize: " + Double.toString(d), false));
        }
        if ((d = niso.getXPhysScanResolution()) != -1.0) {
            val.add(new DefaultMutableTreeNode("XPhysScanResolution: " + Double.toString(d), false));
        }
        if ((d = niso.getYPhysScanResolution()) != -1.0) {
            val.add(new DefaultMutableTreeNode("YPhysScanResolution: " + Double.toString(d), false));
        }
        if ((s = niso.getDigitalCameraManufacturer()) != null) {
            val.add(new DefaultMutableTreeNode("DigitalCameraManufacturer: " + s, false));
        }
        if ((s = niso.getDigitalCameraModelName()) != null) {
            val.add(new DefaultMutableTreeNode("DigitalCameraModelName: " + s, false));
        }
        if ((s = niso.getDigitalCameraModelNumber()) != null) {
            val.add(new DefaultMutableTreeNode("DigitalCameraModelNumber: " + s, false));
        }
        if ((s = niso.getDigitalCameraModelSerialNo()) != null) {
            val.add(new DefaultMutableTreeNode("DigitalCameraModelSerialNo: " + s, false));
        }
        if ((d = niso.getFNumber()) != -1.0) {
            val.add(new DefaultMutableTreeNode("FNumber: " + Double.toString(d), false));
        }
        if ((d = niso.getExposureTime()) != -1.0) {
            val.add(new DefaultMutableTreeNode("ExposureTime: " + Double.toString(d), false));
        }
        if ((n = niso.getExposureProgram()) != -1) {
            val.add(new DefaultMutableTreeNode("ExposureProgram: " + Integer.toString(n), false));
        }
        if ((s = niso.getExifVersion()) != null) {
            val.add(new DefaultMutableTreeNode("ExifVersion: " + s, false));
        }
        if ((r = niso.getBrightness()) != null) {
            val.add(new DefaultMutableTreeNode("Brightness: " + r.toString(), false));
        }
        if ((r = niso.getExposureBias()) != null) {
            val.add(new DefaultMutableTreeNode("ExposureBias: " + r.toString(), false));
        }
        if ((darray = niso.getSubjectDistance()) != null) {
            DefaultMutableTreeNode nod6 = new DefaultMutableTreeNode("SubjectDistance", true);
            val.add(nod6);
            for (int i6 = 0; i6 < darray.length; ++i6) {
                nod6.add(new DefaultMutableTreeNode(Double.toString(darray[i6]), false));
            }
        }
        if ((n = niso.getMeteringMode()) != -1) {
            val.add(new DefaultMutableTreeNode("MeteringMode: " + Integer.toString(n), false));
        }
        if ((n = niso.getSceneIlluminant()) != -1) {
            val.add(new DefaultMutableTreeNode("SceneIlluminant: " + Integer.toString(n), false));
        }
        if ((d = niso.getColorTemp()) != -1.0) {
            val.add(new DefaultMutableTreeNode("ColorTemp: " + Double.toString(d), false));
        }
        if ((d = niso.getFocalLength()) != -1.0) {
            val.add(new DefaultMutableTreeNode("FocalLength: " + Double.toString(d), false));
        }
        if ((n = niso.getFlash()) != -1) {
            val.add(new DefaultMutableTreeNode("Flash: " + this.integerRepresentation(n & 1, NisoImageMetadata.FLASH_20), false));
        }
        if ((r = niso.getFlashEnergy()) != null) {
            val.add(new DefaultMutableTreeNode("FlashEnergy: " + r.toString(), false));
        }
        if ((n = niso.getFlashReturn()) != -1) {
            val.add(new DefaultMutableTreeNode("FlashReturn: " + this.integerRepresentation(n, NisoImageMetadata.FLASH_RETURN), false));
        }
        if ((n = niso.getBackLight()) != -1) {
            val.add(new DefaultMutableTreeNode("BackLight: " + this.integerRepresentation(n, NisoImageMetadata.BACKLIGHT), false));
        }
        if ((d = niso.getExposureIndex()) != -1.0) {
            val.add(new DefaultMutableTreeNode("ExposureIndex: " + Double.toString(d), false));
        }
        if ((n = niso.getAutoFocus()) != -1) {
            val.add(new DefaultMutableTreeNode("AutoFocus: " + Integer.toString(n), false));
        }
        if ((d = niso.getXPrintAspectRatio()) != -1.0) {
            val.add(new DefaultMutableTreeNode("XPrintAspectRatio: " + Double.toString(d), false));
        }
        if ((d = niso.getYPrintAspectRatio()) != -1.0) {
            val.add(new DefaultMutableTreeNode("YPrintAspectRatio: " + Double.toString(d), false));
        }
        if ((n = niso.getSensor()) != -1) {
            val.add(new DefaultMutableTreeNode("Sensor: " + this.integerRepresentation(n, NisoImageMetadata.SENSOR), false));
        }
        if ((s = niso.getDateTimeCreated()) != null) {
            val.add(new DefaultMutableTreeNode("DateTimeCreated: " + s, false));
        }
        if ((s = niso.getMethodology()) != null) {
            val.add(new DefaultMutableTreeNode("Methodology: " + s, false));
        }
        if ((n = niso.getSamplingFrequencyPlane()) != -1) {
            val.add(new DefaultMutableTreeNode("SamplingFrequencyPlane: " + this.integerRepresentation(n, NisoImageMetadata.SAMPLING_FREQUENCY_PLANE), false));
        }
        if ((n = niso.getSamplingFrequencyUnit()) != -1) {
            val.add(new DefaultMutableTreeNode("SamplingFrequencyUnit: " + this.integerRepresentation(n, NisoImageMetadata.SAMPLING_FREQUENCY_UNIT), false));
        }
        if ((rat = niso.getXSamplingFrequency()) != null) {
            val.add(new DefaultMutableTreeNode("XSamplingFrequency: " + rat.toString(), false));
        }
        if ((rat = niso.getYSamplingFrequency()) != null) {
            val.add(new DefaultMutableTreeNode("YSamplingFrequency: " + rat.toString(), false));
        }
        if ((ln = niso.getImageWidth()) != -1L) {
            val.add(new DefaultMutableTreeNode("ImageWidth: " + Long.toString(ln), false));
        }
        if ((ln = niso.getImageLength()) != -1L) {
            val.add(new DefaultMutableTreeNode("ImageLength: " + Long.toString(ln), false));
        }
        if ((d = niso.getSourceXDimension()) != -1.0) {
            val.add(new DefaultMutableTreeNode("SourceXDimension: " + Double.toString(d), false));
        }
        if ((n = niso.getSourceXDimensionUnit()) != -1) {
            val.add(new DefaultMutableTreeNode("SourceXDimensionUnit: " + this.integerRepresentation(n, NisoImageMetadata.SOURCE_DIMENSION_UNIT), false));
        }
        if ((d = niso.getSourceYDimension()) != -1.0) {
            val.add(new DefaultMutableTreeNode("SourceYDimension: " + Double.toString(d), false));
        }
        if ((n = niso.getSourceYDimensionUnit()) != -1) {
            val.add(new DefaultMutableTreeNode("SourceYDimensionUnit: " + this.integerRepresentation(n, NisoImageMetadata.SOURCE_DIMENSION_UNIT), false));
        }
        if ((iarray = niso.getBitsPerSample()) != null) {
            DefaultMutableTreeNode nod7 = new DefaultMutableTreeNode("BitsPerSample");
            val.add(nod7);
            for (i = 0; i < iarray.length; ++i) {
                nod7.add(new DefaultMutableTreeNode(Integer.toString(iarray[i]), false));
                nod7.add(new DefaultMutableTreeNode("Integer"));
            }
        }
        if ((n = niso.getSamplesPerPixel()) != -1) {
            val.add(new DefaultMutableTreeNode("SamplesPerPixel: " + Integer.toString(n), false));
        }
        if ((iarray = niso.getExtraSamples()) != null) {
            DefaultMutableTreeNode nod8 = new DefaultMutableTreeNode("ExtraSamples");
            val.add(nod8);
            for (i = 0; i < iarray.length; ++i) {
                nod8.add(new DefaultMutableTreeNode(this.integerRepresentation(iarray[i], NisoImageMetadata.EXTRA_SAMPLES), false));
            }
        }
        if ((s = niso.getColormapReference()) != null) {
            val.add(new DefaultMutableTreeNode("ColormapReference: " + s));
        }
        if ((iarray = niso.getColormapBitCodeValue()) != null) {
            DefaultMutableTreeNode nod9 = new DefaultMutableTreeNode("ColormapBitCodeValue");
            val.add(nod9);
            for (i = 0; i < iarray.length; ++i) {
                nod9.add(new DefaultMutableTreeNode(Integer.toString(iarray[i]), false));
            }
        }
        if ((iarray = niso.getColormapRedValue()) != null) {
            DefaultMutableTreeNode nod10 = new DefaultMutableTreeNode("ColormapRedValue");
            val.add(nod10);
            for (i = 0; i < iarray.length; ++i) {
                nod10.add(new DefaultMutableTreeNode(Integer.toString(iarray[i]), false));
            }
        }
        if ((iarray = niso.getColormapGreenValue()) != null) {
            DefaultMutableTreeNode nod11 = new DefaultMutableTreeNode("ColormapGreenValue");
            val.add(nod11);
            for (i = 0; i < iarray.length; ++i) {
                nod11.add(new DefaultMutableTreeNode(Integer.toString(iarray[i]), false));
            }
        }
        if ((iarray = niso.getColormapBlueValue()) != null) {
            DefaultMutableTreeNode nod12 = new DefaultMutableTreeNode("ColormapBlueValue");
            val.add(nod12);
            for (i = 0; i < iarray.length; ++i) {
                nod12.add(new DefaultMutableTreeNode(Integer.toString(iarray[i]), false));
            }
        }
        if ((iarray = niso.getGrayResponseCurve()) != null) {
            DefaultMutableTreeNode nod13 = new DefaultMutableTreeNode("GrayResponseCurve");
            val.add(nod13);
            for (i = 0; i < iarray.length; ++i) {
                nod13.add(new DefaultMutableTreeNode(Integer.toString(iarray[i]), false));
            }
        }
        if ((n = niso.getGrayResponseUnit()) != -1) {
            val.add(new DefaultMutableTreeNode("GrayResponseUnit: " + Integer.toString(n), false));
        }
        if ((r = niso.getWhitePointXValue()) != null) {
            val.add(new DefaultMutableTreeNode("WhitePointXValue: " + r.toString(), false));
        }
        if ((r = niso.getWhitePointYValue()) != null) {
            val.add(new DefaultMutableTreeNode("WhitePointYValue: " + r.toString(), false));
        }
        if ((r = niso.getPrimaryChromaticitiesRedX()) != null) {
            val.add(new DefaultMutableTreeNode("PrimaryChromaticitiesRedX: " + r.toString(), false));
        }
        if ((r = niso.getPrimaryChromaticitiesRedY()) != null) {
            val.add(new DefaultMutableTreeNode("PrimaryChromaticitiesRedY: " + r.toString(), false));
        }
        if ((r = niso.getPrimaryChromaticitiesGreenX()) != null) {
            val.add(new DefaultMutableTreeNode("PrimaryChromaticitiesGreenX: " + r.toString(), false));
        }
        if ((r = niso.getPrimaryChromaticitiesGreenY()) != null) {
            val.add(new DefaultMutableTreeNode("PrimaryChromaticitiesGreenY: " + r.toString(), false));
        }
        if ((r = niso.getPrimaryChromaticitiesBlueX()) != null) {
            val.add(new DefaultMutableTreeNode("PrimaryChromaticitiesBlueX: " + r.toString()));
        }
        if ((r = niso.getPrimaryChromaticitiesBlueY()) != null) {
            val.add(new DefaultMutableTreeNode("PrimaryChromaticitiesBlueY: " + r.toString()));
        }
        if ((n = niso.getTargetType()) != -1) {
            val.add(new DefaultMutableTreeNode("TargetType: " + this.integerRepresentation(n, NisoImageMetadata.TARGET_TYPE), false));
        }
        if ((s = niso.getTargetIDManufacturer()) != null) {
            val.add(new DefaultMutableTreeNode("TargetIDManufacturer: " + s, false));
        }
        if ((s = niso.getTargetIDName()) != null) {
            val.add(new DefaultMutableTreeNode("TargetIDName: " + s, false));
        }
        if ((s = niso.getTargetIDNo()) != null) {
            val.add(new DefaultMutableTreeNode("TargetIDNo: " + s, false));
        }
        if ((s = niso.getTargetIDMedia()) != null) {
            val.add(new DefaultMutableTreeNode("TargetIDMedia: " + s, false));
        }
        if ((s = niso.getImageData()) != null) {
            val.add(new DefaultMutableTreeNode("ImageData: " + s, false));
        }
        if ((s = niso.getPerformanceData()) != null) {
            val.add(new DefaultMutableTreeNode("PerformanceData: " + s, false));
        }
        if ((s = niso.getProfiles()) != null) {
            val.add(new DefaultMutableTreeNode("Profiles: " + s, false));
        }
        if ((s = niso.getDateTimeProcessed()) != null) {
            val.add(new DefaultMutableTreeNode("DateTimeProcessed: " + s, false));
        }
        if ((s = niso.getSourceData()) != null) {
            val.add(new DefaultMutableTreeNode("SourceData: " + s, false));
        }
        if ((s = niso.getProcessingAgency()) != null) {
            val.add(new DefaultMutableTreeNode("ProcessingAgency: " + s, false));
        }
        if ((s = niso.getProcessingSoftwareName()) != null) {
            val.add(new DefaultMutableTreeNode("ProcessingSoftwareName: " + s, false));
        }
        if ((s = niso.getProcessingSoftwareVersion()) != null) {
            val.add(new DefaultMutableTreeNode("ProcessingSoftwareVersion: " + s, false));
        }
        if ((sarray = niso.getProcessingActions()) != null) {
            DefaultMutableTreeNode nod14 = new DefaultMutableTreeNode("ProcessingActions", true);
            val.add(nod14);
            for (int i7 = 1; i7 < sarray.length; ++i7) {
                nod14.add(new DefaultMutableTreeNode(sarray[i7], false));
            }
        }
        return val;
    }

    private String integerRepresentation(int n, String[] labels) {
        if (this._rawOutput) {
            return Integer.toString(n);
        }
        try {
            return labels[n];
        }
        catch (Exception e) {
            return Integer.toString(n);
        }
    }

    private String integerRepresentation(int n, String[] labels, int[] index) {
        if (this._rawOutput) {
            return Integer.toString(n);
        }
        try {
            int idx = -1;
            for (int i = 0; i < index.length; ++i) {
                if (n != index[i]) continue;
                idx = i;
                break;
            }
            if (idx > -1) {
                return labels[idx];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.toString(n);
    }

    private DefaultMutableTreeNode getDefaultMutableTreeNode(PropertyType ptyp, Object item, boolean allowsChildren) {
        DefaultMutableTreeNode itemNode;
        if (null == ptyp) {
            itemNode = new DefaultMutableTreeNode(item, allowsChildren);
        } else {
            switch (ptyp) {
                case PROPERTY: {
                    itemNode = this.propToNode((Property)item);
                    break;
                }
                case NISOIMAGEMETADATA: {
                    itemNode = this.nisoToNode((NisoImageMetadata)item);
                    break;
                }
                default: {
                    itemNode = new DefaultMutableTreeNode(item, allowsChildren);
                }
            }
        }
        return itemNode;
    }

    private <E> void addToNode(DefaultMutableTreeNode node, E[] array) {
        for (E element : array) {
            if (element instanceof Property) {
                node.add(this.propToNode((Property)element));
                continue;
            }
            node.add(new DefaultMutableTreeNode(element));
        }
    }
}

