/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.handler;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.HandlerBase;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class XmlHandler
extends HandlerBase {
    private static final ThreadLocal<NumberFormat> formatters = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat _format = NumberFormat.getInstance(Locale.ROOT);
            _format.setGroupingUsed(false);
            _format.setMinimumFractionDigits(0);
            return _format;
        }
    };
    private static final String NAME = "XML";
    private static final String RELEASE = "1.7";
    private static final int[] DATE = new int[]{2012, 8, 12};
    private static final String NOTE = "This output handler is defined by the XML Schema http://hul.harvard.edu/ois/xml/xsd/jhove/jhove.xsd";
    private static final String RIGHTS = "Derived from software Copyright 2004-2011 by the President and Fellows of Harvard College. Version 1.7 independently released. Released under the GNU Lesser General Public License.";
    private static final String EOL = System.getProperty("line.separator");
    private static final String SCHEMA_VERSION = "1.6";
    private double _sampleRate;

    public XmlHandler() {
        super(NAME, RELEASE, DATE, NOTE, RIGHTS);
        this._vendor = Agent.harvardInstance();
    }

    public XmlHandler(String name, String release, int[] date, String note, String rights) {
        super(name, release, date, note, rights);
        this._vendor = Agent.harvardInstance();
    }

    @Override
    public void show() {
        String margin = XmlHandler.getIndent(++this._level);
        --this._level;
    }

    @Override
    public void show(App app) {
        String[][] attr2;
        String s;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        this._writer.println(margin + XmlHandler.elementStart("app"));
        String[][] attrs = new String[][]{{"date", date.format(this._je.getDate())}};
        this._writer.println(margn2 + XmlHandler.element("api", attrs, app.getRelease()));
        String configFile = this._je.getConfigFile();
        if (configFile != null) {
            this._writer.println(margn2 + XmlHandler.element("configuration", configFile));
        }
        if ((s = this._je.getSaxClass()) != null) {
            this._writer.println(margn2 + XmlHandler.element("saxParser", s));
        }
        if ((s = this._je.getJhoveHome()) != null) {
            this._writer.println(margn2 + XmlHandler.element("jhoveHome", s));
        }
        if ((s = this._je.getEncoding()) != null) {
            this._writer.println(margn2 + XmlHandler.element("encoding", s));
        }
        if ((s = this._je.getTempDirectory()) != null) {
            this._writer.println(margn2 + XmlHandler.element("tempDirectory", s));
        }
        this._writer.println(margn2 + XmlHandler.element("bufferSize", Integer.toString(this._je.getBufferSize())));
        this._writer.println(margn2 + XmlHandler.elementStart("modules"));
        Iterator<String> iter = this._je.getModuleMap().keySet().iterator();
        while (iter.hasNext()) {
            Module module = this._je.getModule(iter.next());
            attr2 = new String[][]{{"release", module.getRelease()}};
            this._writer.println(margn3 + XmlHandler.element("module", attr2, module.getName()));
        }
        this._writer.println(margn2 + XmlHandler.elementEnd("modules"));
        this._writer.println(margn2 + XmlHandler.elementStart("outputHandlers"));
        iter = this._je.getHandlerMap().keySet().iterator();
        while (iter.hasNext()) {
            OutputHandler handler = this._je.getHandler(iter.next());
            attr2 = new String[][]{{"release", handler.getRelease()}};
            this._writer.println(margn3 + XmlHandler.element("outputHandler", attr2, handler.getName()));
        }
        this._writer.println(margn2 + XmlHandler.elementEnd("outputHandlers"));
        this._writer.println(margn2 + XmlHandler.element("usage", app.getUsage()));
        this._writer.println(margn2 + XmlHandler.element("rights", app.getRights()));
        this._writer.println(margin + XmlHandler.elementEnd("app"));
        --this._level;
    }

    @Override
    public void show(OutputHandler handler) {
        String s;
        Agent vendor;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = margin + " ";
        this._writer.println(margin + XmlHandler.elementStart("handler"));
        this._writer.println(margn2 + XmlHandler.element("name", handler.getName()));
        this._writer.println(margn2 + XmlHandler.element("release", handler.getRelease()));
        this._writer.println(margn2 + XmlHandler.element("date", date.format(handler.getDate())));
        List<Document> list = handler.getSpecification();
        int n = list.size();
        if (n > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("specifications"));
            ++this._level;
            for (int i = 0; i < n; ++i) {
                this.showDocument(list.get(i));
            }
            --this._level;
            this._writer.println(margn2 + XmlHandler.elementEnd("specifications"));
        }
        if ((vendor = handler.getVendor()) != null) {
            this.showAgent(vendor, "Vendor");
        }
        if ((s = handler.getNote()) != null) {
            this._writer.println(margn2 + XmlHandler.element("note", s));
        }
        if ((s = handler.getRights()) != null) {
            this._writer.println(margn2 + XmlHandler.element("rights", s));
        }
        this._writer.println(margin + XmlHandler.elementEnd("handler"));
        --this._level;
    }

    @Override
    public void show(Module module) {
        List<String> ftr;
        int i;
        List<Object> list;
        int n;
        String s2;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        this._writer.println(margin + XmlHandler.elementStart("module"));
        this._writer.println(margn2 + XmlHandler.element("name", module.getName()));
        this._writer.println(margn2 + XmlHandler.element("release", module.getRelease()));
        this._writer.println(margn2 + XmlHandler.element("date", HandlerBase.date.format(module.getDate())));
        String[] ss = module.getFormat();
        if (ss.length > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("formats"));
            for (int i2 = 0; i2 < ss.length; ++i2) {
                this._writer.println(margn3 + XmlHandler.element("format", ss[i2]));
            }
            this._writer.println(margn2 + XmlHandler.elementEnd("formats"));
        }
        if ((s2 = module.getCoverage()) != null) {
            this._writer.println(margn2 + XmlHandler.element("coverage", s2));
        }
        if ((ss = module.getMimeType()).length > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("mimeTypes"));
            for (int i3 = 0; i3 < ss.length; ++i3) {
                this._writer.println(margn3 + XmlHandler.element("mimeType", ss[i3]));
            }
            this._writer.println(margn2 + XmlHandler.elementEnd("mimeTypes"));
        }
        if ((n = (list = module.getSignature()).size()) > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("signatures"));
            ++this._level;
            for (i = 0; i < n; ++i) {
                this.showSignature((Signature)list.get(i));
            }
            --this._level;
            this._writer.println(margn2 + XmlHandler.elementEnd("signatures"));
        }
        if ((n = (list = module.getSpecification()).size()) > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("specifications"));
            ++this._level;
            for (i = 0; i < n; ++i) {
                this.showDocument((Document)list.get(i));
            }
            --this._level;
            this._writer.println(margn2 + XmlHandler.elementEnd("specifications"));
        }
        if ((ftr = module.getFeatures()) != null && !ftr.isEmpty()) {
            this._writer.println(margn2 + XmlHandler.elementStart("features"));
            for (String s2 : ftr) {
                this._writer.println(margn3 + XmlHandler.element("feature", s2));
            }
            this._writer.println(margn2 + XmlHandler.elementEnd("features"));
        }
        this._writer.println(margn2 + XmlHandler.elementStart("methodology"));
        s2 = module.getWellFormedNote();
        if (s2 != null) {
            this._writer.println(margn3 + XmlHandler.element("wellFormed", s2));
        }
        if ((s2 = module.getValidityNote()) != null) {
            this._writer.println(margn3 + XmlHandler.element("validity", s2));
        }
        if ((s2 = module.getRepInfoNote()) != null) {
            this._writer.println(margn3 + XmlHandler.element("repInfo", s2));
        }
        this._writer.println(margn2 + XmlHandler.elementEnd("methodology"));
        Agent vendor = module.getVendor();
        if (vendor != null) {
            this.showAgent(vendor, "Vendor");
        }
        if ((s2 = module.getNote()) != null) {
            this._writer.println(margn2 + XmlHandler.element("note", s2));
        }
        if ((s2 = module.getRights()) != null) {
            this._writer.println(margn2 + XmlHandler.element("rights", s2));
        }
        this._writer.println(margin + XmlHandler.elementEnd("module"));
        --this._level;
    }

    @Override
    public void show(RepInfo info) {
        Map<String, Property> map;
        int i;
        String wfStr;
        String s;
        long size;
        Date date;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        Module module = info.getModule();
        this._logger.info("Reporting RepInfo");
        if (this._je.getSignatureFlag()) {
            this._logger.info("Checking signatures only");
        }
        String[][] attrs = new String[][]{{"uri", this.cleanURIString(info.getUri())}};
        this._writer.println(margin + XmlHandler.elementStart("repInfo", attrs));
        if (module != null) {
            String[][] attr2 = new String[][]{{"release", module.getRelease()}, {"date", XmlHandler.date.format(module.getDate())}};
            this._writer.println(margn2 + XmlHandler.element("reportingModule", attr2, module.getName()));
        }
        if ((date = info.getCreated()) != null) {
            this._writer.println(margn2 + XmlHandler.element("created", this.toDateTime(date)));
        }
        if ((date = info.getLastModified()) != null) {
            this._writer.println(margn2 + XmlHandler.element("lastModified", this.toDateTime(date)));
        }
        if ((size = info.getSize()) > -1L) {
            this._writer.println(margn2 + XmlHandler.element("size", Long.toString(size)));
        }
        if ((s = info.getFormat()) != null) {
            this._writer.println(margn2 + XmlHandler.element("format", s));
        }
        if ((s = info.getVersion()) != null) {
            this._writer.println(margn2 + XmlHandler.element("version", s));
        }
        if (!this._je.getSignatureFlag()) {
            switch (info.getWellFormed()) {
                case 1: {
                    wfStr = "Well-Formed";
                    break;
                }
                case 0: {
                    wfStr = "Not well-formed";
                    break;
                }
                default: {
                    wfStr = "Unknown";
                }
            }
            if (info.getWellFormed() == 1) {
                switch (info.getValid()) {
                    case 1: {
                        wfStr = wfStr + " and valid";
                        break;
                    }
                    case 0: {
                        wfStr = wfStr + ", but not valid";
                    }
                }
            }
            this._logger.info("Validity/WF status: " + wfStr);
            this._writer.println(margn2 + XmlHandler.element("status", wfStr));
        } else {
            switch (info.getWellFormed()) {
                case 1: {
                    wfStr = "Well-Formed";
                    break;
                }
                default: {
                    wfStr = "Not well-formed";
                }
            }
            this._writer.println(margn2 + XmlHandler.element("status", wfStr));
        }
        List<Object> list = info.getSigMatch();
        int n = list.size();
        if (n > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("sigMatch"));
            ++this._level;
            for (i = 0; i < n; ++i) {
                this._writer.println(margn2 + XmlHandler.element("module", (String)list.get(i)));
            }
            --this._level;
            this._writer.println(margn2 + XmlHandler.elementEnd("sigMatch"));
        }
        if ((n = (list = info.getMessage()).size()) > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("messages"));
            ++this._level;
            for (i = 0; i < n; ++i) {
                this.showMessage((Message)list.get(i));
            }
            --this._level;
            this._writer.println(margn2 + XmlHandler.elementEnd("messages"));
        }
        if ((s = info.getMimeType()) != null) {
            this._writer.println(margn2 + XmlHandler.element("mimeType", s));
        }
        if ((n = (list = info.getProfile()).size()) > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("profiles"));
            for (i = 0; i < n; ++i) {
                this._writer.println(margn3 + XmlHandler.element("profile", (String)list.get(i)));
            }
            this._writer.println(margn2 + XmlHandler.elementEnd("profiles"));
        }
        if ((map = info.getProperty()) != null && map.size() > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("properties"));
            for (String key : map.keySet()) {
                Property property = info.getProperty(key);
                this.showProperty(property);
            }
            this._writer.println(margn2 + XmlHandler.elementEnd("properties"));
        }
        if ((n = (list = info.getChecksum()).size()) > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("checksums"));
            ++this._level;
            for (int i2 = 0; i2 < n; ++i2) {
                this.showChecksum((Checksum)list.get(i2));
            }
            --this._level;
            this._writer.println(margn2 + XmlHandler.elementEnd("checksums"));
        }
        if ((s = info.getNote()) != null) {
            this._writer.println(margn2 + XmlHandler.element("note", s));
        }
        this._writer.println(margin + XmlHandler.elementEnd("repInfo"));
        --this._level;
    }

    protected void showAgent(Agent agent, String label) {
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = margin + " ";
        String[][] attrs = new String[][]{{"type", label}};
        this._writer.println(margin + XmlHandler.elementStart("agent", attrs));
        this._writer.println(margn2 + XmlHandler.element("name", agent.getName()));
        this._writer.println(margn2 + XmlHandler.element("type", agent.getType().toString()));
        String s = agent.getAddress();
        if (s != null) {
            this._writer.println(margn2 + XmlHandler.element("address", s));
        }
        if ((s = agent.getTelephone()) != null) {
            this._writer.println(margn2 + XmlHandler.element("telephone", s));
        }
        if ((s = agent.getFax()) != null) {
            this._writer.println(margn2 + XmlHandler.element("fax", s));
        }
        if ((s = agent.getEmail()) != null) {
            this._writer.println(margn2 + XmlHandler.element("email", s));
        }
        if ((s = agent.getWeb()) != null) {
            this._writer.println(margn2 + XmlHandler.element("web", s));
        }
        this._writer.println(margin + XmlHandler.elementEnd("agent"));
        --this._level;
    }

    protected void showChecksum(Checksum checksum) {
        String margin = XmlHandler.getIndent(++this._level);
        String[][] attrs = new String[][]{{"type", checksum.getType().toString()}};
        this._writer.println(margin + XmlHandler.element("checksum", attrs, checksum.getValue()));
        --this._level;
    }

    protected void showDocument(Document document) {
        String s;
        int i;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = margin + " ";
        this._writer.println(margin + XmlHandler.elementStart("specification"));
        this._writer.println(margn2 + XmlHandler.element("title", document.getTitle()));
        this._writer.println(margn2 + XmlHandler.element("type", document.getType().toString()));
        List list = document.getAuthor();
        int n = list.size();
        if (n > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("authors"));
            ++this._level;
            for (i = 0; i < n; ++i) {
                this.showAgent((Agent)list.get(i), "Author");
            }
            --this._level;
            this._writer.println(margn2 + XmlHandler.elementEnd("authors"));
        }
        if ((n = (list = document.getPublisher()).size()) > 0) {
            ++this._level;
            this._writer.println(margn2 + XmlHandler.elementStart("publishers"));
            for (i = 0; i < n; ++i) {
                this.showAgent((Agent)list.get(i), "Publisher");
            }
            this._writer.println(margn2 + XmlHandler.elementEnd("publishers"));
            --this._level;
        }
        if ((s = document.getEdition()) != null) {
            this._writer.println(margn2 + XmlHandler.element("edition", s));
        }
        if ((s = document.getDate()) != null) {
            this._writer.println(margn2 + XmlHandler.element("date", s));
        }
        if ((s = document.getEnumeration()) != null) {
            this._writer.println(margn2 + XmlHandler.element("enumeration", s));
        }
        if ((s = document.getPages()) != null) {
            this._writer.println(margn2 + XmlHandler.element("pages", s));
        }
        if ((n = (list = document.getIdentifier()).size()) > 0) {
            this._writer.println(margn2 + XmlHandler.elementStart("identifiers"));
            ++this._level;
            for (int i2 = 0; i2 < n; ++i2) {
                this.showIdentifier((Identifier)list.get(i2));
            }
            --this._level;
            this._writer.println(margn2 + XmlHandler.elementEnd("identifiers"));
        }
        if ((s = document.getNote()) != null) {
            this._writer.println(margn2 + XmlHandler.element("note", s));
        }
        this._writer.println(margin + XmlHandler.elementEnd("specification"));
        --this._level;
    }

    @Override
    public void showFooter() {
        String margin = XmlHandler.getIndent(this._level--);
        this._writer.println(margin + XmlHandler.elementEnd("jhove"));
        this._writer.flush();
    }

    @Override
    public void showHeader() {
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = margin + " ";
        if (this._encoding != null) {
            this._writer.println(margin + XmlHandler.xmlDecl(this._encoding));
        } else {
            this._writer.println(margin + XmlHandler.xmlDecl());
        }
        String[][] attrs = new String[][]{{"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xmlns", "http://hul.harvard.edu/ois/xml/ns/jhove"}, {"xsi:schemaLocation", "http://hul.harvard.edu/ois/xml/ns/jhove http://hul.harvard.edu/ois/xml/xsd/jhove/1.6/jhove.xsd"}, {"name", this._app.getName()}, {"release", this._app.getRelease()}, {"date", HandlerBase.date.format(this._app.getDate())}};
        this._writer.println(margin + XmlHandler.elementStart("jhove", attrs));
        this._writer.println(margn2 + XmlHandler.element("date", this.toDateTime(new Date())));
    }

    protected void showIdentifier(Identifier identifier) {
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = margin + " ";
        this._writer.println(margin + XmlHandler.elementStart("identifier"));
        this._writer.println(margn2 + XmlHandler.element("value", identifier.getValue()));
        this._writer.println(margn2 + XmlHandler.element("type", identifier.getType().toString()));
        String note = identifier.getNote();
        if (note != null) {
            this._writer.println(margn2 + XmlHandler.element("note", note));
        }
        this._writer.println(margin + XmlHandler.elementEnd("identifier"));
        --this._level;
    }

    protected void showMessage(Message message) {
        long offset;
        String margin = XmlHandler.getIndent(++this._level);
        String[][] attrs = new String[3][];
        boolean hasAttr = false;
        attrs[0] = new String[]{"subMessage", null};
        attrs[1] = new String[]{"offset", null};
        attrs[2] = new String[]{"severity", null};
        String submsg = message.getSubMessage();
        if (submsg != null) {
            attrs[0][1] = submsg;
            hasAttr = true;
        }
        if ((offset = message.getOffset()) > -1L) {
            attrs[1][1] = Long.toString(offset);
            hasAttr = true;
        }
        if (message instanceof ErrorMessage) {
            attrs[2][1] = "error";
            hasAttr = true;
        } else if (message instanceof InfoMessage) {
            attrs[2][1] = "info";
            hasAttr = true;
        }
        if (hasAttr) {
            this._writer.println(margin + XmlHandler.element("message", attrs, message.getMessage()));
        } else {
            this._writer.println(margin + XmlHandler.element("message", message.getMessage()));
        }
        --this._level;
    }

    protected void showSignature(Signature signature) {
        String use;
        String note;
        String margin = XmlHandler.getIndent(++this._level);
        String margin1 = margin + " ";
        this._writer.println(margin + XmlHandler.elementStart("signature"));
        String sigValue = signature.isStringValue() ? signature.getValueString() : signature.getValueHexString();
        this._writer.println(margin1 + XmlHandler.element("type", signature.getType().toString()));
        this._writer.println(margin1 + XmlHandler.element("value", sigValue));
        if (signature.getType().equals(SignatureType.MAGIC) && ((InternalSignature)signature).hasFixedOffset()) {
            this._writer.println(margin1 + XmlHandler.element("offset", "0x" + Integer.toHexString(((InternalSignature)signature).getOffset())));
        }
        if ((note = signature.getNote()) != null) {
            this._writer.println(margin1 + XmlHandler.element("note", note));
        }
        if ((use = signature.getUse().toString()) != null) {
            this._writer.println(margin1 + XmlHandler.element("use", use));
        }
        this._writer.println(margin + XmlHandler.elementEnd("signature"));
        --this._level;
    }

    protected String valueToString(Object obj) {
        if (obj instanceof Date) {
            return this.toDateTime((Date)obj);
        }
        return obj.toString();
    }

    protected void showProperty(Property property) {
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        PropertyArity arity = property.getArity();
        PropertyType type = property.getType();
        if (this.isPropertyEmpty(property, arity)) {
            return;
        }
        boolean valueIsProperty = PropertyType.PROPERTY.equals(type);
        boolean valueIsNiso = PropertyType.NISOIMAGEMETADATA.equals(type);
        boolean valueIsAes = PropertyType.AESAUDIOMETADATA.equals(type);
        boolean valueIsTextMD = PropertyType.TEXTMDMETADATA.equals(type);
        String[][] propAttrs = new String[][]{{"arity", arity.toString()}, {"type", type.toString()}};
        this._writer.println(margn2 + XmlHandler.elementStart("property"));
        this._writer.println(margn3 + XmlHandler.element("name", property.getName()));
        this._writer.println(margn3 + XmlHandler.elementStart("values", propAttrs));
        if (arity.equals(PropertyArity.SCALAR)) {
            if (valueIsProperty) {
                this.showProperty((Property)property.getValue());
            } else if (valueIsNiso) {
                this._writer.println(margn4 + XmlHandler.elementStart("value"));
                this.showNisoImageMetadata((NisoImageMetadata)property.getValue());
                this._writer.println(margn4 + XmlHandler.elementEnd("value"));
            } else if (valueIsAes) {
                this._writer.println(margn4 + XmlHandler.elementStart("value"));
                this.showAESAudioMetadata((AESAudioMetadata)property.getValue());
                this._writer.println(margn4 + XmlHandler.elementEnd("value"));
            } else if (valueIsTextMD) {
                this._writer.println(margn4 + XmlHandler.elementStart("value"));
                this.showTextMDMetadata((TextMDMetadata)property.getValue());
                this._writer.println(margn4 + XmlHandler.elementEnd("value"));
            } else {
                this._writer.println(margn4 + XmlHandler.element("value", property.getValue().toString()));
            }
        } else if (arity.equals(PropertyArity.LIST)) {
            List propList = (List)property.getValue();
            ListIterator iter = propList.listIterator();
            while (iter.hasNext()) {
                Object val = iter.next();
                if (valueIsProperty) {
                    this.showProperty((Property)val);
                    continue;
                }
                if (valueIsNiso) {
                    this._writer.println(margn4 + XmlHandler.elementStart("value"));
                    this.showNisoImageMetadata((NisoImageMetadata)property.getValue());
                    this._writer.println(margn4 + XmlHandler.elementEnd("value"));
                    continue;
                }
                if (valueIsAes) {
                    this._writer.println(margn4 + XmlHandler.elementStart("value"));
                    this.showAESAudioMetadata((AESAudioMetadata)property.getValue());
                    this._writer.println(margn4 + XmlHandler.elementEnd("value"));
                    continue;
                }
                if (valueIsTextMD) {
                    this._writer.println(margn4 + XmlHandler.elementStart("value"));
                    this.showTextMDMetadata((TextMDMetadata)property.getValue());
                    this._writer.println(margn4 + XmlHandler.elementEnd("value"));
                    continue;
                }
                this._writer.println(margn4 + XmlHandler.element("value", this.valueToString(val)));
            }
        } else if (arity.equals(PropertyArity.MAP)) {
            Map propMap = (Map)property.getValue();
            for (Object key : propMap.keySet()) {
                String keystr = key.toString();
                Object val = propMap.get(key);
                String[][] attrs = new String[1][];
                String[] keyAttr = new String[]{"key", keystr};
                attrs[0] = keyAttr;
                if (valueIsProperty) {
                    Property pval = (Property)val;
                    if (pval.getName().equals(keystr)) {
                        this._writer.print(margn4 + XmlHandler.elementStart("value"));
                    } else {
                        this._writer.print(margn4 + XmlHandler.elementStart("value", attrs));
                    }
                    this.showProperty(pval);
                    this._writer.println(margn4 + XmlHandler.elementEnd("value"));
                    continue;
                }
                if (valueIsNiso) {
                    this._writer.println(margn4 + XmlHandler.elementStart("value"));
                    this.showNisoImageMetadata((NisoImageMetadata)val);
                    this._writer.println(margn4 + XmlHandler.elementEnd("value"));
                    continue;
                }
                if (valueIsAes) {
                    this._writer.println(margn4 + XmlHandler.elementStart("value"));
                    this.showAESAudioMetadata((AESAudioMetadata)val);
                    this._writer.println(margn4 + XmlHandler.elementEnd("value"));
                    continue;
                }
                if (valueIsTextMD) {
                    this._writer.println(margn4 + XmlHandler.elementStart("value"));
                    this.showTextMDMetadata((TextMDMetadata)val);
                    this._writer.println(margn4 + XmlHandler.elementEnd("value"));
                    continue;
                }
                this._writer.println(margn4 + XmlHandler.element("value", attrs, this.valueToString(val)));
            }
        } else if (arity.equals(PropertyArity.SET)) {
            Set propSet = (Set)property.getValue();
            for (Object val : propSet) {
                if (valueIsProperty) {
                    this.showProperty((Property)val);
                    continue;
                }
                this._writer.println(margn4 + XmlHandler.element("value", this.valueToString(val)));
            }
        } else if (arity.equals(PropertyArity.ARRAY)) {
            this.showArrayProperty(property, margn4);
        }
        this._writer.println(margn3 + XmlHandler.elementEnd("values"));
        this._writer.println(margn2 + XmlHandler.elementEnd("property"));
        --this._level;
    }

    private boolean isPropertyEmpty(Property property, PropertyArity arity) {
        try {
            if (arity.equals(PropertyArity.SET)) {
                Set propSet = (Set)property.getValue();
                return propSet.isEmpty();
            }
            if (arity.equals(PropertyArity.LIST)) {
                List propList = (List)property.getValue();
                return propList.isEmpty();
            }
            if (arity.equals(PropertyArity.MAP)) {
                Map propMap = (Map)property.getValue();
                return propMap.isEmpty();
            }
            if (arity.equals(PropertyArity.ARRAY)) {
                boolean[] boolArray = null;
                byte[] byteArray = null;
                char[] charArray = null;
                Date[] dateArray = null;
                double[] doubleArray = null;
                float[] floatArray = null;
                int[] intArray = null;
                long[] longArray = null;
                Object[] objArray = null;
                Property[] propArray = null;
                short[] shortArray = null;
                String[] stringArray = null;
                Rational[] rationalArray = null;
                NisoImageMetadata[] nisoArray = null;
                AESAudioMetadata[] aesArray = null;
                TextMDMetadata[] textMDArray = null;
                int n = 0;
                PropertyType propType = property.getType();
                if (PropertyType.BOOLEAN.equals(propType)) {
                    boolArray = (boolean[])property.getValue();
                    n = boolArray.length;
                } else if (PropertyType.BYTE.equals(propType)) {
                    byteArray = (byte[])property.getValue();
                    n = byteArray.length;
                } else if (PropertyType.CHARACTER.equals(propType)) {
                    charArray = (char[])property.getValue();
                    n = charArray.length;
                } else if (PropertyType.DATE.equals(propType)) {
                    dateArray = (Date[])property.getValue();
                    n = dateArray.length;
                } else if (PropertyType.DOUBLE.equals(propType)) {
                    doubleArray = (double[])property.getValue();
                    n = doubleArray.length;
                } else if (PropertyType.FLOAT.equals(propType)) {
                    floatArray = (float[])property.getValue();
                    n = floatArray.length;
                } else if (PropertyType.INTEGER.equals(propType)) {
                    intArray = (int[])property.getValue();
                    n = intArray.length;
                } else if (PropertyType.LONG.equals(propType)) {
                    longArray = (long[])property.getValue();
                    n = longArray.length;
                } else if (PropertyType.OBJECT.equals(propType)) {
                    objArray = (Object[])property.getValue();
                    n = objArray.length;
                } else if (PropertyType.SHORT.equals(propType)) {
                    shortArray = (short[])property.getValue();
                    n = shortArray.length;
                } else if (PropertyType.STRING.equals(propType)) {
                    stringArray = (String[])property.getValue();
                    n = stringArray.length;
                } else if (PropertyType.RATIONAL.equals(propType)) {
                    rationalArray = (Rational[])property.getValue();
                    n = rationalArray.length;
                } else if (PropertyType.PROPERTY.equals(propType)) {
                    propArray = (Property[])property.getValue();
                    n = propArray.length;
                } else if (PropertyType.NISOIMAGEMETADATA.equals(propType)) {
                    nisoArray = (NisoImageMetadata[])property.getValue();
                    n = nisoArray.length;
                } else if (PropertyType.AESAUDIOMETADATA.equals(propType)) {
                    aesArray = (AESAudioMetadata[])property.getValue();
                    n = aesArray.length;
                } else if (PropertyType.TEXTMDMETADATA.equals(propType)) {
                    textMDArray = (TextMDMetadata[])property.getValue();
                    n = textMDArray.length;
                }
                return n == 0;
            }
            return property.getValue().toString().length() == 0;
        }
        catch (Exception e) {
            return true;
        }
    }

    protected void showArrayProperty(Property property, String margin) {
        boolean[] boolArray = null;
        byte[] byteArray = null;
        char[] charArray = null;
        Date[] dateArray = null;
        double[] doubleArray = null;
        float[] floatArray = null;
        int[] intArray = null;
        long[] longArray = null;
        Object[] objArray = null;
        Property[] propArray = null;
        short[] shortArray = null;
        String[] stringArray = null;
        Rational[] rationalArray = null;
        NisoImageMetadata[] nisoArray = null;
        AESAudioMetadata[] aesArray = null;
        TextMDMetadata[] textMDArray = null;
        int n = 0;
        PropertyType propType = property.getType();
        if (PropertyType.BOOLEAN.equals(propType)) {
            boolArray = (boolean[])property.getValue();
            n = boolArray.length;
        } else if (PropertyType.BYTE.equals(propType)) {
            byteArray = (byte[])property.getValue();
            n = byteArray.length;
        } else if (PropertyType.CHARACTER.equals(propType)) {
            charArray = (char[])property.getValue();
            n = charArray.length;
        } else if (PropertyType.DATE.equals(propType)) {
            dateArray = (Date[])property.getValue();
            n = dateArray.length;
        } else if (PropertyType.DOUBLE.equals(propType)) {
            doubleArray = (double[])property.getValue();
            n = doubleArray.length;
        } else if (PropertyType.FLOAT.equals(propType)) {
            floatArray = (float[])property.getValue();
            n = floatArray.length;
        } else if (PropertyType.INTEGER.equals(propType)) {
            intArray = (int[])property.getValue();
            n = intArray.length;
        } else if (PropertyType.LONG.equals(propType)) {
            longArray = (long[])property.getValue();
            n = longArray.length;
        } else if (PropertyType.OBJECT.equals(propType)) {
            objArray = (Object[])property.getValue();
            n = objArray.length;
        } else if (PropertyType.SHORT.equals(propType)) {
            shortArray = (short[])property.getValue();
            n = shortArray.length;
        } else if (PropertyType.STRING.equals(propType)) {
            stringArray = (String[])property.getValue();
            n = stringArray.length;
        } else if (PropertyType.RATIONAL.equals(propType)) {
            rationalArray = (Rational[])property.getValue();
            n = rationalArray.length;
        } else if (PropertyType.PROPERTY.equals(propType)) {
            propArray = (Property[])property.getValue();
            n = propArray.length;
        } else if (PropertyType.NISOIMAGEMETADATA.equals(propType)) {
            nisoArray = (NisoImageMetadata[])property.getValue();
            n = nisoArray.length;
        } else if (PropertyType.AESAUDIOMETADATA.equals(propType)) {
            aesArray = (AESAudioMetadata[])property.getValue();
            n = aesArray.length;
        } else if (PropertyType.TEXTMDMETADATA.equals(propType)) {
            textMDArray = (TextMDMetadata[])property.getValue();
            n = textMDArray.length;
        }
        for (int i = 0; i < n; ++i) {
            String elem;
            if (PropertyType.BOOLEAN.equals(propType)) {
                elem = String.valueOf(boolArray[i]);
            } else if (PropertyType.BYTE.equals(propType)) {
                elem = String.valueOf(byteArray[i]);
            } else if (PropertyType.CHARACTER.equals(propType)) {
                elem = String.valueOf(charArray[i]);
            } else if (PropertyType.DATE.equals(propType)) {
                elem = dateArray[i].toString();
            } else if (PropertyType.DOUBLE.equals(propType)) {
                elem = String.valueOf(doubleArray[i]);
            } else if (PropertyType.FLOAT.equals(propType)) {
                elem = String.valueOf(floatArray[i]);
            } else if (PropertyType.INTEGER.equals(propType)) {
                elem = String.valueOf(intArray[i]);
            } else if (PropertyType.LONG.equals(propType)) {
                elem = String.valueOf(longArray[i]);
            } else if (PropertyType.OBJECT.equals(propType)) {
                elem = this.valueToString(objArray[i]);
            } else if (PropertyType.SHORT.equals(propType)) {
                elem = String.valueOf(shortArray[i]);
            } else if (PropertyType.STRING.equals(propType)) {
                elem = stringArray[i];
            } else if (PropertyType.RATIONAL.equals(propType)) {
                elem = rationalArray[i].toString();
            } else {
                if (PropertyType.PROPERTY.equals(propType)) {
                    this.showProperty(propArray[i]);
                    continue;
                }
                if (PropertyType.NISOIMAGEMETADATA.equals(propType)) {
                    this.showNisoImageMetadata(nisoArray[i]);
                    continue;
                }
                if (PropertyType.AESAUDIOMETADATA.equals(propType)) {
                    this.showAESAudioMetadata(aesArray[i]);
                    continue;
                }
                if (PropertyType.TEXTMDMETADATA.equals(propType)) {
                    this.showTextMDMetadata(textMDArray[i]);
                    continue;
                }
                elem = "<error>";
            }
            this._writer.println(margin + XmlHandler.element("value", elem));
        }
    }

    protected void showTextMDMetadata(TextMDMetadata textMD) {
        String[][] attrs1;
        String margin = XmlHandler.getIndent(++this._level);
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String[][] attrs = new String[][]{{"xmlns:textmd", "info:lc/xmlns/textMD-v3"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "info:lc/xmlns/textMD-v3 http://www.loc.gov/standards/textMD/textMD-v3.01a.xsd"}};
        this._writer.println(margin + XmlHandler.elementStart("textmd:textMD", attrs));
        this._writer.println(margn2 + XmlHandler.elementStart("textmd:character_info"));
        this._writer.println(margn3 + XmlHandler.element("textmd:charset", textMD.getCharset()));
        this._writer.println(margn3 + XmlHandler.element("textmd:byte_order", textMD.getByte_orderString()));
        this._writer.println(margn3 + XmlHandler.element("textmd:byte_size", textMD.getByte_size()));
        if ("variable".equals(textMD.getCharacter_size())) {
            attrs1 = new String[][]{{"encoding", textMD.getCharset()}};
            this._writer.println(margn3 + XmlHandler.element("textmd:character_size", attrs1, "variable"));
        } else if (textMD.getCharacter_size() != null && textMD.getCharacter_size().length() != 0) {
            this._writer.println(margn3 + XmlHandler.element("textmd:character_size", textMD.getCharacter_size()));
        }
        this._writer.println(margn3 + XmlHandler.element("textmd:linebreak", textMD.getLinebreakString()));
        this._writer.println(margn2 + XmlHandler.elementEnd("textmd:character_info"));
        if (textMD.getLanguage() != null && textMD.getLanguage().length() != 0) {
            this._writer.println(margn2 + XmlHandler.element("textmd:language", textMD.getLanguage()));
        }
        if (textMD.getMarkup_basis() != null && textMD.getMarkup_basis().length() != 0) {
            if (textMD.getMarkup_basis_version() != null) {
                attrs1 = new String[][]{{"version", textMD.getMarkup_basis_version()}};
                this._writer.println(margn2 + XmlHandler.element("textmd:markup_basis", attrs1, textMD.getMarkup_basis()));
            } else {
                this._writer.println(margn2 + XmlHandler.element("textmd:markup_basis", textMD.getMarkup_basis()));
            }
        }
        if (textMD.getMarkup_language() != null && textMD.getMarkup_language().length() != 0) {
            if (textMD.getMarkup_language_version() != null) {
                attrs1 = new String[][]{{"version", textMD.getMarkup_language_version()}};
                this._writer.println(margn2 + XmlHandler.element("textmd:markup_language", attrs1, textMD.getMarkup_language()));
            } else {
                this._writer.println(margn2 + XmlHandler.element("textmd:markup_language", textMD.getMarkup_language()));
            }
        }
        this._writer.println(margin + XmlHandler.elementEnd("textmd:textMD"));
        --this._level;
    }

    protected void showNisoImageMetadata(NisoImageMetadata niso) {
        if ("0.2".equals(this._je.getMixVersion())) {
            this.showNisoImageMetadata02(niso);
        } else if ("1.0".equals(this._je.getMixVersion())) {
            this.showNisoImageMetadata10(niso);
        } else {
            this.showNisoImageMetadata20(niso);
        }
    }

    protected void showNisoImageMetadata02(NisoImageMetadata niso) {
        String margin = XmlHandler.getIndent(++this._level);
        String[][] attrs = new String[][]{{"xmlns:mix", "http://www.loc.gov/mix/"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "http://www.loc.gov/mix/ http://www.loc.gov/mix/mix02.xsd"}};
        this._writer.println(margin + XmlHandler.elementStart("mix:mix", attrs));
        this.showNisoBasicImageParameters02(niso, margin);
        this.showNisoImageCreation02(niso, margin);
        this.showNisoImagingPerformanceAssessment02(niso, margin);
        this.showNisoChangeHistory02(niso, margin);
        this._writer.println(margin + XmlHandler.elementEnd("mix:mix"));
        --this._level;
    }

    protected void showNisoBasicImageParameters02(NisoImageMetadata niso, String margin) {
        long ln;
        long[] larray;
        Rational[] rarray;
        int[] iarray;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        String margn6 = margn5 + " ";
        this._writer.println(margn2 + XmlHandler.elementStart("mix:BasicImageParameters"));
        StringBuffer fBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:Format") + EOL);
        boolean useFBuf = false;
        String s = niso.getMimeType();
        if (s != null) {
            fBuf.append(margn4 + XmlHandler.element("mix:MIMEType", s) + EOL);
            useFBuf = true;
        }
        if ((s = niso.getByteOrder()) != null) {
            fBuf.append(margn4 + XmlHandler.element("mix:ByteOrder", s) + EOL);
            useFBuf = true;
        }
        int comp = niso.getCompressionScheme();
        int level = niso.getCompressionLevel();
        if (comp != -1 || level != -1) {
            fBuf.append(margn4 + XmlHandler.elementStart("mix:Compression") + EOL);
            if (comp != -1) {
                fBuf.append(margn5 + XmlHandler.element("mix:CompressionScheme", Integer.toString(comp)) + EOL);
            }
            if (level != -1) {
                fBuf.append(margn5 + XmlHandler.element("mix:CompressionLevel", Integer.toString(level)) + EOL);
            }
            fBuf.append(margn4 + XmlHandler.elementEnd("mix:Compression") + EOL);
            useFBuf = true;
        }
        StringBuffer piBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:PhotometricInterpretation") + EOL);
        boolean usePIBuf = false;
        int n = niso.getColorSpace();
        if (n != -1) {
            piBuf.append(margn5 + XmlHandler.element("mix:ColorSpace", Integer.toString(n)) + EOL);
            usePIBuf = true;
        }
        String s2 = niso.getProfileURL();
        s = niso.getProfileName();
        if (s != null || s2 != null) {
            piBuf.append(margn5 + XmlHandler.elementStart("mix:ICCProfile") + EOL);
            if (s != null) {
                piBuf.append(margn6 + XmlHandler.element("mix:ProfileName", s) + EOL);
            }
            if (s2 != null) {
                piBuf.append(margn6 + XmlHandler.element("mix:ProfileURL", s2) + EOL);
            }
            piBuf.append(margn5 + XmlHandler.elementEnd("mix:ICCProfile") + EOL);
            usePIBuf = true;
        }
        if ((iarray = niso.getYCbCrSubSampling()) != null) {
            piBuf.append(margn5 + XmlHandler.element("mix:YCbCrSubSampling", XmlHandler.integerArray(iarray)) + EOL);
            usePIBuf = true;
        }
        if ((n = niso.getYCbCrPositioning()) != -1) {
            piBuf.append(margn5 + XmlHandler.element("mix:YCbCrPositioning", Integer.toString(n)) + EOL);
            usePIBuf = true;
        }
        if ((rarray = niso.getYCbCrCoefficients()) != null) {
            piBuf.append(margn5 + XmlHandler.element("mix:YCbCrCoefficients", XmlHandler.rationalArray(rarray)) + EOL);
            usePIBuf = true;
        }
        if ((rarray = niso.getReferenceBlackWhite()) != null) {
            piBuf.append(margn5 + XmlHandler.element("mix:ReferenceBlackWhite", XmlHandler.rationalArray(rarray)) + EOL);
            usePIBuf = true;
        }
        piBuf.append(margn4 + XmlHandler.elementEnd("mix:PhotometricInterpretation") + EOL);
        if (usePIBuf) {
            fBuf.append(piBuf);
            useFBuf = true;
        }
        StringBuffer segBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:Segments") + EOL);
        boolean useSegBuf = false;
        n = niso.getSegmentType();
        if (n != -1) {
            segBuf.append(margn5 + XmlHandler.element("mix:SegmentType", Integer.toString(n)) + EOL);
            useSegBuf = true;
        }
        if ((larray = niso.getStripOffsets()) != null) {
            segBuf.append(margn5 + XmlHandler.element("mix:StripOffsets", XmlHandler.longArray(larray)) + EOL);
            useSegBuf = true;
        }
        if ((ln = niso.getRowsPerStrip()) != -1L) {
            segBuf.append(margn5 + XmlHandler.element("mix:RowsPerStrip", Long.toString(ln)) + EOL);
            useSegBuf = true;
        }
        if ((larray = niso.getStripByteCounts()) != null) {
            segBuf.append(margn5 + XmlHandler.element("mix:StripByteCounts", XmlHandler.longArray(larray)) + EOL);
            useSegBuf = true;
        }
        if ((ln = niso.getTileWidth()) != -1L) {
            segBuf.append(margn5 + XmlHandler.element("mix:TileWidth", Long.toString(ln)) + EOL);
            useSegBuf = true;
        }
        if ((ln = niso.getTileLength()) != -1L) {
            segBuf.append(margn5 + XmlHandler.element("mix:TileLength", Long.toString(ln)) + EOL);
            useSegBuf = true;
        }
        if ((larray = niso.getTileOffsets()) != null) {
            segBuf.append(margn5 + XmlHandler.element("mix:TileOffsets", XmlHandler.longArray(larray)) + EOL);
            useSegBuf = true;
        }
        if ((larray = niso.getTileByteCounts()) != null) {
            segBuf.append(margn5 + XmlHandler.element("mix:TileByteCounts", XmlHandler.longArray(larray)) + EOL);
            useSegBuf = true;
        }
        segBuf.append(margn4 + XmlHandler.elementEnd("mix:Segments") + EOL);
        if (useSegBuf) {
            fBuf.append(segBuf);
            useFBuf = true;
        }
        if ((n = niso.getPlanarConfiguration()) != -1) {
            fBuf.append(margn4 + XmlHandler.element("mix:PlanarConfiguration", Integer.toString(n)) + EOL);
        }
        fBuf.append(margn3 + XmlHandler.elementEnd("mix:Format") + EOL);
        if (useFBuf) {
            this._writer.print(fBuf.toString());
        }
        StringBuffer fileBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:File") + EOL);
        boolean useFileBuf = false;
        s = niso.getImageIdentifier();
        if (s != null) {
            fileBuf.append(margn4 + XmlHandler.element("mix:ImageIdentifier", s) + EOL);
            useFileBuf = true;
        }
        if ((ln = niso.getFileSize()) != -1L) {
            fileBuf.append(margn4 + XmlHandler.element("mix:FileSize", Long.toString(ln)) + EOL);
            useFileBuf = true;
        }
        n = niso.getChecksumMethod();
        s = niso.getChecksumValue();
        if (n != -1 || s != null) {
            fileBuf.append(margn4 + XmlHandler.elementStart("mix:Checksum") + EOL);
            if (n != -1) {
                fileBuf.append(margn5 + XmlHandler.element("mix:ChecksumMethod", Integer.toString(n)) + EOL);
            }
            if (s != null) {
                fileBuf.append(margn5 + XmlHandler.element("mix:ChecksumValue", s) + EOL);
            }
            fileBuf.append(margn4 + XmlHandler.elementEnd("mix:Checksum") + EOL);
            useFileBuf = true;
        }
        if ((n = niso.getOrientation()) != -1) {
            fileBuf.append(margn4 + XmlHandler.element("mix:Orientation", Integer.toString(n)) + EOL);
            useFileBuf = true;
        }
        if ((n = niso.getDisplayOrientation()) != -1) {
            fileBuf.append(margn4 + XmlHandler.element("mix:DisplayOrientation", Integer.toString(n)) + EOL);
            useFileBuf = true;
        }
        ln = niso.getXTargetedDisplayAR();
        long ln2 = niso.getYTargetedDisplayAR();
        if (ln != -1L || ln2 != -1L) {
            fileBuf.append(margn4 + XmlHandler.elementStart("mix:TargetedDisplayAR") + EOL);
            if (ln != -1L) {
                fileBuf.append(margn5 + XmlHandler.element("mix:XTargetedDisplayAR", Long.toString(ln)) + EOL);
            }
            if (ln2 != -1L) {
                fileBuf.append(margn5 + XmlHandler.element("mix:YTargetedDisplayAR", Long.toString(ln2)) + EOL);
            }
            fileBuf.append(margn4 + XmlHandler.elementEnd("mix:TargetedDisplayAR") + EOL);
            useFileBuf = true;
        }
        fileBuf.append(margn3 + XmlHandler.elementEnd("mix:File") + EOL);
        if (useFileBuf) {
            this._writer.print(fileBuf.toString());
        }
        this._writer.println(margn2 + XmlHandler.elementEnd("mix:BasicImageParameters"));
    }

    protected void showNisoImageCreation02(NisoImageMetadata niso, String margin) {
        int n;
        double[] darray;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        String margn6 = margn5 + " ";
        this._writer.println(margn2 + XmlHandler.elementStart("mix:ImageCreation"));
        String s = niso.getSourceType();
        if (s != null) {
            this._writer.println(margn3 + XmlHandler.element("mix:SourceType", s));
        }
        if ((s = niso.getSourceID()) != null) {
            this._writer.println(margn3 + XmlHandler.element("mix:SourceID", s));
        }
        if ((s = niso.getImageProducer()) != null) {
            this._writer.println(margn3 + XmlHandler.element("mix:ImageProducer", s));
        }
        StringBuffer hostBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:Host") + EOL);
        boolean useHostBuf = false;
        s = niso.getHostComputer();
        if (s != null) {
            hostBuf.append(margn4 + XmlHandler.element("mix:HostComputer", s) + EOL);
            useHostBuf = true;
        }
        if ((s = niso.getOS()) != null) {
            hostBuf.append(margn4 + XmlHandler.element("mix:OperatingSystem", s) + EOL);
            useHostBuf = true;
        }
        if ((s = niso.getOSVersion()) != null) {
            hostBuf.append(margn4 + XmlHandler.element("mix:OSVersion", s) + EOL);
            useHostBuf = true;
        }
        hostBuf.append(margn3 + XmlHandler.elementEnd("mix:Host") + EOL);
        if (useHostBuf) {
            this._writer.print(hostBuf);
        }
        if ((s = niso.getDeviceSource()) != null) {
            this._writer.println(margn3 + XmlHandler.element("mix:DeviceSource", s));
        }
        StringBuffer sscBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:ScanningSystemCapture") + EOL);
        boolean useSSCBuf = false;
        StringBuffer sshBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:ScanningSystemHardware") + EOL);
        boolean useSSHBuf = false;
        s = niso.getScannerManufacturer();
        if (s != null) {
            sshBuf.append(margn5 + XmlHandler.element("mix:ScannerManufacturer", s) + EOL);
            useSSHBuf = true;
        }
        s = niso.getScannerModelName();
        String s1 = niso.getScannerModelNumber();
        String s2 = niso.getScannerModelSerialNo();
        if (s != null || s1 != null || s2 != null) {
            sshBuf.append(margn5 + XmlHandler.elementStart("mix:ScannerModel") + EOL);
            if (s != null) {
                sshBuf.append(margn6 + XmlHandler.element("mix:ScannerModelName", s) + EOL);
                useSSHBuf = true;
            }
            if (s1 != null) {
                sshBuf.append(margn6 + XmlHandler.element("mix:ScannerModelNumber", s1) + EOL);
                useSSHBuf = true;
            }
            if (s2 != null) {
                sshBuf.append(margn6 + XmlHandler.element("mix:ScannerModelSerialNo ", s2) + EOL);
                useSSHBuf = true;
            }
            sshBuf.append(margn5 + XmlHandler.elementEnd("mix:ScannerModel") + EOL);
        }
        sshBuf.append(margn4 + XmlHandler.elementEnd("mix:ScanningSystemHardware") + EOL);
        if (useSSHBuf) {
            sscBuf.append(sshBuf);
            useSSCBuf = true;
        }
        StringBuffer sssBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:ScanningSystemSoftware") + EOL);
        boolean useSSSBuf = false;
        s = niso.getScanningSoftware();
        if (s != null) {
            sssBuf.append(margn5 + XmlHandler.element("mix:ScanningSoftware", s) + EOL);
            useSSSBuf = true;
        }
        if ((s = niso.getScanningSoftwareVersionNo()) != null) {
            sssBuf.append(margn5 + XmlHandler.element("mix:ScanningSoftwareVersionNo", s) + EOL);
            useSSSBuf = true;
        }
        sssBuf.append(margn4 + XmlHandler.elementEnd("mix:ScanningSystemSoftware") + EOL);
        if (useSSSBuf) {
            sscBuf.append(sssBuf);
            useSSCBuf = true;
        }
        StringBuffer scsBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:ScannerCaptureSettings") + EOL);
        boolean useSCSBuf = false;
        double d = niso.getPixelSize();
        if (d != -1.0) {
            scsBuf.append(margn5 + XmlHandler.element("mix:PixelSize", formatters.get().format(d)) + EOL);
            useSCSBuf = true;
        }
        d = niso.getXPhysScanResolution();
        double d1 = niso.getYPhysScanResolution();
        if (d != -1.0 || d1 != -1.0) {
            scsBuf.append(margn5 + XmlHandler.elementStart("mix:PhysScanResolution") + EOL);
            if (d != -1.0) {
                scsBuf.append(margn6 + XmlHandler.element("mix:XphysScanResolution", formatters.get().format(d)) + EOL);
            }
            if (d1 != -1.0) {
                scsBuf.append(margn6 + XmlHandler.element("mix:YphysScanResolution", formatters.get().format(d1)) + EOL);
            }
            scsBuf.append(margn5 + XmlHandler.elementEnd("mix:PhysScanResolution") + EOL);
            useSCSBuf = true;
        }
        scsBuf.append(margn4 + XmlHandler.elementEnd("mix:ScannerCaptureSettings") + EOL);
        if (useSCSBuf) {
            sscBuf.append(scsBuf);
            useSSCBuf = true;
        }
        sscBuf.append(margn3 + XmlHandler.elementEnd("mix:ScanningSystemCapture") + EOL);
        if (useSSCBuf) {
            this._writer.print(sscBuf.toString());
        }
        StringBuffer dccBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:DigitalCameraCapture") + EOL);
        boolean useDCCBuf = false;
        s = niso.getDigitalCameraManufacturer();
        if (s != null) {
            dccBuf.append(margn4 + XmlHandler.element("mix:DigitalCameraManufacturer", s) + EOL);
            useDCCBuf = true;
        }
        if ((s = niso.getDigitalCameraModelName()) != null) {
            dccBuf.append(margn4 + XmlHandler.element("mix:DigitalCameraModel", s) + EOL);
            useDCCBuf = true;
        }
        dccBuf.append(margn3 + XmlHandler.elementEnd("mix:DigitalCameraCapture") + EOL);
        if (useDCCBuf) {
            this._writer.print(dccBuf.toString());
        }
        StringBuffer ccsBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:CameraCaptureSettings") + EOL);
        boolean useCCSBuf = false;
        d = niso.getFNumber();
        if (d != -1.0) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:FNumber", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((d = niso.getExposureTime()) != -1.0) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:ExposureTime", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((d = niso.getBrightness()) != -1.0) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:Brightness", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((d = niso.getExposureBias()) != -1.0) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:ExposureBias", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((darray = niso.getSubjectDistance()) != null) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:SubjectDistance", XmlHandler.doubleArray(darray)) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getMeteringMode()) != -1) {
            s = this.meteringModeToString(n);
            if (s.startsWith("Center weighted")) {
                s = "Center weighted Average";
            }
            ccsBuf.append(margn4 + XmlHandler.element("mix:MeteringMode", s) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getSceneIlluminant()) != -1) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:SceneIlluminant", Integer.toString(n)) + EOL);
            useCCSBuf = true;
        }
        if ((d = niso.getColorTemp()) != -1.0) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:ColorTemp", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((d = niso.getFocalLength()) != -1.0) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:FocalLength", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getFlash()) != -1) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:Flash", Integer.toString(n)) + EOL);
            useCCSBuf = true;
        }
        if ((d = niso.getFlashEnergy()) != -1.0) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:FlashEnergy", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getFlashReturn()) != -1) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:FlashReturn", Integer.toString(n)) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getBackLight()) != -1) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:BackLight", Integer.toString(n)) + EOL);
            useCCSBuf = true;
        }
        if ((d = niso.getExposureIndex()) != -1.0) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:ExposureIndex", formatters.get().format(d)) + EOL);
            useCCSBuf = true;
        }
        if ((n = niso.getAutoFocus()) != -1) {
            ccsBuf.append(margn4 + XmlHandler.element("mix:AutoFocus", Integer.toString(n)) + EOL);
            useCCSBuf = true;
        }
        d = niso.getXPrintAspectRatio();
        d1 = niso.getYPrintAspectRatio();
        if (d != -1.0 || d1 != -1.0) {
            ccsBuf.append(margn4 + XmlHandler.elementStart("mix:PrintAspectRatio") + EOL);
            if (d != -1.0) {
                ccsBuf.append(margn5 + XmlHandler.element("mix:XPrintAspectRatio", formatters.get().format(d)) + EOL);
            }
            if (d1 != -1.0) {
                ccsBuf.append(margn5 + XmlHandler.element("mix:YPrintAspectRatio", formatters.get().format(d1)) + EOL);
                ccsBuf.append(margn4 + XmlHandler.elementEnd("mix:PrintAspectRatio") + EOL);
                useCCSBuf = true;
            }
        }
        ccsBuf.append(margn3 + XmlHandler.elementEnd("mix:CameraCaptureSettings") + EOL);
        if (useCCSBuf) {
            this._writer.print(ccsBuf.toString());
        }
        if ((n = niso.getSensor()) != -1) {
            this._writer.println(margn3 + XmlHandler.element("mix:Sensor", Integer.toString(n)));
        }
        if ((s = niso.getDateTimeCreated()) != null) {
            this._writer.println(margn3 + XmlHandler.element("mix:DateTimeCreated", s));
        }
        if ((s = niso.getMethodology()) != null) {
            this._writer.println(margn3 + XmlHandler.element("mix:Methodology", s));
        }
        this._writer.println(margn2 + XmlHandler.elementEnd("mix:ImageCreation"));
    }

    protected void showNisoImagingPerformanceAssessment02(NisoImageMetadata niso, String margin) {
        long ln;
        Rational r;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        String margn6 = margn5 + " ";
        String margn7 = margn6 + " ";
        StringBuffer ipaBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:ImagingPerformanceAssessment") + EOL);
        boolean useIPABuf = false;
        StringBuffer smBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:SpatialMetrics") + EOL);
        boolean useSMBuf = false;
        int n = niso.getSamplingFrequencyPlane();
        if (n != -1) {
            smBuf.append(margn5 + XmlHandler.element("mix:SamplingFrequencyPlane", Integer.toString(n)) + EOL);
            useSMBuf = true;
        }
        if ((n = niso.getSamplingFrequencyUnit()) != -1) {
            smBuf.append(margn5 + XmlHandler.element("mix:SamplingFrequencyUnit", Integer.toString(n)) + EOL);
            useSMBuf = true;
        }
        if ((r = niso.getXSamplingFrequency()) != null) {
            smBuf.append(margn5 + XmlHandler.element("mix:XSamplingFrequency", Long.toString(r.toLong())) + EOL);
            useSMBuf = true;
        }
        if ((r = niso.getYSamplingFrequency()) != null) {
            smBuf.append(margn5 + XmlHandler.element("mix:YSamplingFrequency", Long.toString(r.toLong())) + EOL);
            useSMBuf = true;
        }
        if ((ln = niso.getImageWidth()) != -1L) {
            smBuf.append(margn5 + XmlHandler.element("mix:ImageWidth", Long.toString(ln)) + EOL);
            useSMBuf = true;
        }
        if ((ln = niso.getImageLength()) != -1L) {
            smBuf.append(margn5 + XmlHandler.element("mix:ImageLength", Long.toString(ln)) + EOL);
            useSMBuf = true;
        }
        double d = niso.getSourceXDimension();
        n = niso.getSourceXDimensionUnit();
        if (d != -1.0 || n != -1) {
            smBuf.append(margn5 + XmlHandler.elementStart("mix:Source_X") + EOL);
            if (d != -1.0) {
                smBuf.append(margn6 + XmlHandler.element("mix:Source_Xdimension", formatters.get().format(d)) + EOL);
            }
            if (n != -1) {
                smBuf.append(margn6 + XmlHandler.element("mix:Source_XdimensionUnit", Integer.toString(n)) + EOL);
            }
            smBuf.append(margn5 + XmlHandler.elementEnd("mix:Source_X") + EOL);
            useSMBuf = true;
        }
        d = niso.getSourceYDimension();
        n = niso.getSourceYDimensionUnit();
        if (d != -1.0 || n != -1) {
            smBuf.append(margn4 + XmlHandler.elementStart("mix:Source_Y") + EOL);
            if (d != -1.0) {
                smBuf.append(margn5 + XmlHandler.element("mix:Source_Ydimension", formatters.get().format(d)) + EOL);
            }
            if (n != -1) {
                smBuf.append(margn5 + XmlHandler.element("mix:Source_YdimensionUnit", Integer.toString(n)) + EOL);
            }
            smBuf.append(margn4 + XmlHandler.elementEnd("mix:Source_Y") + EOL);
            useSMBuf = true;
        }
        smBuf.append(margn3 + XmlHandler.elementEnd("mix:SpatialMetrics") + EOL);
        if (useSMBuf) {
            ipaBuf.append(smBuf);
            useIPABuf = true;
        }
        StringBuffer eBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:Energetics") + EOL);
        boolean useEBuf = false;
        int[] iarray = niso.getBitsPerSample();
        if (iarray != null) {
            eBuf.append(margn4 + XmlHandler.element("mix:BitsPerSample", XmlHandler.integerArray(iarray, ',')) + EOL);
            useEBuf = true;
        }
        if ((n = niso.getSamplesPerPixel()) != -1) {
            eBuf.append(margn4 + XmlHandler.element("mix:SamplesPerPixel", Integer.toString(n)) + EOL);
            useEBuf = true;
        }
        if ((iarray = niso.getExtraSamples()) != null && (n = iarray[0]) >= 0 && n <= 3) {
            eBuf.append(margn4 + XmlHandler.element("mix:ExtraSamples", Integer.toString(n)) + EOL);
            useEBuf = true;
        }
        StringBuffer cmBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:Colormap") + EOL);
        boolean useCMBuf = false;
        String s = niso.getColormapReference();
        if (s != null) {
            cmBuf.append(margn5 + XmlHandler.element("mix:Reference", s) + EOL);
            useCMBuf = true;
        }
        if ((iarray = niso.getColormapRedValue()) != null) {
            cmBuf.append(margn5 + XmlHandler.elementStart("mix:Wrap"));
            int[] bcarray = niso.getColormapBitCodeValue();
            int[] garray = niso.getColormapGreenValue();
            int[] barray = niso.getColormapBlueValue();
            try {
                for (int i = 0; i < iarray.length; ++i) {
                    cmBuf.append(margn6 + XmlHandler.elementStart("mix:Color") + EOL);
                    n = bcarray[i];
                    if (n != -1) {
                        cmBuf.append(margn7 + XmlHandler.element("mix:BitCodeValue", Integer.toString(n)) + EOL);
                    }
                    if ((n = iarray[i]) != -1) {
                        cmBuf.append(margn7 + XmlHandler.element("mix:RedValue", Integer.toString(n)) + EOL);
                    }
                    if ((n = garray[i]) != -1) {
                        cmBuf.append(margn7 + XmlHandler.element("mix:GreenValue", Integer.toString(n)) + EOL);
                    }
                    if ((n = barray[i]) != -1) {
                        cmBuf.append(margn7 + XmlHandler.element("mix:BlueValue", Integer.toString(n)) + EOL);
                    }
                    cmBuf.append(margn6 + XmlHandler.elementEnd("mix:Color") + EOL);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            cmBuf.append(margn5 + XmlHandler.elementEnd("mix:Wrap") + EOL);
            useCMBuf = true;
        }
        cmBuf.append(margn4 + XmlHandler.elementEnd("mix:Colormap"));
        if (useCMBuf) {
            eBuf.append(cmBuf);
            useEBuf = true;
        }
        iarray = niso.getGrayResponseCurve();
        n = niso.getGrayResponseUnit();
        if (iarray != null || n != -1) {
            eBuf.append(margn4 + XmlHandler.elementStart("mix:GrayResponse") + EOL);
            if (iarray != null) {
                eBuf.append(margn5 + XmlHandler.element("mix:GrayResponseCurve", XmlHandler.integerArray(iarray)) + EOL);
            }
            if (n != -1) {
                eBuf.append(margn5 + XmlHandler.element("mix:GrayResponseUnit", Integer.toString(n)) + EOL);
            }
            eBuf.append(margn4 + XmlHandler.elementEnd("mix:GrayResponse") + EOL);
            useEBuf = true;
        }
        r = niso.getWhitePointXValue();
        Rational r1 = niso.getWhitePointYValue();
        if (r != null || r1 != null) {
            eBuf.append(margn4 + XmlHandler.elementStart("mix:WhitePoint") + EOL);
            if (r != null) {
                eBuf.append(margn5 + XmlHandler.element("mix:WhitePoint_Xvalue", r.toString()) + EOL);
            }
            if (r1 != null) {
                eBuf.append(margn5 + XmlHandler.element("mix:WhitePoint_Yvalue", r1.toString()) + EOL);
            }
            eBuf.append(margn4 + XmlHandler.elementEnd("mix:WhitePoint") + EOL);
            useEBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesRedX()) != null) {
            eBuf.append(margn4 + XmlHandler.elementStart("mix:PrimaryChromaticities") + EOL);
            eBuf.append(margn5 + XmlHandler.element("mix:PrimaryChromaticities_RedX", r.toString()) + EOL);
            r = niso.getPrimaryChromaticitiesRedY();
            if (r != null) {
                eBuf.append(margn5 + XmlHandler.element("mix:PrimaryChromaticities_RedY", r.toString()) + EOL);
            }
            if ((r = niso.getPrimaryChromaticitiesGreenX()) != null) {
                eBuf.append(margn5 + XmlHandler.element("mix:PrimaryChromaticities_GreenX", r.toString()) + EOL);
            }
            if ((r = niso.getPrimaryChromaticitiesGreenY()) != null) {
                eBuf.append(margn5 + XmlHandler.element("mix:PrimaryChromaticities_GreenY", r.toString()) + EOL);
            }
            if ((r = niso.getPrimaryChromaticitiesBlueX()) != null) {
                eBuf.append(margn5 + XmlHandler.element("mix:PrimaryChromaticities_BlueX", r.toString()) + EOL);
            }
            if ((r = niso.getPrimaryChromaticitiesBlueY()) != null) {
                eBuf.append(margn5 + XmlHandler.element("mix:PrimaryChromaticities_BlueY", r.toString()) + EOL);
            }
            eBuf.append(margn4 + XmlHandler.elementEnd("mix:PrimaryChromaticities") + EOL);
            useEBuf = true;
        }
        eBuf.append(margn3 + XmlHandler.elementEnd("mix:Energetics") + EOL);
        if (useEBuf) {
            ipaBuf.append(eBuf);
            useIPABuf = true;
        }
        StringBuffer tdBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:TargetData") + EOL);
        boolean useTDBuf = false;
        n = niso.getTargetType();
        if (n != -1) {
            tdBuf.append(margn4 + XmlHandler.element("mix:TargetType", Integer.toString(n)) + EOL);
            useTDBuf = true;
        }
        StringBuffer tiBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:TargetID") + EOL);
        boolean useTIBuf = false;
        s = niso.getTargetIDManufacturer();
        if (s != null) {
            tiBuf.append(margn5 + XmlHandler.element("mix:TargetIDManufacturer", s) + EOL);
            useTIBuf = true;
        }
        if ((s = niso.getTargetIDName()) != null) {
            tiBuf.append(margn5 + XmlHandler.element("mix:TargetIDName", s) + EOL);
            useTIBuf = true;
        }
        if ((s = niso.getTargetIDNo()) != null) {
            tiBuf.append(margn5 + XmlHandler.element("mix:TargetIDNo", s) + EOL);
            useTIBuf = true;
        }
        if ((s = niso.getTargetIDMedia()) != null) {
            tiBuf.append(margn5 + XmlHandler.element("mix:TargetIDMedia", s) + EOL);
            useTIBuf = true;
        }
        tiBuf.append(margn4 + XmlHandler.elementEnd("mix:TargetID") + EOL);
        if (useTIBuf) {
            tdBuf.append(tiBuf);
            useTDBuf = true;
        }
        if ((s = niso.getImageData()) != null) {
            tdBuf.append(margn5 + XmlHandler.element("mix:ImageData", s) + EOL);
            useTDBuf = true;
        }
        if ((s = niso.getPerformanceData()) != null) {
            tdBuf.append(margn5 + XmlHandler.element("mix:PerformanceData", s) + EOL);
            useTDBuf = true;
        }
        if ((s = niso.getProfiles()) != null) {
            tdBuf.append(margn5 + XmlHandler.element("mix:Profiles", s) + EOL);
            useTDBuf = true;
        }
        tdBuf.append(margn3 + XmlHandler.elementEnd("mix:TargetData") + EOL);
        if (useTDBuf) {
            ipaBuf.append(tdBuf);
            useIPABuf = true;
        }
        ipaBuf.append(margn2 + XmlHandler.elementEnd("mix:ImagingPerformanceAssessment") + EOL);
        if (useIPABuf) {
            this._writer.print(ipaBuf.toString());
        }
    }

    protected void showNisoChangeHistory02(NisoImageMetadata niso, String margin) {
        String[] sarray;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        StringBuffer chBuf = new StringBuffer(margn2 + XmlHandler.elementStart("mix:ChangeHistory") + EOL);
        boolean useCHBuf = false;
        StringBuffer ipBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:ImageProcessing") + EOL);
        boolean useIPBuf = false;
        String s = niso.getDateTimeProcessed();
        if (s != null) {
            ipBuf.append(margn4 + XmlHandler.element("DateTimeProcessed", s) + EOL);
            useIPBuf = true;
        }
        if ((s = niso.getSourceData()) != null) {
            ipBuf.append(margn4 + XmlHandler.element("SourceData", s) + EOL);
            useIPBuf = true;
        }
        if ((s = niso.getProcessingAgency()) != null) {
            ipBuf.append(margn4 + XmlHandler.element("ProcessingAgency", s) + EOL);
            useIPBuf = true;
        }
        StringBuffer psBuf = new StringBuffer(margn4 + XmlHandler.elementStart("ProcessingSoftware") + EOL);
        boolean usePSBuf = false;
        s = niso.getProcessingSoftwareName();
        if (s != null) {
            psBuf.append(margn5 + XmlHandler.element("ProcessingSoftwareName", s) + EOL);
            usePSBuf = true;
        }
        if ((s = niso.getProcessingSoftwareVersion()) != null) {
            psBuf.append(margn5 + XmlHandler.element("ProcessingSoftwareVersion", s) + EOL);
            usePSBuf = true;
        }
        psBuf.append(margn4 + XmlHandler.elementEnd("ProcessingSoftware") + EOL);
        if (usePSBuf) {
            ipBuf.append(psBuf);
            useIPBuf = true;
        }
        if ((sarray = niso.getProcessingActions()) != null) {
            for (int i = 0; i < sarray.length; ++i) {
                ipBuf.append(margn4 + XmlHandler.element("ProcessingActions", sarray[i]) + EOL);
            }
            useIPBuf = true;
        }
        ipBuf.append(margn3 + XmlHandler.elementEnd("mix:ImageProcessing") + EOL);
        if (useIPBuf) {
            chBuf.append(ipBuf);
            useCHBuf = true;
        }
        chBuf.append(margn2 + XmlHandler.elementEnd("mix:ChangeHistory") + EOL);
        if (useCHBuf) {
            this._writer.print(chBuf.toString());
        }
    }

    protected void showNisoImageMetadata10(NisoImageMetadata niso) {
        String margin = XmlHandler.getIndent(++this._level);
        String[][] attrs = new String[][]{{"xmlns:mix", "http://www.loc.gov/mix/v10"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "http://www.loc.gov/mix/v10 http://www.loc.gov/standards/mix/mix10/mix10.xsd"}};
        this._writer.println(margin + XmlHandler.elementStart("mix:mix", attrs));
        this.showNisoBasicDigitalObjectInformation10(niso, margin);
        this.showNisoBasicImageInformation10(niso, margin);
        this.showNisoImageCaptureMetadata10(niso, margin);
        this.showNisoImageAssessmentMetadata10(niso, margin);
        this.showChangeHistory10(niso, margin);
        this._writer.println(margin + XmlHandler.elementEnd("mix:mix"));
        --this._level;
    }

    protected void showNisoBasicDigitalObjectInformation10(NisoImageMetadata niso, String margin) {
        long ln;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        this._writer.println(margn2 + XmlHandler.elementStart("mix:BasicDigitalObjectInformation"));
        StringBuffer objIDBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:ObjectIdentifier") + EOL);
        boolean useObjIDBuf = false;
        objIDBuf.append(margn4 + XmlHandler.element("mix:objectIdentifierType", "JHOVE") + EOL);
        String s = niso.getImageIdentifier();
        if (s != null) {
            objIDBuf.append(margn4 + XmlHandler.element("mix:objectIdentifierValue", s) + EOL);
            useObjIDBuf = true;
        }
        objIDBuf.append(margn3 + XmlHandler.elementEnd("mix:ObjectIdentifier") + EOL);
        if (useObjIDBuf) {
            this._writer.print(objIDBuf.toString());
        }
        if ((ln = niso.getFileSize()) != -1L) {
            this._writer.print(margn4 + XmlHandler.element("mix:fileSize", Long.toString(ln)) + EOL);
        }
        if ((s = niso.getByteOrder()) != null) {
            if (s.startsWith("big")) {
                s = "big_endian";
            } else if (s.startsWith("little")) {
                s = "little_endian";
            }
            this._writer.print(margn4 + XmlHandler.element("mix:byteOrder", s) + EOL);
        }
        int comp = niso.getCompressionScheme();
        int level = niso.getCompressionLevel();
        if (comp != -1 || level != -1) {
            this._writer.print(margn4 + XmlHandler.elementStart("mix:Compression") + EOL);
            if (comp != -1) {
                this._writer.print(margn5 + XmlHandler.element("mix:compressionScheme", Integer.toString(comp)) + EOL);
            }
            this._writer.print(margn4 + XmlHandler.elementEnd("mix:Compression") + EOL);
        }
        int n = niso.getChecksumMethod();
        s = niso.getChecksumValue();
        if (n != -1 || s != null) {
            this._writer.print(margn4 + XmlHandler.elementStart("mix:Fixity") + EOL);
            if (n != -1) {
                this._writer.print(margn5 + XmlHandler.element("mix:messageDigestAlgorithm", Integer.toString(n)) + EOL);
            }
            if (s != null) {
                this._writer.print(margn5 + XmlHandler.element("mix:messageDigest", s) + EOL);
            }
            this._writer.println(margn4 + XmlHandler.elementEnd("mix:Fixity"));
        }
        this._writer.println(margn3 + XmlHandler.elementEnd("mix:BasicDigitalObjectInformation"));
    }

    protected void showNisoBasicImageInformation10(NisoImageMetadata niso, String margin) {
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        String margn6 = margn5 + " ";
        String margn7 = margn6 + " ";
        this._writer.println(margn2 + XmlHandler.elementStart("mix:BasicImageInformation"));
        StringBuffer basCharBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:BasicImageCharacteristics") + EOL);
        boolean useBasCharBuf = false;
        long ln = niso.getImageWidth();
        if (ln != -1L) {
            basCharBuf.append(margn4 + XmlHandler.element("mix:imageWidth", Long.toString(ln)) + EOL);
            useBasCharBuf = true;
        }
        if ((ln = niso.getImageLength()) != -1L) {
            basCharBuf.append(margn4 + XmlHandler.element("mix:imageHeight", Long.toString(ln)) + EOL);
            useBasCharBuf = true;
        }
        StringBuffer piBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:PhotometricInterpretation") + EOL);
        boolean usePIBuf = false;
        int n = niso.getColorSpace();
        if (n != -1) {
            piBuf.append(margn5 + XmlHandler.element("mix:colorSpace", Integer.toString(n)) + EOL);
            usePIBuf = true;
        }
        String s = niso.getProfileName();
        String s2 = niso.getProfileURL();
        if (s != null || s2 != null) {
            piBuf.append(margn5 + XmlHandler.elementStart("mix:ColorProfile") + EOL);
            piBuf.append(margn6 + XmlHandler.elementStart("mix:IccProfile") + EOL);
            if (s != null) {
                piBuf.append(margn7 + XmlHandler.element("mix:iccProfileName", s) + EOL);
            }
            if (s2 != null) {
                piBuf.append(margn7 + XmlHandler.element("mix:iccProfileURL", s2) + EOL);
            }
            piBuf.append(margn6 + XmlHandler.elementEnd("mix:IccProfile") + EOL);
            piBuf.append(margn5 + XmlHandler.elementEnd("mix:ColorProfile") + EOL);
            usePIBuf = true;
        }
        int[] iarray = niso.getYCbCrSubSampling();
        n = niso.getYCbCrPositioning();
        Rational[] rarray = niso.getYCbCrCoefficients();
        if (iarray != null || n != -1 || rarray != null) {
            piBuf.append(margn5 + XmlHandler.elementStart("mix:YCbCr") + EOL);
            usePIBuf = true;
            if (iarray != null && iarray.length >= 2) {
                piBuf.append(margn6 + XmlHandler.elementStart("mix:YCbCrSubSampling") + EOL);
                piBuf.append(margn7 + XmlHandler.element("mix:yCbCrSubsampleHoriz", Integer.toString(iarray[0])) + EOL);
                piBuf.append(margn7 + XmlHandler.element("mix:yCbCrSubsampleVert", Integer.toString(iarray[1])) + EOL);
                piBuf.append(margn6 + XmlHandler.elementEnd("mix:YCbCrSubSampling") + EOL);
            }
            if (n != -1) {
                piBuf.append(margn6 + XmlHandler.element("mix:yCbCrPositioning", Integer.toString(n)) + EOL);
            }
            if (rarray != null) {
                piBuf.append(margn6 + XmlHandler.element("mix:yCbCrCoefficients", XmlHandler.rationalArray10(rarray)) + EOL);
            }
            piBuf.append(margn5 + XmlHandler.elementEnd("mix:YCbCr") + EOL);
        }
        if ((rarray = niso.getReferenceBlackWhite()) != null) {
            piBuf.append(margn6 + XmlHandler.element("mix:referenceBlackWhite", XmlHandler.rationalArray10(rarray)) + EOL);
            usePIBuf = true;
        }
        piBuf.append(margn4 + XmlHandler.elementEnd("mix:PhotometricInterpretation") + EOL);
        if (usePIBuf) {
            basCharBuf.append(piBuf);
            useBasCharBuf = true;
        }
        basCharBuf.append(margn3 + XmlHandler.elementEnd("mix:BasicImageCharacteristics"));
        if (useBasCharBuf) {
            this._writer.println(basCharBuf);
        }
        this._writer.println(margn2 + XmlHandler.elementEnd("mix:BasicImageInformation"));
    }

    protected void showNisoImageCaptureMetadata10(NisoImageMetadata niso, String margin) {
        double[] darray;
        Rational r;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        String margn6 = margn5 + " ";
        String margn7 = margn6 + " ";
        StringBuffer captureBuffer = new StringBuffer();
        boolean useCaptureBuffer = false;
        String s = niso.getSourceType();
        if (s != null) {
            captureBuffer.append(margn3 + XmlHandler.element("mix:sourceType", s));
            useCaptureBuffer = true;
        }
        if ((s = niso.getSourceID()) != null) {
            captureBuffer.append(margn3 + XmlHandler.elementStart("mix:SourceID"));
            captureBuffer.append(margn3 + XmlHandler.element("mix:sourceIDValue", s));
            captureBuffer.append(margn3 + XmlHandler.elementEnd("mix:sourceID"));
            useCaptureBuffer = true;
        }
        double d = niso.getSourceXDimension();
        int n = niso.getSourceXDimensionUnit();
        if (d != -1.0 || n != -1) {
            captureBuffer.append(margn3 + XmlHandler.elementStart("mix:SourceSize"));
            captureBuffer.append(margn4 + XmlHandler.elementStart("mix:SourceXDimension") + EOL);
            if (d != -1.0) {
                captureBuffer.append(margn5 + XmlHandler.element("mix:sourceXDimensionValue", formatters.get().format(d)) + EOL);
            }
            if (n != -1) {
                captureBuffer.append(margn5 + XmlHandler.element("mix:sourceXDimensionUnit", Integer.toString(n)) + EOL);
            }
            captureBuffer.append(margn4 + XmlHandler.elementEnd("mix:SourceXDimension") + EOL);
            d = niso.getSourceYDimension();
            n = niso.getSourceYDimensionUnit();
            if (d != -1.0 || n != -1) {
                captureBuffer.append(margn4 + XmlHandler.elementStart("mix:SourceYDimension") + EOL);
                if (d != -1.0) {
                    captureBuffer.append(margn5 + XmlHandler.element("mix:sourceYDimensionValue", formatters.get().format(d)) + EOL);
                }
                if (n != -1) {
                    captureBuffer.append(margn5 + XmlHandler.element("mix:sourceYDimensionUnit", Integer.toString(n)) + EOL);
                }
                captureBuffer.append(margn4 + XmlHandler.elementEnd("mix:SourceYDimension") + EOL);
            }
            captureBuffer.append(margn3 + XmlHandler.elementEnd("mix:SourceSize") + EOL);
            useCaptureBuffer = true;
        }
        StringBuffer genCapBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:GeneralCaptureInformation") + EOL);
        boolean useGenCapBuf = false;
        s = niso.getDateTimeCreated();
        if (s != null) {
            genCapBuf.append(margn3 + XmlHandler.element("mix:dateTimeCreated", s) + EOL);
            useGenCapBuf = true;
        }
        if ((s = niso.getImageProducer()) != null) {
            genCapBuf.append(margn3 + XmlHandler.element("mix:imageProducer", s) + EOL);
            useGenCapBuf = true;
        }
        if ((s = niso.getDeviceSource()) != null) {
            genCapBuf.append(margn3 + XmlHandler.element("mix:captureDevice", s) + EOL);
        }
        genCapBuf.append(margn3 + XmlHandler.elementEnd("mix:GeneralCaptureInformation") + EOL);
        if (useGenCapBuf) {
            captureBuffer.append(genCapBuf);
            useCaptureBuffer = true;
        }
        StringBuffer scanCapBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:ScannerCapture") + EOL);
        boolean useScanCapBuf = false;
        String mfg = niso.getScannerManufacturer();
        if (mfg != null) {
            scanCapBuf.append(margn4 + XmlHandler.element("mix:scannerManufacturer", mfg) + EOL);
            useScanCapBuf = true;
        }
        String model = niso.getScannerModelName();
        String modelNum = niso.getScannerModelNumber();
        String serNum = niso.getScannerModelSerialNo();
        if (model != null || modelNum != null || serNum != null) {
            useScanCapBuf = true;
            scanCapBuf.append(margn4 + XmlHandler.elementStart("mix:ScannerModel") + EOL);
            if (model != null) {
                scanCapBuf.append(margn5 + XmlHandler.element("mix:scannerModelName", model) + EOL);
            }
            if (modelNum != null) {
                scanCapBuf.append(margn5 + XmlHandler.element("mix:scannerModelNumber", modelNum) + EOL);
            }
            if (serNum != null) {
                scanCapBuf.append(margn5 + XmlHandler.element("mix:scannerModelSerialNo", serNum) + EOL);
            }
            scanCapBuf.append(margn4 + XmlHandler.elementEnd("mix:ScannerModel") + EOL);
        }
        double xres = niso.getXPhysScanResolution();
        double yres = niso.getYPhysScanResolution();
        if (xres != -1.0 && yres != -1.0) {
            double res = xres > yres ? xres : yres;
            scanCapBuf.append(margn4 + XmlHandler.element("mix:maximumOpticalResolution", formatters.get().format(res)) + EOL);
        }
        if ((s = niso.getScanningSoftware()) != null) {
            useScanCapBuf = true;
            scanCapBuf.append(margn4 + XmlHandler.elementStart("mix:ScanningSystemSoftware") + EOL);
            scanCapBuf.append(margn5 + XmlHandler.element("mix:scanningSoftwareName", s) + EOL);
            s = niso.getScanningSoftwareVersionNo();
            if (s != null) {
                scanCapBuf.append(margn5 + XmlHandler.element("mix:scanningSoftwareVersionNo", s) + EOL);
            }
            scanCapBuf.append(margn4 + XmlHandler.elementEnd("mix:ScanningSystemSoftware") + EOL);
        }
        scanCapBuf.append(margn3 + XmlHandler.elementEnd("mix:ScannerCapture") + EOL);
        if (useScanCapBuf) {
            captureBuffer.append(scanCapBuf);
            useCaptureBuffer = true;
        }
        StringBuffer digCamBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:DigitalCameraCapture") + EOL);
        boolean useDigCamBuf = false;
        s = niso.getDigitalCameraManufacturer();
        if (s != null) {
            digCamBuf.append(margn4 + XmlHandler.element("mix:digitalCameraManufacturer", s) + EOL);
            useDigCamBuf = true;
        }
        String dcmodel = niso.getDigitalCameraModelName();
        String dcmodelNum = niso.getDigitalCameraModelNumber();
        String dcserNum = niso.getDigitalCameraModelSerialNo();
        if (dcmodel != null || dcmodelNum != null || dcserNum != null) {
            useDigCamBuf = true;
            digCamBuf.append(margn4 + XmlHandler.elementStart("mix:DigitalCameraModel") + EOL);
            if (dcmodel != null) {
                digCamBuf.append(margn5 + XmlHandler.element("mix:digitalCameraModelName", dcmodel) + EOL);
            }
            if (dcmodelNum != null) {
                digCamBuf.append(margn5 + XmlHandler.element("mix:digitalCameraModelNumber", dcmodelNum) + EOL);
            }
            if (dcserNum != null) {
                digCamBuf.append(margn5 + XmlHandler.element("mix:mix:digitalCameraModelSerialNo", dcserNum) + EOL);
            }
            digCamBuf.append(margn4 + XmlHandler.elementEnd("mix:DigitalCameraModel") + EOL);
        }
        StringBuffer ccSetBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:CameraCaptureSettings") + EOL);
        boolean useCcSetBuf = false;
        ccSetBuf.append(margn5 + XmlHandler.elementStart("mix:ImageData") + EOL);
        d = niso.getFNumber();
        if (d != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:fNumber", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureTime()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:exposureTime", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getExposureProgram()) != -1) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:exposureProgram", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ("0220".equals(s = niso.getExifVersion())) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:exifVersion", s) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getBrightness()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:brightnessValue", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureBias()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:exposureBiasValue", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((r = niso.getMaxApertureValue()) != null) {
            this.rationalToString(ccSetBuf, "mix:maxApertureValue", margn6, r);
            useCcSetBuf = true;
        }
        if ((darray = niso.getSubjectDistance()) != null) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:subjectDistance", formatters.get().format(darray[0])) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getMeteringMode()) != -1) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:meteringMode", this.meteringModeToString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getFlash()) != -1) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:flash", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getFocalLength()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:focalLength", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getFlashEnergy()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:flashEnergy", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getBackLight()) != -1) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:backLight", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureIndex()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:exposureIndex", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getAutoFocus()) != -1) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:autoFocus", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        d = niso.getXPrintAspectRatio();
        double d2 = niso.getYPrintAspectRatio();
        if (d != -1.0 || d2 != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.elementStart("mix:PrintAspectRatio") + EOL);
            if (d != -1.0) {
                ccSetBuf.append(margn7 + XmlHandler.element("mix:xPrintAspectRatio", formatters.get().format(d)) + EOL);
            }
            if (d2 != -1.0) {
                ccSetBuf.append(margn7 + XmlHandler.element("mix:yPrintAspectRatio", formatters.get().format(d)) + EOL);
            }
            ccSetBuf.append(margn6 + XmlHandler.elementEnd("mix:PrintAspectRatio") + EOL);
        }
        ccSetBuf.append(margn5 + XmlHandler.elementEnd("mix:ImageData") + EOL);
        ccSetBuf.append(margn4 + XmlHandler.elementEnd("mix:CameraCaptureSettings") + EOL);
        if (useCcSetBuf) {
            digCamBuf.append(ccSetBuf);
            useDigCamBuf = true;
        }
        digCamBuf.append(margn3 + XmlHandler.elementEnd("mix:DigitalCameraCapture") + EOL);
        if (useDigCamBuf) {
            captureBuffer.append(digCamBuf);
            useCaptureBuffer = true;
        }
        if ((n = niso.getOrientation()) != -1) {
            captureBuffer.append(margn3 + XmlHandler.element("mix:orientation", Integer.toString(n)) + EOL);
            useCaptureBuffer = true;
        }
        if ((s = niso.getMethodology()) != null) {
            captureBuffer.append(margn3 + XmlHandler.element("mix:methodology", s) + EOL);
        }
        if (useCaptureBuffer) {
            this._writer.println(margn2 + XmlHandler.elementStart("mix:ImageCaptureMetadata"));
            this._writer.print(captureBuffer.toString());
            this._writer.println(margn2 + XmlHandler.elementEnd("mix:ImageCaptureMetadata"));
        }
    }

    protected void showNisoImageAssessmentMetadata10(NisoImageMetadata niso, String margin) {
        String s;
        Rational r;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        this._writer.println(margn2 + XmlHandler.elementStart("mix:ImageAssessmentMetadata"));
        StringBuffer metricsBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:SpatialMetrics") + EOL);
        boolean useMetricsBuf = false;
        int n = niso.getSamplingFrequencyPlane();
        if (n != -1) {
            metricsBuf.append(margn4 + XmlHandler.element("mix:samplingFrequencyPlane", Integer.toString(n)) + EOL);
            useMetricsBuf = true;
        }
        if ((n = niso.getSamplingFrequencyUnit()) != -1) {
            metricsBuf.append(margn4 + XmlHandler.element("mix:samplingFrequencyUnit", Integer.toString(n)) + EOL);
            useMetricsBuf = true;
        }
        if ((r = niso.getXSamplingFrequency()) != null) {
            this.rationalToString(metricsBuf, "mix:xSamplingFrequency", margn4, r);
        }
        if ((r = niso.getYSamplingFrequency()) != null) {
            this.rationalToString(metricsBuf, "mix:ySamplingFrequency", margn4, r);
        }
        metricsBuf.append(margn3 + XmlHandler.elementEnd("mix:SpatialMetrics"));
        if (useMetricsBuf) {
            this._writer.println(metricsBuf);
        }
        StringBuffer colorEncBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:ImageColorEncoding") + EOL);
        boolean useColorEncBuf = false;
        int[] iarray = niso.getBitsPerSample();
        if (iarray != null) {
            colorEncBuf.append(margn4 + XmlHandler.elementStart("mix:bitsPerSample") + EOL);
            colorEncBuf.append(margn5 + XmlHandler.element("mix:bitsPerSampleValue", XmlHandler.integerArray(iarray, ',')) + EOL);
            colorEncBuf.append(margn5 + XmlHandler.element("mix:bitsPerSampleUnit", "integer") + EOL);
            colorEncBuf.append(margn4 + XmlHandler.elementEnd("mix:bitsPerSample") + EOL);
            useColorEncBuf = true;
        }
        if ((n = niso.getSamplesPerPixel()) != -1) {
            colorEncBuf.append(margn4 + XmlHandler.element("mix:samplesPerPixel", Integer.toString(n)) + EOL);
            useColorEncBuf = true;
        }
        if ((iarray = niso.getExtraSamples()) != null && (n = iarray[0]) >= 0 && n <= 3) {
            colorEncBuf.append(margn4 + XmlHandler.element("mix:extraSamples", Integer.toString(n)) + EOL);
            useColorEncBuf = true;
        }
        if ((s = niso.getColormapReference()) != null) {
            colorEncBuf.append(margn4 + XmlHandler.elementStart("mix:Colormap") + EOL);
            colorEncBuf.append(margn5 + XmlHandler.element("mix:colormapReference", s) + EOL);
            colorEncBuf.append(margn4 + XmlHandler.elementEnd("mix:Colormap") + EOL);
            useColorEncBuf = true;
        }
        if ((iarray = niso.getGrayResponseCurve()) != null) {
            colorEncBuf.append(margn4 + XmlHandler.element("mix:grayResponseCurve", "N") + EOL);
            useColorEncBuf = true;
        }
        if ((n = niso.getGrayResponseUnit()) != -1) {
            colorEncBuf.append(margn4 + XmlHandler.element("mix:grayResponseUnit", Integer.toString(n)) + EOL);
            useColorEncBuf = true;
        }
        r = niso.getWhitePointXValue();
        Rational r2 = niso.getWhitePointYValue();
        if (r != null || r2 != null) {
            colorEncBuf.append(margn4 + XmlHandler.elementStart("mix:WhitePoint") + EOL);
            if (r != null) {
                colorEncBuf.append(margn5 + XmlHandler.element("mix:whitePointXValue", r.toString()) + EOL);
            }
            if (r2 != null) {
                colorEncBuf.append(margn5 + XmlHandler.element("mix:whitePointYValue", r2.toString()) + EOL);
            }
            colorEncBuf.append(margn4 + XmlHandler.elementEnd("mix:WhitePoint") + EOL);
            useColorEncBuf = true;
        }
        StringBuffer chromaBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:PrimaryChromaticities") + EOL);
        boolean useChromaBuf = false;
        r = niso.getPrimaryChromaticitiesRedX();
        if (r != null) {
            chromaBuf.append(margn5 + XmlHandler.element("mix:primaryChromaticitiesRedX", r.toString()) + EOL);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesRedY()) != null) {
            chromaBuf.append(margn5 + XmlHandler.element("mix:primaryChromaticitiesRedY", r.toString()) + EOL);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesGreenX()) != null) {
            chromaBuf.append(margn5 + XmlHandler.element("mix:primaryChromaticitiesGreenX", r.toString()) + EOL);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesGreenY()) != null) {
            chromaBuf.append(margn5 + XmlHandler.element("mix:primaryChromaticitiesGreenY", r.toString()) + EOL);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesBlueX()) != null) {
            chromaBuf.append(margn5 + XmlHandler.element("mix:primaryChromaticitiesBlueX", r.toString()) + EOL);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesBlueY()) != null) {
            chromaBuf.append(margn5 + XmlHandler.element("mix:primaryChromaticitiesBlueY", r.toString()) + EOL);
            useChromaBuf = true;
        }
        chromaBuf.append(margn4 + XmlHandler.elementEnd("mix:PrimaryChromaticities") + EOL);
        if (useChromaBuf) {
            colorEncBuf.append(chromaBuf);
            useColorEncBuf = true;
        }
        colorEncBuf.append(margn3 + XmlHandler.elementEnd("mix:ImageColorEncoding") + EOL);
        if (useColorEncBuf) {
            this._writer.print(colorEncBuf);
        }
        StringBuffer targetBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:TargetData") + EOL);
        boolean useTargetBuf = false;
        n = niso.getTargetType();
        if (n != -1) {
            targetBuf.append(margn4 + XmlHandler.element("mix:targetType", Integer.toString(n)) + EOL);
            useTargetBuf = true;
        }
        StringBuffer targetIDBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:TargetID") + EOL);
        boolean useTargetIDBuf = false;
        s = niso.getTargetIDManufacturer();
        if (s != null) {
            targetIDBuf.append(margn5 + XmlHandler.element("mix:targetManufacturer", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDName()) != null) {
            targetIDBuf.append(margn5 + XmlHandler.element("mix:targetName", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDNo()) != null) {
            targetIDBuf.append(margn5 + XmlHandler.element("mix:targetNo", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDMedia()) != null) {
            targetIDBuf.append(margn5 + XmlHandler.element("mix:targetMedia", s) + EOL);
            useTargetIDBuf = true;
        }
        targetIDBuf.append(margn4 + XmlHandler.elementEnd("mix:TargetID") + EOL);
        if (useTargetIDBuf) {
            targetBuf.append(targetIDBuf);
            useTargetBuf = true;
        }
        if ((s = niso.getImageData()) != null) {
            targetBuf.append(margn4 + XmlHandler.element("mix:externalTarget", s) + EOL);
            useTargetBuf = true;
        }
        if ((s = niso.getPerformanceData()) != null) {
            targetBuf.append(margn4 + XmlHandler.element("mix:performanceData", s) + EOL);
            useTargetBuf = true;
        }
        targetBuf.append(margn3 + XmlHandler.elementEnd("mix:TargetData") + EOL);
        if (useTargetBuf) {
            this._writer.print(targetBuf);
        }
        this._writer.println(margn2 + XmlHandler.elementEnd("mix:ImageAssessmentMetadata"));
    }

    protected void showChangeHistory10(NisoImageMetadata niso, String margin) {
        String[] sarray;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        StringBuffer chBuf = new StringBuffer(margn2 + XmlHandler.elementStart("mix:ChangeHistory") + EOL);
        boolean useChBuf = false;
        chBuf.append(margn3 + XmlHandler.elementStart("mix:ImageProcessing") + EOL);
        String s = niso.getSourceData();
        if (s != null) {
            chBuf.append(margn4 + XmlHandler.element("mix:sourceData") + EOL);
            useChBuf = true;
        }
        if ((s = niso.getProcessingAgency()) != null) {
            chBuf.append(margn4 + XmlHandler.element("mix:processingAgency") + EOL);
            useChBuf = true;
        }
        StringBuffer sftwBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:ProcessingSoftware") + EOL);
        boolean useSftwBuf = false;
        s = niso.getProcessingSoftwareName();
        if (s != null) {
            sftwBuf.append(margn5 + XmlHandler.element("mix:processingSoftwareName", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getProcessingSoftwareVersion()) != null) {
            sftwBuf.append(margn5 + XmlHandler.element("mix:processingSoftwareVersion", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getOS()) != null) {
            sftwBuf.append(margn5 + XmlHandler.element("mix:processingOperatingSystemName", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getOSVersion()) != null) {
            sftwBuf.append(margn5 + XmlHandler.element("mix:processingOperatingSystemVersion", s) + EOL);
            useSftwBuf = true;
        }
        sftwBuf.append(margn4 + XmlHandler.elementEnd("mix:ProcessingSoftware") + EOL);
        if (useSftwBuf) {
            chBuf.append(sftwBuf);
            useChBuf = true;
        }
        if ((sarray = niso.getProcessingActions()) != null) {
            for (int i = 0; i < sarray.length; ++i) {
                chBuf.append(margn4 + XmlHandler.element("mix:processingActions", sarray[i]) + EOL);
            }
            useChBuf = true;
        }
        chBuf.append(margn3 + XmlHandler.elementEnd("mix:ImageProcessing") + EOL);
        chBuf.append(margn2 + XmlHandler.elementEnd("mix:ChangeHistory") + EOL);
        if (useChBuf) {
            this._writer.println(chBuf);
        }
    }

    protected void showNisoImageMetadata20(NisoImageMetadata niso) {
        String margin = XmlHandler.getIndent(++this._level);
        String[][] attrs = new String[][]{{"xmlns:mix", "http://www.loc.gov/mix/v20"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"xsi:schemaLocation", "http://www.loc.gov/mix/v20 http://www.loc.gov/standards/mix/mix20/mix20.xsd"}};
        this._writer.println(margin + XmlHandler.elementStart("mix:mix", attrs));
        this.showNisoBasicDigitalObjectInformation20(niso, margin);
        this.showNisoBasicImageInformation20(niso, margin);
        this.showNisoImageCaptureMetadata20(niso, margin);
        this.showNisoImageAssessmentMetadata20(niso, margin);
        this.showChangeHistory20(niso, margin);
        this._writer.println(margin + XmlHandler.elementEnd("mix:mix"));
        --this._level;
    }

    protected void showNisoBasicDigitalObjectInformation20(NisoImageMetadata niso, String margin) {
        String compStr;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        this._writer.println(margn2 + XmlHandler.elementStart("mix:BasicDigitalObjectInformation"));
        StringBuffer objIDBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:ObjectIdentifier") + EOL);
        objIDBuf.append(margn4 + XmlHandler.element("mix:objectIdentifierType", "JHOVE") + EOL);
        String s = niso.getImageIdentifier();
        if (s != null) {
            objIDBuf.append(margn4 + XmlHandler.element("mix:objectIdentifierValue", s) + EOL);
        }
        objIDBuf.append(margn3 + XmlHandler.elementEnd("mix:ObjectIdentifier") + EOL);
        this._writer.print(objIDBuf.toString());
        long ln = niso.getFileSize();
        if (ln != -1L) {
            this._writer.print(margn3 + XmlHandler.element("mix:fileSize", Long.toString(ln)) + EOL);
        }
        if ((s = niso.getByteOrder()) != null) {
            if (s.startsWith("big")) {
                s = "big endian";
            } else if (s.startsWith("little")) {
                s = "little endian";
            }
            this._writer.print(margn3 + XmlHandler.element("mix:byteOrder", s) + EOL);
        }
        int comp = niso.getCompressionScheme();
        int level = niso.getCompressionLevel();
        switch (comp) {
            case 1: {
                compStr = "Uncompressed";
                break;
            }
            case 2: {
                compStr = "CCITT 1D";
                break;
            }
            case 3: {
                compStr = "Group 3 Fax";
                break;
            }
            case 4: {
                compStr = "Group 4 Fax";
                break;
            }
            case 5: {
                compStr = "LZW";
                break;
            }
            case 6: {
                compStr = "JPEG";
                break;
            }
            case 32773: {
                compStr = "PackBits";
                break;
            }
            default: {
                compStr = "Unknown";
            }
        }
        if (comp != -1 || level != -1) {
            this._writer.print(margn3 + XmlHandler.elementStart("mix:Compression") + EOL);
            if (comp != -1) {
                this._writer.print(margn4 + XmlHandler.element("mix:compressionScheme", compStr) + EOL);
            }
            this._writer.print(margn3 + XmlHandler.elementEnd("mix:Compression") + EOL);
        }
        int n = niso.getChecksumMethod();
        s = niso.getChecksumValue();
        if (n != -1 || s != null) {
            this._writer.print(margn4 + XmlHandler.elementStart("mix:Fixity") + EOL);
            if (n != -1) {
                this._writer.print(margn5 + XmlHandler.element("mix:messageDigestAlgorithm", Integer.toString(n)) + EOL);
            }
            if (s != null) {
                this._writer.print(margn5 + XmlHandler.element("mix:messageDigest", s) + EOL);
            }
            this._writer.println(margn4 + XmlHandler.elementEnd("mix:Fixity"));
        }
        this._writer.print(margn2 + XmlHandler.elementEnd("mix:BasicDigitalObjectInformation") + EOL);
    }

    protected void showNisoBasicImageInformation20(NisoImageMetadata niso, String margin) {
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        String margn6 = margn5 + " ";
        String margn7 = margn6 + " ";
        this._writer.println(margn2 + XmlHandler.elementStart("mix:BasicImageInformation"));
        StringBuffer basCharBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:BasicImageCharacteristics") + EOL);
        boolean useBasCharBuf = false;
        long ln = niso.getImageWidth();
        if (ln != -1L) {
            basCharBuf.append(margn4 + XmlHandler.element("mix:imageWidth", Long.toString(ln)) + EOL);
            useBasCharBuf = true;
        }
        if ((ln = niso.getImageLength()) != -1L) {
            basCharBuf.append(margn4 + XmlHandler.element("mix:imageHeight", Long.toString(ln)) + EOL);
            useBasCharBuf = true;
        }
        StringBuffer piBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:PhotometricInterpretation") + EOL);
        boolean usePIBuf = false;
        int n = niso.getColorSpace();
        if (n != -1) {
            piBuf.append(margn5 + XmlHandler.element("mix:colorSpace", this.photometricInterpretationToString(n)) + EOL);
            usePIBuf = true;
        }
        String s = niso.getProfileName();
        String s2 = niso.getProfileURL();
        if (s != null || s2 != null) {
            piBuf.append(margn5 + XmlHandler.elementStart("mix:ColorProfile") + EOL);
            piBuf.append(margn6 + XmlHandler.elementStart("mix:IccProfile") + EOL);
            if (s != null) {
                piBuf.append(margn7 + XmlHandler.element("mix:iccProfileName", s) + EOL);
            }
            if (s2 != null) {
                piBuf.append(margn7 + XmlHandler.element("mix:iccProfileURI", s2) + EOL);
            }
            piBuf.append(margn6 + XmlHandler.elementEnd("mix:IccProfile") + EOL);
            piBuf.append(margn5 + XmlHandler.elementEnd("mix:ColorProfile") + EOL);
            usePIBuf = true;
        }
        int[] iarray = niso.getYCbCrSubSampling();
        n = niso.getYCbCrPositioning();
        Rational[] rarray = niso.getYCbCrCoefficients();
        if (iarray != null || n != -1 || rarray != null) {
            piBuf.append(margn5 + XmlHandler.elementStart("mix:YCbCr") + EOL);
            usePIBuf = true;
            if (iarray != null && iarray.length >= 2) {
                piBuf.append(margn6 + XmlHandler.elementStart("mix:YCbCrSubSampling") + EOL);
                piBuf.append(margn7 + XmlHandler.element("mix:yCbCrSubsampleHoriz", Integer.toString(iarray[0])) + EOL);
                piBuf.append(margn7 + XmlHandler.element("mix:yCbCrSubsampleVert", Integer.toString(iarray[1])) + EOL);
                piBuf.append(margn6 + XmlHandler.elementEnd("mix:YCbCrSubSampling") + EOL);
            }
            if (n != -1) {
                piBuf.append(margn6 + XmlHandler.element("mix:yCbCrPositioning", Integer.toString(n)) + EOL);
            }
            if (rarray != null && rarray.length >= 3) {
                piBuf.append(margn6 + XmlHandler.elementStart("mix:YCbCrCoefficients") + EOL);
                this.rationalToString(piBuf, "mix:lumaRed", margn7, rarray[0]);
                this.rationalToString(piBuf, "mix:lumaGreen", margn7, rarray[1]);
                this.rationalToString(piBuf, "mix:lumaBlue", margn7, rarray[2]);
                piBuf.append(margn6 + XmlHandler.elementEnd("mix:YCbCrCoefficients") + EOL);
            }
            piBuf.append(margn5 + XmlHandler.elementEnd("mix:YCbCr") + EOL);
        }
        if ((rarray = niso.getReferenceBlackWhite()) != null) {
            piBuf.append(margn5 + XmlHandler.elementStart("mix:ReferenceBlackWhite") + EOL);
            for (int i = 0; i < rarray.length - 1; i += 2) {
                String pi;
                piBuf.append(margn6 + XmlHandler.elementStart("mix:Component") + EOL);
                piBuf.append(margn7 + XmlHandler.elementStart("mix:componentPhotometricInterpretation"));
                if (niso.getColorSpace() == 6) {
                    switch (i) {
                        case 0: {
                            pi = "Y";
                            break;
                        }
                        case 2: {
                            pi = "Cb";
                            break;
                        }
                        default: {
                            pi = "Cr";
                            break;
                        }
                    }
                } else {
                    switch (i) {
                        case 0: {
                            pi = "R";
                            break;
                        }
                        case 2: {
                            pi = "G";
                            break;
                        }
                        default: {
                            pi = "B";
                        }
                    }
                }
                piBuf.append(pi + XmlHandler.elementEnd("mix:componentPhotometricInterpretation") + EOL);
                this.rationalToString(piBuf, "mix:footroom", margn7, rarray[i]);
                this.rationalToString(piBuf, "mix:headroom", margn7, rarray[i + 1]);
                piBuf.append(margn7 + XmlHandler.elementEnd("mix:Component") + EOL);
            }
            piBuf.append(margn6 + XmlHandler.elementEnd("mix:ReferenceBlackWhite") + EOL);
            usePIBuf = true;
        }
        piBuf.append(margn4 + XmlHandler.elementEnd("mix:PhotometricInterpretation") + EOL);
        if (usePIBuf) {
            basCharBuf.append(piBuf);
            useBasCharBuf = true;
        }
        basCharBuf.append(margn3 + XmlHandler.elementEnd("mix:BasicImageCharacteristics"));
        if (useBasCharBuf) {
            this._writer.println(basCharBuf);
        }
        this._writer.println(margn2 + XmlHandler.elementEnd("mix:BasicImageInformation"));
    }

    protected void showNisoImageCaptureMetadata20(NisoImageMetadata niso, String margin) {
        double[] darray;
        Rational r;
        int n;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        String margn6 = margn5 + " ";
        String margn7 = margn6 + " ";
        String margn8 = margn7 + " ";
        StringBuffer captureBuffer = new StringBuffer();
        boolean useCaptureBuffer = false;
        String s = niso.getSourceType();
        String si = niso.getSourceID();
        double d = niso.getSourceXDimension();
        if (s != null || si != null || d != -1.0) {
            captureBuffer.append(margn3 + XmlHandler.element("mix:SourceInformation", s));
            useCaptureBuffer = true;
            if (s != null) {
                captureBuffer.append(margn4 + XmlHandler.element("mix:sourceType", s));
            }
            if (si != null) {
                captureBuffer.append(margn4 + XmlHandler.elementStart("mix:SourceID"));
                captureBuffer.append(margn4 + XmlHandler.element("mix:sourceIDValue", si));
                captureBuffer.append(margn4 + XmlHandler.elementEnd("mix:sourceID"));
            }
            n = niso.getSourceXDimensionUnit();
            if (d != -1.0 || n != -1) {
                captureBuffer.append(margn4 + XmlHandler.elementStart("mix:SourceSize"));
                captureBuffer.append(margn5 + XmlHandler.elementStart("mix:SourceXDimension") + EOL);
                if (d != -1.0) {
                    captureBuffer.append(margn6 + XmlHandler.element("mix:sourceXDimensionValue", formatters.get().format(d)) + EOL);
                }
                if (n != -1) {
                    captureBuffer.append(margn6 + XmlHandler.element("mix:sourceXDimensionUnit", Integer.toString(n)) + EOL);
                }
                captureBuffer.append(margn5 + XmlHandler.elementEnd("mix:SourceXDimension") + EOL);
                d = niso.getSourceYDimension();
                n = niso.getSourceYDimensionUnit();
                if (d != -1.0 || n != -1) {
                    captureBuffer.append(margn5 + XmlHandler.elementStart("mix:SourceYDimension") + EOL);
                    if (d != -1.0) {
                        captureBuffer.append(margn6 + XmlHandler.element("mix:sourceYDimensionValue", formatters.get().format(d)) + EOL);
                    }
                    if (n != -1) {
                        captureBuffer.append(margn6 + XmlHandler.element("mix:sourceYDimensionUnit", Integer.toString(n)) + EOL);
                    }
                    captureBuffer.append(margn5 + XmlHandler.elementEnd("mix:SourceYDimension") + EOL);
                }
                captureBuffer.append(margn4 + XmlHandler.elementEnd("mix:SourceSize") + EOL);
            }
            captureBuffer.append(margn3 + XmlHandler.elementEnd("mix:SourceInformation") + EOL);
        }
        StringBuffer genCapBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:GeneralCaptureInformation") + EOL);
        boolean useGenCapBuf = false;
        s = niso.getDateTimeCreated();
        if (s != null) {
            genCapBuf.append(margn3 + XmlHandler.element("mix:dateTimeCreated", s) + EOL);
            useGenCapBuf = true;
        }
        if ((s = niso.getImageProducer()) != null) {
            genCapBuf.append(margn3 + XmlHandler.element("mix:imageProducer", s) + EOL);
            useGenCapBuf = true;
        }
        if ((s = niso.getDeviceSource()) != null) {
            genCapBuf.append(margn3 + XmlHandler.element("mix:captureDevice", s) + EOL);
        }
        genCapBuf.append(margn3 + XmlHandler.elementEnd("mix:GeneralCaptureInformation") + EOL);
        if (useGenCapBuf) {
            captureBuffer.append(genCapBuf);
            useCaptureBuffer = true;
        }
        StringBuffer scanCapBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:ScannerCapture") + EOL);
        boolean useScanCapBuf = false;
        String mfg = niso.getScannerManufacturer();
        if (mfg != null) {
            scanCapBuf.append(margn4 + XmlHandler.element("mix:scannerManufacturer", mfg) + EOL);
            useScanCapBuf = true;
        }
        String model = niso.getScannerModelName();
        String modelNum = niso.getScannerModelNumber();
        String serNum = niso.getScannerModelSerialNo();
        if (model != null || modelNum != null || serNum != null) {
            useScanCapBuf = true;
            scanCapBuf.append(margn4 + XmlHandler.elementStart("mix:ScannerModel") + EOL);
            if (model != null) {
                scanCapBuf.append(margn5 + XmlHandler.element("mix:scannerModelName", model) + EOL);
            }
            if (modelNum != null) {
                scanCapBuf.append(margn5 + XmlHandler.element("mix:scannerModelNumber", modelNum) + EOL);
            }
            if (serNum != null) {
                scanCapBuf.append(margn5 + XmlHandler.element("mix:scannerModelSerialNo", serNum) + EOL);
            }
            scanCapBuf.append(margn4 + XmlHandler.elementEnd("mix:ScannerModel") + EOL);
        }
        double xres = niso.getXPhysScanResolution();
        double yres = niso.getYPhysScanResolution();
        if (xres != -1.0 && yres != -1.0) {
            scanCapBuf.append(margn4 + XmlHandler.elementStart("mix:MaximumOpticalResolution") + EOL);
            scanCapBuf.append(margn5 + XmlHandler.element("mix:xOpticalResolution", formatters.get().format(xres)) + EOL);
            scanCapBuf.append(margn5 + XmlHandler.element("mix:yOpticalResolution", formatters.get().format(yres)) + EOL);
            scanCapBuf.append(margn5 + XmlHandler.element("mix:resolutionUnit", "in.") + EOL);
            scanCapBuf.append(margn4 + XmlHandler.elementEnd("mix:MaximumOpticalResolution"));
        }
        if ((s = niso.getScanningSoftware()) != null) {
            useScanCapBuf = true;
            scanCapBuf.append(margn4 + XmlHandler.elementStart("mix:ScanningSystemSoftware") + EOL);
            scanCapBuf.append(margn5 + XmlHandler.element("mix:scanningSoftwareName", s) + EOL);
            s = niso.getScanningSoftwareVersionNo();
            if (s != null) {
                scanCapBuf.append(margn5 + XmlHandler.element("mix:scanningSoftwareVersionNo", s) + EOL);
            }
            scanCapBuf.append(margn4 + XmlHandler.elementEnd("mix:ScanningSystemSoftware") + EOL);
        }
        scanCapBuf.append(margn3 + XmlHandler.elementEnd("mix:ScannerCapture") + EOL);
        if (useScanCapBuf) {
            captureBuffer.append(scanCapBuf);
            useCaptureBuffer = true;
        }
        StringBuffer digCamBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:DigitalCameraCapture") + EOL);
        boolean useDigCamBuf = false;
        s = niso.getDigitalCameraManufacturer();
        if (s != null) {
            digCamBuf.append(margn4 + XmlHandler.element("mix:digitalCameraManufacturer", s) + EOL);
            useDigCamBuf = true;
        }
        String dcmodel = niso.getDigitalCameraModelName();
        String dcmodelNum = niso.getDigitalCameraModelNumber();
        String dcserNum = niso.getDigitalCameraModelSerialNo();
        if (dcmodel != null || dcmodelNum != null || dcserNum != null) {
            useDigCamBuf = true;
            digCamBuf.append(margn4 + XmlHandler.elementStart("mix:DigitalCameraModel") + EOL);
            if (dcmodel != null) {
                digCamBuf.append(margn5 + XmlHandler.element("mix:digitalCameraModelName", dcmodel) + EOL);
            }
            if (dcmodelNum != null) {
                digCamBuf.append(margn5 + XmlHandler.element("mix:digitalCameraModelNumber", dcmodelNum) + EOL);
            }
            if (dcserNum != null) {
                digCamBuf.append(margn5 + XmlHandler.element("mix:mix:digitalCameraModelSerialNo", dcserNum) + EOL);
            }
            digCamBuf.append(margn4 + XmlHandler.elementEnd("mix:DigitalCameraModel") + EOL);
        }
        StringBuffer ccSetBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:CameraCaptureSettings") + EOL);
        boolean useCcSetBuf = false;
        ccSetBuf.append(margn5 + XmlHandler.elementStart("mix:ImageData") + EOL);
        d = niso.getFNumber();
        if (d != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:fNumber", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureTime()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:exposureTime", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getExposureProgram()) != -1) {
            if (n > 8 || n < 0) {
                n = 0;
            }
            ccSetBuf.append(margn6 + XmlHandler.element("mix:exposureProgram", NisoImageMetadata.EXPOSURE_PROGRAM[n]) + EOL);
            useCcSetBuf = true;
        }
        if (niso.getExifVersion() != null) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:exifVersion", niso.getExifVersion()) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getBrightness()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:brightnessValue", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureBias()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:exposureBiasValue", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((r = niso.getMaxApertureValue()) != null) {
            this.rationalToString(ccSetBuf, "mix:maxApertureValue", margn6, r);
            useCcSetBuf = true;
        }
        if ((darray = niso.getSubjectDistance()) != null) {
            ccSetBuf.append(margn6 + XmlHandler.elementStart("mix:SubjectDistance") + EOL);
            useCcSetBuf = true;
            if (darray[0] == darray[1]) {
                ccSetBuf.append(margn7 + XmlHandler.element("mix:distance", formatters.get().format(darray[0])) + EOL);
            } else {
                ccSetBuf.append(margn7 + XmlHandler.elementStart("mix:MinMaxDistance") + EOL);
                ccSetBuf.append(margn8 + XmlHandler.element("mix:minDistance", formatters.get().format(darray[0])) + EOL);
                ccSetBuf.append(margn8 + XmlHandler.element("mix:maxDistance", formatters.get().format(darray[1])) + EOL);
                ccSetBuf.append(margn7 + XmlHandler.elementEnd("mix:MinMaxDistance") + EOL);
            }
            ccSetBuf.append(margn6 + XmlHandler.elementEnd("mix:SubjectDistance") + EOL);
        }
        if ((n = niso.getMeteringMode()) != -1) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:meteringMode", this.meteringModeToString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getFlash()) != -1) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:flash", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getFocalLength()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:focalLength", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getFlashEnergy()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:flashEnergy", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getBackLight()) != -1) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:backLight", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        if ((d = niso.getExposureIndex()) != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:exposureIndex", formatters.get().format(d)) + EOL);
            useCcSetBuf = true;
        }
        if ((n = niso.getAutoFocus()) != -1) {
            ccSetBuf.append(margn6 + XmlHandler.element("mix:autoFocus", Integer.toString(n)) + EOL);
            useCcSetBuf = true;
        }
        d = niso.getXPrintAspectRatio();
        double d2 = niso.getYPrintAspectRatio();
        if (d != -1.0 || d2 != -1.0) {
            ccSetBuf.append(margn6 + XmlHandler.elementStart("mix:PrintAspectRatio") + EOL);
            if (d != -1.0) {
                ccSetBuf.append(margn7 + XmlHandler.element("mix:xPrintAspectRatio", formatters.get().format(d)) + EOL);
            }
            if (d2 != -1.0) {
                ccSetBuf.append(margn7 + XmlHandler.element("mix:yPrintAspectRatio", formatters.get().format(d)) + EOL);
            }
            ccSetBuf.append(margn6 + XmlHandler.elementEnd("mix:PrintAspectRatio") + EOL);
        }
        ccSetBuf.append(margn5 + XmlHandler.elementEnd("mix:ImageData") + EOL);
        ccSetBuf.append(margn4 + XmlHandler.elementEnd("mix:CameraCaptureSettings") + EOL);
        if (useCcSetBuf) {
            digCamBuf.append(ccSetBuf);
            useDigCamBuf = true;
        }
        digCamBuf.append(margn3 + XmlHandler.elementEnd("mix:DigitalCameraCapture") + EOL);
        if (useDigCamBuf) {
            captureBuffer.append(digCamBuf);
            useCaptureBuffer = true;
        }
        if ((n = niso.getOrientation()) != -1) {
            String[] orient = new String[]{"unknown", "normal*", "normal, image flipped", "normal, rotated 180\u00b0", "normal, image flipped, rotated 180\u00b0", "normal, image flipped, rotated cw 90\u00b0", "normal, rotated ccw 90\u00b0", "normal, image flipped, rotated ccw 90\u00b0", "normal, rotated cw 90\u00b0"};
            if (n > 8 || n < 0) {
                n = 0;
            }
            captureBuffer.append(margn3 + XmlHandler.element("mix:orientation", orient[n]) + EOL);
            useCaptureBuffer = true;
        }
        if ((s = niso.getMethodology()) != null) {
            captureBuffer.append(margn3 + XmlHandler.element("mix:methodology", s) + EOL);
        }
        if (useCaptureBuffer) {
            this._writer.println(margn2 + XmlHandler.elementStart("mix:ImageCaptureMetadata"));
            this._writer.print(captureBuffer.toString());
            this._writer.println(margn2 + XmlHandler.elementEnd("mix:ImageCaptureMetadata"));
        }
    }

    protected void showNisoImageAssessmentMetadata20(NisoImageMetadata niso, String margin) {
        String s;
        int ii;
        Rational r;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        this._writer.println(margn2 + XmlHandler.elementStart("mix:ImageAssessmentMetadata"));
        StringBuffer metricsBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:SpatialMetrics") + EOL);
        boolean useMetricsBuf = false;
        int n = niso.getSamplingFrequencyPlane();
        if (n != -1) {
            metricsBuf.append(margn4 + XmlHandler.element("mix:samplingFrequencyPlane", Integer.toString(n)) + EOL);
            useMetricsBuf = true;
        }
        if ((n = niso.getSamplingFrequencyUnit()) != -1) {
            String[] sfu = new String[]{null, "no absolute unit of measurement", "in.", "cm"};
            if (n < 1 || n > 3) {
                n = 1;
            }
            metricsBuf.append(margn4 + XmlHandler.element("mix:samplingFrequencyUnit", sfu[n]) + EOL);
            useMetricsBuf = true;
        }
        if ((r = niso.getXSamplingFrequency()) != null) {
            this.rationalToString(metricsBuf, "mix:xSamplingFrequency", margn4, r);
        }
        if ((r = niso.getYSamplingFrequency()) != null) {
            this.rationalToString(metricsBuf, "mix:ySamplingFrequency", margn4, r);
        }
        metricsBuf.append(margn3 + XmlHandler.elementEnd("mix:SpatialMetrics"));
        if (useMetricsBuf) {
            this._writer.println(metricsBuf);
        }
        StringBuffer colorEncBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:ImageColorEncoding") + EOL);
        boolean useColorEncBuf = false;
        int[] iarray = niso.getBitsPerSample();
        if (iarray != null) {
            colorEncBuf.append(margn4 + XmlHandler.elementStart("mix:BitsPerSample") + EOL);
            for (ii = 0; ii < iarray.length; ++ii) {
                colorEncBuf.append(margn5 + XmlHandler.element("mix:bitsPerSampleValue", Integer.toString(iarray[ii])) + EOL);
            }
            colorEncBuf.append(margn5 + XmlHandler.element("mix:bitsPerSampleUnit", "integer") + EOL);
            colorEncBuf.append(margn4 + XmlHandler.elementEnd("mix:BitsPerSample") + EOL);
            useColorEncBuf = true;
        }
        if ((n = niso.getSamplesPerPixel()) != -1) {
            colorEncBuf.append(margn4 + XmlHandler.element("mix:samplesPerPixel", Integer.toString(n)) + EOL);
            useColorEncBuf = true;
        }
        if ((iarray = niso.getExtraSamples()) != null) {
            for (ii = 0; ii < iarray.length; ++ii) {
                n = iarray[ii];
                if (n < 0 || n > 3) continue;
                colorEncBuf.append(margn4 + XmlHandler.element("mix:extraSamples", NisoImageMetadata.EXTRA_SAMPLE_20[n]) + EOL);
                useColorEncBuf = true;
            }
        }
        if ((s = niso.getColormapReference()) != null) {
            colorEncBuf.append(margn4 + XmlHandler.elementStart("mix:Colormap") + EOL);
            colorEncBuf.append(margn5 + XmlHandler.element("mix:colormapReference", s) + EOL);
            colorEncBuf.append(margn4 + XmlHandler.elementEnd("mix:Colormap") + EOL);
            useColorEncBuf = true;
        }
        iarray = niso.getGrayResponseCurve();
        n = niso.getGrayResponseUnit();
        if (iarray != null || n != -1) {
            StringBuffer grayRespBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:GrayResponse") + EOL);
            if (iarray != null) {
                for (int ii2 = 0; ii2 < iarray.length; ++ii2) {
                    grayRespBuf.append(margn5 + XmlHandler.element("mix:grayResponseCurve", Integer.toString(iarray[ii2])) + EOL);
                }
            }
            if (n != -1 && n > 0 && n <= 5) {
                grayRespBuf.append(margn5 + XmlHandler.element("mix:grayResponseUnit", NisoImageMetadata.GRAY_RESPONSE_UNIT_20[n - 1]) + EOL);
            }
            grayRespBuf.append(margn4 + XmlHandler.elementEnd("mix:GrayResponse") + EOL);
            colorEncBuf.append(grayRespBuf);
            useColorEncBuf = true;
        }
        r = niso.getWhitePointXValue();
        Rational r2 = niso.getWhitePointYValue();
        if (r != null || r2 != null) {
            colorEncBuf.append(margn4 + XmlHandler.elementStart("mix:WhitePoint") + EOL);
            if (r != null) {
                this.rationalToString(colorEncBuf, "mix:whitePointXValue", margn5, r);
            }
            if (r2 != null) {
                this.rationalToString(colorEncBuf, "mix:whitePointYValue", margn5, r2);
            }
            colorEncBuf.append(margn4 + XmlHandler.elementEnd("mix:WhitePoint") + EOL);
            useColorEncBuf = true;
        }
        StringBuffer chromaBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:PrimaryChromaticities") + EOL);
        boolean useChromaBuf = false;
        r = niso.getPrimaryChromaticitiesRedX();
        if (r != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesRedX", margn5, r);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesRedY()) != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesRedY", margn5, r);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesGreenX()) != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesGreenX", margn5, r);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesGreenY()) != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesGreenY", margn5, r);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesBlueX()) != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesBlueX", margn5, r);
            useChromaBuf = true;
        }
        if ((r = niso.getPrimaryChromaticitiesBlueY()) != null) {
            this.rationalToString(chromaBuf, "mix:primaryChromaticitiesBlueY", margn5, r);
            useChromaBuf = true;
        }
        chromaBuf.append(margn4 + XmlHandler.elementEnd("mix:PrimaryChromaticities") + EOL);
        if (useChromaBuf) {
            colorEncBuf.append(chromaBuf);
            useColorEncBuf = true;
        }
        colorEncBuf.append(margn3 + XmlHandler.elementEnd("mix:ImageColorEncoding") + EOL);
        if (useColorEncBuf) {
            this._writer.print(colorEncBuf);
        }
        StringBuffer targetBuf = new StringBuffer(margn3 + XmlHandler.elementStart("mix:TargetData") + EOL);
        boolean useTargetBuf = false;
        n = niso.getTargetType();
        if (n != -1) {
            targetBuf.append(margn4 + XmlHandler.element("mix:targetType", Integer.toString(n)) + EOL);
            useTargetBuf = true;
        }
        StringBuffer targetIDBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:TargetID") + EOL);
        boolean useTargetIDBuf = false;
        s = niso.getTargetIDManufacturer();
        if (s != null) {
            targetIDBuf.append(margn5 + XmlHandler.element("mix:targetManufacturer", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDName()) != null) {
            targetIDBuf.append(margn5 + XmlHandler.element("mix:targetName", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDNo()) != null) {
            targetIDBuf.append(margn5 + XmlHandler.element("mix:targetNo", s) + EOL);
            useTargetIDBuf = true;
        }
        if ((s = niso.getTargetIDMedia()) != null) {
            targetIDBuf.append(margn5 + XmlHandler.element("mix:targetMedia", s) + EOL);
            useTargetIDBuf = true;
        }
        targetIDBuf.append(margn4 + XmlHandler.elementEnd("mix:TargetID") + EOL);
        if (useTargetIDBuf) {
            targetBuf.append(targetIDBuf);
            useTargetBuf = true;
        }
        if ((s = niso.getImageData()) != null) {
            targetBuf.append(margn4 + XmlHandler.element("mix:externalTarget", s) + EOL);
            useTargetBuf = true;
        }
        if ((s = niso.getPerformanceData()) != null) {
            targetBuf.append(margn4 + XmlHandler.element("mix:performanceData", s) + EOL);
            useTargetBuf = true;
        }
        targetBuf.append(margn3 + XmlHandler.elementEnd("mix:TargetData") + EOL);
        if (useTargetBuf) {
            this._writer.print(targetBuf);
        }
        this._writer.println(margn2 + XmlHandler.elementEnd("mix:ImageAssessmentMetadata"));
    }

    protected void showChangeHistory20(NisoImageMetadata niso, String margin) {
        String[] sarray;
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        StringBuffer chBuf = new StringBuffer(margn2 + XmlHandler.elementStart("mix:ChangeHistory") + EOL);
        boolean useChBuf = false;
        chBuf.append(margn3 + XmlHandler.elementStart("mix:ImageProcessing") + EOL);
        String s = niso.getSourceData();
        if (s != null) {
            chBuf.append(margn4 + XmlHandler.element("mix:sourceData") + EOL);
            useChBuf = true;
        }
        if ((s = niso.getProcessingAgency()) != null) {
            chBuf.append(margn4 + XmlHandler.element("mix:processingAgency") + EOL);
            useChBuf = true;
        }
        StringBuffer sftwBuf = new StringBuffer(margn4 + XmlHandler.elementStart("mix:ProcessingSoftware") + EOL);
        boolean useSftwBuf = false;
        s = niso.getProcessingSoftwareName();
        if (s != null) {
            sftwBuf.append(margn5 + XmlHandler.element("mix:processingSoftwareName", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getProcessingSoftwareVersion()) != null) {
            sftwBuf.append(margn5 + XmlHandler.element("mix:processingSoftwareVersion", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getOS()) != null) {
            sftwBuf.append(margn5 + XmlHandler.element("mix:processingOperatingSystemName", s) + EOL);
            useSftwBuf = true;
        }
        if ((s = niso.getOSVersion()) != null) {
            sftwBuf.append(margn5 + XmlHandler.element("mix:processingOperatingSystemVersion", s) + EOL);
            useSftwBuf = true;
        }
        sftwBuf.append(margn4 + XmlHandler.elementEnd("mix:ProcessingSoftware") + EOL);
        if (useSftwBuf) {
            chBuf.append(sftwBuf);
            useChBuf = true;
        }
        if ((sarray = niso.getProcessingActions()) != null) {
            for (int i = 0; i < sarray.length; ++i) {
                chBuf.append(margn4 + XmlHandler.element("mix:processingActions", sarray[i]) + EOL);
            }
            useChBuf = true;
        }
        chBuf.append(margn3 + XmlHandler.elementEnd("mix:ImageProcessing") + EOL);
        chBuf.append(margn2 + XmlHandler.elementEnd("mix:ChangeHistory") + EOL);
        if (useChBuf) {
            this._writer.println(chBuf);
        }
    }

    private String meteringModeToString(int n) {
        String s = NisoImageMetadata.METERING_MODE[1];
        if (n >= 1 && n <= 6) {
            s = NisoImageMetadata.METERING_MODE[n];
        }
        return s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1);
    }

    private String photometricInterpretationToString(int n) {
        String s = "Unknown";
        switch (n) {
            case 0: {
                s = "WhiteIsZero";
                break;
            }
            case 1: {
                s = "BlackIsZero";
                break;
            }
            case 2: {
                s = "RGB";
                break;
            }
            case 3: {
                s = "PaletteColor";
                break;
            }
            case 4: {
                s = "TransparencyMask";
                break;
            }
            case 5: {
                s = "CMYK";
                break;
            }
            case 6: {
                s = "YCbCr";
                break;
            }
            case 8: {
                s = "CIELab";
                break;
            }
            case 9: {
                s = "ICCLab";
                break;
            }
            case 10: {
                s = "ITULab";
                break;
            }
            case 32803: {
                s = "CFA";
                break;
            }
            case 34892: {
                s = "LinearRaw";
            }
        }
        return s;
    }

    protected void showAESAudioMetadata(AESAudioMetadata aes) {
        List flist;
        List facelist;
        String[] use;
        long lin;
        int in;
        this._level += 3;
        String margin = XmlHandler.getIndent(this._level);
        String margn2 = margin + " ";
        String margn3 = margn2 + " ";
        String margn4 = margn3 + " ";
        String margn5 = margn4 + " ";
        String formatRegionID = "J1";
        String faceRegionID = "J2";
        String faceID = "J3";
        String audioObjectID = "J4";
        String streamIDBase = "J9";
        this._sampleRate = aes.getSampleRate();
        String[][] attrs = new String[][]{{"xmlns:aes", "http://www.aes.org/audioObject"}, {"xmlns:tcf", "http://www.aes.org/tcf"}, {"xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"}, {"ID", "J4"}, {"analogDigitalFlag", aes.getAnalogDigitalFlag()}, {"disposition", "Validated by JHOVE"}, {"schemaVersion", "1.02b"}};
        this._writer.println(margin + XmlHandler.elementStart("aes:audioObject", attrs));
        String s = aes.getFormat();
        if (s != null) {
            String v = aes.getSpecificationVersion();
            String[][] fmattrs = new String[1][2];
            fmattrs[0][0] = "specificationVersion";
            fmattrs[0][1] = v != null ? v : "";
            this._writer.println(margn2 + XmlHandler.element("aes:format", fmattrs, s));
        }
        if ((s = aes.getAppSpecificData()) != null) {
            this._writer.println(margn2 + XmlHandler.element("aes:appSpecificData", s));
        }
        if ((s = aes.getAudioDataEncoding()) != null) {
            this._writer.println(margn2 + XmlHandler.element("aes:audioDataEncoding", s));
        }
        if ((in = aes.getByteOrder()) != -1) {
            this._writer.println(margn2 + XmlHandler.element("aes:byteOrder", in == 0 ? "BIG_ENDIAN" : "LITTLE_ENDIAN"));
        }
        if ((lin = aes.getFirstSampleOffset()) != -1L) {
            this._writer.println(margn2 + XmlHandler.element("aes:firstSampleOffset", Long.toString(lin)));
        }
        if ((use = aes.getUse()) != null) {
            String[][] uattrs = new String[][]{{"useType", use[0]}, {"otherType", use[1]}};
            this._writer.println(margn2 + XmlHandler.element("aes:use", uattrs));
        }
        if ((s = aes.getPrimaryIdentifier()) != null) {
            String t = aes.getPrimaryIdentifierType();
            String[][] idattrs = new String[1][2];
            idattrs[0][0] = "identifierType";
            idattrs[0][1] = t != null ? t : "";
            this._writer.println(margn2 + XmlHandler.element("aes:primaryIdentifier", idattrs, s));
        }
        if (!(facelist = aes.getFaceList()).isEmpty()) {
            String[][] faceRegionAttrs = new String[][]{{"ID", "J2"}, {"formatRef", "J1"}, {"faceRef", "J3"}, {"label", "BuiltByJHOVE"}};
            String[][] faceAttrs = new String[][]{{"direction", null}, {"ID", "J3"}, {"audioObjectRef", "J4"}, {"label", "Face"}};
            AESAudioMetadata.Face f = (AESAudioMetadata.Face)facelist.get(0);
            faceAttrs[0][1] = f.getDirection();
            this._writer.println(margn2 + XmlHandler.elementStart("aes:face", faceAttrs));
            AESAudioMetadata.TimeDesc startTime = f.getStartTime();
            if (startTime != null) {
                this._writer.println(margn3 + XmlHandler.elementStart("aes:timeline"));
                this.writeAESTimeRange(margn3, startTime, f.getDuration());
                this._writer.println(margn3 + XmlHandler.elementEnd("aes:timeline"));
            }
            AESAudioMetadata.FaceRegion facergn = f.getFaceRegion(0);
            this._writer.println(margn3 + XmlHandler.elementStart("aes:region", faceRegionAttrs));
            this._writer.println(margn4 + XmlHandler.elementStart("aes:timeRange"));
            this.writeAESTimeRange(margn3, facergn.getStartTime(), facergn.getDuration());
            this._writer.println(margn4 + XmlHandler.elementEnd("aes:timeRange"));
            int nchan = aes.getNumChannels();
            if (nchan != -1) {
                this._writer.println(margn4 + XmlHandler.element("aes:numChannels", Integer.toString(nchan)));
            }
            String[] locs = aes.getMapLocations();
            for (int ch = 0; ch < nchan; ++ch) {
                String[][] streamAttrs = new String[][]{{"ID", "J9" + Integer.toString(ch)}, {"label", "JHOVE"}, {"faceRegionRef", "J2"}};
                this._writer.println(margn4 + XmlHandler.elementStart("aes:stream", streamAttrs));
                String[][] chanAttrs = new String[][]{{"channelNum", Integer.toString(ch)}, {"mapLocation", locs[ch]}};
                this._writer.println(margn5 + XmlHandler.element("aes:channelAssignment", chanAttrs));
                this._writer.println(margn4 + XmlHandler.elementEnd("aes:stream"));
            }
            this._writer.println(margn3 + XmlHandler.elementEnd("aes:region"));
            this._writer.println(margn2 + XmlHandler.elementEnd("aes:face"));
        }
        if (!(flist = aes.getFormatList()).isEmpty()) {
            AESAudioMetadata.FormatRegion rgn = (AESAudioMetadata.FormatRegion)flist.get(0);
            int bitDepth = rgn.getBitDepth();
            double sampleRate = rgn.getSampleRate();
            int wordSize = rgn.getWordSize();
            String[] bitRed = rgn.getBitrateReduction();
            if (bitDepth != -1 || sampleRate != -1.0 || wordSize != -1) {
                this._writer.println(margn2 + XmlHandler.elementStart("aes:formatList"));
                String[][] frAttr = new String[][]{{"ID", "J1"}};
                this._writer.println(margn3 + XmlHandler.elementStart("aes:formatRegion", frAttr));
                if (bitDepth != -1) {
                    this._writer.println(margn4 + XmlHandler.element("aes:bitDepth", Integer.toString(bitDepth)));
                }
                if (sampleRate != -1.0) {
                    this._writer.println(margn4 + XmlHandler.element("aes:sampleRate", formatters.get().format(sampleRate)));
                }
                if (wordSize != -1) {
                    this._writer.println(margn4 + XmlHandler.element("aes:wordSize", Integer.toString(wordSize)));
                }
                if (bitRed != null) {
                    this._writer.println(margn4 + XmlHandler.elementStart("aes:bitrateReduction"));
                    this._writer.println(margn5 + XmlHandler.element("aes:codecName", bitRed[0]));
                    this._writer.println(margn5 + XmlHandler.element("aes:codecNameVersion", bitRed[1]));
                    this._writer.println(margn5 + XmlHandler.element("aes:codecCreatorApplication", bitRed[2]));
                    this._writer.println(margn5 + XmlHandler.element("aes:codecCreatorApplicationVersion", bitRed[3]));
                    this._writer.println(margn5 + XmlHandler.element("aes:codecQuality", bitRed[4]));
                    this._writer.println(margn5 + XmlHandler.element("aes:dataRate", bitRed[5]));
                    this._writer.println(margn5 + XmlHandler.element("aes:dataRateMode", bitRed[6]));
                    this._writer.println(margn4 + XmlHandler.elementEnd("aes:bitrateReduction"));
                }
                this._writer.println(margn3 + XmlHandler.elementEnd("aes:formatRegion"));
                this._writer.println(margn2 + XmlHandler.elementEnd("aes:formatList"));
            }
        }
        this._writer.println(margin + XmlHandler.elementEnd("aes:audioObject"));
        this._level -= 3;
    }

    private void writeAESTimeRange(String baseIndent, AESAudioMetadata.TimeDesc start, AESAudioMetadata.TimeDesc duration) {
        String margn1 = baseIndent + " ";
        String margn2 = margn1 + " ";
        String margn3 = margn2 + " ";
        String[][] attrs = new String[][]{{"tcf:frameCount", "30"}, {"tcf:timeBase", "1000"}, {"tcf:videoField", "FIELD_1"}, {"tcf:countingMode", "NTSC_NON_DROP_FRAME"}};
        String[][] ffAttrs = new String[][]{{"tcf:framing", "NOT_APPLICABLE"}, {"xsi:type", "tcf:ntscFilmFramingType"}};
        this._writer.println(margn1 + XmlHandler.elementStart("tcf:startTime", attrs));
        this._writer.println(margn2 + XmlHandler.element("tcf:hours", Integer.toString(start.getHours())));
        this._writer.println(margn2 + XmlHandler.element("tcf:minutes", Integer.toString(start.getMinutes())));
        this._writer.println(margn2 + XmlHandler.element("tcf:seconds", Integer.toString(start.getSeconds())));
        this._writer.println(margn2 + XmlHandler.element("tcf:frames", Integer.toString(start.getFrames())));
        String[][] sampleAttrs = new String[][]{{"tcf:sampleRate", ""}};
        double sr = start.getSampleRate();
        if (sr == 1.0) {
            sr = this._sampleRate;
        }
        sampleAttrs[0][1] = "S" + Integer.toString((int)sr);
        this._writer.println(margn2 + XmlHandler.elementStart("tcf:samples", sampleAttrs));
        this._writer.println(margn3 + XmlHandler.element("tcf:numberOfSamples", Integer.toString(start.getSamples())));
        this._writer.println(margn2 + XmlHandler.elementEnd("tcf:samples"));
        this._writer.println(margn2 + XmlHandler.element("tcf:filmFraming", ffAttrs));
        this._writer.println(margn1 + XmlHandler.elementEnd("tcf:startTime"));
        if (duration != null) {
            this._writer.println(margn1 + XmlHandler.elementStart("tcf:duration", attrs));
            this._writer.println(margn2 + XmlHandler.element("tcf:hours", Integer.toString(duration.getHours())));
            this._writer.println(margn2 + XmlHandler.element("tcf:minutes", Integer.toString(duration.getMinutes())));
            this._writer.println(margn2 + XmlHandler.element("tcf:seconds", Integer.toString(duration.getSeconds())));
            this._writer.println(margn2 + XmlHandler.element("tcf:frames", Integer.toString(duration.getFrames())));
            sr = duration.getSampleRate();
            if (sr == 1.0) {
                sr = this._sampleRate;
            }
            sampleAttrs[0][1] = "S" + Integer.toString((int)sr);
            this._writer.println(margn2 + XmlHandler.elementStart("tcf:samples", sampleAttrs));
            this._writer.println(margn3 + XmlHandler.element("tcf:numberOfSamples", Integer.toString(duration.getSamples())));
            this._writer.println(margn2 + XmlHandler.elementEnd("tcf:samples"));
            this._writer.println(margn2 + XmlHandler.element("tcf:filmFraming", ffAttrs));
            this._writer.println(margn1 + XmlHandler.elementEnd("tcf:duration"));
        }
    }

    private String cleanURIString(String uri) {
        StringBuffer sb = new StringBuffer(uri.length() * 2);
        boolean change = false;
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '%' || "-_.!~*'();/?:@=+$,".indexOf(c) >= 0) {
                sb.append(c);
                continue;
            }
            char cval = c;
            int mshd = cval >> 4;
            mshd = mshd >= 10 ? (mshd += 55) : (mshd += 48);
            sb.append('%');
            sb.append((char)mshd);
            int lshd = cval & 0xF;
            lshd = lshd >= 10 ? (lshd += 55) : (lshd += 48);
            sb.append((char)lshd);
            change = true;
        }
        if (change) {
            return sb.toString();
        }
        return uri;
    }

    public void rationalToString(StringBuffer buf, String tag, String margin, Rational r) {
        String margn2 = margin + " ";
        long numer = r.getNumerator();
        long denom = r.getDenominator();
        buf.append(margin + XmlHandler.elementStart(tag) + EOL);
        buf.append(margn2 + XmlHandler.element("mix:numerator", Long.toString(numer)) + EOL);
        if (denom != 1L) {
            buf.append(margn2 + XmlHandler.element("mix:denominator", Long.toString(denom)) + EOL);
        }
        buf.append(margin + XmlHandler.elementEnd(tag) + EOL);
    }
}

