/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.PrintWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Logger;

public abstract class HandlerBase
implements OutputHandler {
    public static SynchronizedDateFormat date = new SynchronizedDateFormat("yyyy-MM-dd");
    public static SynchronizedDateFormat dateTime = new SynchronizedDateFormat("yyyy-MM-dd HH:mm:ss z");
    public static SynchronizedDateFormat iso8601 = new SynchronizedDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    protected App _app;
    protected JhoveBase _base;
    protected Date _date;
    protected String _encoding;
    protected String _init;
    protected List<String> _defaultParams;
    protected JhoveBase _je;
    protected int _level;
    protected String _name;
    protected String _note;
    protected String _release;
    protected String _param;
    protected String _rights;
    protected List<Document> _specification;
    protected Agent _vendor;
    protected PrintWriter _writer;
    protected Logger _logger = Logger.getLogger("edu.harvard.hul.ois.jhove.handler");

    protected HandlerBase(String name, String release, int[] date, String note, String rights) {
        this._logger.info("Initializing " + name);
        this._name = name;
        this._release = release;
        this._encoding = "UTF-8";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(date[0], date[1] - 1, date[2]);
        this._date = calendar.getTime();
        this._note = note;
        this._rights = rights;
        this._specification = new ArrayList<Document>();
        this._level = -1;
    }

    @Override
    public void reset() {
        this._level = -1;
    }

    @Override
    public void setDefaultParams(List<String> params) {
        this._defaultParams = params;
    }

    @Override
    public void applyDefaultParams() {
        this.resetParams();
        for (String parm : this._defaultParams) {
            this.param(parm);
        }
    }

    @Override
    public void resetParams() {
        this._param = null;
    }

    @Override
    public void init(String init) {
        this._init = init;
    }

    @Override
    public void param(String param) {
        this._param = param;
    }

    @Override
    public final Date getDate() {
        return this._date;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final String getNote() {
        return this._note;
    }

    @Override
    public final String getRelease() {
        return this._release;
    }

    @Override
    public final String getRights() {
        return this._rights;
    }

    @Override
    public final List<Document> getSpecification() {
        return this._specification;
    }

    @Override
    public final Agent getVendor() {
        return this._vendor;
    }

    @Override
    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public final void setApp(App app) {
        this._app = app;
    }

    @Override
    public final void setBase(JhoveBase je) {
        this._je = je;
    }

    @Override
    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    @Override
    public final void setWriter(PrintWriter writer) {
        this._writer = writer;
    }

    @Override
    public void analyze(RepInfo info) {
    }

    @Override
    public void endDirectory() {
    }

    @Override
    public boolean okToProcess(String filepath) {
        return true;
    }

    @Override
    public abstract void show(Module var1);

    @Override
    public abstract void show(RepInfo var1);

    @Override
    public abstract void show(OutputHandler var1);

    @Override
    public abstract void show();

    @Override
    public abstract void show(App var1);

    @Override
    public abstract void showHeader();

    @Override
    public abstract void showFooter();

    @Override
    public void close() {
        this._writer.close();
    }

    @Override
    public void startDirectory(String directory) {
    }

    protected static String doctype(String root, String uri) {
        return HandlerBase.doctype(root, null, uri);
    }

    protected static String doctype(String root, String name, String uri) {
        StringBuffer s = new StringBuffer("<!DOCTYPE " + root);
        if (name != null) {
            s.append(" PUBLIC \"" + name + "\" \"");
        } else {
            s.append(" SYSTEM \"");
        }
        s.append(uri + "\">");
        return s.toString();
    }

    protected static String element(String tag) {
        return "<" + tag + "/>";
    }

    protected static String element(String tag, String content) {
        return HandlerBase.elementStart(tag) + HandlerBase.encodeContent(content) + HandlerBase.elementEnd(tag);
    }

    protected static String element(String tag, String[][] attrs) {
        StringBuffer buffer = new StringBuffer("<");
        buffer.append(tag);
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i][0] == null || attrs[i][1] == null) continue;
            buffer.append(" ");
            buffer.append(attrs[i][0]);
            buffer.append("=\"");
            buffer.append(HandlerBase.encodeValue(attrs[i][1]));
            buffer.append("\"");
        }
        buffer.append("/>");
        return buffer.toString();
    }

    protected static String element(String tag, String[][] attrs, String content) {
        StringBuffer buffer = new StringBuffer("<");
        buffer.append(tag);
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i][0] == null || attrs[i][1] == null) continue;
            buffer.append(" ");
            buffer.append(attrs[i][0]);
            buffer.append("=\"");
            buffer.append(HandlerBase.encodeValue(attrs[i][1]));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(HandlerBase.encodeContent(content));
        buffer.append(HandlerBase.elementEnd(tag));
        return buffer.toString();
    }

    protected static String elementEnd(String tag) {
        return "</" + tag + ">";
    }

    protected static String elementStart(String tag) {
        return "<" + tag + ">";
    }

    protected static String elementStart(String tag, String[][] attrs) {
        StringBuffer buffer = new StringBuffer("<");
        buffer.append(tag);
        for (int i = 0; i < attrs.length; ++i) {
            buffer.append(" ");
            buffer.append(attrs[i][0]);
            buffer.append("=\"");
            buffer.append(HandlerBase.encodeValue(attrs[i][1]));
            buffer.append("\"");
        }
        buffer.append(">");
        return buffer.toString();
    }

    private static String encodeContent(String content) {
        if (content == null) {
            content = "";
        }
        StringBuffer buffer = new StringBuffer(content);
        int n = buffer.length();
        for (int i = 0; i < n; ++i) {
            char ch = buffer.charAt(i);
            if (!('\u0000' <= ch && ch <= '\b' || '\u000b' <= ch && ch <= '\f' || '\u000e' <= ch && ch <= '\u001f') && '\u007f' != ch) continue;
            buffer.deleteCharAt(i--);
            --n;
        }
        n = 0;
        while ((n = buffer.indexOf("&", n)) > -1) {
            buffer.insert(n + 1, "amp;");
            n += 5;
        }
        n = 0;
        while ((n = buffer.indexOf("<", n)) > -1) {
            buffer.replace(n, n + 1, "&lt;");
            n += 4;
        }
        n = 0;
        while ((n = buffer.indexOf(">", n)) > -1) {
            buffer.replace(n, n + 1, "&gt;");
            n += 4;
        }
        return buffer.toString();
    }

    private static String encodeValue(String value) {
        StringBuffer buffer = new StringBuffer(value);
        int n = buffer.length();
        for (int i = 0; i < n; ++i) {
            char ch = buffer.charAt(i);
            if (!('\u0000' <= ch && ch <= '\b' || '\u000b' <= ch && ch <= '\f' || '\u000e' <= ch && ch <= '\u001f') && '\u007f' != ch) continue;
            buffer.deleteCharAt(i--);
            --n;
        }
        n = 0;
        while ((n = buffer.indexOf("&", n)) > -1) {
            buffer.insert(n + 1, "amp;");
            n += 5;
        }
        n = 0;
        while ((n = buffer.indexOf("<", n)) > -1) {
            buffer.replace(n, n + 1, "&lt;");
            n += 4;
        }
        n = 0;
        while ((n = buffer.indexOf(">", n)) > -1) {
            buffer.replace(n, n + 1, "&gt;");
            n += 4;
        }
        n = 0;
        while ((n = buffer.indexOf("\"", n)) > -1) {
            buffer.replace(n, n + 1, "&quot;");
            n += 7;
        }
        return buffer.toString();
    }

    protected static String xmlDecl() {
        return "<?xml version=\"1.0\"?>";
    }

    protected static String xmlDecl(String encoding) {
        return "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
    }

    protected static String getIndent(int level) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            s.append(" ");
        }
        return s.toString();
    }

    protected static String integerArray(int[] iarray) {
        return HandlerBase.integerArray(iarray, ' ');
    }

    protected static String integerArray(int[] iarray, char separator) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < iarray.length; ++i) {
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(Integer.toString(iarray[i]));
        }
        return buffer.toString();
    }

    protected static String longArray(long[] larray) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < larray.length; ++i) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(Long.toString(larray[i]));
        }
        return buffer.toString();
    }

    protected static String rationalArray(Rational[] rarray) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < rarray.length; ++i) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(rarray[i].toDouble());
        }
        return buffer.toString();
    }

    protected static String rationalArray10(Rational[] rarray) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < rarray.length; ++i) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(rarray[i].getNumerator());
            buffer.append(" ");
            buffer.append(rarray[i].getNumerator());
        }
        return buffer.toString();
    }

    protected static String doubleArray(double[] darray) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < darray.length; ++i) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(Double.toString(darray[i]));
        }
        return buffer.toString();
    }

    protected String toDateTime(Date date) {
        String isoStr = iso8601.format(date);
        int len = isoStr.length();
        return isoStr.substring(0, len - 2) + ":" + isoStr.substring(len - 2);
    }

    public static class SynchronizedDateFormat
    extends SimpleDateFormat {
        public SynchronizedDateFormat(String pattern) {
            super(pattern);
        }

        @Override
        public synchronized StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
            return super.format(date, toAppendTo, pos);
        }
    }
}

