/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.ListIterator;

public class ObjectIdentifier {
    private List<Module> _moduleList;

    public ObjectIdentifier(List<Module> moduleList) {
        this._moduleList = moduleList;
    }

    public void identify(File file, RepInfo info, String parm, boolean verbose, boolean shortCheck) {
        ListIterator<Module> modIter = this._moduleList.listIterator();
        while (modIter.hasNext()) {
            RepInfo info1;
            block29: {
                info1 = (RepInfo)info.clone();
                Module mod = modIter.next();
                try {
                    if (!mod.hasFeature("edu.harvard.hul.ois.jhove.canValidate")) continue;
                    if (mod.isRandomAccess()) {
                        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                            mod.param(parm);
                            if (verbose) {
                                mod.setVerbosity(1);
                            }
                            if (shortCheck) {
                                mod.checkSignatures(file, raf, info1);
                            } else {
                                mod.parse(raf, info1);
                            }
                            break block29;
                        }
                    }
                    mod.param(parm);
                    if (shortCheck) {
                        try (FileInputStream stream = new FileInputStream(file);){
                            mod.checkSignatures(file, stream, info1);
                            break block29;
                        }
                    }
                    int parseIndex = 0;
                    try (FileInputStream stream = new FileInputStream(file);){
                        parseIndex = mod.parse(stream, info1, 0);
                    }
                    while (parseIndex != 0) {
                        stream = new FileInputStream(file);
                        try {
                            parseIndex = mod.parse(stream, info1, parseIndex);
                        }
                        finally {
                            ((InputStream)stream).close();
                        }
                    }
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (info1.getWellFormed() != 1) continue;
            info.copy(info1);
            break;
        }
    }
}

