/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AESAudioMetadata {
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    public static final String[] A_D = new String[]{"ANALOG", "PHYS_DIGITAL", "FILE_DIGITAL"};
    public static final String FILE_NAME = "FILE_NAME";
    public static final String OTHER = "OTHER";
    public static final int NULL = -1;
    public static final double NILL = -1.0;
    public static final String SCHEMA_VERSION = "1.02b";
    private static final String DEFAULT_DISPOSITION = "validation";
    private String _analogDigitalFlag = null;
    private String _appSpecificData;
    private String _audioDataEncoding = null;
    private int _byteOrder;
    private String _disposition = "validation";
    private List<Face> _faceList;
    private long _firstSampleOffset;
    private String _format = null;
    private List<FormatRegion> _formatList = new LinkedList<FormatRegion>();
    private int _numChannels;
    private String _primaryIdentifier = null;
    private String _primaryIdentifierType = null;
    private String _primaryIdentifierOtherType;
    private String _schemaVersion = "1.02b";
    private String _specificationVersion = null;
    private String[] _use = null;
    private FormatRegion _curFormatRegion;
    private Face _curFace;

    public AESAudioMetadata() {
        this._faceList = new LinkedList<Face>();
        this.addFormatRegion();
        this.addFace();
        this._numChannels = -1;
        this._byteOrder = -1;
        this._firstSampleOffset = -1L;
    }

    public String getAnalogDigitalFlag() {
        return this._analogDigitalFlag;
    }

    public String getAppSpecificData() {
        return this._appSpecificData;
    }

    public String getAudioDataEncoding() {
        return this._audioDataEncoding;
    }

    public String[] getBitrateReduction() {
        return this._curFormatRegion.getBitrateReduction();
    }

    public double getSampleRate() {
        return this._curFormatRegion.getSampleRate();
    }

    public int getByteOrder() {
        return this._byteOrder;
    }

    public String getDisposition() {
        return this._disposition;
    }

    public List<Face> getFaceList() {
        return this._faceList;
    }

    public long getFirstSampleOffset() {
        return this._firstSampleOffset;
    }

    public String getFormat() {
        return this._format;
    }

    public List<FormatRegion> getFormatList() {
        return this._formatList;
    }

    public String[] getMapLocations() {
        return this._curFace.getFaceRegion(0).getMapLocations();
    }

    public int getNumChannels() {
        return this._numChannels;
    }

    public String getPrimaryIdentifier() {
        return this._primaryIdentifier;
    }

    public String getPrimaryIdentifierType() {
        return this._primaryIdentifierType;
    }

    public String getSchemaVersion() {
        return this._schemaVersion;
    }

    public String getSpecificationVersion() {
        return this._specificationVersion;
    }

    public String[] getUse() {
        return this._use;
    }

    public void setAnalogDigitalFlag(String flagType) {
        this._analogDigitalFlag = flagType;
    }

    public void setBitrateReduction(String codecName, String codecNameVersion, String codecCreatorApplication, String codecCreatorApplicationVersion, String codecQuality, String dataRate, String dataRateMode) {
        this._curFormatRegion.setBitrateReduction(codecName, codecNameVersion, codecCreatorApplication, codecCreatorApplicationVersion, codecQuality, dataRate, dataRateMode);
    }

    public void clearBitrateReduction() {
        this._curFormatRegion.clearBitrateReduction();
    }

    public void setByteOrder(int order) {
        this._byteOrder = order;
    }

    public void setByteOrder(String order) {
        if (order.substring(0, 3).toLowerCase().equals("big")) {
            this._byteOrder = 0;
        } else if (order.substring(0, 6).toLowerCase().equals("little")) {
            this._byteOrder = 1;
        }
    }

    public void setAudioDataEncoding(String audioDataEncoding) {
        this._audioDataEncoding = audioDataEncoding;
    }

    public void setAppSpecificData(String data) {
        this._appSpecificData = data;
    }

    public void setBitDepth(int bitDepth) {
        this._curFormatRegion.setBitDepth(bitDepth);
    }

    public void setDisposition(String disposition) {
        this._disposition = disposition;
    }

    public void setDirection(String direction) {
        this._curFace.setDirection(direction);
    }

    public void setDuration(long duration) {
        this._curFace.setDuration(duration);
        this._curFace.getFaceRegion(0).setDuration(duration);
    }

    public void setFirstSampleOffset(long offset) {
        this._firstSampleOffset = offset;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public void setMapLocations(String[] locations) {
        this._curFace.getFaceRegion(0).setMapLocations(locations);
    }

    public void setNumChannels(int numChannels) {
        this._numChannels = numChannels;
    }

    public void setPrimaryIdentifier(String primaryIdentifier) {
        this._primaryIdentifier = primaryIdentifier;
    }

    public void setPrimaryIdentifierType(String primaryIdentifierType) {
        this._primaryIdentifierType = primaryIdentifierType;
    }

    public void setOtherPrimaryIdentifierType(String otherType) {
        this._primaryIdentifierType = OTHER;
        this._primaryIdentifierOtherType = otherType;
    }

    public void setSampleRate(double sampleRate) {
        this._curFormatRegion.setSampleRate(sampleRate);
    }

    public void setSpecificationVersion(String specificationVersion) {
        this._specificationVersion = specificationVersion;
    }

    public void setStartTime(long samples) {
        this._curFace.setStartTime(samples);
        this._curFace.getFaceRegion(0).setStartTime(samples);
    }

    public void setUse(String useType, String otherType) {
        this._use = new String[]{useType, otherType};
    }

    public void setWordSize(int wordSize) {
        this._curFormatRegion.setWordSize(wordSize);
    }

    public void addFormatRegion() {
        this._curFormatRegion = new FormatRegionImpl();
        this._formatList.add(this._curFormatRegion);
    }

    public void addFace() {
        this._curFace = new FaceImpl();
        this._faceList.add(this._curFace);
        this._curFace.addFaceRegion();
    }

    public static interface FormatRegion {
        public int getBitDepth();

        public String[] getBitrateReduction();

        public double getSampleRate();

        public int getWordSize();

        public boolean isEmpty();

        public void setBitDepth(int var1);

        public void clearBitrateReduction();

        public void setBitrateReduction(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

        public void setSampleRate(double var1);

        public void setWordSize(int var1);
    }

    public static interface Face {
        public FaceRegion getFaceRegion(int var1);

        public void addFaceRegion();

        public TimeDesc getStartTime();

        public TimeDesc getDuration();

        public String getDirection();

        public void setStartTime(long var1);

        public void setDuration(long var1);

        public void setDirection(String var1);
    }

    public static interface FaceRegion {
        public TimeDesc getStartTime();

        public TimeDesc getDuration();

        public String[] getMapLocations();

        public void setStartTime(long var1);

        public void setDuration(long var1);

        public void setMapLocations(String[] var1);
    }

    class FormatRegionImpl
    implements FormatRegion {
        private int _bitDepth = -1;
        private double _sampleRate = -1.0;
        private int _wordSize = -1;
        private String[] _bitrateReduction = null;

        @Override
        public int getBitDepth() {
            return this._bitDepth;
        }

        @Override
        public String[] getBitrateReduction() {
            return this._bitrateReduction;
        }

        @Override
        public double getSampleRate() {
            return this._sampleRate;
        }

        @Override
        public int getWordSize() {
            return this._wordSize;
        }

        @Override
        public boolean isEmpty() {
            return this._bitDepth == -1 && this._sampleRate == -1.0 && this._wordSize == -1;
        }

        @Override
        public void setBitDepth(int bitDepth) {
            this._bitDepth = bitDepth;
        }

        @Override
        public void clearBitrateReduction() {
            this._bitrateReduction = null;
        }

        @Override
        public void setBitrateReduction(String codecName, String codecNameVersion, String codecCreatorApplication, String codecCreatorApplicationVersion, String codecQuality, String dataRate, String dataRateMode) {
            this._bitrateReduction = new String[7];
            this._bitrateReduction[0] = codecName;
            this._bitrateReduction[1] = codecNameVersion;
            this._bitrateReduction[2] = codecCreatorApplication;
            this._bitrateReduction[3] = codecCreatorApplicationVersion;
            this._bitrateReduction[4] = codecQuality;
            this._bitrateReduction[5] = dataRate;
            this._bitrateReduction[6] = dataRateMode;
        }

        @Override
        public void setSampleRate(double sampleRate) {
            this._sampleRate = sampleRate;
        }

        @Override
        public void setWordSize(int wordSize) {
            this._wordSize = wordSize;
        }
    }

    class FaceImpl
    implements Face {
        private List<FaceRegion> _regionList = new ArrayList<FaceRegion>();
        private TimeDesc _startTime;
        private TimeDesc _duration;
        private String _direction;

        public FaceImpl() {
            this._startTime = new TimeDescImpl(0L);
            this._duration = null;
        }

        @Override
        public FaceRegion getFaceRegion(int i) {
            return this._regionList.get(i);
        }

        @Override
        public void addFaceRegion() {
            this._regionList.add(new FaceRegionImpl());
        }

        @Override
        public TimeDesc getStartTime() {
            return this._startTime;
        }

        @Override
        public TimeDesc getDuration() {
            return this._duration;
        }

        @Override
        public String getDirection() {
            return this._direction;
        }

        @Override
        public void setStartTime(long samples) {
            this._startTime = new TimeDescImpl(samples);
        }

        @Override
        public void setDuration(long samples) {
            this._duration = new TimeDescImpl(samples);
        }

        @Override
        public void setDirection(String direction) {
            this._direction = direction;
        }
    }

    class FaceRegionImpl
    implements FaceRegion {
        private TimeDesc _startTime;
        private TimeDesc _duration;
        private String[] _mapLocations;

        public FaceRegionImpl() {
            this._startTime = new TimeDescImpl(0L);
            this._duration = null;
        }

        @Override
        public TimeDesc getStartTime() {
            return this._startTime;
        }

        @Override
        public TimeDesc getDuration() {
            return this._duration;
        }

        @Override
        public String[] getMapLocations() {
            return this._mapLocations;
        }

        @Override
        public void setStartTime(long samples) {
            this._startTime = new TimeDescImpl(samples);
        }

        @Override
        public void setDuration(long samples) {
            this._duration = new TimeDescImpl(samples);
        }

        @Override
        public void setMapLocations(String[] locations) {
            this._mapLocations = locations;
        }
    }

    class TimeDescImpl
    implements TimeDesc {
        private long _hours;
        private long _minutes;
        private long _seconds;
        private long _frames;
        private long _samples;
        private double _sampleRate;
        private long _frameCount;

        public TimeDescImpl(long samples) {
            long _sample_count = samples;
            this._frameCount = 30L;
            this._sampleRate = AESAudioMetadata.this._curFormatRegion.getSampleRate();
            if (this._sampleRate < 0.0) {
                this._sampleRate = 44100.0;
            }
            long sample_in_1_frame = (long)(this._sampleRate / (double)this._frameCount);
            long sample_in_1_second = sample_in_1_frame * this._frameCount;
            long sample_in_1_minute = sample_in_1_frame * this._frameCount * 60L;
            long sample_in_1_hour = sample_in_1_frame * this._frameCount * 60L * 60L;
            long sample_in_1_day = sample_in_1_frame * this._frameCount * 60L * 60L * 24L;
            if (_sample_count < 0L) {
                _sample_count += sample_in_1_day;
                _sample_count %= sample_in_1_day;
            }
            this._hours = _sample_count / sample_in_1_hour;
            this._minutes = (_sample_count -= this._hours * sample_in_1_hour) / sample_in_1_minute;
            this._seconds = (_sample_count -= this._minutes * sample_in_1_minute) / sample_in_1_second;
            this._frames = (_sample_count -= this._seconds * sample_in_1_second) / sample_in_1_frame;
            this._samples = _sample_count -= this._frames * sample_in_1_frame;
            this._hours %= 24L;
        }

        @Override
        public long getHours() {
            return this._hours;
        }

        @Override
        public long getMinutes() {
            return this._minutes;
        }

        @Override
        public long getSeconds() {
            return this._seconds;
        }

        @Override
        public long getFrames() {
            return this._frames;
        }

        @Override
        public long getSamples() {
            return this._samples;
        }

        @Override
        public double getSampleRate() {
            return this._sampleRate;
        }
    }

    public static interface TimeDesc {
        public long getHours();

        public long getMinutes();

        public long getSeconds();

        public long getFrames();

        public long getSamples();

        public double getSampleRate();
    }
}

