/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Property {
    private String _name;
    private PropertyType _type;
    private PropertyArity _arity;
    private Object _value;

    public Property(String name, PropertyType type, Object value) {
        this.init(name, type, PropertyArity.SCALAR, value);
    }

    public Property(String name, PropertyType type, PropertyArity arity, Object value) {
        this.init(name, type, arity, value);
    }

    private void init(String name, PropertyType type, PropertyArity arity, Object value) {
        if (value == null) {
            throw new NullPointerException("Null value not permitted for property: ");
        }
        if (arity == PropertyArity.SCALAR && !Property.isObjScalarProp(value)) {
            throw new IncompatibleClassChangeError(String.format("Scalar.", "Incompatible class for property: "));
        }
        if (arity == PropertyArity.MAP && !(value instanceof Map)) {
            throw new IncompatibleClassChangeError(String.format("Map.", "Incompatible class for property: "));
        }
        if (arity == PropertyArity.SET && !(value instanceof Set)) {
            throw new IncompatibleClassChangeError(String.format("Set.", "Incompatible class for property: "));
        }
        if (arity == PropertyArity.LIST && !(value instanceof List)) {
            throw new IncompatibleClassChangeError(String.format("List.", "Incompatible class for property: "));
        }
        this._name = name;
        this._type = type;
        this._arity = arity;
        this._value = value;
    }

    private static boolean isObjScalarProp(Object toTest) {
        return !(toTest instanceof List) && !(toTest instanceof Map) && !(toTest instanceof Set);
    }

    public PropertyArity getArity() {
        return this._arity;
    }

    public Property getByName(String name) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        if (this._name.equals(name)) {
                            return this;
                        }
                        if (this._arity.equals((Object)PropertyArity.SCALAR) || !this._type.equals((Object)PropertyType.PROPERTY)) break block5;
                        if (!this._arity.equals((Object)PropertyArity.ARRAY)) break block6;
                        Property[] array = (Property[])this._value;
                        for (int i = 0; i < array.length; ++i) {
                            Property prop = array[i].getByName(name);
                            if (prop == null) continue;
                            return prop;
                        }
                        break block5;
                    }
                    if (!this._arity.equals((Object)PropertyArity.LIST)) break block7;
                    List list = (List)this._value;
                    int len = list.size();
                    for (int i = 0; i < len; ++i) {
                        Property prop = ((Property)list.get(i)).getByName(name);
                        if (prop == null) continue;
                        return prop;
                    }
                    break block5;
                }
                if (!this._arity.equals((Object)PropertyArity.MAP)) break block8;
                Collection coll = ((Map)this._value).values();
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    Property prop = ((Property)iter.next()).getByName(name);
                    if (prop == null) continue;
                    return prop;
                }
                break block5;
            }
            if (!this._arity.equals((Object)PropertyArity.SET)) break block5;
            Iterator iter = ((Set)this._value).iterator();
            while (iter.hasNext()) {
                Property prop = ((Property)iter.next()).getByName(name);
                if (prop == null) continue;
                return prop;
            }
        }
        return null;
    }

    public String getName() {
        return this._name;
    }

    public PropertyType getType() {
        return this._type;
    }

    public Object getValue() {
        return this._value;
    }
}

