/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum Utils {
    INSTANCE;

    private static final char amp = '&';
    private static final String ampsym = "&amp;";
    private static final char lt = '<';
    private static final String ltsym = "&lt;";
    private static final char gt = '>';
    private static final String gtsym = "&gt;";
    private static final char qut = '\"';
    private static final String qutsym = "&quot;";

    public static String encodeContent(String content) {
        if (content == null) {
            return "";
        }
        int n = content.length();
        StringBuilder buffer = new StringBuilder((int)((double)n * 1.3));
        block5: for (int i = 0; i < n; ++i) {
            char ch = content.charAt(i);
            if ('\u0000' <= ch && ch <= '\b' || '\u000b' <= ch && ch <= '\f' || '\u000e' <= ch && ch <= '\u001f' || '\ufffe' <= ch && ch <= '\uffff' || '\u007f' == ch) continue;
            switch (ch) {
                case '&': {
                    buffer.append(ampsym);
                    continue block5;
                }
                case '>': {
                    buffer.append(gtsym);
                    continue block5;
                }
                case '<': {
                    buffer.append(ltsym);
                    continue block5;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }

    public static String encodeValue(String value) {
        if (value == null) {
            return "";
        }
        int n = value.length();
        StringBuilder buffer = new StringBuilder((int)((double)n * 1.3));
        block6: for (int i = 0; i < n; ++i) {
            char ch = value.charAt(i);
            if ('\u0000' <= ch && ch <= '\b' || '\u000b' <= ch && ch <= '\f' || '\u000e' <= ch && ch <= '\u001f' || '\ufffe' <= ch && ch <= '\uffff' || '\u007f' == ch) continue;
            switch (ch) {
                case '&': {
                    buffer.append(ampsym);
                    continue block6;
                }
                case '>': {
                    buffer.append(gtsym);
                    continue block6;
                }
                case '<': {
                    buffer.append(ltsym);
                    continue block6;
                }
                case '\"': {
                    buffer.append(qutsym);
                    continue block6;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }

    public static boolean isPropertyEmpty(Property property, PropertyArity arity) {
        try {
            if (arity.equals((Object)PropertyArity.SET)) {
                Set propSet = (Set)property.getValue();
                return propSet.isEmpty();
            }
            if (arity.equals((Object)PropertyArity.LIST)) {
                List propList = (List)property.getValue();
                return propList.isEmpty();
            }
            if (arity.equals((Object)PropertyArity.MAP)) {
                Map propMap = (Map)property.getValue();
                return propMap.isEmpty();
            }
            if (arity.equals((Object)PropertyArity.ARRAY)) {
                boolean[] boolArray = null;
                byte[] byteArray = null;
                char[] charArray = null;
                Date[] dateArray = null;
                double[] doubleArray = null;
                float[] floatArray = null;
                int[] intArray = null;
                long[] longArray = null;
                Object[] objArray = null;
                Property[] propArray = null;
                short[] shortArray = null;
                String[] stringArray = null;
                Rational[] rationalArray = null;
                NisoImageMetadata[] nisoArray = null;
                AESAudioMetadata[] aesArray = null;
                TextMDMetadata[] textMDArray = null;
                int n = 0;
                PropertyType propType = property.getType();
                if (PropertyType.BOOLEAN.equals((Object)propType)) {
                    boolArray = (boolean[])property.getValue();
                    n = boolArray.length;
                } else if (PropertyType.BYTE.equals((Object)propType)) {
                    byteArray = (byte[])property.getValue();
                    n = byteArray.length;
                } else if (PropertyType.CHARACTER.equals((Object)propType)) {
                    charArray = (char[])property.getValue();
                    n = charArray.length;
                } else if (PropertyType.DATE.equals((Object)propType)) {
                    dateArray = (Date[])property.getValue();
                    n = dateArray.length;
                } else if (PropertyType.DOUBLE.equals((Object)propType)) {
                    doubleArray = (double[])property.getValue();
                    n = doubleArray.length;
                } else if (PropertyType.FLOAT.equals((Object)propType)) {
                    floatArray = (float[])property.getValue();
                    n = floatArray.length;
                } else if (PropertyType.INTEGER.equals((Object)propType)) {
                    intArray = (int[])property.getValue();
                    n = intArray.length;
                } else if (PropertyType.LONG.equals((Object)propType)) {
                    longArray = (long[])property.getValue();
                    n = longArray.length;
                } else if (PropertyType.OBJECT.equals((Object)propType)) {
                    objArray = (Object[])property.getValue();
                    n = objArray.length;
                } else if (PropertyType.SHORT.equals((Object)propType)) {
                    shortArray = (short[])property.getValue();
                    n = shortArray.length;
                } else if (PropertyType.STRING.equals((Object)propType)) {
                    stringArray = (String[])property.getValue();
                    n = stringArray.length;
                } else if (PropertyType.RATIONAL.equals((Object)propType)) {
                    rationalArray = (Rational[])property.getValue();
                    n = rationalArray.length;
                } else if (PropertyType.PROPERTY.equals((Object)propType)) {
                    propArray = (Property[])property.getValue();
                    n = propArray.length;
                } else if (PropertyType.NISOIMAGEMETADATA.equals((Object)propType)) {
                    nisoArray = (NisoImageMetadata[])property.getValue();
                    n = nisoArray.length;
                } else if (PropertyType.AESAUDIOMETADATA.equals((Object)propType)) {
                    aesArray = (AESAudioMetadata[])property.getValue();
                    n = aesArray.length;
                } else if (PropertyType.TEXTMDMETADATA.equals((Object)propType)) {
                    textMDArray = (TextMDMetadata[])property.getValue();
                    n = textMDArray.length;
                }
                return n == 0;
            }
            return property.getValue().toString().length() == 0;
        }
        catch (Exception e) {
            return true;
        }
    }
}

