/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.handler;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.HandlerBase;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import edu.harvard.hul.ois.jhove.handler.Handlers;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JsonHandler
extends HandlerBase {
    private static final String NAME = "JSON";
    private static final String RELEASE = "1.4";
    private static final String RELEASE_CONSTANT = "release";
    private static final int[] DATE = new int[]{2024, 11, 19};
    private static final String DATE_CONSTANT = "date";
    private static final String WELL_FORMED = "Well-Formed";
    private static final String NOT_WELL_FORMED = "Not well-formed";
    private static final String MIX_TILES = "mix:tiles";
    private static final String MIX_EXTRA_SAMPLES = "mix:extraSamples";
    private static final String MIX_GRAY_RESPONSE_UNIT = "mix:grayResponseUnit";
    private static final String NTSC_NON_DROP_FRAME = "NTSC_NON_DROP_FRAME";
    private static final String NOTE = "";
    private static final String RIGHTS = "Version 1.0 release by Open Preservation Foundation. Released under the GNU Lesser General Public License.";
    private JsonObjectBuilder jhoveBuilder;
    private JsonArrayBuilder repInfosBuilder;
    private double _sampleRate;
    private String reportingModule = "";

    public JsonHandler() {
        super(NAME, RELEASE, DATE, NOTE, RIGHTS);
        this._vendor = Agent.bnfInstance();
    }

    public JsonHandler(String name, String release, int[] date, String note, String rights) {
        super(name, release, date, note, rights);
        this._vendor = Agent.bnfInstance();
    }

    @Override
    public void show() {
        --this._level;
    }

    @Override
    public void show(App app) {
        String s;
        JsonObjectBuilder appBuilder = Json.createObjectBuilder();
        JsonObjectBuilder apiBuilder = Json.createObjectBuilder();
        apiBuilder.add("version", app.getRelease());
        apiBuilder.add(DATE_CONSTANT, date.format(this._je.getDate()));
        appBuilder.add("api", apiBuilder);
        String configFile = this._je.getConfigFile();
        if (configFile != null) {
            appBuilder.add("configuration", configFile);
        }
        if ((s = this._je.getSaxClass()) != null) {
            appBuilder.add("saxParser", s);
        }
        if ((s = this._je.getJhoveHome()) != null) {
            appBuilder.add("jhoveHome", s);
        }
        if ((s = this._je.getEncoding()) != null) {
            appBuilder.add("encoding", s);
        }
        if ((s = this._je.getTempDirectory()) != null) {
            appBuilder.add("tempDirectory", s);
        }
        appBuilder.add("bufferSize", this._je.getBufferSize());
        JsonArrayBuilder modulesBuilder = Json.createArrayBuilder();
        for (String modKey : this._je.getModuleMap().keySet()) {
            Module module = this._je.getModule(modKey);
            modulesBuilder.add(Json.createObjectBuilder().add("module", module.getName()).add(RELEASE_CONSTANT, module.getRelease()));
        }
        appBuilder.add("modules", modulesBuilder);
        JsonArrayBuilder oHandlersBuilder = Json.createArrayBuilder();
        for (String handlerKey : this._je.getHandlerMap().keySet()) {
            OutputHandler handler = this._je.getHandler(handlerKey);
            oHandlersBuilder.add(Json.createObjectBuilder().add("outputHandler", handler.getName()).add(RELEASE_CONSTANT, handler.getRelease()));
        }
        appBuilder.add("outputHandlers", oHandlersBuilder);
        appBuilder.add("usage", app.getUsage());
        appBuilder.add("rights", app.getRights());
        this.jhoveBuilder.add("app", appBuilder);
    }

    @Override
    public void show(OutputHandler handler) {
        String s;
        Agent vendor;
        JsonObjectBuilder outputHandlerBuilder = Json.createObjectBuilder();
        outputHandlerBuilder.add("name", handler.getName());
        outputHandlerBuilder.add(RELEASE_CONSTANT, handler.getRelease());
        outputHandlerBuilder.add(DATE_CONSTANT, date.format(handler.getDate()));
        List<Document> list = handler.getSpecification();
        int n = list.size();
        if (n > 0) {
            JsonArrayBuilder specBuilder = Json.createArrayBuilder();
            for (int i = 0; i < n; ++i) {
                specBuilder.add(this.showDocument(list.get(i)));
            }
            outputHandlerBuilder.add("specifications", specBuilder);
        }
        if ((vendor = handler.getVendor()) != null) {
            outputHandlerBuilder.add("vendor", this.showAgent(vendor, "Vendor"));
        }
        if ((s = handler.getNote()) != null) {
            outputHandlerBuilder.add("note", s);
        }
        if ((s = handler.getRights()) != null) {
            outputHandlerBuilder.add("rights", s);
        }
        this.jhoveBuilder.add("handler", outputHandlerBuilder);
    }

    @Override
    public void show(Module module) {
        List<String> ftr;
        List<Document> list2;
        List<Signature> list1;
        String s;
        JsonObjectBuilder modBuilder = Json.createObjectBuilder();
        modBuilder.add("name", module.getName());
        modBuilder.add(RELEASE_CONSTANT, module.getRelease());
        modBuilder.add(DATE_CONSTANT, HandlerBase.date.format(module.getDate()));
        String[] ss = module.getFormat();
        if (ss.length > 0) {
            modBuilder.add("formats", this.showArray(ss));
        }
        if ((s = module.getCoverage()) != null) {
            modBuilder.add("coverage", s);
        }
        if ((ss = module.getMimeType()).length > 0) {
            modBuilder.add("mimeTypes", this.showArray(ss));
        }
        if ((list1 = module.getSignature()) != null && !list1.isEmpty()) {
            JsonArrayBuilder sigBuilder = Json.createArrayBuilder();
            for (Signature signature : list1) {
                sigBuilder.add(this.showSignature(signature));
            }
            modBuilder.add("signatures", sigBuilder);
        }
        if ((list2 = module.getSpecification()) != null && !list2.isEmpty()) {
            JsonArrayBuilder docBuilder = Json.createArrayBuilder();
            for (Document document : list2) {
                docBuilder.add(this.showDocument(document));
            }
            modBuilder.add("specifications", docBuilder);
        }
        if ((ftr = module.getFeatures()) != null && !ftr.isEmpty()) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (String f : ftr) {
                jsonArrayBuilder.add(f);
            }
            modBuilder.add("features", jsonArrayBuilder);
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        s = module.getWellFormedNote();
        if (s != null) {
            jsonObjectBuilder.add("wellFormed", s);
        }
        if ((s = module.getValidityNote()) != null) {
            jsonObjectBuilder.add("validity", s);
        }
        if ((s = module.getRepInfoNote()) != null) {
            jsonObjectBuilder.add("repInfo", s);
        }
        modBuilder.add("methodology", jsonObjectBuilder);
        Agent agent = module.getVendor();
        if (agent != null) {
            modBuilder.add("vendor", this.showAgent(agent, "Vendor"));
        }
        if ((s = module.getNote()) != null) {
            modBuilder.add("note", s);
        }
        if ((s = module.getRights()) != null) {
            modBuilder.add("rights", s);
        }
        this.jhoveBuilder.add("module", modBuilder);
    }

    @Override
    public void show(RepInfo info) {
        List<Checksum> list;
        Map<String, Property> map;
        List<String> list3;
        List<Message> list2;
        String wfStr;
        String s;
        long size;
        Date date;
        JsonObjectBuilder infoBuilder = Json.createObjectBuilder();
        Module module = info.getModule();
        this._logger.info("Reporting RepInfo");
        if (this._je.getSignatureFlag()) {
            this._logger.info("Checking signatures only");
        }
        infoBuilder.add("uri", info.getUri());
        if (module != null) {
            this.reportingModule = module.getName();
            infoBuilder.add("reportingModule", Json.createObjectBuilder().add("name", this.reportingModule).add(RELEASE_CONSTANT, module.getRelease()).add(DATE_CONSTANT, JsonHandler.date.format(module.getDate())));
        }
        if ((date = info.getCreated()) != null) {
            infoBuilder.add("created", this.toDateTime(date));
        }
        if ((date = info.getLastModified()) != null) {
            infoBuilder.add("lastModified", this.toDateTime(date));
        }
        if ((size = info.getSize()) > -1L) {
            infoBuilder.add("size", size);
        }
        if ((s = info.getFormat()) != null) {
            infoBuilder.add("format", s);
        }
        if ((s = info.getVersion()) != null) {
            infoBuilder.add("version", s);
        }
        if (!this._je.getSignatureFlag()) {
            switch (info.getWellFormed()) {
                case 1: {
                    wfStr = WELL_FORMED;
                    break;
                }
                case 0: {
                    wfStr = NOT_WELL_FORMED;
                    break;
                }
                default: {
                    wfStr = "Unknown";
                }
            }
            if (info.getWellFormed() == 1) {
                switch (info.getValid()) {
                    case 1: {
                        wfStr = wfStr + " and valid";
                        break;
                    }
                    case 0: {
                        wfStr = wfStr + ", but not valid";
                        break;
                    }
                }
            }
            this._logger.info("Validity/WF status: " + wfStr);
            infoBuilder.add("status", wfStr);
        } else {
            switch (info.getWellFormed()) {
                case 1: {
                    wfStr = WELL_FORMED;
                    break;
                }
                default: {
                    wfStr = NOT_WELL_FORMED;
                }
            }
            infoBuilder.add("status", wfStr);
        }
        List<String> list1 = info.getSigMatch();
        if (list1 != null && !list1.isEmpty()) {
            JsonArrayBuilder sigBuilder = Json.createArrayBuilder();
            for (String string : list1) {
                sigBuilder.add(string);
            }
            infoBuilder.add("sigMatch", sigBuilder);
        }
        if ((list2 = info.getMessage()) != null && !list2.isEmpty()) {
            JsonArrayBuilder msgBuilder = Json.createArrayBuilder();
            for (Message message : list2) {
                msgBuilder.add(this.showMessage(message));
            }
            infoBuilder.add("messages", msgBuilder);
        }
        if ((s = info.getMimeType()) != null) {
            infoBuilder.add("mimeType", s);
        }
        if ((list3 = info.getProfile()) != null && !list3.isEmpty()) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (String string : list3) {
                jsonArrayBuilder.add(string);
            }
            infoBuilder.add("profiles", jsonArrayBuilder);
        }
        if ((map = info.getProperty()) != null && !map.isEmpty()) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (String key : map.keySet()) {
                Property property = info.getProperty(key);
                jsonArrayBuilder.add(this.showProperty(property));
            }
            infoBuilder.add("properties", jsonArrayBuilder);
        }
        if ((list = info.getChecksum()) != null && !list.isEmpty()) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            for (Checksum ck : list) {
                jsonArrayBuilder.add(this.showChecksum(ck));
            }
            infoBuilder.add("properties", jsonArrayBuilder);
        }
        if ((s = info.getNote()) != null) {
            infoBuilder.add("note", s);
        }
        if (this.repInfosBuilder == null) {
            this.repInfosBuilder = Json.createArrayBuilder();
        }
        this.repInfosBuilder.add(infoBuilder);
    }

    protected JsonObjectBuilder showAgent(Agent agent, String label) {
        JsonObjectBuilder agentBuilder = Json.createObjectBuilder();
        agentBuilder.add("kind", label);
        agentBuilder.add("name", agent.getName());
        agentBuilder.add("type", agent.getType().toString());
        String s = agent.getAddress();
        if (s != null) {
            agentBuilder.add("address", s);
        }
        if ((s = agent.getTelephone()) != null) {
            agentBuilder.add("telephone", s);
        }
        if ((s = agent.getFax()) != null) {
            agentBuilder.add("fax", s);
        }
        if ((s = agent.getEmail()) != null) {
            agentBuilder.add("email", s);
        }
        if ((s = agent.getWeb()) != null) {
            agentBuilder.add("web", s);
        }
        return agentBuilder;
    }

    protected JsonObjectBuilder showChecksum(Checksum checksum) {
        return Json.createObjectBuilder().add("checksum", checksum.getValue()).add("type", checksum.getType().toString());
    }

    protected JsonObjectBuilder showDocument(Document document) {
        List<Identifier> list;
        String s;
        List<Agent> list2;
        JsonObjectBuilder docBuilder = Json.createObjectBuilder();
        docBuilder.add("title", document.getTitle());
        docBuilder.add("type", document.getType().toString());
        List<Agent> list1 = document.getAuthor();
        if (list1 != null && !list1.isEmpty()) {
            JsonArrayBuilder autBuilder = Json.createArrayBuilder();
            for (Agent agent : list1) {
                autBuilder.add(this.showAgent(agent, "Author"));
            }
            docBuilder.add("authors", autBuilder);
        }
        if ((list2 = document.getPublisher()) != null && !list2.isEmpty()) {
            JsonArrayBuilder pubBuilder = Json.createArrayBuilder();
            for (Agent ag : list2) {
                pubBuilder.add(this.showAgent(ag, "Publisher"));
            }
            docBuilder.add("publishers", pubBuilder);
        }
        if ((s = document.getEdition()) != null) {
            docBuilder.add("edition", s);
        }
        if ((s = document.getDate()) != null) {
            docBuilder.add(DATE_CONSTANT, s);
        }
        if ((s = document.getEnumeration()) != null) {
            docBuilder.add("enumeration", s);
        }
        if ((s = document.getPages()) != null) {
            docBuilder.add("pages", s);
        }
        if ((list = document.getIdentifier()) != null && !list.isEmpty()) {
            JsonArrayBuilder idBuilder = Json.createArrayBuilder();
            for (Identifier id : list) {
                idBuilder.add(this.showIdentifier(id));
            }
            docBuilder.add("identifiers", idBuilder);
        }
        if ((s = document.getNote()) != null) {
            docBuilder.add("note", s);
        }
        return docBuilder;
    }

    @Override
    public void showFooter() {
        if (this.repInfosBuilder != null) {
            this.jhoveBuilder.add("repInfo", this.repInfosBuilder);
        }
        JsonObjectBuilder mainBuilder = Json.createObjectBuilder();
        mainBuilder.add("jhove", this.jhoveBuilder);
        JsonObject jsonObject = mainBuilder.build();
        JsonWriter jsonWriter = Json.createWriter((Writer)this._writer);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
    }

    @Override
    public void showHeader() {
        this.jhoveBuilder = Json.createObjectBuilder();
        this.jhoveBuilder.add("name", this._app.getName());
        this.jhoveBuilder.add(RELEASE_CONSTANT, this._app.getRelease());
        this.jhoveBuilder.add(DATE_CONSTANT, HandlerBase.date.format(this._app.getDate()));
        this.jhoveBuilder.add("executionTime", this.toDateTime(new Date()));
        this.repInfosBuilder = null;
    }

    protected JsonObjectBuilder showIdentifier(Identifier identifier) {
        JsonObjectBuilder idBuilder = Json.createObjectBuilder();
        idBuilder.add("value", identifier.getValue());
        idBuilder.add("type", identifier.getType().toString());
        String note = identifier.getNote();
        if (note != null) {
            idBuilder.add("note", note);
        }
        return idBuilder;
    }

    protected JsonObjectBuilder showMessage(Message message) {
        String id;
        long offset;
        JsonObjectBuilder msgBuilder = Json.createObjectBuilder();
        msgBuilder.add("message", message.getMessage());
        String submsg = message.getSubMessage();
        if (submsg != null) {
            msgBuilder.add("subMessage", submsg);
        }
        if ((offset = message.getOffset()) > -1L) {
            msgBuilder.add("offset", offset);
        }
        if (!message.getPrefix().isEmpty()) {
            msgBuilder.add("severity", message.getPrefix().toLowerCase());
        }
        if ((id = message.getJhoveMessage().getId()) != null && !id.isEmpty() && !"NO-ID".equals(id)) {
            msgBuilder.add("id", message.getId());
            msgBuilder.add("infoLink", Handlers.makeInfoLink(this.reportingModule, id));
        }
        return msgBuilder;
    }

    protected JsonObjectBuilder showSignature(Signature signature) {
        String use;
        String note;
        JsonObjectBuilder sigBuilder = Json.createObjectBuilder();
        String sigValue = signature.isStringValue() ? signature.getValueString() : signature.getValueHexString();
        sigBuilder.add("type", signature.getType().toString());
        sigBuilder.add("value", sigValue);
        if (SignatureType.MAGIC.equals((Object)signature.getType()) && ((InternalSignature)signature).hasFixedOffset()) {
            sigBuilder.add("offset", "0x" + Integer.toHexString(((InternalSignature)signature).getOffset()));
        }
        if ((note = signature.getNote()) != null) {
            sigBuilder.add("note", note);
        }
        if ((use = signature.getUse().toString()) != null) {
            sigBuilder.add("use", use);
        }
        return sigBuilder;
    }

    protected String valueToString(Object obj) {
        if (obj instanceof Date) {
            return this.toDateTime((Date)obj);
        }
        return obj.toString();
    }

    protected JsonObjectBuilder showProperty(Property property) {
        JsonObjectBuilder propBuilder = Json.createObjectBuilder();
        PropertyArity arity = property.getArity();
        switch (arity) {
            case SCALAR: {
                return this.showScalarProperty(property);
            }
            case ARRAY: {
                return this.showArrayProperty(property);
            }
            case LIST: {
                return this.showListProperty(property);
            }
            case MAP: {
                return this.showMapProperty(property);
            }
            case SET: {
                return this.showSetProperty(property);
            }
        }
        return propBuilder;
    }

    protected JsonObjectBuilder showScalarProperty(Property property) {
        JsonObjectBuilder propBuilder = Json.createObjectBuilder();
        PropertyType propType = property.getType();
        switch (propType) {
            case BOOLEAN: {
                Boolean b = (Boolean)property.getValue();
                propBuilder.add(property.getName(), b.booleanValue());
                break;
            }
            case BYTE: 
            case CHARACTER: 
            case OBJECT: {
                propBuilder.add(property.getName(), property.getValue().toString());
                break;
            }
            case DATE: {
                Date dt = (Date)property.getValue();
                propBuilder.add(property.getName(), this.toDateTime(dt));
                break;
            }
            case DOUBLE: {
                Double d = (Double)property.getValue();
                propBuilder.add(property.getName(), d.doubleValue());
                break;
            }
            case FLOAT: {
                Float f = (Float)property.getValue();
                propBuilder.add(property.getName(), (double)f.floatValue());
                break;
            }
            case INTEGER: {
                Integer i = (Integer)property.getValue();
                propBuilder.add(property.getName(), i.intValue());
                break;
            }
            case LONG: {
                Long l = (Long)property.getValue();
                propBuilder.add(property.getName(), l.longValue());
                break;
            }
            case AESAUDIOMETADATA: {
                propBuilder.add(property.getName(), this.showAESAudioMetadata((AESAudioMetadata)property.getValue()));
                break;
            }
            case NISOIMAGEMETADATA: {
                propBuilder.add(property.getName(), this.showNisoImageMetadata((NisoImageMetadata)property.getValue()));
                break;
            }
            case TEXTMDMETADATA: {
                propBuilder.add(property.getName(), this.showTextMDMetadata((TextMDMetadata)property.getValue()));
                break;
            }
            case SHORT: {
                Short s = (Short)property.getValue();
                propBuilder.add(property.getName(), (int)s.shortValue());
                break;
            }
            case STRING: {
                propBuilder.add(property.getName(), (String)property.getValue());
                break;
            }
            case RATIONAL: {
                propBuilder.add(property.getName(), this.showRational((Rational)property.getValue()));
                break;
            }
            case PROPERTY: {
                Property property2 = (Property)property.getValue();
                propBuilder.add(property.getName(), this.showProperty(property2));
                break;
            }
            default: {
                propBuilder.add(property.getName(), property.getValue().toString());
            }
        }
        return propBuilder;
    }

    protected JsonObjectBuilder showListProperty(Property property) {
        JsonObjectBuilder propBuilder = Json.createObjectBuilder();
        List propList = (List)property.getValue();
        JsonArrayBuilder lPropBuilder = Json.createArrayBuilder();
        PropertyType type = property.getType();
        ListIterator iter = propList.listIterator();
        while (iter.hasNext()) {
            Object val = iter.next();
            switch (type) {
                case BOOLEAN: {
                    lPropBuilder.add(((Boolean)val).booleanValue());
                    break;
                }
                case BYTE: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case CHARACTER: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case DATE: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case DOUBLE: {
                    lPropBuilder.add(((Double)val).doubleValue());
                    break;
                }
                case FLOAT: {
                    lPropBuilder.add((double)((Float)val).floatValue());
                    break;
                }
                case INTEGER: {
                    lPropBuilder.add(((Integer)val).intValue());
                    break;
                }
                case LONG: {
                    lPropBuilder.add(((Long)val).longValue());
                    break;
                }
                case OBJECT: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case SHORT: {
                    lPropBuilder.add((int)((Short)val).shortValue());
                    break;
                }
                case STRING: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case RATIONAL: {
                    lPropBuilder.add(this.showRational((Rational)val));
                    break;
                }
                case PROPERTY: {
                    lPropBuilder.add(this.showProperty((Property)val));
                    break;
                }
                case NISOIMAGEMETADATA: {
                    lPropBuilder.add(this.showNisoImageMetadata((NisoImageMetadata)property.getValue()));
                    break;
                }
                case AESAUDIOMETADATA: {
                    lPropBuilder.add(this.showAESAudioMetadata((AESAudioMetadata)property.getValue()));
                    break;
                }
                case TEXTMDMETADATA: {
                    lPropBuilder.add(this.showTextMDMetadata((TextMDMetadata)property.getValue()));
                    break;
                }
            }
        }
        propBuilder.add(property.getName(), lPropBuilder);
        return propBuilder;
    }

    protected JsonObjectBuilder showSetProperty(Property property) {
        JsonObjectBuilder propBuilder = Json.createObjectBuilder();
        Set propSet = (Set)property.getValue();
        JsonArrayBuilder lPropBuilder = Json.createArrayBuilder();
        PropertyType type = property.getType();
        for (Object val : propSet) {
            switch (type) {
                case BOOLEAN: {
                    lPropBuilder.add(((Boolean)val).booleanValue());
                    break;
                }
                case BYTE: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case CHARACTER: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case DATE: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case DOUBLE: {
                    lPropBuilder.add(((Double)val).doubleValue());
                    break;
                }
                case FLOAT: {
                    lPropBuilder.add((double)((Float)val).floatValue());
                    break;
                }
                case INTEGER: {
                    lPropBuilder.add(((Integer)val).intValue());
                    break;
                }
                case LONG: {
                    lPropBuilder.add(((Long)val).longValue());
                    break;
                }
                case OBJECT: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case SHORT: {
                    lPropBuilder.add((int)((Short)val).shortValue());
                    break;
                }
                case STRING: {
                    lPropBuilder.add(this.valueToString(val));
                    break;
                }
                case RATIONAL: {
                    lPropBuilder.add(this.showRational((Rational)val));
                    break;
                }
                case PROPERTY: {
                    lPropBuilder.add(this.showProperty((Property)val));
                    break;
                }
                case NISOIMAGEMETADATA: {
                    lPropBuilder.add(this.showNisoImageMetadata((NisoImageMetadata)property.getValue()));
                    break;
                }
                case AESAUDIOMETADATA: {
                    lPropBuilder.add(this.showAESAudioMetadata((AESAudioMetadata)property.getValue()));
                    break;
                }
                case TEXTMDMETADATA: {
                    lPropBuilder.add(this.showTextMDMetadata((TextMDMetadata)property.getValue()));
                    break;
                }
            }
        }
        propBuilder.add(property.getName(), lPropBuilder);
        return propBuilder;
    }

    protected JsonObjectBuilder showMapProperty(Property property) {
        JsonObjectBuilder propBuilder = Json.createObjectBuilder();
        JsonObjectBuilder lPropBuilder = Json.createObjectBuilder();
        Map propMap = (Map)property.getValue();
        PropertyType type = property.getType();
        for (Object key : propMap.keySet()) {
            String keystr = key.toString();
            Object val = propMap.get(key);
            switch (type) {
                case BOOLEAN: {
                    lPropBuilder.add(keystr, ((Boolean)val).booleanValue());
                    break;
                }
                case BYTE: {
                    lPropBuilder.add(keystr, this.valueToString(val));
                    break;
                }
                case CHARACTER: {
                    lPropBuilder.add(keystr, this.valueToString(val));
                    break;
                }
                case DATE: {
                    lPropBuilder.add(keystr, this.valueToString(val));
                    break;
                }
                case DOUBLE: {
                    lPropBuilder.add(keystr, ((Double)val).doubleValue());
                    break;
                }
                case FLOAT: {
                    lPropBuilder.add(keystr, (double)((Float)val).floatValue());
                    break;
                }
                case INTEGER: {
                    lPropBuilder.add(keystr, ((Integer)val).intValue());
                    break;
                }
                case LONG: {
                    lPropBuilder.add(keystr, ((Long)val).longValue());
                    break;
                }
                case OBJECT: {
                    lPropBuilder.add(keystr, this.valueToString(val));
                    break;
                }
                case SHORT: {
                    lPropBuilder.add(keystr, (int)((Short)val).shortValue());
                    break;
                }
                case STRING: {
                    lPropBuilder.add(keystr, this.valueToString(val));
                    break;
                }
                case RATIONAL: {
                    lPropBuilder.add(keystr, this.showRational((Rational)val));
                    break;
                }
                case PROPERTY: {
                    lPropBuilder.add(keystr, this.showProperty((Property)val));
                    break;
                }
                case NISOIMAGEMETADATA: {
                    lPropBuilder.add(keystr, this.showNisoImageMetadata((NisoImageMetadata)property.getValue()));
                    break;
                }
                case AESAUDIOMETADATA: {
                    lPropBuilder.add(keystr, this.showAESAudioMetadata((AESAudioMetadata)property.getValue()));
                    break;
                }
                case TEXTMDMETADATA: {
                    lPropBuilder.add(keystr, this.showTextMDMetadata((TextMDMetadata)property.getValue()));
                    break;
                }
            }
        }
        propBuilder.add(property.getName(), lPropBuilder);
        return propBuilder;
    }

    protected int propertyLength(Property property) {
        int n = 0;
        try {
            block1 : switch (property.getArity()) {
                case SET: {
                    Set propSet = (Set)property.getValue();
                    n = propSet.size();
                    break;
                }
                case LIST: {
                    List propList = (List)property.getValue();
                    n = propList.size();
                    break;
                }
                case MAP: {
                    Map propMap = (Map)property.getValue();
                    n = propMap.size();
                    break;
                }
                case ARRAY: {
                    switch (property.getType()) {
                        case BOOLEAN: {
                            boolean[] boolArray = (boolean[])property.getValue();
                            n = boolArray.length;
                            break block1;
                        }
                        case BYTE: {
                            byte[] byteArray = (byte[])property.getValue();
                            n = byteArray.length;
                            break block1;
                        }
                        case CHARACTER: {
                            char[] charArray = (char[])property.getValue();
                            n = charArray.length;
                            break block1;
                        }
                        case DATE: {
                            Date[] dateArray = (Date[])property.getValue();
                            n = dateArray.length;
                            break block1;
                        }
                        case DOUBLE: {
                            double[] doubleArray = (double[])property.getValue();
                            n = doubleArray.length;
                            break block1;
                        }
                        case FLOAT: {
                            float[] floatArray = (float[])property.getValue();
                            n = floatArray.length;
                            break block1;
                        }
                        case INTEGER: {
                            int[] intArray = (int[])property.getValue();
                            n = intArray.length;
                            break block1;
                        }
                        case LONG: {
                            long[] longArray = (long[])property.getValue();
                            n = longArray.length;
                            break block1;
                        }
                        case OBJECT: {
                            Object[] objArray = (Object[])property.getValue();
                            n = objArray.length;
                            break block1;
                        }
                        case SHORT: {
                            short[] shortArray = (short[])property.getValue();
                            n = shortArray.length;
                            break block1;
                        }
                        case STRING: {
                            String[] stringArray = (String[])property.getValue();
                            n = stringArray.length;
                            break block1;
                        }
                        case RATIONAL: {
                            Rational[] rationalArray = (Rational[])property.getValue();
                            n = rationalArray.length;
                            break block1;
                        }
                        case PROPERTY: {
                            Property[] propArray = (Property[])property.getValue();
                            n = propArray.length;
                            break block1;
                        }
                        case NISOIMAGEMETADATA: {
                            NisoImageMetadata[] nisoArray = (NisoImageMetadata[])property.getValue();
                            n = nisoArray.length;
                            break block1;
                        }
                        case AESAUDIOMETADATA: {
                            AESAudioMetadata[] aesArray = (AESAudioMetadata[])property.getValue();
                            n = aesArray.length;
                            break block1;
                        }
                        case TEXTMDMETADATA: {
                            TextMDMetadata[] textMDArray = (TextMDMetadata[])property.getValue();
                            n = textMDArray.length;
                            break block1;
                        }
                    }
                    Object[] array2 = (Object[])property.getValue();
                    n = array2.length;
                    break;
                }
                default: {
                    n = property.getValue().toString().length() == 0 ? 0 : 1;
                }
            }
        }
        catch (Exception e) {
            return 0;
        }
        return n;
    }

    protected JsonObjectBuilder showArrayProperty(Property property) {
        boolean[] boolArray = null;
        byte[] byteArray = null;
        char[] charArray = null;
        Date[] dateArray = null;
        double[] doubleArray = null;
        float[] floatArray = null;
        int[] intArray = null;
        long[] longArray = null;
        Object[] objArray = null;
        Property[] propArray = null;
        short[] shortArray = null;
        String[] stringArray = null;
        Rational[] rationalArray = null;
        NisoImageMetadata[] nisoArray = null;
        AESAudioMetadata[] aesArray = null;
        TextMDMetadata[] textMDArray = null;
        int n = 0;
        PropertyType propType = property.getType();
        switch (propType) {
            case BOOLEAN: {
                boolArray = (boolean[])property.getValue();
                n = boolArray.length;
                break;
            }
            case BYTE: {
                byteArray = (byte[])property.getValue();
                n = byteArray.length;
                break;
            }
            case CHARACTER: {
                charArray = (char[])property.getValue();
                n = charArray.length;
                break;
            }
            case DATE: {
                dateArray = (Date[])property.getValue();
                n = dateArray.length;
                break;
            }
            case DOUBLE: {
                doubleArray = (double[])property.getValue();
                n = doubleArray.length;
                break;
            }
            case FLOAT: {
                floatArray = (float[])property.getValue();
                n = floatArray.length;
                break;
            }
            case INTEGER: {
                intArray = (int[])property.getValue();
                n = intArray.length;
                break;
            }
            case LONG: {
                longArray = (long[])property.getValue();
                n = longArray.length;
                break;
            }
            case OBJECT: {
                objArray = (Object[])property.getValue();
                n = objArray.length;
                break;
            }
            case SHORT: {
                shortArray = (short[])property.getValue();
                n = shortArray.length;
                break;
            }
            case STRING: {
                stringArray = (String[])property.getValue();
                n = stringArray.length;
                break;
            }
            case RATIONAL: {
                rationalArray = (Rational[])property.getValue();
                n = rationalArray.length;
                break;
            }
            case PROPERTY: {
                propArray = (Property[])property.getValue();
                n = propArray.length;
                break;
            }
            case NISOIMAGEMETADATA: {
                nisoArray = (NisoImageMetadata[])property.getValue();
                n = nisoArray.length;
                break;
            }
            case AESAUDIOMETADATA: {
                aesArray = (AESAudioMetadata[])property.getValue();
                n = aesArray.length;
                break;
            }
            case TEXTMDMETADATA: {
                textMDArray = (TextMDMetadata[])property.getValue();
                n = textMDArray.length;
                break;
            }
        }
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        block36: for (int i = 0; i < n; ++i) {
            switch (propType) {
                case BOOLEAN: {
                    arrayBuilder.add(boolArray[i]);
                    continue block36;
                }
                case BYTE: {
                    arrayBuilder.add(String.valueOf(byteArray[i]));
                    continue block36;
                }
                case CHARACTER: {
                    arrayBuilder.add(String.valueOf(charArray[i]));
                    continue block36;
                }
                case DATE: {
                    arrayBuilder.add(dateArray[i].toString());
                    continue block36;
                }
                case DOUBLE: {
                    arrayBuilder.add(doubleArray[i]);
                    continue block36;
                }
                case FLOAT: {
                    arrayBuilder.add((double)floatArray[i]);
                    continue block36;
                }
                case INTEGER: {
                    arrayBuilder.add(intArray[i]);
                    continue block36;
                }
                case LONG: {
                    arrayBuilder.add(longArray[i]);
                    continue block36;
                }
                case OBJECT: {
                    arrayBuilder.add(this.valueToString(objArray[i]));
                    continue block36;
                }
                case SHORT: {
                    arrayBuilder.add((int)shortArray[i]);
                    continue block36;
                }
                case STRING: {
                    arrayBuilder.add(stringArray[i]);
                    continue block36;
                }
                case RATIONAL: {
                    arrayBuilder.add(rationalArray[i].toString());
                    continue block36;
                }
                case PROPERTY: {
                    arrayBuilder.add(this.showProperty(propArray[i]));
                    continue block36;
                }
                case NISOIMAGEMETADATA: {
                    arrayBuilder.add(this.showNisoImageMetadata(nisoArray[i]));
                    continue block36;
                }
                case AESAUDIOMETADATA: {
                    arrayBuilder.add(this.showAESAudioMetadata(aesArray[i]));
                    continue block36;
                }
                case TEXTMDMETADATA: {
                    arrayBuilder.add(this.showTextMDMetadata(textMDArray[i]));
                    continue block36;
                }
                default: {
                    arrayBuilder.add("<error>");
                }
            }
        }
        return Json.createObjectBuilder().add(property.getName(), arrayBuilder);
    }

    protected JsonObjectBuilder showTextMDMetadata(TextMDMetadata textMD) {
        JsonObjectBuilder textmdBuilder = Json.createObjectBuilder();
        this.addStringToJson(textmdBuilder, "textmd:charset", textMD.getCharset());
        this.addStringToJson(textmdBuilder, "textmd:byte_order", textMD.getByte_orderString());
        this.addStringToJson(textmdBuilder, "textmd:byte_size", textMD.getByte_size());
        this.addStringToJson(textmdBuilder, "textmd:character_size", textMD.getCharacter_size());
        this.addStringToJson(textmdBuilder, "textmd:linebreak", textMD.getLinebreakString());
        this.addStringToJson(textmdBuilder, "textmd:language", textMD.getLanguage());
        this.addStringToJson(textmdBuilder, "textmd:markup_basis", textMD.getMarkup_basis());
        this.addStringToJson(textmdBuilder, "textmd:markup_basis_version", textMD.getMarkup_basis_version());
        this.addStringToJson(textmdBuilder, "textmd:markup_language", textMD.getMarkup_language());
        this.addStringToJson(textmdBuilder, "textmd:markup_language_version", textMD.getMarkup_language_version());
        return textmdBuilder;
    }

    protected JsonObjectBuilder showNisoImageMetadata(NisoImageMetadata niso) {
        if ("0.2".equals(this._je.getMixVersion())) {
            return null;
        }
        if ("1.0".equals(this._je.getMixVersion())) {
            return this.showNisoImageMetadata(niso, true);
        }
        return this.showNisoImageMetadata(niso, false);
    }

    protected JsonObjectBuilder showNisoImageMetadata(NisoImageMetadata niso, boolean bMix10) {
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        JsonObjectBuilder ob = this.showNisoBasicDigitalObjectInformation(niso, bMix10);
        if (ob != null) {
            mixBuilder.add("mix:BasicDigitalObjectInformation", ob);
        }
        if ((ob = this.showNisoBasicImageInformation(niso, bMix10)) != null) {
            mixBuilder.add("mix:BasicImageInformation", ob);
        }
        if ((ob = this.showNisoImageCaptureMetadata(niso, bMix10)) != null) {
            mixBuilder.add("mix:ImageCaptureMetadata", ob);
        }
        if ((ob = this.showNisoImageAssessmentMetadata(niso, bMix10)) != null) {
            mixBuilder.add("mix:ImageAssessmentMetadata", ob);
        }
        if ((ob = this.showChangeHistory(niso, bMix10)) != null) {
            mixBuilder.add("mix:ChangeHistory", ob);
        }
        return mixBuilder;
    }

    protected JsonObjectBuilder showNisoBasicDigitalObjectInformation(NisoImageMetadata niso, boolean bMix10) {
        String compStr;
        long ln;
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        String s = niso.getImageIdentifier();
        if (s != null) {
            mixBuilder.add("mix:ObjectIdentifier", Json.createObjectBuilder().add("mix:objectIdentifierType", "JHOVE").add("mix:objectIdentifierValue", s));
        }
        if ((ln = niso.getFileSize()) != -1L) {
            mixBuilder.add("mix:fileSize", ln);
        }
        if ((s = niso.getMimeType()) != null) {
            mixBuilder.add("mix:formatName", s);
        }
        if ((s = niso.getByteOrder()) != null) {
            if (s.startsWith("big")) {
                s = bMix10 ? "big_endian" : "big endian";
            } else if (s.startsWith("little")) {
                s = bMix10 ? "little_endian" : "little endian";
            }
            mixBuilder.add("mix:byteOrder", s);
        }
        int comp = niso.getCompressionScheme();
        int level = niso.getCompressionLevel();
        switch (comp) {
            case 1: {
                compStr = "Uncompressed";
                break;
            }
            case 2: {
                compStr = "CCITT 1D";
                break;
            }
            case 3: {
                compStr = "Group 3 Fax";
                break;
            }
            case 4: {
                compStr = "Group 4 Fax";
                break;
            }
            case 5: {
                compStr = "LZW";
                break;
            }
            case 6: {
                compStr = "JPEG";
                break;
            }
            case 32773: {
                compStr = "PackBits";
                break;
            }
            case 34713: {
                compStr = "JPEG2000 Lossy";
                break;
            }
            case 34714: {
                compStr = "JPEG2000 Lossless";
                break;
            }
            default: {
                compStr = "Unknown";
            }
        }
        if (comp != -1) {
            if (comp == 34713 || comp == 34714) {
                mixBuilder.add("mix:compressionScheme", this.compressionSchemeToString(comp));
                if (level != -1) {
                    mixBuilder.add("mix:compressionRatio", level);
                }
            } else if (bMix10) {
                mixBuilder.add("mix:compressionScheme", Integer.toString(comp));
            } else {
                mixBuilder.add("mix:compressionScheme", compStr);
            }
        }
        int n = niso.getChecksumMethod();
        s = niso.getChecksumValue();
        if (n != -1 || s != null) {
            if (n != -1) {
                mixBuilder.add("mix:messageDigestAlgorithm", n);
            }
            if (s != null) {
                mixBuilder.add("mix:messageDigest", s);
            }
        }
        return mixBuilder;
    }

    protected JsonObjectBuilder showNisoBasicImageInformation(NisoImageMetadata niso, boolean bMix10) {
        int n;
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        boolean hasBuilder = false;
        long ln = niso.getImageWidth();
        if (ln != -1L) {
            mixBuilder.add("mix:imageWidth", ln);
            hasBuilder = true;
        }
        if ((ln = niso.getImageLength()) != -1L) {
            mixBuilder.add("mix:imageHeight", ln);
            hasBuilder = true;
        }
        if ((n = niso.getColorSpace()) != -1) {
            if (bMix10) {
                mixBuilder.add("mix:colorSpace", n);
            } else {
                mixBuilder.add("mix:colorSpace", this.photometricInterpretationToString(n));
            }
            hasBuilder = true;
        }
        String s = niso.getProfileName();
        String s2 = niso.getProfileURL();
        if (s != null || s2 != null) {
            JsonObjectBuilder iccBuilder = Json.createObjectBuilder();
            this.addStringToJson(iccBuilder, "mix:iccProfileName", s);
            this.addStringToJson(iccBuilder, "mix:iccProfileURL", s2);
            mixBuilder.add("mix:IccProfile", iccBuilder);
            hasBuilder = true;
        }
        int[] iarray = niso.getYCbCrSubSampling();
        n = niso.getYCbCrPositioning();
        Rational[] rarray = niso.getYCbCrCoefficients();
        if (iarray != null || n != -1 || rarray != null) {
            JsonObjectBuilder yccBuilder = Json.createObjectBuilder();
            if (iarray != null && iarray.length >= 2) {
                yccBuilder.add("mix:YCbCrSubSampling", Json.createObjectBuilder().add("mix:yCbCrSubsampleHoriz", iarray[0]).add("mix:yCbCrSubsampleVert", iarray[1]));
            }
            this.addNisoIntToJson(yccBuilder, "mix:yCbCrPositioning", n);
            if (rarray != null) {
                if (bMix10) {
                    yccBuilder.add("mix:yCbCrCoefficients", this.showArray(rarray));
                } else {
                    yccBuilder.add("mix:yCbCrCoefficients", Json.createObjectBuilder().add("mix:lumaRed", this.showRational(rarray[0])).add("mix:lumaGreen", this.showRational(rarray[1])).add("mix:lumaBlue", this.showRational(rarray[2])));
                }
            }
            mixBuilder.add("mix:YCbCr", yccBuilder);
            hasBuilder = true;
        }
        if ((rarray = niso.getReferenceBlackWhite()) != null) {
            if (bMix10) {
                mixBuilder.add("mix:referenceBlackWhite", this.showArray(rarray));
            } else {
                JsonArrayBuilder aBuilder = Json.createArrayBuilder();
                for (int i = 0; i < rarray.length - 1; i += 2) {
                    String pi;
                    JsonObjectBuilder cBuilder = Json.createObjectBuilder();
                    if (niso.getColorSpace() == 6) {
                        switch (i) {
                            case 0: {
                                pi = "Y";
                                break;
                            }
                            case 2: {
                                pi = "Cb";
                                break;
                            }
                            default: {
                                pi = "Cr";
                                break;
                            }
                        }
                    } else {
                        switch (i) {
                            case 0: {
                                pi = "R";
                                break;
                            }
                            case 2: {
                                pi = "G";
                                break;
                            }
                            default: {
                                pi = "B";
                            }
                        }
                    }
                    cBuilder.add("mix:componentPhotometricInterpretation", pi);
                    cBuilder.add("mix:footroom", this.showRational(rarray[i]));
                    cBuilder.add("mix:headroom", this.showRational(rarray[i + 1]));
                    aBuilder.add(cBuilder);
                }
                mixBuilder.add("mix:ReferenceBlackWhite", aBuilder);
            }
            hasBuilder = true;
        }
        int lay = niso.getJp2Layers();
        int lev = niso.getJp2ResolutionLevels();
        String sizTiles = niso.getJp2Tiles();
        if (sizTiles != null || lay != -1 || lev != -1) {
            JsonObjectBuilder jp2Builder = Json.createObjectBuilder();
            if (sizTiles != null) {
                if (bMix10) {
                    jp2Builder.add(MIX_TILES, sizTiles);
                } else {
                    String[] sizes = sizTiles.split("x");
                    jp2Builder.add(MIX_TILES, this.showArray(sizes));
                }
            }
            this.addNisoIntToJson(jp2Builder, "mix:qualityLayers", lay);
            this.addNisoIntToJson(jp2Builder, "mix:resolutionLevels", lev);
            mixBuilder.add("mix:JPEG2000", jp2Builder);
            hasBuilder = true;
        }
        return hasBuilder ? mixBuilder : null;
    }

    protected JsonObjectBuilder showNisoImageCaptureMetadata(NisoImageMetadata niso, boolean bMix10) {
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        boolean hasBuilder = false;
        hasBuilder |= this.addStringToJson(mixBuilder, "mix:sourceType", niso.getSourceType());
        hasBuilder |= this.addStringToJson(mixBuilder, "mix:sourceIDValue", niso.getSourceID());
        double d = niso.getSourceXDimension();
        int n = niso.getSourceXDimensionUnit();
        if (d != -1.0 || n != -1) {
            this.addNisoDoubleToJson(mixBuilder, "mix:sourceXDimensionValue", d);
            this.addNisoIntToJson(mixBuilder, "mix:sourceXDimensionUnit", n);
            this.addNisoDoubleToJson(mixBuilder, "mix:sourceYDimensionValue", niso.getSourceYDimension());
            this.addNisoIntToJson(mixBuilder, "mix:sourceYDimensionUnit", niso.getSourceYDimensionUnit());
            hasBuilder = true;
        }
        hasBuilder |= this.addStringToJson(mixBuilder, "mix:dateTimeCreated", niso.getDateTimeCreated());
        hasBuilder |= this.addStringToJson(mixBuilder, "mix:imageProducer", niso.getImageProducer());
        hasBuilder |= this.addStringToJson(mixBuilder, "mix:captureDevice", niso.getDeviceSource());
        hasBuilder |= this.addStringToJson(mixBuilder, "mix:scannerManufacturer", niso.getScannerManufacturer());
        String model = niso.getScannerModelName();
        String modelNum = niso.getScannerModelNumber();
        String serNum = niso.getScannerModelSerialNo();
        if (model != null || modelNum != null || serNum != null) {
            hasBuilder = true;
            JsonObjectBuilder smBuilder = Json.createObjectBuilder();
            this.addStringToJson(smBuilder, "mix:scannerModelName", model);
            this.addStringToJson(smBuilder, "mix:scannerModelNumber", modelNum);
            this.addStringToJson(smBuilder, "mix:scannerModelSerialNo", serNum);
            mixBuilder.add("mix:ScannerModel", smBuilder);
        }
        double xres = niso.getXPhysScanResolution();
        double yres = niso.getYPhysScanResolution();
        if (xres != -1.0 && yres != -1.0) {
            double res;
            double d2 = res = xres > yres ? xres : yres;
            if (bMix10) {
                mixBuilder.add("mix:maximumOpticalResolution", res);
            } else {
                mixBuilder.add("mix:MaximumOpticalResolution", Json.createObjectBuilder().add("mix:xOpticalResolution", xres).add("mix:yOpticalResolution", yres).add("mix:resolutionUnit", ".in"));
            }
            hasBuilder = true;
        }
        if (this.addStringToJson(mixBuilder, "mix:scanningSoftwareName", niso.getScanningSoftware())) {
            hasBuilder = true;
            this.addStringToJson(mixBuilder, "mix:scanningSoftwareVersionNo", niso.getScanningSoftwareVersionNo());
        }
        hasBuilder |= this.addStringToJson(mixBuilder, "mix:digitalCameraManufacturer", niso.getDigitalCameraManufacturer());
        String dcmodel = niso.getDigitalCameraModelName();
        String dcmodelNum = niso.getDigitalCameraModelNumber();
        String dcserNum = niso.getDigitalCameraModelSerialNo();
        if (dcmodel != null || dcmodelNum != null || dcserNum != null) {
            hasBuilder = true;
            JsonObjectBuilder smBuilder = Json.createObjectBuilder();
            this.addStringToJson(smBuilder, "mix:digitalCameraModelName", dcmodel);
            this.addStringToJson(smBuilder, "mix:digitalCameraModelNumber", dcmodelNum);
            this.addStringToJson(smBuilder, "mix:mix:digitalCameraModelSerialNo", dcserNum);
            mixBuilder.add("mix:DigitalCameraModel", smBuilder);
        }
        JsonObjectBuilder ccsBuilder = Json.createObjectBuilder();
        boolean useCcSetBuf = false;
        useCcSetBuf |= this.addNisoDoubleToJson(ccsBuilder, "mix:fNumber", niso.getFNumber());
        useCcSetBuf |= this.addNisoDoubleToJson(ccsBuilder, "mix:exposureTime", niso.getExposureTime());
        n = niso.getExposureProgram();
        if (n != -1) {
            if (bMix10) {
                ccsBuilder.add("mix:exposureProgram", n);
            } else {
                if (n > 8 || n < 0) {
                    n = 0;
                }
                ccsBuilder.add("mix:exposureProgram", NisoImageMetadata.EXPOSURE_PROGRAM[n]);
            }
            useCcSetBuf = true;
        }
        useCcSetBuf |= this.addStringToJson(ccsBuilder, "mix:exifVersion", niso.getExifVersion());
        useCcSetBuf |= this.addRationalToJson(ccsBuilder, "mix:brightnessValue", niso.getBrightness());
        useCcSetBuf |= this.addRationalToJson(ccsBuilder, "mix:exposureBiasValue", niso.getExposureBias());
        useCcSetBuf |= this.addRationalToJson(ccsBuilder, "mix:maxApertureValue", niso.getMaxApertureValue());
        double[] darray = niso.getSubjectDistance();
        if (darray != null) {
            ccsBuilder.add("mix:subjectDistance", this.showArray(darray));
            useCcSetBuf = true;
        }
        if ((n = niso.getMeteringMode()) != -1) {
            if (bMix10) {
                ccsBuilder.add("mix:meteringMode", n);
            } else {
                String s = this.meteringModeToString(n);
                if (s.startsWith("Center weighted")) {
                    s = "Center weighted Average";
                }
                ccsBuilder.add("mix:MeteringMode", s);
            }
            useCcSetBuf = true;
        }
        if ((n = niso.getFlash()) != -1) {
            int firstBit = n & 1;
            ccsBuilder.add("mix:flash", NisoImageMetadata.FLASH_20[firstBit]);
            useCcSetBuf = true;
        }
        useCcSetBuf |= this.addNisoDoubleToJson(ccsBuilder, "mix:focalLength", niso.getFocalLength());
        useCcSetBuf |= this.addRationalToJson(ccsBuilder, "mix:flashEnergy", niso.getFlashEnergy());
        useCcSetBuf |= this.addNisoIntToJson(ccsBuilder, "mix:backLight", niso.getBackLight());
        useCcSetBuf |= this.addNisoDoubleToJson(ccsBuilder, "mix:exposureIndex", niso.getExposureIndex());
        useCcSetBuf |= this.addNisoIntToJson(ccsBuilder, "mix:autoFocus", niso.getAutoFocus());
        useCcSetBuf |= this.addNisoDoubleToJson(ccsBuilder, "mix:xPrintAspectRatio", niso.getXPrintAspectRatio());
        if (useCcSetBuf |= this.addNisoDoubleToJson(ccsBuilder, "mix:yPrintAspectRatio", niso.getYPrintAspectRatio())) {
            mixBuilder.add("mix:CameraCaptureSettings", ccsBuilder);
            hasBuilder = true;
        }
        if ((n = niso.getOrientation()) != -1) {
            if (n > 9 || n < 1) {
                n = 9;
            }
            if (bMix10) {
                mixBuilder.add("mix:orientation", n);
            } else {
                String[] orient = new String[]{NOTE, "normal*", "normal, image flipped", "normal, rotated 180\u00b0", "normal, image flipped, rotated 180\u00b0", "normal, image flipped, rotated cw 90\u00b0", "normal, rotated ccw 90\u00b0", "normal, image flipped, rotated ccw 90\u00b0", "normal, rotated cw 90\u00b0", "unknown"};
                mixBuilder.add("mix:orientation", orient[n]);
            }
            hasBuilder = true;
        }
        return (hasBuilder |= this.addStringToJson(mixBuilder, "mix:methodology", niso.getMethodology())) ? mixBuilder : null;
    }

    protected JsonObjectBuilder showNisoImageAssessmentMetadata(NisoImageMetadata niso, boolean bMix10) {
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        boolean hasBuilder = false;
        JsonObjectBuilder smBuilder = Json.createObjectBuilder();
        boolean useMetricsBuf = false;
        useMetricsBuf |= this.addNisoIntToJson(smBuilder, "mix:samplingFrequencyPlane", niso.getSamplingFrequencyPlane());
        int n = niso.getSamplingFrequencyUnit();
        if (n != -1) {
            if (bMix10) {
                smBuilder.add("mix:samplingFrequencyUnit", n);
            } else {
                String[] sfu = new String[]{null, "no absolute unit of measurement", "in.", "cm"};
                if (n < 1 || n > 3) {
                    n = 1;
                }
                smBuilder.add("mix:samplingFrequencyUnit", sfu[n]);
            }
            useMetricsBuf = true;
        }
        useMetricsBuf |= this.addRationalToJson(smBuilder, "mix:xSamplingFrequency", niso.getXSamplingFrequency());
        if (useMetricsBuf |= this.addRationalToJson(smBuilder, "mix:ySamplingFrequency", niso.getYSamplingFrequency())) {
            mixBuilder.add("mix:SpatialMetrics", smBuilder);
            hasBuilder = true;
        }
        JsonObjectBuilder imeBuilder = Json.createObjectBuilder();
        boolean useColorEncBuf = false;
        int[] iarray = niso.getBitsPerSample();
        if (iarray != null) {
            imeBuilder.add("mix:bitsPerSample", this.showArray(iarray));
            imeBuilder.add("mix:bitsPerSampleUnit", "integer");
            useColorEncBuf = true;
        }
        useColorEncBuf |= this.addNisoIntToJson(imeBuilder, "mix:samplesPerPixel", niso.getSamplesPerPixel());
        iarray = niso.getExtraSamples();
        if (iarray != null && (n = iarray[0]) >= 0 && n <= 3) {
            if (bMix10) {
                imeBuilder.add(MIX_EXTRA_SAMPLES, this.showArray(iarray));
            } else {
                String[] sarray = new String[iarray.length];
                for (int ii = 0; ii < iarray.length; ++ii) {
                    sarray[ii] = NisoImageMetadata.EXTRA_SAMPLE_20[iarray[ii]];
                    imeBuilder.add(MIX_EXTRA_SAMPLES, this.showArray(sarray));
                }
            }
            useColorEncBuf = true;
        }
        useColorEncBuf |= this.addStringToJson(imeBuilder, "mix:colormapReference", niso.getColormapReference());
        iarray = niso.getGrayResponseCurve();
        if (iarray != null) {
            imeBuilder.add("mix:grayResponseCurve", this.showArray(iarray));
            useColorEncBuf = true;
        }
        if ((n = niso.getGrayResponseUnit()) != -1) {
            if (bMix10) {
                imeBuilder.add(MIX_GRAY_RESPONSE_UNIT, n);
            } else if (n > 0 && n <= 5) {
                imeBuilder.add(MIX_GRAY_RESPONSE_UNIT, NisoImageMetadata.GRAY_RESPONSE_UNIT_20[n - 1]);
            }
            useColorEncBuf = true;
        }
        Rational r = niso.getWhitePointXValue();
        Rational r2 = niso.getWhitePointYValue();
        if (r != null && r2 != null) {
            imeBuilder.add("mix:WhitePoint", Json.createObjectBuilder().add("mix:whitePointXValue", this.showRational(r)).add("mix:whitePointYValue", this.showRational(r2)));
            useColorEncBuf = true;
        }
        JsonObjectBuilder pcBuilder = Json.createObjectBuilder();
        boolean useChromaBuf = false;
        useChromaBuf |= this.addRationalToJson(pcBuilder, "mix:primaryChromaticitiesRedX", niso.getPrimaryChromaticitiesRedX());
        useChromaBuf |= this.addRationalToJson(pcBuilder, "mix:primaryChromaticitiesRedY", niso.getPrimaryChromaticitiesRedY());
        useChromaBuf |= this.addRationalToJson(pcBuilder, "mix:primaryChromaticitiesGreenX", niso.getPrimaryChromaticitiesGreenX());
        useChromaBuf |= this.addRationalToJson(pcBuilder, "mix:primaryChromaticitiesGreenY", niso.getPrimaryChromaticitiesGreenY());
        useChromaBuf |= this.addRationalToJson(pcBuilder, "mix:primaryChromaticitiesBlueX", niso.getPrimaryChromaticitiesBlueX());
        if (useChromaBuf |= this.addRationalToJson(pcBuilder, "mix:primaryChromaticitiesBlueY", niso.getPrimaryChromaticitiesBlueY())) {
            imeBuilder.add("mix:PrimaryChromaticities", pcBuilder);
            useColorEncBuf = true;
        }
        if (useColorEncBuf) {
            mixBuilder.add("mix:ImageColorEncoding", imeBuilder);
            hasBuilder = true;
        }
        JsonObjectBuilder tdBuilder = Json.createObjectBuilder();
        boolean useTargetBuf = false;
        useTargetBuf |= this.addNisoIntToJson(tdBuilder, "mix:targetType", niso.getTargetType());
        useTargetBuf |= this.addStringToJson(tdBuilder, "mix:targetManufacturer", niso.getTargetIDManufacturer());
        useTargetBuf |= this.addStringToJson(tdBuilder, "mix:targetName", niso.getTargetIDName());
        useTargetBuf |= this.addStringToJson(tdBuilder, "mix:targetNo", niso.getTargetIDNo());
        useTargetBuf |= this.addStringToJson(tdBuilder, "mix:targetMedia", niso.getTargetIDMedia());
        useTargetBuf |= this.addStringToJson(tdBuilder, "mix:externalTarget", niso.getImageData());
        if (useTargetBuf |= this.addStringToJson(tdBuilder, "mix:performanceData", niso.getPerformanceData())) {
            mixBuilder.add("mix:TargetData", tdBuilder);
            hasBuilder = true;
        }
        return hasBuilder ? mixBuilder : null;
    }

    protected JsonObjectBuilder showChangeHistory(NisoImageMetadata niso, boolean bMix10) {
        String[] sarray;
        JsonObjectBuilder mixBuilder = Json.createObjectBuilder();
        boolean hasBuilder = false;
        hasBuilder |= this.addStringToJson(mixBuilder, "mix:sourceData", niso.getSourceData());
        hasBuilder |= this.addStringToJson(mixBuilder, "mix:processingAgency", niso.getProcessingAgency());
        JsonObjectBuilder psBuilder = Json.createObjectBuilder();
        boolean useSftwBuf = false;
        useSftwBuf |= this.addStringToJson(psBuilder, "mix:processingSoftwareName", niso.getProcessingSoftwareName());
        useSftwBuf |= this.addStringToJson(psBuilder, "mix:processingSoftwareVersion", niso.getProcessingSoftwareVersion());
        useSftwBuf |= this.addStringToJson(psBuilder, "mix:processingOperatingSystemName", niso.getOS());
        if (useSftwBuf |= this.addStringToJson(psBuilder, "mix:processingOperatingSystemVersion", niso.getOSVersion())) {
            mixBuilder.add("mix:ProcessingSoftware", psBuilder);
            hasBuilder = true;
        }
        if ((sarray = niso.getProcessingActions()) != null) {
            mixBuilder.add("mix:processingActions", this.showArray(sarray));
            hasBuilder = true;
        }
        return hasBuilder ? mixBuilder : null;
    }

    private String meteringModeToString(int n) {
        String s = NisoImageMetadata.METERING_MODE[1];
        if (n >= 1 && n <= 6) {
            s = NisoImageMetadata.METERING_MODE[n];
        }
        return s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1);
    }

    private String photometricInterpretationToString(int n) {
        switch (n) {
            case 0: {
                return "WhiteIsZero";
            }
            case 1: {
                return "BlackIsZero";
            }
            case 2: {
                return "RGB";
            }
            case 3: {
                return "PaletteColor";
            }
            case 4: {
                return "TransparencyMask";
            }
            case 5: {
                return "CMYK";
            }
            case 6: {
                return "YCbCr";
            }
            case 8: {
                return "CIELab";
            }
            case 9: {
                return "ICCLab";
            }
            case 10: {
                return "ITULab";
            }
            case 32803: {
                return "CFA";
            }
            case 34892: {
                return "LinearRaw";
            }
        }
        return "Unknown";
    }

    private String compressionSchemeToString(int n) {
        for (int i = 0; i < NisoImageMetadata.COMPRESSION_SCHEME_INDEX.length; ++i) {
            if (n != NisoImageMetadata.COMPRESSION_SCHEME_INDEX[i]) continue;
            return NisoImageMetadata.COMPRESSION_SCHEME[i];
        }
        return Integer.toString(n);
    }

    protected JsonObjectBuilder showAESAudioMetadata(AESAudioMetadata aes) {
        List<AESAudioMetadata.Face> facelist;
        String[] use;
        long lin;
        JsonObjectBuilder aesBuilder = Json.createObjectBuilder();
        this._sampleRate = aes.getSampleRate();
        this.addStringToJson(aesBuilder, "aes:analogDigitalFlag", aes.getAnalogDigitalFlag());
        this.addStringToJson(aesBuilder, "aes:schemaVersion", aes.getSchemaVersion());
        this.addStringToJson(aesBuilder, "aes:format", aes.getFormat());
        this.addStringToJson(aesBuilder, "aes:specificationVersion", aes.getSpecificationVersion());
        this.addStringToJson(aesBuilder, "aes:appSpecificData", aes.getAppSpecificData());
        this.addStringToJson(aesBuilder, "aes:audioDataEncoding", aes.getAudioDataEncoding());
        int in = aes.getByteOrder();
        if (in != -1) {
            aesBuilder.add("aes:byteOrder", in == 0 ? "BIG_ENDIAN" : "LITTLE_ENDIAN");
        }
        if ((lin = aes.getFirstSampleOffset()) != -1L) {
            aesBuilder.add("aes:firstSampleOffset", lin);
        }
        if ((use = aes.getUse()) != null) {
            aesBuilder.add("aes:use", Json.createObjectBuilder().add("aes:useType", use[0]).add("aes:otherType", use[1]));
        }
        if (this.addStringToJson(aesBuilder, "aes:primaryIdentifier", aes.getPrimaryIdentifier())) {
            this.addStringToJson(aesBuilder, "aes:primaryIdentifierType", aes.getPrimaryIdentifierType());
        }
        if ((facelist = aes.getFaceList()) != null && !facelist.isEmpty()) {
            int nchan;
            AESAudioMetadata.Face f = facelist.get(0);
            JsonObjectBuilder faceBuilder = Json.createObjectBuilder();
            AESAudioMetadata.TimeDesc startTime = f.getStartTime();
            if (startTime != null) {
                faceBuilder.add("aes:timeline", this.writeAESTimeRange(startTime, f.getDuration()));
            }
            if ((nchan = aes.getNumChannels()) != -1) {
                faceBuilder.add("aes:numChannels", nchan);
            }
            JsonArrayBuilder streamsBuilder = Json.createArrayBuilder();
            for (int ch = 0; ch < nchan; ++ch) {
                streamsBuilder.add(Json.createObjectBuilder().add("aes:channelNum", ch));
            }
            faceBuilder.add("aes:streams", streamsBuilder);
            aesBuilder.add("aes:face", faceBuilder);
        }
        this.showAesFormatList(aes.getFormatList(), aesBuilder);
        return aesBuilder;
    }

    private void showAesFormatList(List<AESAudioMetadata.FormatRegion> flist, JsonObjectBuilder aesBuilder) {
        if (flist == null || flist.isEmpty()) {
            return;
        }
        AESAudioMetadata.FormatRegion rgn = flist.get(0);
        int bitDepth = rgn.getBitDepth();
        double sampleRate = rgn.getSampleRate();
        int wordSize = rgn.getWordSize();
        String[] bitRed = rgn.getBitrateReduction();
        JsonArrayBuilder formatListBuilder = Json.createArrayBuilder();
        JsonObjectBuilder formatRegionBuilder = Json.createObjectBuilder();
        if (bitDepth != -1 || sampleRate != -1.0 || wordSize != -1) {
            if (bitDepth != -1) {
                formatRegionBuilder.add("aes:bitDepth", bitDepth);
            }
            if (sampleRate != -1.0) {
                formatRegionBuilder.add("aes:sampleRate", sampleRate);
            }
            if (wordSize != -1) {
                formatRegionBuilder.add("aes:wordSize", wordSize);
            }
            if (bitRed != null) {
                formatRegionBuilder.add("aes:bitrateReduction", Json.createObjectBuilder().add("aes:codecName", bitRed[0]).add("aes:codecNameVersion", bitRed[1]).add("aes:codecCreatorApplication", bitRed[2]).add("aes:codecCreatorApplicationVersion", bitRed[3]).add("aes:codecQuality", bitRed[4]).add("aes:dataRate", bitRed[5]).add("aes:dataRateMode", bitRed[6]));
            }
            formatListBuilder.add(formatRegionBuilder);
            aesBuilder.add("aes:formatList", formatListBuilder);
        }
    }

    private JsonObjectBuilder writeAESTimeRange(AESAudioMetadata.TimeDesc start, AESAudioMetadata.TimeDesc duration) {
        JsonObjectBuilder timerangeBuilder = Json.createObjectBuilder();
        this.writeAESTimeRangePart(timerangeBuilder, "aes:start", start);
        if (duration != null) {
            this.writeAESTimeRangePart(timerangeBuilder, "aes:duration", duration);
        }
        return timerangeBuilder;
    }

    private void writeAESTimeRangePart(JsonObjectBuilder timerangeBuilder, String name, AESAudioMetadata.TimeDesc part) {
        double sr = part.getSampleRate() == 1.0 ? this._sampleRate : part.getSampleRate();
        timerangeBuilder.add(name, Json.createObjectBuilder().add("aes:value", part.getSamples()).add("aes:editRate", (int)sr).add("aes:factorNumerator", "1").add("aes:factorDenominator", "1"));
    }

    protected JsonArrayBuilder showArray(int[] iarray) {
        JsonArrayBuilder aBuilder = Json.createArrayBuilder();
        for (int i : iarray) {
            aBuilder.add(i);
        }
        return aBuilder;
    }

    protected JsonArrayBuilder showArray(double[] darray) {
        JsonArrayBuilder dBuilder = Json.createArrayBuilder();
        for (double d : darray) {
            dBuilder.add(d);
        }
        return dBuilder;
    }

    protected JsonArrayBuilder showArray(String[] sarray) {
        JsonArrayBuilder sBuilder = Json.createArrayBuilder();
        for (String s : sarray) {
            if (s == null) {
                sBuilder.addNull();
                continue;
            }
            sBuilder.add(s);
        }
        return sBuilder;
    }

    protected JsonArrayBuilder showArray(Rational[] rarray) {
        JsonArrayBuilder rBuilder = Json.createArrayBuilder();
        for (Rational r : rarray) {
            if (r == null) {
                rBuilder.addNull();
                continue;
            }
            rBuilder.add(this.showRational(r));
        }
        return rBuilder;
    }

    protected JsonArrayBuilder showRational(Rational r) {
        JsonArrayBuilder rationalBuilder = Json.createArrayBuilder();
        long numer = r.getNumerator();
        long denom = r.getDenominator();
        rationalBuilder.add(numer);
        rationalBuilder.add(denom);
        return rationalBuilder;
    }

    private boolean addStringToJson(JsonObjectBuilder objBuilder, String attr, String value) {
        if (value == null) {
            return false;
        }
        objBuilder.add(attr, value);
        return true;
    }

    private boolean addRationalToJson(JsonObjectBuilder objBuilder, String attr, Rational r) {
        if (r == null) {
            return false;
        }
        objBuilder.add(attr, this.showRational(r));
        return true;
    }

    private boolean addNisoIntToJson(JsonObjectBuilder objBuilder, String attr, int n) {
        if (n == -1) {
            return false;
        }
        objBuilder.add(attr, n);
        return true;
    }

    private boolean addNisoDoubleToJson(JsonObjectBuilder objBuilder, String attr, double d) {
        if (d == -1.0) {
            return false;
        }
        objBuilder.add(attr, d);
        return true;
    }
}

