/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RAFInputStream
extends InputStream {
    private static int DEFAULT_BUFFER_SIZE = 65536;
    private RandomAccessFile _raf;
    private int fileBufSize;
    private byte[] fileBuf;
    private int fileBufPos;
    private int fileBufBytes;
    private long fileOffset;
    private boolean eof;

    public RAFInputStream(RandomAccessFile raf) {
        this._raf = raf;
        this.fileBufSize = DEFAULT_BUFFER_SIZE;
        this.init();
    }

    public RAFInputStream(RandomAccessFile raf, int bufferSize) {
        this._raf = raf;
        this.fileBufSize = bufferSize <= 0 ? DEFAULT_BUFFER_SIZE : bufferSize;
        this.init();
    }

    private void init() {
        this.fileBufBytes = 0;
        this.fileBufPos = 0;
        this.fileBuf = new byte[this.fileBufSize];
        try {
            this.fileOffset = this._raf.getFilePointer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.eof = false;
    }

    private void fillFileBuffer() throws IOException {
        this._raf.seek(this.fileOffset);
        this.fileBufBytes = this._raf.read(this.fileBuf);
        this.fileBufPos = 0;
        if (this.fileBufBytes <= 0) {
            this.eof = true;
        }
        this.fileOffset += (long)this.fileBufBytes;
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.fileBufPos >= this.fileBufBytes) {
            this.fillFileBuffer();
            if (this.eof) {
                return -1;
            }
        }
        return this.fileBuf[this.fileBufPos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesToRead = b.length;
        int bytesRead = 0;
        do {
            int fbAvail;
            if ((fbAvail = this.fileBufBytes - this.fileBufPos) <= 0) {
                this.fillFileBuffer();
                if (this.eof) {
                    return bytesRead;
                }
                fbAvail = this.fileBufBytes;
            }
            if (fbAvail > bytesToRead) {
                fbAvail = bytesToRead;
            }
            int i = 0;
            while (i < fbAvail) {
                b[bytesRead++] = this.fileBuf[this.fileBufPos++];
                --bytesToRead;
                ++i;
            }
        } while (bytesToRead != 0);
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesToRead = len;
        int bytesRead = 0;
        do {
            int fbAvail;
            if ((fbAvail = this.fileBufBytes - this.fileBufPos) <= 0) {
                this.fillFileBuffer();
                if (this.eof) {
                    return bytesRead;
                }
                fbAvail = this.fileBufBytes;
            }
            if (fbAvail > bytesToRead) {
                fbAvail = bytesToRead;
            }
            int i = 0;
            while (i < fbAvail) {
                b[off + bytesRead++] = this.fileBuf[this.fileBufPos++];
                --bytesToRead;
                ++i;
            }
        } while (bytesToRead != 0);
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        int bytesLeft = this.fileBufBytes - this.fileBufPos;
        if ((long)bytesLeft > n) {
            this.fileBufPos += (int)n;
        } else {
            this.fileOffset = this.fileOffset + n - (long)bytesLeft > this._raf.length() ? this._raf.length() : (this.fileOffset += n - (long)bytesLeft);
            this.fileBufBytes = 0;
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        if (this.fileBufPos >= this.fileBufBytes) {
            this.fillFileBuffer();
            if (this.eof) {
                return 0;
            }
        }
        return this.fileBufBytes - this.fileBufPos;
    }

    public RandomAccessFile getRAF() {
        return this._raf;
    }

    public void seek(long offset) throws IOException {
        this._raf.seek(offset);
        this.fileBufBytes = 0;
        this.fileBufPos = 0;
        this.eof = false;
    }

    public long getFilePos() throws IOException {
        return this._raf.getFilePointer() - (long)(this.fileBufBytes - this.fileBufPos);
    }
}

