/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

public final class RFC1766Lang {
    String _langCode;

    public RFC1766Lang(String str) {
        this._langCode = str;
    }

    public String getLangCode() {
        return this._langCode;
    }

    public boolean isSyntaxCorrect() {
        if (this._langCode == null) {
            return false;
        }
        char[] chrs = this._langCode.toLowerCase().toCharArray();
        char firstChar = '\u0000';
        int ntags = 0;
        int taglength = 0;
        int i = 0;
        while (i < chrs.length) {
            char ch = chrs[i];
            if (i == 0) {
                firstChar = ch;
            }
            if (!Character.isLetter(ch) && ch != '-') {
                return false;
            }
            if (ch == '-') {
                taglength = 0;
                if (ntags++ == 0 && taglength == 1) {
                    if (firstChar != 'i' && firstChar != 'x') {
                        return false;
                    }
                    if (taglength != 2) {
                        return false;
                    }
                }
            } else if (++taglength > 8) {
                return false;
            }
            ++i;
        }
        return taglength != 0;
    }
}

