/*
 * Decompiled with CFR 0.152.
 */
package org.openpreservation.jhove;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public final class ReleaseDetails {
    private static final String APPLICATION_PROPERTIES_PATH = "org/openpreservation/jhove/jhove.properties";
    private static final String RIGHTS = "Derived from software Copyright 2004-2011 by the President and Fellows of Harvard College. Version 1.7 to 1.11 independently released. Version 1.12 onwards released by Open Preservation Foundation. Released under the GNU Lesser General Public License.";
    private static final ReleaseDetails INSTANCE = ReleaseDetails.fromPropertyResource("org/openpreservation/jhove/jhove.properties");
    private final String version;
    private final Date buildDate;

    private ReleaseDetails() {
        throw new AssertionError((Object)("Entered private constructor for: " + this.getClass().getName()));
    }

    private ReleaseDetails(String version, Date buildDate) {
        this.version = version;
        this.buildDate = new Date(buildDate.getTime());
    }

    public String getVersion() {
        return this.version;
    }

    public Date getBuildDate() {
        return new Date(this.buildDate.getTime());
    }

    public String getRights() {
        return RIGHTS;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.buildDate == null ? 0 : this.buildDate.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReleaseDetails other = (ReleaseDetails)obj;
        if (this.buildDate == null ? other.buildDate != null : !this.buildDate.equals(other.buildDate)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "ReleaseDetails [version=" + this.version + ", buildDate=" + this.buildDate + "]";
    }

    public static ReleaseDetails getInstance() {
        return INSTANCE;
    }

    private static ReleaseDetails fromPropertyResource(String propertyResourceName) {
        Properties props = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = ReleaseDetails.class.getClassLoader().getResourceAsStream(propertyResourceName);){
                if (is == null) {
                    throw new IllegalStateException("No application properties found for: " + propertyResourceName);
                }
                try {
                    props.load(is);
                }
                catch (IOException e) {
                    is.close();
                    throw new IllegalStateException("No application properties found for: " + propertyResourceName, e);
                }
                is.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ReleaseDetails.fromProperties(props);
    }

    private static ReleaseDetails fromProperties(Properties props) {
        String release = props.getProperty("jhove.release.version");
        String dateFormat = props.getProperty("jhove.date.format");
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        Date date = new Date();
        try {
            date = formatter.parse(props.getProperty("jhove.release.date"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return new ReleaseDetails(release, date);
    }
}

