/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.api;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.util.FeatureEnum;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Set;

public final class FeatureReport {
    private final SetMultimap<FeatureEnum, Feature> features = Multimaps.synchronizedSetMultimap(LinkedHashMultimap.create());

    public void report(FeatureEnum name, EPUBLocation location) {
        this.features.put(name, new Feature(name, location, null));
    }

    public void report(FeatureEnum name, EPUBLocation location, String value) {
        this.features.put(name, new Feature(name, location, value));
    }

    public boolean hasFeature(FeatureEnum feature) {
        return this.features.containsKey((Object)feature);
    }

    public Set<Feature> getFeature(FeatureEnum feature) {
        return ImmutableSet.copyOf(this.features.get((Object)feature));
    }

    public static final class Feature {
        private FeatureEnum name;
        private Optional<EPUBLocation> location;
        private Optional<String> value;

        private Feature(FeatureEnum name, EPUBLocation location, String value) {
            Preconditions.checkNotNull(name);
            Preconditions.checkNotNull(location);
            this.name = name;
            this.location = Optional.fromNullable(location);
            this.value = Optional.fromNullable(Strings.emptyToNull(value));
        }

        public FeatureEnum getName() {
            return this.name;
        }

        public Optional<EPUBLocation> getLocation() {
            return this.location;
        }

        public Optional<String> getValue() {
            return this.value;
        }
    }
}

