/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.dict;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.dict.SearchKeyMapHandler;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.PublicationResourceChecker;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Preconditions;

public class SearchKeyMapChecker
extends PublicationResourceChecker {
    public SearchKeyMapChecker(ValidationContext context) {
        super(context);
        Preconditions.checkState("application/vnd.epub.search-key-map+xml".equals(context.mimeType));
    }

    @Override
    protected boolean checkContent() {
        if (!this.context.path.endsWith(".xml")) {
            this.report.message(MessageId.OPF_080, EPUBLocation.of(this.context), new Object[0]);
        }
        XMLParser parser = new XMLParser(this.context);
        parser.addValidator(XMLValidators.SEARCH_KEY_MAP_RNC.get());
        parser.addContentHandler(new SearchKeyMapHandler(this.context));
        parser.process();
        return true;
    }
}

