/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.OCFCheckerState;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.xml.handlers.XMLHandler;
import com.adobe.epubcheck.xml.model.XMLElement;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.mola.galimatias.URL;

final class OCFContainerFileHandler
extends XMLHandler {
    private final OCFCheckerState state;

    public OCFContainerFileHandler(ValidationContext context, OCFCheckerState state) {
        super(context, state.getContainer().getRootURL());
        this.state = state;
    }

    @Override
    public void startElement() {
        XMLElement element = this.currentElement();
        String ns = element.getNamespace();
        if ("urn:oasis:names:tc:opendocument:xmlns:container".equals(ns)) {
            switch (element.getName()) {
                case "rootfile": {
                    this.processRootFile();
                    break;
                }
                case "link": {
                    this.processMappingDoc();
                }
            }
        }
    }

    private void processRootFile() {
        assert ("rootfile".equals(this.currentElement().getName()));
        String fullPath = this.currentElement().getAttribute("full-path");
        String mediaType = Optional.fromNullable(this.currentElement().getAttribute("media-type")).or("unknown").trim();
        if (fullPath == null) {
            this.report.message(MessageId.OPF_016, this.location(), new Object[0]);
            return;
        }
        if (fullPath.trim().isEmpty()) {
            this.report.message(MessageId.OPF_017, this.location(), new Object[0]);
            return;
        }
        URL rootfileURL = this.checkURL(fullPath);
        if (rootfileURL != null) {
            this.state.addRootfile(mediaType, rootfileURL);
        }
    }

    private void processMappingDoc() {
        URL mappingDocURL;
        assert ("link".equals(this.currentElement().getName()));
        String href = this.currentElement().getAttribute("href");
        if ("mapping".equals(Strings.nullToEmpty(this.currentElement().getAttribute("rel")).trim()) && !Strings.nullToEmpty(href).trim().isEmpty() && (mappingDocURL = this.checkURL(href)) != null) {
            this.state.addMappingDocument(mappingDocURL);
        }
    }
}

