/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.vocab.Property;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import java.util.Set;

public final class LinkedResource {
    private final Optional<String> id;
    private final URL url;
    private final Set<Property> rel;
    private final Optional<String> refines;
    private final Optional<String> mimetype;

    public Optional<String> getId() {
        return this.id;
    }

    public URL getURL() {
        return this.url;
    }

    public URL getDocumentURL() {
        try {
            return this.url.withFragment(null);
        }
        catch (GalimatiasParseException e) {
            throw new AssertionError();
        }
    }

    public Set<Property> getRel() {
        return this.rel;
    }

    public Optional<String> getRefines() {
        return this.refines;
    }

    public Optional<String> getMimeType() {
        return this.mimetype;
    }

    private LinkedResource(Builder builder) {
        Preconditions.checkState(builder.url != null);
        this.url = builder.url;
        this.id = LinkedResource.optional(builder.id);
        this.rel = builder.rel == null ? ImmutableSet.of() : ImmutableSet.copyOf(builder.rel);
        this.refines = LinkedResource.optional(builder.refines);
        this.mimetype = LinkedResource.optional(builder.mimetype);
    }

    private static Optional<String> optional(String string) {
        if (string == null || string.trim().isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(string.trim());
    }

    public static final class Builder {
        private final URL url;
        private String id = null;
        private Set<Property> rel = null;
        private String refines = null;
        private String mimetype = null;

        public Builder(URL url) {
            this.url = Preconditions.checkNotNull(url);
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder rel(Set<Property> rel) {
            this.rel = rel;
            return this;
        }

        public Builder refines(String refines) {
            this.refines = refines;
            return this;
        }

        public Builder mimetype(String mimetype) {
            this.mimetype = mimetype;
            return this;
        }

        public LinkedResource build() {
            return new LinkedResource(this);
        }
    }
}

