/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.vocab.Property;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public final class MetadataSet {
    private final SetMultimap<Property, Metadata> all;
    private final SetMultimap<Property, Metadata> primary;
    private final SetMultimap<String, Metadata> refiners;
    private final Map<Metadata, Metadata> refines;
    private final Supplier<Set<Metadata>> allSet = Suppliers.memoize(new Supplier<Set<Metadata>>(){

        @Override
        public Set<Metadata> get() {
            return ImmutableSet.copyOf(MetadataSet.this.all.values());
        }
    });
    private final Supplier<Set<Metadata>> primarySet = Suppliers.memoize(new Supplier<Set<Metadata>>(){

        @Override
        public Set<Metadata> get() {
            return ImmutableSet.copyOf(MetadataSet.this.primary.values());
        }
    });

    private MetadataSet(Multimap<Property, Metadata> all, Multimap<Property, Metadata> primary, Map<Metadata, Metadata> refines, Multimap<String, Metadata> refiners) {
        this.all = ImmutableSetMultimap.copyOf(all);
        this.primary = ImmutableSetMultimap.copyOf(primary);
        this.refines = ImmutableMap.copyOf(refines);
        this.refiners = ImmutableSetMultimap.copyOf(refiners);
    }

    public Set<Metadata> getPrimary() {
        return this.primarySet.get();
    }

    public Set<Metadata> getAll() {
        return this.allSet.get();
    }

    public boolean containsPrimary(Property property) {
        return this.primary.containsKey(property);
    }

    public boolean containsPrimary(Property property, String value) {
        for (Metadata meta : this.primary.get((Object)property)) {
            if (!meta.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(Property property) {
        return this.all.containsKey(property);
    }

    public Set<Metadata> getPrimary(Property property) {
        return this.primary.get((Object)property);
    }

    public Set<Metadata> getAny(Property property) {
        return this.all.get((Object)property);
    }

    public Optional<Metadata> getRefinedBy(Metadata meta) {
        return Optional.fromNullable(this.refines.get(meta));
    }

    public Set<Metadata> getRefining(String id) {
        return this.refiners.get((Object)id);
    }

    public static Optional<Metadata> tryFindInRefines(Set<Metadata> metas, final Property property, final Optional<String> value) {
        Preconditions.checkNotNull(metas);
        Preconditions.checkNotNull(property);
        Preconditions.checkNotNull(value);
        return Iterables.tryFind(metas, new Predicate<Metadata>(){

            @Override
            public boolean apply(Metadata meta) {
                return MetadataSet.tryFind(meta.getRefiners(), property, value).isPresent();
            }
        });
    }

    public static Optional<Metadata> tryFind(Set<Metadata> metas, final Property property, final Optional<String> value) {
        Preconditions.checkNotNull(metas);
        Preconditions.checkNotNull(property);
        Preconditions.checkNotNull(value);
        return Iterables.tryFind(metas, new Predicate<Metadata>(){

            @Override
            public boolean apply(Metadata meta) {
                return property.equals(meta.getProperty()) && (!value.isPresent() || ((String)value.get()).equals(meta.getValue()));
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Metadata {
        private final Optional<String> id;
        private final Property property;
        private final String value;
        private final Optional<String> refines;
        private final Set<Metadata> refiners;

        private Metadata(String id, Property property, String value, String refines, Set<Metadata> refiners) {
            Preconditions.checkNotNull(property);
            this.id = Optional.fromNullable(id);
            this.property = property;
            String string = this.value = value == null ? "" : value.trim();
            this.refines = refines == null ? Optional.absent() : (refines.startsWith("#") ? Optional.fromNullable(Strings.emptyToNull(refines.substring(1))) : Optional.of(refines));
            this.refiners = refiners == null ? ImmutableSet.of() : refiners;
        }

        public Optional<String> getId() {
            return this.id;
        }

        public Property getProperty() {
            return this.property;
        }

        public String getValue() {
            return this.value;
        }

        public Optional<String> getRefines() {
            return this.refines;
        }

        public Set<Metadata> getRefiners() {
            return this.refiners;
        }

        public boolean isPrimary() {
            return !this.refines.isPresent();
        }

        public String toString() {
            return "Metadata [id=" + this.id + ", property=" + this.property + ", value=" + this.value + ", refines=" + this.refines + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
            result = 31 * result + (this.refines == null ? 0 : this.refines.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Metadata other = (Metadata)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
                return false;
            }
            if (this.refines == null ? other.refines != null : !this.refines.equals(other.refines)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static final class Builder {
        private final Multimap<Property, Metadata> primary = HashMultimap.create();
        private final Multimap<Property, Metadata> all = HashMultimap.create();
        private final LinkedList<Metadata> tempMetas = Lists.newLinkedList();
        private final Multimap<String, Metadata> refinersMap = LinkedListMultimap.create();
        private final Map<Metadata, Metadata> refines = Maps.newHashMap();
        private final Map<Metadata, Visit> visits = Maps.newHashMap();

        public MetadataSet build() {
            for (Metadata metadata : this.tempMetas) {
                this.build(metadata);
            }
            return new MetadataSet(this.all, this.primary, this.refines, this.refinersMap);
        }

        private Metadata build(Metadata meta) {
            Preconditions.checkArgument(meta.getId().isPresent());
            switch (Visit.safe(this.visits.get(meta))) {
                case VISITED: {
                    return meta;
                }
                case VISITING: {
                    throw new IllegalStateException("Not a DAG");
                }
            }
            this.visits.put(meta, Visit.VISITING);
            HashSet<Metadata> refiners = new HashSet<Metadata>();
            for (Metadata refiner : this.refinersMap.get(meta.getId().get())) {
                refiners.add(refiner.getId().isPresent() ? this.build(refiner) : refiner);
            }
            Metadata result = new Metadata(meta.getId().get(), meta.getProperty(), meta.getValue(), meta.getRefines().orNull(), refiners);
            for (Metadata refiner : refiners) {
                this.refines.put(refiner, result);
            }
            if (result.getRefines().isPresent()) {
                this.refinersMap.remove(result.getRefines().get(), meta);
                this.refinersMap.put(result.getRefines().get(), result);
            } else {
                this.primary.put(result.getProperty(), result);
            }
            this.all.put(result.getProperty(), result);
            this.visits.put(meta, Visit.VISITED);
            return result;
        }

        public Builder meta(String id, Property property, String value, String refines) {
            Metadata meta = new Metadata(id, property, value, refines, null);
            if (id == null) {
                if (!meta.refines.isPresent()) {
                    this.primary.put(property, meta);
                }
                this.all.put(property, meta);
            } else {
                this.tempMetas.add(meta);
            }
            if (meta.refines.isPresent()) {
                this.refinersMap.put((String)meta.refines.get(), meta);
            }
            return this;
        }

        private static enum Visit {
            UNVISITED,
            VISITED,
            VISITING;


            public static Visit safe(Visit visit) {
                return visit != null ? visit : UNVISITED;
            }
        }
    }
}

