/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.overlay;

import com.adobe.epubcheck.overlay.ClipTime;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SmilClock {
    private static Pattern fullClockPattern = Pattern.compile("(npt=)?(\\d+):([0-5]\\d):([0-5]\\d)([.](\\d+))?");
    private static Pattern partialClockPattern = Pattern.compile("(npt=)?([0-5]\\d):([0-5]\\d)([.](\\d+))?");
    private static Pattern timecountClockPattern = Pattern.compile("(npt=)?(\\d+([.]\\d+)?)(h|min|s|ms)?");
    public static final int FULL = 1;
    public static final int PARTIAL = 2;
    public static final int TIMECOUNT = 3;
    public static final int TIMECOUNT_MSEC = 4;
    public static final int TIMECOUNT_SEC = 5;
    public static final int TIMECOUNT_MIN = 6;
    public static final int TIMECOUNT_HR = 7;
    public static final int HUMAN_READABLE = 8;
    public static final int RAW_TIMECOUNT_TRUNCATED_MSC = 9;
    private final ClipTime msecValue;
    private static long msecTolerance;

    public SmilClock(String s2) throws NumberFormatException {
        Matcher m3 = timecountClockPattern.matcher(s2.trim());
        if (m3.matches()) {
            BigDecimal bd = new BigDecimal(m3.group(2));
            this.msecValue = m3.group(4) == null ? new ClipTime(bd.multiply(BigDecimal.valueOf(1000L)).longValue()) : (m3.group(4).equals("ms") ? new ClipTime(bd.doubleValue()) : (m3.group(4).equals("s") ? new ClipTime(bd.multiply(BigDecimal.valueOf(1000L)).longValue()) : (m3.group(4).equals("min") ? new ClipTime(bd.multiply(BigDecimal.valueOf(60000L)).doubleValue()) : (m3.group(4).equals("h") ? new ClipTime(bd.multiply(BigDecimal.valueOf(3600000L)).longValue()) : new ClipTime()))));
            return;
        }
        m3 = fullClockPattern.matcher(s2.trim());
        if (m3.matches()) {
            this.msecValue = new ClipTime((double)(Long.parseLong(m3.group(2)) * 60L * 60L * 1000L + Long.parseLong(m3.group(3)) * 60L * 1000L + Long.parseLong(m3.group(4)) * 1000L) + (m3.group(6) != null ? new BigDecimal(m3.group(5)).multiply(BigDecimal.valueOf(1000L)).doubleValue() : 0.0));
            return;
        }
        m3 = partialClockPattern.matcher(s2.trim());
        if (m3.matches()) {
            this.msecValue = new ClipTime((double)(Long.parseLong(m3.group(2)) * 60L * 1000L + Long.parseLong(m3.group(3)) * 1000L) + (m3.group(5) != null ? new BigDecimal(m3.group(4)).multiply(BigDecimal.valueOf(1000L)).doubleValue() : 0.0));
            return;
        }
        throw new NumberFormatException("Invalid SMIL clock value format: " + s2.trim());
    }

    public SmilClock() {
        this.msecValue = new ClipTime();
    }

    private SmilClock(ClipTime clipTime) {
        this.msecValue = clipTime;
    }

    public SmilClock(double sec) {
        this.msecValue = new ClipTime(sec * 1000.0);
    }

    public SmilClock addTime(SmilClock addTime) {
        return new SmilClock(this.getTimeWOPrecisionLoss().add(addTime.getTimeWOPrecisionLoss()));
    }

    public SmilClock subtractTime(SmilClock subtractTime) {
        return new SmilClock(this.getTimeWOPrecisionLoss().subtract(subtractTime.getTimeWOPrecisionLoss()));
    }

    @Deprecated
    public SmilClock(long msec) {
        this.msecValue = new ClipTime(msec);
    }

    public boolean notSet() {
        return this.msecValue.notSet();
    }

    public String toString() {
        return this.toString(1);
    }

    public String toString(int format) {
        String s2;
        NumberFormat nfInt = NumberFormat.getIntegerInstance();
        nfInt.setMinimumIntegerDigits(2);
        NumberFormat nfMsec = NumberFormat.getIntegerInstance();
        nfMsec.setMinimumIntegerDigits(3);
        DecimalFormatSymbols dfSymbols = new DecimalFormatSymbols();
        dfSymbols.setDecimalSeparator('.');
        DecimalFormat dfDouble = new DecimalFormat("0.000", dfSymbols);
        dfDouble.setMaximumFractionDigits(3);
        dfDouble.setGroupingUsed(false);
        double msec = this.msecValue.roundedToMilliSeconds().getTimeInMs() % 1000.0;
        long tmp = Math.round(this.msecValue.getTimeInMs() - msec) / 1000L;
        long sec = tmp % 60L;
        tmp = (tmp - sec) / 60L;
        long min2 = tmp % 60L;
        long hr = (tmp - min2) / 60L;
        switch (format) {
            case 1: {
                if (msec > 0.0) {
                    s2 = hr + ":" + nfInt.format(min2) + ":" + nfInt.format(sec) + "." + nfMsec.format(msec);
                    break;
                }
                s2 = hr + ":" + nfInt.format(min2) + ":" + nfInt.format(sec);
                break;
            }
            case 2: {
                if (msec > 0.0) {
                    s2 = nfInt.format(min2) + ":" + nfInt.format(sec) + "." + nfMsec.format(msec);
                    break;
                }
                s2 = nfInt.format(min2) + ":" + nfInt.format(sec);
                break;
            }
            case 3: {
                s2 = dfDouble.format(BigDecimal.valueOf(this.msecValue.getTimeInMs() / 1000.0));
                break;
            }
            case 4: {
                s2 = dfDouble.format(BigDecimal.valueOf(this.msecValue.getTimeInMs())) + "ms";
                break;
            }
            case 9: {
                s2 = Long.toString((long)Math.ceil(this.msecValue.getTimeInMs()));
                break;
            }
            case 5: {
                s2 = dfDouble.format(BigDecimal.valueOf(this.msecValue.getTimeInMs() / 1000.0)) + "s";
                break;
            }
            case 6: {
                s2 = dfDouble.format(BigDecimal.valueOf(this.msecValue.getTimeInMs() / 60000.0)) + "min";
                break;
            }
            case 7: {
                s2 = dfDouble.format(BigDecimal.valueOf(this.msecValue.getTimeInMs() / 3600000.0)) + "h";
                break;
            }
            case 8: {
                if (hr > 0L) {
                    s2 = hr + " h " + nfInt.format(min2) + " min ";
                    break;
                }
                if (min2 > 0L) {
                    s2 = nfInt.format(min2) + " min " + nfInt.format(sec) + " s";
                    break;
                }
                if (sec > 0L) {
                    s2 = nfInt.format(sec) + " s " + nfMsec.format(msec) + " ms";
                    break;
                }
                s2 = nfMsec.format(msec) + " ms";
                break;
            }
            default: {
                throw new NumberFormatException("Unknown SMIL clock format code: " + format);
            }
        }
        return s2;
    }

    private ClipTime getTimeWOPrecisionLoss() {
        return this.msecValue;
    }

    @Deprecated
    public long millisecondsValue() {
        return this.millisecondsValueAsLong();
    }

    public long millisecondsValueAsLong() {
        return Math.round(this.msecValue.roundedToMilliSeconds().getTimeInMs());
    }

    @Deprecated
    public long secondsValueRounded() {
        return Math.round(this.secondsValue());
    }

    public double secondsValue() {
        return this.msecValue.getTimeInMs() / 1000.0;
    }

    public double secondsValueRoundedDouble() {
        return Math.round(this.secondsValue());
    }

    public SmilClock roundToMSPrecision() {
        return new SmilClock(this.getTimeWOPrecisionLoss().roundedToMilliSeconds());
    }

    public SmilClock floorToMSPrecision() {
        return new SmilClock(this.getTimeWOPrecisionLoss().floorToMilliSeconds());
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        try {
            SmilClock other = (SmilClock)otherObject;
            return this.eqWithinTolerance(other, msecTolerance);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean eqWithinTolerance(SmilClock other, long msecTolerance) {
        return this.compareTo(other, msecTolerance) == 0;
    }

    public int compareTo(Object otherObject) throws ClassCastException {
        return this.compareTo(otherObject, SmilClock.getTolerance());
    }

    public int compareTo(Object otherObject, long msecTolerance) throws ClassCastException {
        SmilClock other = (SmilClock)otherObject;
        if (Math.abs(other.msecValue.getTimeInMs() - this.msecValue.getTimeInMs()) <= (double)msecTolerance) {
            return 0;
        }
        if (this.msecValue.getTimeInMs() < other.msecValue.getTimeInMs()) {
            return -1;
        }
        return 1;
    }

    public static void setTolerance(long msec) {
        msecTolerance = msec;
    }

    public static long getTolerance() {
        return msecTolerance;
    }
}

