/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml.handlers;

import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.xml.handlers.LocationHandler;
import com.google.common.base.Preconditions;
import io.mola.galimatias.URL;
import org.w3c.epubcheck.core.references.URLChecker;
import org.xml.sax.Attributes;

public abstract class BaseURLHandler
extends LocationHandler {
    private URL baseURL;
    private final URLChecker urlChecker;

    public BaseURLHandler(ValidationContext context) {
        this(context, context.url);
    }

    public BaseURLHandler(ValidationContext context, URL baseURL) {
        super(context);
        this.urlChecker = new URLChecker(context, baseURL);
        this.baseURL = Preconditions.checkNotNull(baseURL);
    }

    protected final URL baseURL() {
        return this.baseURL;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String newBase = null;
        newBase = "http://www.w3.org/1999/xhtml".equals(uri) && "base".equals(localName) ? attributes.getValue("", "href") : attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
        if (newBase != null) {
            this.baseURL = this.urlChecker.setBase(newBase, this.location());
        }
    }

    protected final URL checkURL(String string) {
        return this.urlChecker.checkURL(string, this.location());
    }
}

