/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;

public class HistChunk
extends PNGChunk {
    public HistChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        this.processChunkCommon(info);
        ErrorMessage msg = null;
        if (!this._module.isPlteSeen()) {
            msg = new ErrorMessage(MessageConstants.PNG_GDM_12);
        } else if (this._module.isIdatSeen()) {
            msg = new ErrorMessage(MessageConstants.PNG_GDM_13);
        }
        if (msg != null) {
            info.setMessage(msg);
            info.setWellFormed(false);
            throw new PNGException(MessageConstants.PNG_GDM_14);
        }
        Property prop = new Property("Histogram", PropertyType.STRING, "present");
        info.setProperty(prop);
        int i = 0;
        while ((long)i < this.length) {
            this.readUnsignedByte();
            ++i;
        }
    }
}

