/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.JhoveException;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.module.JwatJhoveIdMinter;
import edu.harvard.hul.ois.jhove.module.gzip.GzipEntryProperties;
import edu.harvard.hul.ois.jhove.module.gzip.MessageConstants;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.Diagnosis;
import org.jwat.common.Diagnostics;
import org.jwat.common.InputStreamNoSkip;
import org.jwat.common.RandomAccessFileInputStream;
import org.jwat.gzip.GzipEntry;
import org.jwat.gzip.GzipReader;

public class GzipModule
extends ModuleBase {
    private static final Agent KB_AGENT = new Agent.Builder("Royal Library of Denmark", AgentType.STANDARD).address("S\u00f8ren Kierkegaards Plads 1, 1219 K\u00f8benhavn K, Denmark").fax("+45 3393 2218").web("http://kb.dk").build();
    private static final String NAME = "GZIP-kb";
    private static final String RELEASE = "0.3";
    private static final int[] DATE = new int[]{2023, 3, 16};
    private static final String[] FORMAT = new String[]{"GZIP"};
    private static final String COVERAGE = "GZIP, https://tools.ietf.org/html/rfc1952";
    private static final String[] MIMETYPE = new String[]{"application/gzip", "application/x-gzip"};
    private static final String WELLFORMED = "";
    private static final String VALIDITY = "The file is well-formed";
    private static final String REPINFO = "";
    private static final String NOTE = "";
    private static final String RIGHTS = "Copyright 2015 by The Royal Library of Denmark. Released under the GNU Lesser General Public License.";
    private static final String EXTENSION = ".gz";
    private List<Property> entryProperties;

    public GzipModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, "", VALIDITY, "", "", RIGHTS, false);
        this.setVendorAndSpecification();
        this.initialiseVariables();
    }

    private void setVendorAndSpecification() {
        this._vendor = KB_AGENT;
        Document doc = new Document(FORMAT[0], DocumentType.RFC);
        Agent ietfAgent = new Agent.Builder("IETF", AgentType.STANDARD).web("http://www.ietf.org").build();
        doc.setPublisher(ietfAgent);
        doc.setDate("1996");
        doc.setIdentifier(new Identifier("https://www.ietf.org/rfc/rfc1952.txt", IdentifierType.RFC));
        this._specification.add(doc);
        ExternalSignature sig = new ExternalSignature(EXTENSION, SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
    }

    private void initialiseVariables() {
        this.entryProperties = new ArrayList<Property>();
    }

    @Override
    public void resetParams() {
        this.initialiseVariables();
    }

    @Override
    public void checkSignatures(File file, InputStream stream, RepInfo info) throws IOException {
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule(this);
        boolean checkIsGzip = GzipReader.isGzipped(new ByteCountingPushBackInputStream(stream, 8192));
        if (checkIsGzip) {
            info.setSigMatch(this._name);
        } else {
            info.setWellFormed(false);
        }
    }

    @Override
    public void checkSignatures(File file, RandomAccessFile raf, RepInfo info) throws IOException {
        try (RandomAccessFileInputStream stream = new RandomAccessFileInputStream(raf);){
            this.checkSignatures(file, stream, info);
        }
    }

    @Override
    public void parse(RandomAccessFile file, RepInfo info) {
        RandomAccessFileInputStream stream = new RandomAccessFileInputStream(file);
        this.parse(stream, info, 0);
    }

    @Override
    public int parse(InputStream stream, RepInfo info, int parseIndex) {
        try (GzipReader reader = new GzipReader(new InputStreamNoSkip(stream), 8192);){
            info.setFormat(this._format[0]);
            info.setVersion("4.3");
            info.setMimeType(this._mimeType[0]);
            info.setModule(this);
            this.parseRecords(reader);
            info.setValid(reader.isCompliant());
            info.setWellFormed(reader.isCompliant());
            this.reportResults(reader, info);
            if (reader.isCompliant()) {
                info.setSigMatch(this._name);
            }
        }
        catch (Exception e) {
            info.setMessage(new ErrorMessage(MessageConstants.GZIP_KB_1, String.format("%s: %s", e.getClass().getName(), e.getMessage())));
            info.setValid(false);
            info.setWellFormed(false);
        }
        return 0;
    }

    protected void parseRecords(GzipReader reader) throws EOFException, IOException, JhoveException {
        if (reader != null) {
            GzipEntry entry;
            while ((entry = reader.getNextEntry()) != null) {
                this.processEntry(entry);
                reader.diagnostics.addAll(entry.diagnostics);
            }
        } else {
            throw new JhoveException("GzipReader has not been properly instantiated.");
        }
    }

    protected void processEntry(GzipEntry entry) throws EOFException, IOException {
        GzipEntryProperties properties = new GzipEntryProperties(entry);
        Property p = new Property("Record", PropertyType.STRING, PropertyArity.MAP, properties.getProperties());
        this.entryProperties.add(p);
        entry.close();
    }

    private void reportResults(GzipReader reader, RepInfo repInfo) {
        JwatJhoveIdMinter minter = JwatJhoveIdMinter.getInstance(NAME);
        Diagnostics<Diagnosis> diagnostics = reader.diagnostics;
        if (diagnostics.hasErrors()) {
            for (Diagnosis d : diagnostics.getErrors()) {
                repInfo.setMessage(new ErrorMessage(minter.mint(d)));
            }
            repInfo.setConsistent(false);
        }
        if (diagnostics.hasWarnings()) {
            for (Diagnosis d : diagnostics.getWarnings()) {
                repInfo.setMessage(new InfoMessage(minter.mint(d)));
            }
        }
        repInfo.setProperty(new Property("Records", PropertyType.PROPERTY, PropertyArity.LIST, this.entryProperties));
        repInfo.setSize(reader.getConsumed());
    }
}

