/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.regex.OpCapture;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.RECompiler;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.regex.charclass.CharacterClass;
import net.sf.saxon.regex.charclass.EmptyCharacterClass;
import net.sf.saxon.z.IntIterator;

public class OpChoice
extends Operation {
    List<Operation> branches;

    OpChoice(List<Operation> branches) {
        this.branches = branches;
    }

    @Override
    public int getMatchLength() {
        int fixed = this.branches.get(0).getMatchLength();
        for (int i = 1; i < this.branches.size(); ++i) {
            if (this.branches.get(i).getMatchLength() == fixed) continue;
            return -1;
        }
        return fixed;
    }

    @Override
    public int getMinimumMatchLength() {
        int min2 = this.branches.get(0).getMinimumMatchLength();
        for (int i = 1; i < this.branches.size(); ++i) {
            int m3 = this.branches.get(i).getMinimumMatchLength();
            if (m3 >= min2) continue;
            min2 = m3;
        }
        return min2;
    }

    @Override
    public int matchesEmptyString() {
        int m3 = 0;
        for (Operation branch : this.branches) {
            int b = branch.matchesEmptyString();
            if (b == 1024) continue;
            m3 |= b;
        }
        return m3;
    }

    @Override
    public boolean containsCapturingExpressions() {
        for (Operation o : this.branches) {
            if (!(o instanceof OpCapture) && !o.containsCapturingExpressions()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CharacterClass getInitialCharacterClass(boolean caseBlind) {
        CharacterClass result = EmptyCharacterClass.getInstance();
        for (Operation o : this.branches) {
            result = RECompiler.makeUnion(result, o.getInitialCharacterClass(caseBlind));
        }
        return result;
    }

    @Override
    public Operation optimize(REProgram program, REFlags flags) {
        for (int i = 0; i < this.branches.size(); ++i) {
            Operation o2;
            Operation o1 = this.branches.get(i);
            if (o1 == (o2 = o1.optimize(program, flags))) continue;
            this.branches.set(i, o2);
        }
        return this;
    }

    @Override
    public IntIterator iterateMatches(final REMatcher matcher, final int position) {
        return new IntIterator(){
            final Iterator<Operation> branchIter;
            IntIterator currentIter;
            Operation currentOp;
            {
                this.branchIter = OpChoice.this.branches.iterator();
                this.currentIter = null;
                this.currentOp = null;
            }

            @Override
            public boolean hasNext() {
                while (true) {
                    if (this.currentIter == null) {
                        if (this.branchIter.hasNext()) {
                            matcher.clearCapturedGroupsBeyond(position);
                            this.currentOp = this.branchIter.next();
                            this.currentIter = this.currentOp.iterateMatches(matcher, position);
                        } else {
                            return false;
                        }
                    }
                    if (this.currentIter.hasNext()) {
                        return true;
                    }
                    this.currentIter = null;
                }
            }

            @Override
            public int next() {
                return this.currentIter.next();
            }
        };
    }

    @Override
    public String display() {
        StringBuilder fsb = new StringBuilder(64);
        fsb.append("(?:");
        boolean first = true;
        for (Operation branch : this.branches) {
            if (first) {
                first = false;
            } else {
                fsb.append('|');
            }
            fsb.append(branch.display());
        }
        fsb.append(")");
        return fsb.toString();
    }
}

