/*
 * Decompiled with CFR 0.152.
 */
package org.ithaka.portico.jhove.module;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.Severity;
import com.adobe.epubcheck.reporting.CheckMessage;
import com.adobe.epubcheck.util.PathUtil;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.ithaka.portico.jhove.module.PorticoConstants;
import org.ithaka.portico.jhove.module.epub.JhoveRepInfoReport;
import org.ithaka.portico.jhove.module.epub.MessageConstants;
import org.jwat.common.RandomAccessFileInputStream;

public class EpubModule
extends ModuleBase {
    private static final String EPUB_MEDIATYPE = "application/epub+zip";
    private static final String FORMATNAME = "EPUB";
    private static final String NAME = "EPUB-ptc";
    private static final String RELEASE = "1.3";
    private static final int[] DATE = new int[]{2023, 6, 12};
    private static final String RIGHTS_YEAR = "2023";
    private static final String[] FORMAT = new String[]{"EPUB"};
    private static final String COVERAGE = "EPUB";
    private static final String[] MIMETYPE = new String[]{"application/epub+zip"};
    private static final String WELLFORMED = "";
    private static final String VALIDITY = "";
    private static final String REPINFO = "";
    private static final String NOTE = "This module uses EPUBCheck for testing of EPUB files.";
    private static final String EPUB_AGENTNAME = "International Digital Publishing Forum and World Wide Web Consortium";
    private static final AgentType EPUB_AGENTTYPE = AgentType.STANDARD;
    private static final String EPUB_AGENTADDRESS = "W3C Inc, 401 Edgewater Place, Suite 600, Wakefield, MA 01880, USA";
    private static final String EPUB_AGENTWEBSITE = "https://www.w3.org/";
    private static final String EPUB_AGENTEMAIL = "membership@w3.org";
    private static final String EPUB_AGENTPHONE = "+1-339-273-2711";
    private static final String EPUB_FORMATDOCTITLE = "EPUB";
    private static final String EPUB_FORMATDOCDATE = "2023-05-25";
    private static final String EPUB_FORMATDOCURL = "https://www.w3.org/TR/epub/";
    private static final String EPUB_EXTENSION = ".epub";
    private static final int FIRST_SIG_POSITION = 0;
    private static final String FIRST_SIG_VALUE = "PK";
    private static final int SECOND_SIG_POSITION = 30;
    private static final String SECOND_SIG_VALUE = "mimetype";
    private static final int THIRD_SIG_POSITION = 38;
    private static final String THIRD_SIG_VALUE = "application/epub+zip";
    public static final String[] NOTWELLFORMED_ERRCODES = new String[]{"PKG-"};
    protected List<Property> _propList;
    protected Property _metadata;

    public EpubModule() {
        super(NAME, RELEASE, DATE, FORMAT, "EPUB", MIMETYPE, "", "", "", NOTE, PorticoConstants.porticoRightsStmt(RIGHTS_YEAR), false);
        this.initializeInstance(PorticoConstants.porticoAgent());
    }

    public EpubModule(String name, String release, int[] date, String[] format, String coverage, String[] mimetype, String wellformedNote, String validityNote, String repinfoNote, String note, String rights, boolean isRandomAccess, Agent moduleAgent) {
        super(name, release, date, format, coverage, mimetype, wellformedNote, validityNote, repinfoNote, note, rights, isRandomAccess);
        this.initializeInstance(moduleAgent);
    }

    protected void initializeInstance(Agent moduleAgent) {
        this._vendor = moduleAgent;
        Agent formatDocAgent = new Agent.Builder(EPUB_AGENTNAME, EPUB_AGENTTYPE).address(EPUB_AGENTADDRESS).telephone(EPUB_AGENTPHONE).web(EPUB_AGENTWEBSITE).email(EPUB_AGENTEMAIL).build();
        Document doc = new Document("EPUB", DocumentType.STANDARD);
        doc.setPublisher(formatDocAgent);
        doc.setDate(EPUB_FORMATDOCDATE);
        doc.setIdentifier(new Identifier(EPUB_FORMATDOCURL, IdentifierType.URL));
        this._specification.add(doc);
        Signature sig = new ExternalSignature(EPUB_EXTENSION, SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new InternalSignature(FIRST_SIG_VALUE, SignatureType.MAGIC, SignatureUseType.MANDATORY, 0, "");
        this._signature.add(sig);
        sig = new InternalSignature(SECOND_SIG_VALUE, SignatureType.MAGIC, SignatureUseType.MANDATORY, 30, "");
        this._signature.add(sig);
        sig = new InternalSignature("application/epub+zip", SignatureType.MAGIC, SignatureUseType.MANDATORY, 38, "");
        this._signature.add(sig);
    }

    @Override
    protected void setupDataStream(InputStream stream, RepInfo info) {
        if (this._je != null) {
            super.setupDataStream(stream, info);
        } else {
            this._dstream = EpubModule.getBufferedDataStream(stream, 0);
        }
    }

    @Override
    public void checkSignatures(File file, InputStream stream, RepInfo info) throws IOException {
        super.checkSignatures(file, stream, info);
        info.setValid(-1);
    }

    @Override
    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        this.initParse();
        info.setModule(this);
        info.setFormat(this._format[0]);
        info.setWellFormed(false);
        info.setValid(false);
        this._propList = new LinkedList<Property>();
        this._metadata = new Property("EPUBMetadata", PropertyType.PROPERTY, PropertyArity.LIST, this._propList);
        this._ckSummer = null;
        this.setupDataStream(stream, info);
        try {
            JhoveRepInfoReport report = new JhoveRepInfoReport(info.getUri());
            EpubCheck epubCheck = new EpubCheck(this._dstream, (Report)report, info.getUri());
            epubCheck.doValidate();
            info.setCreated(report.getCreationDate());
            info.setLastModified(report.getLastModifiedDate());
            info.setVersion(report.getVersion());
            List<CheckMessage> epubMessages = report.getAllMessages();
            int notWellFormedErrors = epubMessages.stream().filter(this::triggerNotWellFormed).collect(Collectors.toSet()).size();
            info.setWellFormed(report.getFatalErrorCount() == 0 && notWellFormedErrors == 0);
            info.setValid(info.getWellFormed() == 1 && report.getErrorCount() == 0);
            TreeSet<Message> msgs = new TreeSet<Message>(new MessageComparator());
            for (CheckMessage msg : report.getAllMessages()) {
                msgs.addAll(this.toJhoveMessages(msg));
            }
            msgs.forEach(jhoveMsg -> info.setMessage((Message)jhoveMsg));
            info.setMimeType(report.getFormat());
            this.generateProperties(report).forEach(prop -> this._propList.add((Property)prop));
        }
        catch (Exception f) {
            f.printStackTrace();
            if (f.getMessage() != null) {
                info.setMessage(new ErrorMessage(MessageConstants.EPUB_PTC_1, String.format(MessageConstants.EPUB_PTC_1_SUB.getMessage(), f.getMessage())));
            } else {
                info.setMessage(new ErrorMessage(MessageConstants.EPUB_PTC_2));
            }
            info.setWellFormed(false);
            return 0;
        }
        if (this._je != null && this._je.getAbort()) {
            return 0;
        }
        info.setProperty(this._metadata);
        EpubModule.setChecksums(this._ckSummer, info);
        return 0;
    }

    @Override
    public void parse(RandomAccessFile file, RepInfo info) throws IOException {
        try (RandomAccessFileInputStream stream = new RandomAccessFileInputStream(file);){
            this.parse(stream, info, 0);
        }
    }

    private List<Property> generateProperties(JhoveRepInfoReport report) {
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(this.generateProperty("PageCount", report.getPageCount(), true));
        properties.add(this.generateProperty("CharacterCount", report.getCharacterCount(), true));
        properties.add(this.generateProperty("Language", report.getLanguage()));
        TreeSet<Property> infoProperties = new TreeSet<Property>(new PropertyComparator());
        EpubModule.addProperty(infoProperties, this.generateProperty("Identifier", report.getIdentifier()));
        EpubModule.addProperty(infoProperties, this.generateProperty("Title", report.getTitles()));
        EpubModule.addProperty(infoProperties, this.generateProperty("Creator", report.getCreators()));
        EpubModule.addProperty(infoProperties, this.generateProperty("Contributor", report.getContributors()));
        EpubModule.addProperty(infoProperties, this.generateProperty("Date", report.getDate()));
        EpubModule.addProperty(infoProperties, this.generateProperty("Publisher", report.getPublisher()));
        EpubModule.addProperty(infoProperties, this.generateProperty("Subject", report.getSubjects()));
        EpubModule.addProperty(infoProperties, this.generateProperty("Rights", report.getRights()));
        properties.add(this.generateProperty("Info", infoProperties));
        Set<Property> fontList = this.generateFontProps(report.getEmbeddedFonts(), true);
        fontList.addAll(this.generateFontProps(report.getRefFonts(), false));
        properties.add(this.generateProperty("Fonts", fontList));
        properties.add(this.generateProperty("References", report.getReferences()));
        properties.add(this.generateProperty("Resources", report.getResources()));
        properties.add(this.generateProperty("MediaTypes", report.getMediaTypes()));
        for (String feature : report.getFeatures()) {
            properties.add(this.generateProperty(feature, true));
        }
        properties.removeAll(Collections.singletonList(null));
        return properties;
    }

    private static void addProperty(Set<Property> props, Property prop) {
        if (prop == null) {
            return;
        }
        props.add(prop);
    }

    private boolean triggerNotWellFormed(CheckMessage msg) {
        if (msg.getSeverity().equals((Object)Severity.FATAL)) {
            return true;
        }
        if (msg.getSeverity().equals((Object)Severity.ERROR)) {
            for (String s2 : NOTWELLFORMED_ERRCODES) {
                if (!msg.getID().startsWith(s2)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<Property> generateFontProps(Set<String> fonts, boolean fontFile) {
        TreeSet<Property> fontPropertiesList = new TreeSet<Property>(new PropertyComparator());
        if (fonts != null && fonts.size() > 0) {
            for (String font : fonts) {
                TreeSet<Property> fontProps = new TreeSet<Property>(new PropertyComparator());
                EpubModule.addProperty(fontProps, this.generateProperty("FontName", font));
                EpubModule.addProperty(fontProps, this.generateProperty("FontFile", fontFile));
                fontPropertiesList.add(this.generateProperty("Font", fontProps));
            }
        }
        return fontPropertiesList;
    }

    private Property generateProperty(String name, String value) {
        if (value != null && value.trim().length() > 0) {
            return new Property(name, PropertyType.STRING, EpubModule.toUtf8(value));
        }
        return null;
    }

    private Property generateProperty(String name, Long value, boolean hideIfZero) {
        if (!(value == null || value.equals(0L) && hideIfZero)) {
            return new Property(name, PropertyType.LONG, value);
        }
        return null;
    }

    private Property generateProperty(String name, boolean value) {
        return new Property(name, PropertyType.BOOLEAN, value);
    }

    private Property generateProperty(String name, String[] value) {
        if (value != null && value.length > 0) {
            for (int i = 0; i < value.length; ++i) {
                value[i] = EpubModule.toUtf8(value[i]);
            }
            if (value.length == 1) {
                return new Property(name, PropertyType.STRING, PropertyArity.SCALAR, value[0]);
            }
            return new Property(name, PropertyType.STRING, PropertyArity.ARRAY, value);
        }
        return null;
    }

    private Property generateProperty(String name, Set<Property> value) {
        if (value != null && value.size() > 0) {
            return new Property(name, PropertyType.PROPERTY, PropertyArity.SET, value);
        }
        return null;
    }

    private Set<Message> toJhoveMessages(CheckMessage msg) {
        TreeSet<Message> msgs = new TreeSet<Message>(new MessageComparator());
        if (msg == null) {
            return msgs;
        }
        Severity severity = msg.getSeverity();
        String msgText = msg.getMessage();
        String msgId = msg.getID();
        if (msg.getLocations().size() > 0) {
            for (EPUBLocation location : msg.getLocations()) {
                EpubModule.addJhoveMessage(msgs, this.toJhoveMessage(msgId, msgText, severity, location));
            }
        } else {
            EpubModule.addJhoveMessage(msgs, this.toJhoveMessage(msgId, msgText, severity, null));
        }
        return msgs;
    }

    private static void addJhoveMessage(Set<Message> msgs, Message msg) {
        if (msg == null) {
            return;
        }
        msgs.add(msg);
    }

    private Message toJhoveMessage(String msgId, String messageText, Severity severity, EPUBLocation location) {
        String divider = ", ";
        String severityText = severity.toString();
        if (severity.equals((Object)Severity.WARNING)) {
            severityText = "WARN";
        }
        String msgText = msgId + ", " + severityText + ", " + "[" + messageText + "]";
        if (location != null) {
            String loc = "";
            if (location.getLine() > 0 || location.getColumn() > 0) {
                loc = " (" + location.getLine() + "-" + location.getColumn() + ")";
            }
            msgText = msgText + ", " + PathUtil.removeWorkingDirectory(location.getPath()) + loc;
        }
        JhoveMessage msg = JhoveMessages.getMessageInstance(msgId, msgText);
        if (severity == Severity.ERROR || severity == Severity.FATAL || severity == Severity.WARNING) {
            return new ErrorMessage(msg);
        }
        return new InfoMessage(msg);
    }

    public static String toUtf8(String inputString) {
        byte[] b = inputString.getBytes(StandardCharsets.UTF_8);
        return new String(b, StandardCharsets.UTF_8);
    }

    @Override
    protected void initParse() {
        super.initParse();
    }

    static class MessageComparator
    implements Comparator<Message> {
        MessageComparator() {
        }

        @Override
        public int compare(Message firstMess, Message secondMess) {
            int compVal = firstMess.getId().compareTo(secondMess.getId());
            return compVal == 0 ? firstMess.getMessage().compareTo(secondMess.getMessage()) : compVal;
        }
    }

    static class PropertyComparator
    implements Comparator<Property> {
        PropertyComparator() {
        }

        @Override
        public int compare(Property firstProp, Property secondProp) {
            int compVal = firstProp.getName().compareTo(secondProp.getName());
            return compVal == 0 ? firstProp.getValue().toString().compareTo(secondProp.getValue().toString()) : compVal;
        }
    }
}

