/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.jwat.arc.ArcFileNaming;
import org.jwat.arc.ArcFileWriterConfig;
import org.jwat.arc.ArcWriter;
import org.jwat.arc.ArcWriterFactory;
import org.jwat.common.RandomAccessFileOutputStream;

public class ArcFileWriter {
    protected static final String ACTIVE_SUFFIX = ".open";
    protected ArcFileWriterConfig arcFileConfig;
    protected ArcFileNaming arcFileNaming;
    protected int sequenceNr = -1;
    protected File writerFile;
    protected RandomAccessFile writer_raf;
    protected RandomAccessFileOutputStream writer_rafout;
    public ArcWriter writer;

    protected ArcFileWriter() {
    }

    public static ArcFileWriter getArcWriterInstance(ArcFileNaming arcFileNaming, ArcFileWriterConfig arcFileConfig) {
        ArcFileWriter wfw = new ArcFileWriter();
        wfw.arcFileNaming = arcFileNaming;
        wfw.arcFileConfig = arcFileConfig;
        return wfw;
    }

    public int getSequenceNr() {
        return this.sequenceNr;
    }

    public File getFile() {
        return this.writerFile;
    }

    public ArcWriter getWriter() {
        return this.writer;
    }

    public void open() throws IOException {
        if (this.writer == null) {
            ++this.sequenceNr;
            String finishedFilename = this.arcFileNaming.getFilename(this.sequenceNr, this.arcFileConfig.bCompression);
            String activeFilename = finishedFilename + ACTIVE_SUFFIX;
            File finishedFile = new File(this.arcFileConfig.targetDir, finishedFilename);
            this.writerFile = new File(this.arcFileConfig.targetDir, activeFilename);
            if (this.writerFile.exists()) {
                if (this.arcFileConfig.bOverwrite) {
                    this.writerFile.delete();
                } else {
                    throw new IOException("'" + this.writerFile + "' already exists, will not overwrite");
                }
            }
            if (finishedFile.exists()) {
                if (this.arcFileConfig.bOverwrite) {
                    finishedFile.delete();
                } else {
                    throw new IOException("'" + finishedFile + "' already exists, will not overwrite");
                }
            }
            this.writer_raf = new RandomAccessFile(this.writerFile, "rw");
            this.writer_raf.seek(0L);
            this.writer_raf.setLength(0L);
            this.writer_rafout = new RandomAccessFileOutputStream(this.writer_raf);
            this.writer = ArcWriterFactory.getWriter(this.writer_rafout, 8192, this.arcFileConfig.bCompression);
        }
    }

    public boolean nextWriter() throws Exception {
        boolean bNewWriter = false;
        if (this.writer_raf == null) {
            bNewWriter = true;
        } else if (this.arcFileNaming.supportMultipleFiles() && this.writer_raf.length() > this.arcFileConfig.maxFileSize) {
            this.close();
            bNewWriter = true;
        }
        if (bNewWriter) {
            this.open();
        }
        return bNewWriter;
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.writer_rafout != null) {
            this.writer_rafout.close();
            this.writer_rafout = null;
        }
        if (this.writer_raf != null) {
            this.writer_raf.close();
            this.writer_raf = null;
        }
        if (this.writerFile != null && this.writerFile.getName().endsWith(ACTIVE_SUFFIX)) {
            String finishedName = this.writerFile.getName().substring(0, this.writerFile.getName().length() - ACTIVE_SUFFIX.length());
            File finishedFile = new File(this.writerFile.getParent(), finishedName);
            if (finishedFile.exists()) {
                throw new IOException("unable to rename '" + this.writerFile + "' to '" + finishedFile + "' - destination file already exists");
            }
            boolean success = this.writerFile.renameTo(finishedFile);
            if (!success) {
                throw new IOException("unable to rename '" + this.writerFile + "' to '" + finishedFile + "' - unknown problem");
            }
        }
        this.writerFile = null;
    }
}

