/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.epubcheck.core.references;

import com.adobe.epubcheck.opf.OPFItem;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.mola.galimatias.URL;

public class Resource {
    private final URL url;
    private final String mimetype;
    private final Optional<OPFItem> item;

    public static Resource fromItem(OPFItem item) {
        return new Builder().item(item).build();
    }

    public static Resource fromURL(URL url, String mimetype) {
        return new Builder().url(url).mimetype(mimetype).build();
    }

    private Resource(Builder builder) {
        Preconditions.checkState(builder.url != null, "A URL or OPF Item must be provided");
        Preconditions.checkState(builder.mimetype != null, "A MIME type must be provided");
        Preconditions.checkState(builder.item == null || builder.item.getMimeType().equals(builder.mimetype));
        this.url = builder.url;
        this.item = Optional.fromNullable(builder.item);
        this.mimetype = builder.mimetype;
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public boolean hasItem() {
        return this.item.isPresent();
    }

    public OPFItem getItem() {
        return this.item.orNull();
    }

    public URL getURL() {
        return this.url;
    }

    public boolean hasCoreMediaTypeFallback() {
        return this.item.isPresent() && this.item.get().hasCoreMediaTypeFallback();
    }

    public boolean hasContentDocumentFallback() {
        return this.item.isPresent() && this.item.get().hasContentDocumentFallback();
    }

    public boolean isInSpine() {
        return this.item.isPresent() && this.item.get().isInSpine();
    }

    public String toString() {
        return this.url.toString();
    }

    private static final class Builder {
        private URL url;
        private OPFItem item = null;
        public String mimetype;

        private Builder() {
        }

        public Builder url(URL url) {
            this.url = url;
            return this;
        }

        public Builder item(OPFItem item) {
            this.url = item.getURL();
            this.item = item;
            this.mimetype = item.getMimeType();
            return this;
        }

        public Builder mimetype(String mimetype) {
            this.mimetype = mimetype;
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }
    }
}

