/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.epubcheck.util.url;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLUtils;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.om.NameChecker;
import org.w3c.epubcheck.constants.MIMEType;

public class URLFragment {
    public static final URLFragment NONE = new URLFragment(Parser.access$100(new Parser(), null, null));
    private final String fragment;
    private final String scheme;
    private final String id;
    private final boolean isMediaFragment;
    private final boolean isValid;

    private URLFragment(Parser parser) {
        this.fragment = parser.fragment;
        this.id = Strings.nullToEmpty(parser.id);
        this.scheme = Strings.nullToEmpty(parser.scheme);
        this.isMediaFragment = parser.isMediaFragment;
        this.isValid = parser.isValid;
    }

    public String getId() {
        return this.id;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean exists() {
        return this.fragment != null;
    }

    public boolean isEmpty() {
        return this.fragment == null || this.fragment.isEmpty();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isMediaFragment() {
        return this.isMediaFragment;
    }

    public String toString() {
        return this.fragment;
    }

    public int hashCode() {
        return Objects.hash(this.fragment);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URLFragment other = (URLFragment)obj;
        return Objects.equals(this.fragment, other.fragment);
    }

    public static URLFragment parse(URL url, String mimetype) {
        if (url == null || url.fragment() == null) {
            return NONE;
        }
        return new URLFragment(new Parser().parse(url.fragment(), mimetype));
    }

    public static URLFragment parse(URL url) {
        return URLFragment.parse(url, "");
    }

    private static final class Parser {
        private String fragment;
        private String scheme;
        private String id;
        private boolean isMediaFragment = false;
        private boolean isValid = true;
        private static final Pattern SCHEME_BASED = Pattern.compile("(\\w+)\\(.*\\)");
        private static final Pattern MEDIA_FRAGMENT = Pattern.compile("(t|xywh|track|id|xyn|xyr)=[^&]+(&[^&=]+=[^&]+)*");
        private static final Pattern SVGVIEW = Pattern.compile("svgView\\(.+\\)");
        private static final Pattern SPATIAL = Pattern.compile("xywh=(pixel:|percent:)?\\d+,\\d+,\\d+,\\d+");
        private static final Pattern TEMPORAL = Pattern.compile("t=(?:npt:)?(?:([0-9.:]+)(?:,([0-9.:]+))?|,([0-9.:]+))");
        private static final Pattern NPTTIME = Pattern.compile("((\\d+)|([0-5]\\d:[0-5]\\d)|(\\d+:[0-5]\\d:[0-5]\\d))(\\.\\d*)?");

        private Parser() {
        }

        private Parser parse(String fragment, String mimetype) {
            this.fragment = fragment;
            if (fragment != null) {
                switch (MIMEType.get(mimetype)) {
                    case SVG: {
                        this.parseSVGFragment(fragment);
                        break;
                    }
                    case HTML: 
                    case XHTML: {
                        this.parseHTMLFragment(fragment);
                        break;
                    }
                    default: {
                        this.parseXMLFragment(fragment);
                    }
                }
            }
            return this;
        }

        private void parseXMLFragment(String fragment) {
            Matcher matcher = SCHEME_BASED.matcher(fragment);
            if (matcher.matches()) {
                this.scheme = matcher.group(1);
            } else {
                this.id = URLUtils.percentDecode(fragment);
                this.isValid = NameChecker.isValidNCName(this.id);
            }
        }

        private void parseHTMLFragment(String fragment) {
            Matcher matcher;
            int index = fragment.indexOf(":~:");
            if (index > -1) {
                fragment = fragment.substring(0, index);
            }
            if ((matcher = SCHEME_BASED.matcher(fragment)).matches()) {
                this.scheme = matcher.group(1);
            } else {
                matcher = MEDIA_FRAGMENT.matcher(fragment);
                if (matcher.matches()) {
                    this.isMediaFragment = true;
                } else {
                    this.id = URLUtils.percentDecode(fragment);
                }
            }
        }

        private void parseSVGFragment(String fragment) {
            if (fragment.isEmpty()) {
                return;
            }
            Iterator<String> components = Splitter.on('&').split(fragment).iterator();
            String first = components.next();
            if (first.startsWith("svgView(")) {
                this.isValid = this.parseSVGView(first);
                while (this.isValid && components.hasNext()) {
                    this.isValid = this.parseTimeSegment(components.next());
                }
            } else if (first.startsWith("t=")) {
                this.isMediaFragment = true;
                this.isValid = this.parseTimeSegment(first);
                while (this.isValid && components.hasNext()) {
                    this.isValid = this.parseSpaceSegment(components.next());
                }
            } else if (first.startsWith("xywh=")) {
                this.isMediaFragment = true;
                this.isValid = this.parseSpaceSegment(first);
                while (this.isValid && components.hasNext()) {
                    this.isValid = this.parseTimeSegment(components.next());
                }
            } else if (first.contains("=")) {
                this.isValid = false;
            } else {
                this.id = URLUtils.percentDecode(first);
                this.isValid = NameChecker.isValidNCName(this.id);
                while (this.isValid && components.hasNext()) {
                    this.isValid = this.parseTimeSegment(components.next());
                }
            }
        }

        private boolean parseSVGView(String string) {
            this.isValid = SVGVIEW.matcher(string).matches();
            return this.isValid;
        }

        private boolean parseSpaceSegment(String string) {
            this.isValid = SPATIAL.matcher(string).matches();
            return this.isValid;
        }

        private boolean parseTimeSegment(String string) {
            Matcher matcher = TEMPORAL.matcher(string);
            this.isValid = matcher.matches();
            if (this.isValid) {
                for (int i = 1; this.isValid && i <= matcher.groupCount(); ++i) {
                    this.isValid = matcher.group(i) == null || NPTTIME.matcher(matcher.group(i)).matches();
                }
            }
            return this.isValid;
        }
    }
}

