/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.ocf.OCFContainer;
import com.google.common.base.Preconditions;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;

final class OCFMetaFile
extends Enum<OCFMetaFile> {
    public static final /* enum */ OCFMetaFile MIMETYPE = new OCFMetaFile("mimetype");
    public static final /* enum */ OCFMetaFile CONTAINER = new OCFMetaFile("META-INF/container.xml");
    public static final /* enum */ OCFMetaFile ENCRYPTION = new OCFMetaFile("META-INF/encryption.xml");
    public static final /* enum */ OCFMetaFile METADATA = new OCFMetaFile("META-INF/metadata.xml");
    public static final /* enum */ OCFMetaFile SIGNATURES = new OCFMetaFile("META-INF/signatures.xml");
    private final String path;
    private static final /* synthetic */ OCFMetaFile[] $VALUES;

    public static OCFMetaFile[] values() {
        return (OCFMetaFile[])$VALUES.clone();
    }

    public static OCFMetaFile valueOf(String name) {
        return Enum.valueOf(OCFMetaFile.class, name);
    }

    private OCFMetaFile(String path) {
        this.path = path;
    }

    public URL asURL(OCFContainer container) {
        Preconditions.checkArgument(container != null, "container must not be null");
        assert (container != null);
        try {
            return container.getRootURL().resolve(this.path);
        }
        catch (GalimatiasParseException e) {
            throw new AssertionError("Could not build meta file URL", e);
        }
    }

    public EPUBLocation asLocation(OCFContainer container) {
        Preconditions.checkArgument(container != null, "container must not be null");
        return EPUBLocation.of(this.asURL(container), container);
    }

    public boolean isPresent(OCFContainer container) {
        Preconditions.checkArgument(container != null, "container must not be null");
        return container.contains(this.asURL(container));
    }

    public String asPath() {
        return this.path;
    }

    private static /* synthetic */ OCFMetaFile[] $values() {
        return new OCFMetaFile[]{MIMETYPE, CONTAINER, ENCRYPTION, METADATA, SIGNATURES};
    }

    static {
        $VALUES = OCFMetaFile.$values();
    }
}

