/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.ocf.OCFContainer;
import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.vocab.Property;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import java.util.Set;
import org.w3c.epubcheck.util.url.URLUtils;

public class OPFItem {
    private final String id;
    private final URL url;
    private final EPUBLocation location;
    private final String path;
    private final String mimetype;
    private final boolean hasFallback;
    private final boolean hasCoreMediaTypeFallback;
    private final boolean hasContentDocumentFallback;
    private final Set<Property> properties;
    private final boolean ncx;
    private final boolean inSpine;
    private final int spinePosition;
    private final boolean nav;
    private final boolean scripted;
    private final boolean linear;
    private final boolean fixedLayout;
    private final boolean remote;
    private final String mediaOverlay;

    private OPFItem(Builder builder) {
        Preconditions.checkState(builder.id != null, "item ID is null");
        Preconditions.checkState(builder.url != null, "item path is null");
        Preconditions.checkState(builder.location != null, "item location is null");
        if (builder.spinePosition < 0 || !builder.linear) {
            builder.propertiesBuilder.add(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.NON_LINEAR));
        }
        if (builder.fxl) {
            builder.propertiesBuilder.add(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.FIXED_LAYOUT));
        }
        this.id = builder.id.trim();
        this.url = builder.url;
        this.mimetype = builder.mimetype();
        this.location = builder.location;
        this.hasFallback = builder.hasFallback();
        this.hasCoreMediaTypeFallback = builder.hasCoreMediaTypeFallback();
        this.hasContentDocumentFallback = builder.hasContentDocumentFallback();
        this.properties = builder.propertiesBuilder.build();
        this.ncx = builder.ncx;
        this.inSpine = builder.spinePosition > -1;
        this.spinePosition = builder.spinePosition;
        this.nav = this.properties.contains(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.NAV));
        this.scripted = this.properties.contains(PackageVocabs.ITEM_VOCAB.get(PackageVocabs.ITEM_PROPERTIES.SCRIPTED));
        this.linear = builder.linear;
        this.fixedLayout = builder.fxl;
        this.mediaOverlay = builder.mediaOverlay;
        this.remote = builder.remote;
        try {
            if (this.remote) {
                this.path = this.url.toHumanString();
            } else if ("data".equals(this.url.scheme())) {
                String urlString = this.url.toString();
                this.path = this.url.toString().substring(0, Math.min(urlString.length(), 30)) + "\u2026";
            } else {
                this.path = builder.container.isPresent() ? URLUtils.decode(((OCFContainer)builder.container.get()).relativize(this.url)) : URLUtils.decode(this.location.url.resolve(".").relativize(URLUtils.docURL(this.url)));
            }
        }
        catch (GalimatiasParseException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    public String getId() {
        return this.id;
    }

    public URL getURL() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public String getMimeType() {
        return this.mimetype;
    }

    public EPUBLocation getLocation() {
        return this.location;
    }

    public boolean hasFallback() {
        return this.hasFallback;
    }

    public boolean hasCoreMediaTypeFallback() {
        return this.hasCoreMediaTypeFallback;
    }

    public boolean hasContentDocumentFallback() {
        return this.hasContentDocumentFallback;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public int getSpinePosition() {
        return this.spinePosition;
    }

    public boolean isNcx() {
        return this.ncx;
    }

    public boolean isScripted() {
        return this.scripted;
    }

    public boolean isNav() {
        return this.nav;
    }

    public boolean isInSpine() {
        return this.inSpine;
    }

    public boolean isLinear() {
        if (!this.inSpine) {
            throw new IllegalStateException("linear");
        }
        return this.linear;
    }

    public boolean isFixedLayout() {
        return this.fixedLayout;
    }

    public boolean hasDataURL() {
        return "data".equals(this.url.scheme());
    }

    public boolean isRemote() {
        return this.remote;
    }

    public String getMediaOverlay() {
        return this.mediaOverlay;
    }

    public String toString() {
        return this.path + "[" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPFItem other = (OPFItem)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public static final class Builder {
        private String id;
        private URL url;
        private EPUBLocation location;
        private Optional<OCFContainer> container;
        private boolean remote = false;
        private String mimetype;
        private String fallback;
        private String fallbackStyle;
        private boolean hasContentDocumentFallback = false;
        private boolean hasCoreMediaTypeFallback = false;
        private boolean isFallbackResolved = false;
        private boolean ncx = false;
        private boolean linear = true;
        private int spinePosition = -1;
        private boolean fxl = false;
        private String mediaOverlay;
        private ImmutableSet.Builder<Property> propertiesBuilder = new ImmutableSet.Builder();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public String id() {
            return this.id;
        }

        public Builder url(URL url) {
            this.url = url;
            return this;
        }

        public Builder location(EPUBLocation location) {
            this.location = location;
            return this;
        }

        public EPUBLocation location() {
            return this.location;
        }

        public Builder container(Optional<OCFContainer> container) {
            this.container = container;
            return this;
        }

        public Builder remote(boolean remote) {
            this.remote = remote;
            return this;
        }

        public Builder mimetype(String mimetype) {
            this.mimetype = Optional.fromNullable(mimetype).or("undefined").trim();
            return this;
        }

        public String mimetype() {
            return this.mimetype;
        }

        public Builder fallback(String fallback) {
            this.fallback = Strings.nullToEmpty(fallback).trim();
            return this;
        }

        public String fallback() {
            return this.fallback;
        }

        public boolean hasFallback() {
            return !this.fallback.isEmpty();
        }

        public Builder fallbackStyle(String fallbackStyle) {
            this.fallbackStyle = Strings.nullToEmpty(fallbackStyle).trim();
            return this;
        }

        public String fallbackStyle() {
            return this.fallbackStyle;
        }

        public boolean hasFallbackStyle() {
            return !this.fallbackStyle.isEmpty();
        }

        public Builder hasCoreMediaTypeFallback(boolean hasCoreMediaTypeFallback) {
            this.hasCoreMediaTypeFallback = hasCoreMediaTypeFallback;
            return this;
        }

        public boolean hasCoreMediaTypeFallback() {
            return this.hasCoreMediaTypeFallback;
        }

        public Builder hasContentDocumentFallback(boolean hasContentDocumentFallback) {
            this.hasContentDocumentFallback = hasContentDocumentFallback;
            return this;
        }

        public boolean hasContentDocumentFallback() {
            return this.hasContentDocumentFallback;
        }

        public Builder markResolved() {
            this.isFallbackResolved = true;
            return this;
        }

        public boolean isResolved() {
            return this.isFallbackResolved;
        }

        public Builder fixedLayout() {
            this.fxl = true;
            return this;
        }

        public Builder mediaOverlay(String path) {
            this.mediaOverlay = path;
            return this;
        }

        public Builder ncx() {
            this.ncx = true;
            return this;
        }

        public Builder nonlinear() {
            this.linear = false;
            return this;
        }

        public Builder inSpine(int position) {
            this.spinePosition = Preconditions.checkNotNull(position);
            return this;
        }

        public Builder properties(Set<Property> properties) {
            if (properties != null) {
                this.propertiesBuilder.addAll(properties);
            }
            return this;
        }

        public String toString() {
            return this.id;
        }

        public OPFItem build() {
            return new OPFItem(this);
        }
    }
}

