/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.opf.FallbackChainResolver;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.ValidationContext;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.mola.galimatias.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class OPFItems {
    private final List<OPFItem> items;
    private final List<OPFItem> spine;
    private final Map<String, OPFItem> itemsById;
    private final Map<URL, OPFItem> itemsByURL;

    public Optional<OPFItem> getItemById(String id) {
        return Optional.fromNullable(this.itemsById.get(id));
    }

    public Optional<OPFItem> getItemByURL(URL url) {
        return Optional.fromNullable(this.itemsByURL.get(url));
    }

    public List<OPFItem> getSpineItems() {
        return this.spine;
    }

    public List<OPFItem> getItems() {
        return this.items;
    }

    private OPFItems(Iterable<OPFItem> items, Iterable<String> spineIDs) {
        this.items = ImmutableList.copyOf(Preconditions.checkNotNull(items));
        HashMap<String, OPFItem> itemsById = Maps.newHashMap();
        HashMap<URL, OPFItem> itemsByURL = Maps.newHashMap();
        for (OPFItem item : this.items) {
            itemsById.put(item.getId(), item);
            itemsByURL.put(item.getURL(), item);
        }
        this.itemsById = ImmutableMap.copyOf(itemsById);
        this.itemsByURL = ImmutableMap.copyOf(itemsByURL);
        this.spine = FluentIterable.from(spineIDs).transform(new Function<String, OPFItem>(){

            @Override
            public OPFItem apply(String id) {
                return (OPFItem)OPFItems.this.itemsById.get(id.trim());
            }
        }).filter(Predicates.notNull()).toList();
    }

    public static OPFItems build(Map<String, OPFItem.Builder> itemBuilders, Iterable<String> spineIDs, ValidationContext context) {
        return new OPFItems(new FallbackChainResolver(itemBuilders, context).resolve(), Preconditions.checkNotNull(spineIDs));
    }
}

