/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.xml.SAXAbortException;
import com.adobe.epubcheck.xml.XMLEncodingSniffer;
import com.adobe.epubcheck.xml.XMLValidator;
import com.adobe.epubcheck.xml.handlers.DeclarationHandler;
import com.adobe.epubcheck.xml.handlers.DefaultResolver;
import com.adobe.epubcheck.xml.handlers.DelegateDefaultHandler;
import com.adobe.epubcheck.xml.handlers.PreprocessingDefaultHandler;
import com.adobe.epubcheck.xml.handlers.ReportingErrorHandler;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import io.mola.galimatias.URL;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.epubcheck.constants.MIMEType;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    private static final String SAXPROP_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private static final String SAXPROP_DECL_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    private final ValidationContext context;
    private final Report report;
    private final URL url;
    private final SAXParser parser;
    private final DelegateDefaultHandler.Builder handler = new DelegateDefaultHandler.Builder();
    private boolean reporting = true;

    public XMLParser(ValidationContext context) {
        this.context = context;
        this.report = context.report;
        this.url = context.url;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            if (context.version == EPUBVersion.VERSION_3) {
                factory.setXIncludeAware(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.parser = factory.newSAXParser();
            this.handler.setEntityResolver(new DefaultResolver(context.version));
            XMLReader reader = this.parser.getXMLReader();
            DeclarationHandler docTypeHandler = new DeclarationHandler(context);
            reader.setProperty(SAXPROP_LEXICAL_HANDLER, docTypeHandler);
            reader.setProperty(SAXPROP_DECL_HANDLER, docTypeHandler);
        }
        catch (Exception e) {
            throw new AssertionError("Could not configure the XML parser", e);
        }
    }

    public void setReporting(boolean reporting) {
        this.reporting = reporting;
    }

    public void addContentHandler(ContentHandler contentHandler) {
        this.handler.addContentHandler(contentHandler);
    }

    public void addValidator(XMLValidator xv) {
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        ReportingErrorHandler eh = new ReportingErrorHandler(this.context, xv.isNormative());
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, eh);
        Validator validator = xv.getSchema().createValidator(propertyMapBuilder.toPropertyMap());
        this.handler.addContentHandler(validator.getContentHandler());
        this.handler.addDTDHandler(validator.getDTDHandler());
    }

    public void process() {
        block24: {
            try (InputStream in2 = this.context.resourceProvider.openStream(this.context.url);
                 BufferedInputStream buffered = new BufferedInputStream(in2);){
                if (in2 == null) {
                    return;
                }
                String encoding = XMLEncodingSniffer.sniffEncoding(buffered);
                if (encoding != null && !encoding.equals("UTF-8")) {
                    if (encoding.equals("UTF-16")) {
                        if (MIMEType.XHTML.is(this.context.mimeType)) {
                            this.report.message(MessageId.HTM_058, EPUBLocation.of(this.context), new Object[0]);
                        } else {
                            this.report.message(MessageId.RSC_027, EPUBLocation.of(this.context), new Object[0]);
                        }
                    } else {
                        this.report.message(MessageId.RSC_028, EPUBLocation.of(this.context), encoding);
                    }
                }
                InputSource source = new InputSource(buffered);
                source.setSystemId(this.url.toString());
                if (this.reporting) {
                    this.handler.addErrorHandler(new ReportingErrorHandler(this.context));
                }
                this.parser.parse(source, (DefaultHandler)new PreprocessingDefaultHandler(this.handler.build(), this.context));
            }
            catch (SAXAbortException in2) {
            }
            catch (IOException e) {
                this.report.message(MessageId.PKG_008, EPUBLocation.of(this.context), this.context.path);
            }
            catch (SAXException e) {
                if (this.report.getFatalErrorCount() != 0) break block24;
                this.report.message(MessageId.RSC_016, EPUBLocation.of(this.context), e.getMessage());
            }
        }
    }
}

