/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonassert.impl.matcher;

import com.jayway.jsonassert.impl.matcher.CollectionMatcher;
import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;

public class IsCollectionWithSize<E>
extends CollectionMatcher<Collection<? extends E>> {
    private final Matcher<? super Integer> sizeMatcher;

    public IsCollectionWithSize(Matcher<? super Integer> sizeMatcher) {
        this.sizeMatcher = sizeMatcher;
    }

    @Override
    public boolean matchesSafely(Collection<? extends E> item) {
        return this.sizeMatcher.matches(item.size());
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("a collection with size ").appendDescriptionOf(this.sizeMatcher);
    }

    public static <E> Matcher<? super Collection<? extends E>> hasSize(Matcher<? super Integer> size) {
        return new IsCollectionWithSize<E>(size);
    }

    public static <E> Matcher<? super Collection<? extends E>> hasSize(int size) {
        Matcher<Integer> matcher = IsEqual.equalTo(size);
        return IsCollectionWithSize.hasSize(matcher);
    }
}

