/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module;

import com.mcgath.jhove.module.png.IdatChunk;
import com.mcgath.jhove.module.png.MessageConstants;
import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.messages.JhoveMessage;
import edu.harvard.hul.ois.jhove.messages.JhoveMessages;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PngModule
extends ModuleBase {
    private static final String NAME = "PNG-gdm";
    private static final String RELEASE = "1.3";
    private static final int[] DATE = new int[]{2024, 3, 5};
    private static final String[] FORMAT = new String[]{"PNG", " ISO/IEC 15948:2003", "Portable Network Graphics"};
    private static final String COVERAGE = "PNG (ISO/IEC 15948:2003)";
    private static final String[] MIMETYPE = new String[]{"image/png"};
    private static final String WELLFORMED = "Put well-formedness criteria here";
    private static final String VALIDITY = "Put validity criteria here";
    private static final String REPINFO = "Put repinfo note here";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2016 by Gary McGath. Released under the GNU Lesser General Public License.";
    private static final String NISO_IMAGE_MD = "NisoImageMetadata";
    protected Checksummer _ckSummer;
    protected List<Property> _propList;
    protected List<Property> _keywordPropList;
    protected List<Property> _spltList;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected Property _metadata;
    NisoImageMetadata _nisoData;
    protected int _colorType;
    private Set<Integer> _ancillaryChunks;
    private boolean ihdrSeen;
    private boolean plteSeen;
    private boolean idatSeen;
    private boolean idatFinished;
    private boolean iendSeen;
    private static final int[] _sigBytes = new int[]{137, 80, 78, 71, 13, 10, 26, 10};

    public PngModule() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        Signature sig = new InternalSignature(_sigBytes, SignatureType.MAGIC, SignatureUseType.MANDATORY, 0, "");
        this._signature.add(sig);
        sig = new ExternalSignature(".png", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
    }

    @Override
    public void checkSignatures(File file, InputStream stream, RepInfo info) {
        this._dstream = PngModule.getBufferedDataStream(stream, this._je != null ? this._je.getBufferSize() : 0);
        for (int i = 0; i < 8; ++i) {
            int ch;
            try {
                ch = PngModule.readUnsignedByte(this._dstream, this);
            }
            catch (Exception e) {
                ch = -1;
            }
            if (ch == _sigBytes[i]) continue;
            info.setWellFormed(false);
            return;
        }
        info.setModule(this);
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setSigMatch(this._name);
    }

    @Override
    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        this.initParse();
        info.setFormat(this._format[0]);
        info.setMimeType(this._mimeType[0]);
        info.setModule(this);
        this._ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && info.getChecksum().isEmpty()) {
            this._ckSummer = new Checksummer();
            this._cstream = new ChecksumInputStream(stream, this._ckSummer);
            this._dstream = PngModule.getBufferedDataStream(this._cstream, this._je != null ? this._je.getBufferSize() : 0);
        } else {
            this._dstream = PngModule.getBufferedDataStream(stream, this._je != null ? this._je.getBufferSize() : 0);
        }
        this._propList = new LinkedList<Property>();
        this._metadata = new Property("PNGMetadata", PropertyType.PROPERTY, PropertyArity.LIST, this._propList);
        this._nisoData = new NisoImageMetadata();
        Property nisoProp = new Property(NISO_IMAGE_MD, PropertyType.NISOIMAGEMETADATA, this._nisoData);
        this._propList.add(nisoProp);
        this._keywordPropList = new LinkedList<Property>();
        this._spltList = new LinkedList<Property>();
        for (int i = 0; i < _sigBytes.length; ++i) {
            int byt = PngModule.readUnsignedByte(this._dstream);
            if (byt == _sigBytes[i]) continue;
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_66));
            info.setWellFormed(false);
            return 0;
        }
        try {
            PNGChunk chunk;
            while ((chunk = this.readChunkHead(this._dstream)) != null) {
                long calculatedCRC;
                if (this.iendSeen) {
                    info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_67));
                    info.setWellFormed(false);
                    return 0;
                }
                if (this.idatSeen && !(chunk instanceof IdatChunk)) {
                    this.idatFinished = true;
                }
                chunk.setModule(this);
                chunk.setInputStream(this._dstream);
                chunk.setNisoMetadata(this._nisoData);
                chunk.setPropertyList(this._propList);
                chunk.processChunk(info);
                long storedCRC = chunk.readCRC();
                if (storedCRC == (calculatedCRC = chunk.getCRC())) continue;
                JhoveMessage msg = JhoveMessages.getMessageInstance(MessageConstants.PNG_GDM_68.getId(), String.format(MessageConstants.PNG_GDM_68.getMessage(), chunk.chunkTypeString()));
                info.setMessage(new ErrorMessage(msg));
                info.setWellFormed(false);
                return 0;
            }
        }
        catch (PNGException e) {
            return 0;
        }
        catch (EOFException e) {
            JhoveMessage msg = JhoveMessages.getMessageInstance(MessageConstants.PNG_GDM_69.getId(), String.format(MessageConstants.PNG_GDM_69.getMessage(), this._nByte));
            info.setMessage(new ErrorMessage(msg));
            info.setWellFormed(false);
            return 0;
        }
        catch (Exception e) {
            JhoveMessage msg = JhoveMessages.getMessageInstance(MessageConstants.PNG_GDM_70.getId(), String.format(MessageConstants.PNG_GDM_70.getMessage(), e.getClass().getName()));
            info.setMessage(new ErrorMessage(msg));
            info.setWellFormed(false);
            return 0;
        }
        boolean criticalMissing = false;
        if (!this.ihdrSeen) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_71));
            criticalMissing = true;
        }
        if (!this.idatSeen) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_72));
            criticalMissing = true;
        }
        if (!this.iendSeen) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_73));
            criticalMissing = true;
        }
        if (criticalMissing) {
            info.setWellFormed(false);
            return 0;
        }
        if (this._colorType == 3 && !this.plteSeen) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_74));
            info.setWellFormed(false);
            return 0;
        }
        if ((this._colorType == 0 || this._colorType == 4) && this.plteSeen) {
            info.setMessage(new ErrorMessage(MessageConstants.PNG_GDM_75));
            info.setWellFormed(false);
            return 0;
        }
        if (!this._keywordPropList.isEmpty()) {
            this._propList.add(new Property("Keywords", PropertyType.PROPERTY, PropertyArity.LIST, this._keywordPropList));
        }
        if (!this._spltList.isEmpty()) {
            this._propList.add(new Property("Suggested palettes", PropertyType.PROPERTY, PropertyArity.LIST, this._spltList));
        }
        info.setProperty(this._metadata);
        return 0;
    }

    public void eatChunk(PNGChunk chnk) throws IOException {
        chnk.skipBytes((int)chnk.getLength());
    }

    public void addKeyword(String keywd, String val) {
        this.addKeyword(keywd, null, val, null);
    }

    public void addKeyword(String keywd, String translatedKeywd, String val, String language) {
        ArrayList<Property> props = new ArrayList<Property>();
        Property prop = new Property("Keyword", PropertyType.PROPERTY, PropertyArity.LIST, props);
        props.add(new Property("Key", PropertyType.STRING, keywd));
        props.add(new Property("Value", PropertyType.STRING, val));
        if (language != null) {
            props.add(new Property("Language", PropertyType.STRING, language));
        }
        if (translatedKeywd != null) {
            props.add(new Property("Translated key", PropertyType.STRING, translatedKeywd));
        }
        this._keywordPropList.add(prop);
    }

    public void addSplt(String name, int sampleDepth, int numSamples) {
        ArrayList<Property> props = new ArrayList<Property>();
        Property prop = new Property("Suggested palette", PropertyType.PROPERTY, PropertyArity.LIST, props);
        props.add(new Property("Name", PropertyType.STRING, name));
        props.add(new Property("Sample depth", PropertyType.INTEGER, sampleDepth));
        props.add(new Property("Number of samples", PropertyType.INTEGER, numSamples));
        this._spltList.add(prop);
    }

    @Override
    protected void initParse() {
        super.initParse();
        this.ihdrSeen = false;
        this.plteSeen = false;
        this.idatSeen = false;
        this.idatFinished = false;
        this.iendSeen = false;
        this._ancillaryChunks = new HashSet<Integer>();
    }

    private PNGChunk readChunkHead(DataInputStream dstrm) throws IOException {
        long chunkLength;
        try {
            chunkLength = PngModule.readUnsignedInt(dstrm, true);
        }
        catch (EOFException e) {
            return null;
        }
        int sig = (int)PngModule.readUnsignedInt(dstrm, true);
        return PNGChunk.makePNGChunk(chunkLength, sig);
    }

    public void setIhdrSeen(boolean b) {
        this.ihdrSeen = b;
    }

    public boolean isIhdrSeen() {
        return this.ihdrSeen;
    }

    public void setIdatSeen(boolean b) {
        this.idatSeen = b;
    }

    public void setPlteSeen(boolean b) {
        this.plteSeen = b;
    }

    public void setIendSeen(boolean b) {
        this.iendSeen = b;
    }

    public boolean isIdatSeen() {
        return this.idatSeen;
    }

    public boolean isIdatFinished() {
        return this.idatFinished;
    }

    public boolean isPlteSeen() {
        return this.plteSeen;
    }

    public void setChunkSeen(int chunkType) {
        this._ancillaryChunks.add(chunkType);
    }

    public boolean isChunkSeen(int chunkType) {
        return this._ancillaryChunks.contains(chunkType);
    }

    public void setColorType(int ct) {
        this._colorType = ct;
    }

    public int getColorType() {
        return this._colorType;
    }
}

